/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.common;

import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.Netmask;

public class AddressMask
implements Cloneable {
    protected IPAddress _ipAddr;
    protected Netmask _mask;

    public AddressMask(IPAddress address, Netmask mask) {
        this._ipAddr = address;
        this._mask = mask;
    }

    public Object clone() {
        try {
            AddressMask newObj = (AddressMask)super.clone();
            if (this._ipAddr != null) {
                newObj._ipAddr = (IPAddress)this._ipAddr.clone();
            }
            if (this._mask != null) {
                newObj._mask = (Netmask)this._mask.clone();
            }
            return newObj;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Log.getLog().debug("AddressMask: Clone Not supported Exception. ");
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AddressMask)) {
            return false;
        }
        AddressMask tmp = (AddressMask)obj;
        if (this._ipAddr == null) {
            if (tmp._ipAddr != null) {
                return false;
            }
        } else {
            if (tmp._ipAddr == null) {
                return false;
            }
            if (!this._ipAddr.equals(tmp._ipAddr)) {
                return false;
            }
        }
        if (this._mask == null) {
            if (tmp._mask != null) {
                return false;
            }
        } else {
            if (tmp._mask == null) {
                return false;
            }
            if (!this._mask.equals(tmp._mask)) {
                return false;
            }
        }
        return true;
    }

    public IPAddress getAddress() {
        return this._ipAddr;
    }

    public IPAddress getBroadcastAddr() {
        if (this._ipAddr == null || this._mask == null) {
            return null;
        }
        return this._ipAddr.getBroadcastAddr(this._mask);
    }

    public Netmask getMask() {
        return this._mask;
    }

    public IPAddress getSubnet() {
        if (this._ipAddr == null || this._mask == null) {
            return null;
        }
        return this._ipAddr.getSubnet(this._mask);
    }

    public void print() {
        if (this._ipAddr != null) {
            Log.getLog().debug("Address is " + this._ipAddr);
        }
        if (this._mask != null) {
            Log.getLog().debug("Mask is " + this._mask);
        }
    }

    public String toString() {
        String retVal = "";
        if (this._ipAddr != null) {
            retVal = retVal.concat("Address is " + this._ipAddr);
        }
        if (this._mask != null) {
            retVal = retVal.concat("Mask is " + this._mask);
        }
        return retVal;
    }
}

