/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.common;

public class CLIViewType {
    public static final int ADMIN_VAL = 1;
    public static final int MONITOR_VAL = 2;
    public static final int FIREWALL_VAL = 3;
    public static final int EASYVPN_VAL = 4;
    public static final int USERDEFINED_VAL = 5;
    public static final int NONE = 6;
    public static final int ROOT_VAL = 7;
    private String _type;
    private int _val;
    public static final CLIViewType ADMINVIEW = new CLIViewType("SDM_Administrator(root)", 1);
    public static final CLIViewType MONITORVIEW = new CLIViewType("SDM_Monitor", 2);
    public static final CLIViewType FIREWALLVIEW = new CLIViewType("SDM_Firewall", 3);
    public static final CLIViewType EASYVPNVIEW = new CLIViewType("SDM_EasyVPN_Remote", 4);
    public static final CLIViewType USERDEFINEDVIEW = new CLIViewType("USER_Defined", 5);
    public static final CLIViewType NOVIEW = new CLIViewType("", 6);
    public static final CLIViewType ROOTVIEW = new CLIViewType("root", 7);

    private CLIViewType(String descr, int value) {
        this._type = descr;
        this._val = value;
    }

    public String getDescription() {
        return this._type;
    }

    public static int getType(String strView) {
        if (strView.equals(ADMINVIEW.getDescription())) {
            return 1;
        }
        if (strView.equals(MONITORVIEW.getDescription())) {
            return 2;
        }
        if (strView.equals(FIREWALLVIEW.getDescription())) {
            return 3;
        }
        if (strView.equals(EASYVPNVIEW.getDescription())) {
            return 4;
        }
        if (strView.equals("")) {
            return 6;
        }
        if (strView.equals("root")) {
            return 7;
        }
        return 5;
    }

    public int getValue() {
        return this._val;
    }

    public static boolean isSDMDefinedView(String strViewName) {
        return strViewName.equals(MONITORVIEW.getDescription()) || strViewName.equals(FIREWALLVIEW.getDescription()) || strViewName.equals(EASYVPNVIEW.getDescription());
    }

    public static CLIViewType lookupEnum(int val) {
        switch (val) {
            case 1: {
                return ADMINVIEW;
            }
            case 2: {
                return MONITORVIEW;
            }
            case 3: {
                return FIREWALLVIEW;
            }
            case 4: {
                return EASYVPNVIEW;
            }
            case 7: {
                return ROOTVIEW;
            }
            case 6: {
                return NOVIEW;
            }
            case 5: {
                return USERDEFINEDVIEW;
            }
        }
        return null;
    }

    public String toString() {
        return "CLI View Type is " + this._type;
    }
}

