/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.common;

import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.Netmask;
import java.util.Vector;

public class IPAddressRange
implements Cloneable {
    private IPAddress _low;
    private IPAddress _high;

    public IPAddressRange(IPAddress low) {
        this._low = low;
    }

    public IPAddressRange(IPAddress low, IPAddress high) {
        this._low = low;
        this._high = high;
    }

    public static boolean check(IPAddress low, IPAddress high) {
        if (low == null) {
            return false;
        }
        if (high == null) {
            return true;
        }
        return high.greaterThanOrEqual(low);
    }

    public Object clone() {
        try {
            IPAddressRange newObj = (IPAddressRange)super.clone();
            if (this._low != null) {
                newObj._low = (IPAddress)this._low.clone();
            }
            if (this._high != null) {
                newObj._low = (IPAddress)this._low.clone();
            }
            return newObj;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return this;
        }
    }

    public boolean equals(Object toCmp) {
        if (toCmp == null || !(toCmp instanceof IPAddressRange)) {
            return false;
        }
        IPAddressRange toCompare = (IPAddressRange)toCmp;
        return this._low.equals(toCompare._low) && (this._high != null ? this._high.equals(toCompare._high) : toCompare._high == null);
    }

    public IPAddress getHighIPAddress() {
        return this._high;
    }

    public Vector getIPAddressRange() {
        int maxLength = 255;
        return this.getIPAddressRange(new Integer(maxLength).longValue());
    }

    public Vector getIPAddressRange(long maxLength) {
        Vector<IPAddress> retval = new Vector<IPAddress>();
        if (this._low == null) {
            return null;
        }
        long low = this._low.getUnsignedIntValue();
        if (this._high == null) {
            retval.addElement(this._low);
            return retval;
        }
        long high = this._high.getUnsignedIntValue();
        if (this._high.lessThan(this._low)) {
            return null;
        }
        int size = 0;
        long i = low;
        while (i <= high && (long)size < maxLength) {
            IPAddress addr = new IPAddress(this._low.getIntValue() + size);
            retval.addElement(addr);
            ++i;
            ++size;
        }
        return retval;
    }

    public IPAddress getLowIPAddress() {
        return this._low;
    }

    public Netmask getReverseMask() {
        if (!this.isSingleCompleteSubnet()) {
            return null;
        }
        int b0 = this._low.getByte(0) ^ this._high.getByte(0);
        int b1 = this._low.getByte(1) ^ this._high.getByte(1);
        int b2 = this._low.getByte(2) ^ this._high.getByte(2);
        int b3 = this._low.getByte(3) ^ this._high.getByte(3);
        return new Netmask(b0, b1, b2, b3);
    }

    public static boolean isRangeOverlapping(IPAddressRange r1, IPAddressRange r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.getHighIPAddress() == null) {
            if (r2.getHighIPAddress() == null ? r1.getLowIPAddress().equals(r2.getLowIPAddress()) : r2.getLowIPAddress().lessThanOrEqual(r1.getLowIPAddress()) && r1.getLowIPAddress().lessThanOrEqual(r2.getHighIPAddress())) {
                return true;
            }
        } else if (r2.getHighIPAddress() == null) {
            if (r1.getLowIPAddress().lessThanOrEqual(r2.getLowIPAddress()) && r2.getLowIPAddress().lessThanOrEqual(r1.getHighIPAddress())) {
                return true;
            }
        } else {
            if (r1.getLowIPAddress().lessThanOrEqual(r2.getLowIPAddress()) && r2.getLowIPAddress().lessThanOrEqual(r1.getHighIPAddress())) {
                return true;
            }
            if (r1.getLowIPAddress().lessThanOrEqual(r2.getHighIPAddress()) && r2.getHighIPAddress().lessThanOrEqual(r1.getHighIPAddress())) {
                return true;
            }
            if (r2.getLowIPAddress().lessThanOrEqual(r1.getLowIPAddress()) && r1.getHighIPAddress().lessThanOrEqual(r2.getHighIPAddress())) {
                return true;
            }
        }
        return false;
    }

    public boolean isSingleCompleteSubnet() {
        int[] validValues = new int[]{1, 3, 7, 15, 31, 63, 127, 255};
        int startIteration = 0;
        if (this._high == null) {
            return false;
        }
        if (this._low.equals(this._high)) {
            return false;
        }
        if (!(this._low.isClassA() && this._high.isClassA() || this._low.isClassB() && this._high.isClassB() || this._low.isClassC() && this._high.isClassC())) {
            return false;
        }
        if (this._low.isClassA()) {
            if (this._low.getByte(0) != this._high.getByte(0)) {
                return false;
            }
            startIteration = 1;
        } else if (this._low.isClassB()) {
            if (this._low.getByte(0) != this._high.getByte(0) || this._low.getByte(1) != this._high.getByte(1)) {
                return false;
            }
            startIteration = 2;
        } else {
            if (this._low.getByte(0) != this._high.getByte(0) || this._low.getByte(1) != this._high.getByte(1) || this._low.getByte(2) != this._high.getByte(2)) {
                return false;
            }
            startIteration = 3;
        }
        boolean checkForXOR = false;
        int count = startIteration;
        while (count < 4) {
            if (checkForXOR || this._low.getByte(count) != this._high.getByte(count)) {
                int xORValue = this._low.getByte(count) ^ this._high.getByte(count);
                int i = 0;
                while (i < validValues.length) {
                    if (xORValue == validValues[i]) {
                        checkForXOR = true;
                        break;
                    }
                    if (i == validValues.length - 1) {
                        return false;
                    }
                    ++i;
                }
            }
            ++count;
        }
        return true;
    }

    public void print() {
        if (this._low != null) {
            Log.getLog().debug("Low address is " + this._low.toString());
        }
        if (this._high != null) {
            Log.getLog().debug("High address is " + this._high.toString());
        }
    }

    public void setHighIPAddress(IPAddress high) {
        this._high = high;
    }

    public void setLowIPAddress(IPAddress low) throws Exception {
        if (low == null) {
            throw new Exception();
        }
        this._low = low;
    }

    public String toString() {
        return "IPAddressRange: " + this._low + "  " + this._high;
    }
}

