/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.common;

import java.util.StringTokenizer;

public class MACAddress
implements Cloneable {
    int[] m_nWords = new int[3];
    boolean m_bNull;

    public MACAddress() {
        this.m_bNull = true;
    }

    public MACAddress(int nWord0, int nWord1, int nWord2) {
        this.m_nWords[0] = nWord0;
        this.m_nWords[1] = nWord1;
        this.m_nWords[2] = nWord2;
    }

    public MACAddress(String strMACAddress) throws NumberFormatException {
        if (strMACAddress == null || strMACAddress.length() == 0) {
            this.m_bNull = true;
            return;
        }
        if (strMACAddress.startsWith(".") || strMACAddress.endsWith(".")) {
            throw new NumberFormatException(strMACAddress);
        }
        if (strMACAddress.startsWith("-") || strMACAddress.endsWith("-")) {
            throw new NumberFormatException(strMACAddress);
        }
        if (strMACAddress.indexOf("-") == -1 && strMACAddress.indexOf(".") == -1) {
            throw new NumberFormatException(strMACAddress);
        }
        if (strMACAddress.indexOf("-") != -1 && strMACAddress.indexOf(".") != -1) {
            throw new NumberFormatException(strMACAddress);
        }
        if (strMACAddress.indexOf(".") != -1) {
            StringTokenizer st = new StringTokenizer(strMACAddress, ".");
            int i = 0;
            while (i < 3) {
                if (!st.hasMoreTokens()) {
                    throw new NumberFormatException(strMACAddress);
                }
                int value = Integer.parseInt(st.nextToken(), 16);
                if (value < 0 || value > 65535) {
                    throw new NumberFormatException(strMACAddress);
                }
                this.m_nWords[i] = value;
                ++i;
            }
            if (st.hasMoreTokens()) {
                throw new NumberFormatException(strMACAddress);
            }
        } else {
            StringTokenizer st = new StringTokenizer(strMACAddress, "-");
            int i = 0;
            while (i < 3) {
                if (!st.hasMoreTokens()) {
                    throw new NumberFormatException(strMACAddress);
                }
                int value = Integer.parseInt(String.valueOf(this.handleSingleDigit(st.nextToken())) + this.handleSingleDigit(st.nextToken()), 16);
                if (value < 0 || value > 65535) {
                    throw new NumberFormatException(strMACAddress);
                }
                this.m_nWords[i] = value;
                ++i;
            }
            if (st.hasMoreTokens()) {
                throw new NumberFormatException(strMACAddress);
            }
        }
    }

    public Object clone() {
        try {
            MACAddress newObj = (MACAddress)super.clone();
            newObj.m_nWords = new int[3];
            newObj.m_nWords[0] = this.m_nWords[0];
            newObj.m_nWords[1] = this.m_nWords[1];
            newObj.m_nWords[2] = this.m_nWords[2];
            return newObj;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public boolean equals(MACAddress mac) {
        if (this.m_bNull && mac.m_bNull) {
            return true;
        }
        int i = 0;
        while (i < 3) {
            if (this.m_nWords[i] != mac.m_nWords[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String getFourDigits(int n) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 4) {
            sb.append(Integer.toString(n % 16, 16));
            n >>= 4;
            ++i;
        }
        return sb.reverse().toString();
    }

    public int getWord(int pos) {
        return this.m_nWords[pos];
    }

    private String handleSingleDigit(String strDigit) {
        if (strDigit == null) {
            return null;
        }
        if (strDigit.length() == 1) {
            return "0" + strDigit;
        }
        return strDigit;
    }

    public boolean isNull() {
        return this.m_bNull;
    }

    public boolean isValid() {
        return MACAddress.isValid(this.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isValid(String strMACAddress) {
        void var2_3;
        int i;
        StringTokenizer st;
        if (strMACAddress == null || strMACAddress.length() == 0) {
            return false;
        }
        if (strMACAddress.startsWith(".") || strMACAddress.endsWith(".")) {
            return false;
        }
        if (strMACAddress.startsWith("-") || strMACAddress.endsWith("-")) {
            return false;
        }
        if (strMACAddress.indexOf("-") == -1 && strMACAddress.indexOf(".") == -1) {
            return false;
        }
        if (strMACAddress.indexOf("-") != -1 && strMACAddress.indexOf(".") != -1) {
            return false;
        }
        int[] value = new int[3];
        if (strMACAddress.indexOf(".") != -1) {
            st = new StringTokenizer(strMACAddress, ".");
            i = 0;
            while (i < 3) {
                if (!st.hasMoreTokens()) {
                    return false;
                }
                try {
                    value[i] = Integer.parseInt(st.nextToken(), 16);
                }
                catch (Exception exception) {
                    return false;
                }
                ++i;
            }
            if (st.hasMoreTokens()) {
                return false;
            }
        } else {
            st = new StringTokenizer(strMACAddress, "-");
            i = 0;
            while (i < 3) {
                if (!st.hasMoreTokens()) {
                    return false;
                }
                try {
                    value[i] = Integer.parseInt(String.valueOf(st.nextToken()) + st.nextToken(), 16);
                }
                catch (Exception exception) {
                    return false;
                }
                ++i;
            }
            if (st.hasMoreTokens()) {
                return false;
            }
        }
        boolean i2 = false;
        while (var2_3 < 3) {
            if (value[var2_3] < 0 || value[var2_3] > 65535) {
                return false;
            }
            ++var2_3;
        }
        return value[0] != 65535 || value[1] != 65535 || value[2] != 65535;
    }

    public void setNull() {
        this.m_nWords[2] = 0;
        this.m_nWords[1] = 0;
        this.m_nWords[0] = 0;
        this.m_bNull = true;
    }

    public void setWord(int pos, int value) {
        this.m_nWords[pos] = value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getFourDigits(this.m_nWords[0]));
        sb.append(".");
        sb.append(this.getFourDigits(this.m_nWords[1]));
        sb.append(".");
        sb.append(this.getFourDigits(this.m_nWords[2]));
        return sb.toString();
    }
}

