/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.common;

import com.cisco.xdm.data.common.IPAddress;

public class Netmask
extends IPAddress {
    public static final String HOST_MASK_STR = "255.255.255.255";
    public static final String CLASS_A_MASK = "255.0.0.0";
    public static final String CLASS_B_MASK = "255.255.0.0";
    public static final String CLASS_C_MASK = "255.255.255.0";
    public static final int HOST_MASK_INT = -1;
    public static final Netmask HOST_MASK = new Netmask("255.255.255.255");
    public static final String WILD_MASK_STR = "0.0.0.0";
    public static final int WILD_MASK_INT = 0;
    public static final Netmask WILD_MASK = new Netmask("0.0.0.0");

    public Netmask() {
    }

    public Netmask(int maskInt) {
        super(maskInt);
    }

    public Netmask(int b0, int b1, int b2, int b3) {
        super(b0, b1, b2, b3);
    }

    public Netmask(IPAddress mask) {
        this(mask != null ? mask.getByte(0) : 0, mask != null ? mask.getByte(1) : 0, mask != null ? mask.getByte(2) : 0, mask != null ? mask.getByte(3) : 0);
    }

    public Netmask(String s) throws NumberFormatException {
        super(s);
    }

    public boolean equals(Netmask ip) {
        return super.equals(ip);
    }

    public static Netmask getClassBasedMaskFromIP(IPAddress addr) {
        Netmask maskClassA = new Netmask(CLASS_A_MASK);
        Netmask maskClassB = new Netmask(CLASS_B_MASK);
        Netmask maskClassC = new Netmask(CLASS_C_MASK);
        if (addr != null) {
            if (addr.isClassA()) {
                return maskClassA;
            }
            if (addr.isClassB()) {
                return maskClassB;
            }
            if (addr.isClassC()) {
                return maskClassC;
            }
        }
        return new Netmask(HOST_MASK_STR);
    }

    /*
     * Unable to fully structure code
     */
    public int getMaskLength() {
        if (!Netmask.isLegalNetmask(this)) {
            return -1;
        }
        length = 32;
        tmp = this.getIntValue();
        if (tmp != 0) ** GOTO lbl9
        return 0;
lbl-1000:
        // 1 sources

        {
            --length;
            tmp >>= 1;
lbl9:
            // 2 sources

            ** while (tmp % 2 == 0)
        }
lbl10:
        // 1 sources

        return length;
    }

    public boolean isHost() {
        return this.getIntValue() == -1;
    }

    public boolean isLegalHostMask() {
        Netmask mask = new Netmask("255.255.255.254");
        return !this.equals(HOST_MASK) && !this.equals(mask);
    }

    public boolean isLegalHostMaskIf31BitMaskAllowed() {
        Netmask mask = new Netmask("255.255.255.254");
        return !this.equals(HOST_MASK);
    }

    public static boolean isLegalNetmask(int maskInt) {
        if (maskInt == 0) {
            return false;
        }
        int LMB = Integer.MIN_VALUE;
        boolean foundzero = false;
        int i = 0;
        while (i < 32) {
            if ((maskInt & LMB) == 0) {
                foundzero = true;
            } else if (foundzero) {
                return false;
            }
            maskInt <<= 1;
            ++i;
        }
        return true;
    }

    public static boolean isLegalNetmask(Netmask nm) {
        return Netmask.isLegalNetmask(nm.getIntValue());
    }

    public static boolean isLegalNetmask(String s) {
        if (!IPAddress.isLegalIPAddress(s)) {
            return false;
        }
        try {
            Netmask mask = new Netmask(s);
            return Netmask.isLegalNetmask(mask.getIntValue());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isLegalWildcardNetmask(String s) {
        return IPAddress.isLegalIPAddress(s);
    }

    public boolean isMoreGeneralThan(Netmask mask) {
        return this.lessThan(mask);
    }

    public boolean isMoreSpecificThan(Netmask mask) {
        return this.greaterThan(mask);
    }

    public static boolean isValidWildcardNetmask(int maskInt) {
        int RMB = 1;
        boolean foundzero = false;
        int i = 0;
        while (i < 32) {
            if ((maskInt & RMB) == 0) {
                foundzero = true;
            } else if (foundzero) {
                return false;
            }
            maskInt >>= 1;
            ++i;
        }
        return true;
    }

    public static boolean isValidWildcardNetmask(Netmask nm) {
        return Netmask.isValidWildcardNetmask(nm.getIntValue());
    }

    public static boolean isValidWildcardNetmask(String s) {
        if (!IPAddress.isLegalIPAddress(s)) {
            return false;
        }
        return Netmask.isValidWildcardNetmask(new IPAddress(s).getIntValue());
    }

    public boolean isWildAny() {
        return this.getIntValue() == 0;
    }

    /*
     * Unable to fully structure code
     */
    public static String lengthToString(int length) {
        mask = "";
        working = length / 8;
        i = 0;
        while (i < working) {
            mask = mask.concat("255.");
            ++i;
        }
        remainder = length % 8;
        if (remainder <= 0) ** GOTO lbl38
        ++working;
        switch (remainder) {
            case 7: {
                mask = mask.concat("254.");
                ** GOTO lbl38
            }
            case 6: {
                mask = mask.concat("252.");
                ** GOTO lbl38
            }
            case 5: {
                mask = mask.concat("248.");
                ** GOTO lbl38
            }
            case 4: {
                mask = mask.concat("240.");
                ** GOTO lbl38
            }
            case 3: {
                mask = mask.concat("224.");
                ** GOTO lbl38
            }
            case 2: {
                mask = mask.concat("192.");
                ** GOTO lbl38
            }
            case 1: {
                mask = mask.concat("128.");
                ** GOTO lbl38
            }
            default: {
                if (working < 4) ** continue;
            }
        }
        while (true) lbl-1000:
        // 2 sources

        {
            mask = mask.concat("0.");
            ++working;
lbl38:
            // 9 sources

            if (working < 4) ** GOTO lbl-1000
            break;
        }
        retVal = mask.substring(0, mask.length() - 1);
        return retVal;
    }

    public static String lengthToString(String lengthString) {
        int length = 0;
        try {
            length = Integer.parseInt(lengthString);
        }
        catch (Exception exception) {
            return "";
        }
        String retVal = Netmask.lengthToString(length);
        return retVal;
    }

    public Netmask reverseMask() {
        int orig = this.getIntValue();
        return new Netmask(~orig);
    }
}

