/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.common;

import com.cisco.xdm.data.acl.ACEProtocols;
import com.cisco.xdm.data.common.PortMapEntry;
import com.cisco.xdm.data.discovery.XDMDiscovery;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.util.Env;
import java.util.Hashtable;
import java.util.Vector;

public class PortMap {
    public static Vector tcpVector = null;
    public static Vector udpVector = null;
    public static Vector icmpVector = null;
    public static Vector ipVector = null;
    public static Vector _udpPortsSupported = null;
    public static Vector _tcpPortsSupported = null;
    public static int ICMP_ALTADDRESS = 6;
    public static int ICMP_CONVERSION = 31;
    public static int ICMP_ECHO = 8;
    public static int ICMP_ECHOREPLY = 0;
    public static int ICMP_INFOREPLY = 16;
    public static int ICMP_INFOREQUEST = 15;
    public static int ICMP_MASKREPLY = 18;
    public static int ICMP_MASKREQUEST = 17;
    public static int ICMP_MOBILEREDIRECT = 32;
    public static int ICMP_PARAMETER = 12;
    public static int ICMP_REDIRECT = 5;
    public static int ICMP_RDPADVERT = 9;
    public static int ICMP_RDPSOLICIT = 10;
    public static int ICMP_QUENCH = 4;
    public static int ICMP_TIMEEXCEEDED = 11;
    public static int ICMP_TIMESTAMPREPLY = 14;
    public static int ICMP_TIMESTAMP = 13;
    public static int ICMP_TRACEROUTE = 30;
    public static int ICMP_UNREACHABLE = 3;
    public static String ICMP_ADMINPROHIBITED_KEY = "3:13";
    public static String ICMP_ALTADDRESS_KEY = "6";
    public static String ICMP_CONVERSION_KEY = "31";
    public static String ICMP_DODHOST_KEY = "3:10";
    public static String ICMP_DOCNET_KEY = "3:9";
    public static String ICMP_ECHO_KEY = "8";
    public static String ICMP_ECHOREPLY_KEY = "0";
    public static String ICMP_GENPARAM_KEY = "33:0";
    public static String ICMP_HOSTISOLATED_KEY = "3:8";
    public static String ICMP_HOSTPRECED_KEY = "3:14";
    public static String ICMP_HOSTREDIRECT_KEY = "5:1";
    public static String ICMP_HOSTTOSREDIRECT_KEY = "5:3";
    public static String ICMP_HOSTTOSUNREACH_KEY = "3:12";
    public static String ICMP_HOSTUNKNOWN_KEY = "3:7";
    public static String ICMP_HOSTUNREACH_KEY = "3:1";
    public static String ICMP_INFOREPLY_KEY = "16";
    public static String ICMP_INFOREQUEST_KEY = "15";
    public static String ICMP_MASKREPLY_KEY = "18";
    public static String ICMP_MASKREQUEST_KEY = "17";
    public static String ICMP_MOBILEREDIRECT_KEY = "32";
    public static String ICMP_NETREDIRECT_KEY = "5:0";
    public static String ICMP_NETTOSREDIRECT_KEY = "5:2";
    public static String ICMP_NETTOSUNREACH_KEY = "3:11";
    public static String ICMP_NETUNREACH_KEY = "3:0";
    public static String ICMP_NETWORKUNKNOWN_KEY = "3:6";
    public static String ICMP_NOROOM_KEY = "12:2";
    public static String ICMP_OPTIONMISSING_KEY = "12:1";
    public static String ICMP_PACTOOBIG_KEY = "3:4";
    public static String ICMP_PARAMETER_KEY = "12";
    public static String ICMP_PORTUNREACH_KEY = "3:3";
    public static String ICMP_PRECEDUNREACH_KEY = "3:15";
    public static String ICMP_PROTOUNREACH_KEY = "3:2";
    public static String ICMP_REASSEMBLYTIMEOUT_KEY = "11:1";
    public static String ICMP_REDIRECT_KEY = "5";
    public static String ICMP_RDPADVERT_KEY = "9";
    public static String ICMP_RDPSOLICIT_KEY = "10";
    public static String ICMP_QUENCH_KEY = "4";
    public static String ICMP_SRCROUTEFAIL_KEY = "3:5";
    public static String ICMP_TIMEEXCEEDED_KEY = "11";
    public static String ICMP_TIMESTAMPREPLY_KEY = "14";
    public static String ICMP_TIMESTAMP_KEY = "13";
    public static String ICMP_TRACEROUTE_KEY = "30";
    public static String ICMP_TTLEXCEED_KEY = "11:0";
    public static String ICMP_UNREACHABLE_KEY = "3";
    public static String ICMP_ADMINPROHIBITED_NAME = "administratively-prohibited";
    public static String ICMP_ALTADDRESS_NAME = "alternate-address";
    public static String ICMP_CONVERSION_NAME = "conversion-error";
    public static String ICMP_DODHOST_NAME = "dod-host-prohibited";
    public static String ICMP_DOCNET_NAME = "dod-net-prohibited";
    public static String ICMP_ECHO_NAME = "echo";
    public static String ICMP_ECHOREPLY_NAME = "echo-reply";
    public static String ICMP_GENPARAM_NAME = "general-parameter-problem";
    public static String ICMP_HOSTISOLATED_NAME = "host-isolated";
    public static String ICMP_HOSTPRECED_NAME = "host-precedence-unreachable";
    public static String ICMP_HOSTREDIRECT_NAME = "host-redirect";
    public static String ICMP_HOSTTOSREDIRECT_NAME = "host-tos-redirect";
    public static String ICMP_HOSTTOSUNREACH_NAME = "host-tos-unreachable";
    public static String ICMP_HOSTUNKNOWN_NAME = "host-unknown";
    public static String ICMP_HOSTUNREACH_NAME = "host-unreachable";
    public static String ICMP_INFOREPLY_NAME = "information-reply";
    public static String ICMP_INFOREQUEST_NAME = "information-request";
    public static String ICMP_MASKREPLY_NAME = "mask-reply";
    public static String ICMP_MASKREQUEST_NAME = "mask-request";
    public static String ICMP_MOBILEREDIRECT_NAME = "mobile-redirect";
    public static String ICMP_NETREDIRECT_NAME = "net-redirect";
    public static String ICMP_NETTOSREDIRECT_NAME = "net-tos-redirect";
    public static String ICMP_NETTOSUNREACH_NAME = "net-tos-unreachable";
    public static String ICMP_NETUNREACH_NAME = "net-unreachable";
    public static String ICMP_NETWORKUNKNOWN_NAME = "network-unknown";
    public static String ICMP_NOROOM_NAME = "no-room-for-option";
    public static String ICMP_OPTIONMISSING_NAME = "option-missing";
    public static String ICMP_PACTOOBIG_NAME = "packet-too-big";
    public static String ICMP_PARAMETER_NAME = "parameter-problem";
    public static String ICMP_PORTUNREACH_NAME = "port-unreachable";
    public static String ICMP_PRECEDUNREACH_NAME = "precedence-unreachable";
    public static String ICMP_PROTOUNREACH_NAME = "protocol-unreachable";
    public static String ICMP_REASSEMBLYTIMEOUT_NAME = "reassembly-timeout";
    public static String ICMP_REDIRECT_NAME = "redirect";
    public static String ICMP_RDPADVERT_NAME = "router-advertisement";
    public static String ICMP_RDPSOLICIT_NAME = "router-solicitation";
    public static String ICMP_QUENCH_NAME = "source-quench";
    public static String ICMP_SRCROUTEFAIL_NAME = "source-route-failed";
    public static String ICMP_TIMEEXCEEDED_NAME = "time-exceeded";
    public static String ICMP_TIMESTAMPREPLY_NAME = "timestamp-reply";
    public static String ICMP_TIMESTAMP_NAME = "timestamp-request";
    public static String ICMP_TRACEROUTE_NAME = "traceroute";
    public static String ICMP_TTLEXCEED_NAME = "ttl-exceeded";
    public static String ICMP_UNREACHABLE_NAME = "unreachable";
    public static int IGMP_DVMRP = 3;
    public static int IGMP_HOSTQUERY = 1;
    public static int IGMP_HOSTRPT = 2;
    public static int IGMP_PIM = 4;
    public static int IGMP_TRACE = 5;
    public static String IGMP_DVMRP_NAME = "dvmrp";
    public static String IGMP_HOSTQUERY_NAME = "host-query";
    public static String IGMP_HOSTRPT_NAME = "host-report";
    public static String IGMP_PIM_NAME = "pim";
    public static String IGMP_TRACE_NAME = "trace";
    public static PortMapEntry[] tosTable = new PortMapEntry[]{new PortMapEntry("max-reliability", 2), new PortMapEntry("max-throughput", 4), new PortMapEntry("min-delay", 8), new PortMapEntry("min-monetary-cost", 1), new PortMapEntry("normal", 0), new PortMapEntry("", -1)};
    public static PortMapEntry[] dscpTable = new PortMapEntry[]{new PortMapEntry("default", 0), new PortMapEntry("af11", 10), new PortMapEntry("af12", 12), new PortMapEntry("af13", 14), new PortMapEntry("af21", 18), new PortMapEntry("af22", 20), new PortMapEntry("af23", 22), new PortMapEntry("af31", 26), new PortMapEntry("af32", 28), new PortMapEntry("af33", 30), new PortMapEntry("af41", 34), new PortMapEntry("af42", 36), new PortMapEntry("af43", 38), new PortMapEntry("cs1", 8), new PortMapEntry("cs2", 16), new PortMapEntry("cs3", 24), new PortMapEntry("cs4", 32), new PortMapEntry("cs5", 40), new PortMapEntry("cs5", 48), new PortMapEntry("cs6", 56), new PortMapEntry("", -1)};
    public static PortMapEntry[] precedenceTable = new PortMapEntry[]{new PortMapEntry("routine", 0), new PortMapEntry("priority", 1), new PortMapEntry("immidiate", 2), new PortMapEntry("flash", 3), new PortMapEntry("flash-override", 4), new PortMapEntry("critical", 5), new PortMapEntry("internet", 6), new PortMapEntry("network", 7), new PortMapEntry("", -1)};
    public static PortMapEntry[] tcpPortTable = new PortMapEntry[]{new PortMapEntry("bgp", 179), new PortMapEntry("chargen", 19), new PortMapEntry("cmd", 514), new PortMapEntry("daytime", 13), new PortMapEntry("discard", 9), new PortMapEntry("domain", 53), new PortMapEntry("echo", 7), new PortMapEntry("exec", 512), new PortMapEntry("finger", 79), new PortMapEntry("ftp", 21), new PortMapEntry("ftp-data", 20), new PortMapEntry("gopher", 70), new PortMapEntry("hostname", 101), new PortMapEntry("ident", 113), new PortMapEntry("irc", 194), new PortMapEntry("klogin", 543), new PortMapEntry("kshell", 544), new PortMapEntry("login", 513), new PortMapEntry("lpd", 515), new PortMapEntry("nntp", 119), new PortMapEntry("pim-auto-rp", 496), new PortMapEntry("pop2", 109), new PortMapEntry("pop3", 110), new PortMapEntry("smtp", 25), new PortMapEntry("sunrpc", 111), new PortMapEntry("tacacs", 49), new PortMapEntry("talk", 517), new PortMapEntry("telnet", 23), new PortMapEntry("time", 37), new PortMapEntry("uucp", 540), new PortMapEntry("whois", 43), new PortMapEntry("www", 80), new PortMapEntry("", -1)};
    public static PortMapEntry[] udpPortTable = new PortMapEntry[]{new PortMapEntry("biff", 512), new PortMapEntry("bootpc", 68), new PortMapEntry("bootps", 67), new PortMapEntry("discard", 9), new PortMapEntry("dnsix", 195), new PortMapEntry("domain", 53), new PortMapEntry("echo", 7), new PortMapEntry("isakmp", 500), new PortMapEntry("mobile-ip", 434), new PortMapEntry("nameserver", 42), new PortMapEntry("netbios-dgm", 138), new PortMapEntry("netbios-ns", 137), new PortMapEntry("netbios-ss", 139), new PortMapEntry("non500-isakmp", 4500), new PortMapEntry("ntp", 123), new PortMapEntry("pim-auto-rp", 496), new PortMapEntry("rip", 520), new PortMapEntry("snmp", 161), new PortMapEntry("snmptrap", 162), new PortMapEntry("sunrpc", 111), new PortMapEntry("syslog", 514), new PortMapEntry("tacacs", 49), new PortMapEntry("talk", 517), new PortMapEntry("tftp", 69), new PortMapEntry("time", 37), new PortMapEntry("who", 513), new PortMapEntry("xdmcp", 177), new PortMapEntry("", -1)};
    public static PortMapEntry[] icmpTypeTable = new PortMapEntry[]{new PortMapEntry(ICMP_ALTADDRESS, ICMP_ALTADDRESS_NAME), new PortMapEntry(ICMP_CONVERSION, ICMP_CONVERSION_NAME), new PortMapEntry(ICMP_ECHO, ICMP_ECHO_NAME), new PortMapEntry(ICMP_ECHOREPLY, ICMP_ECHOREPLY_NAME), new PortMapEntry(ICMP_INFOREPLY, ICMP_INFOREPLY_NAME), new PortMapEntry(ICMP_INFOREQUEST, ICMP_INFOREQUEST_NAME), new PortMapEntry(ICMP_MASKREPLY, ICMP_MASKREPLY_NAME), new PortMapEntry(ICMP_MASKREQUEST, ICMP_MASKREQUEST_NAME), new PortMapEntry(ICMP_MOBILEREDIRECT, ICMP_MOBILEREDIRECT_NAME), new PortMapEntry(ICMP_PARAMETER, ICMP_PARAMETER_NAME), new PortMapEntry(ICMP_REDIRECT, ICMP_REDIRECT_NAME), new PortMapEntry(ICMP_RDPADVERT, ICMP_RDPADVERT_NAME), new PortMapEntry(ICMP_RDPSOLICIT, ICMP_RDPSOLICIT_NAME), new PortMapEntry(ICMP_QUENCH, ICMP_QUENCH_NAME), new PortMapEntry(ICMP_TIMEEXCEEDED, ICMP_TIMEEXCEEDED_NAME), new PortMapEntry(ICMP_TIMESTAMPREPLY, ICMP_TIMESTAMPREPLY_NAME), new PortMapEntry(ICMP_TIMESTAMP, ICMP_TIMESTAMP_NAME), new PortMapEntry(ICMP_TRACEROUTE, ICMP_TRACEROUTE_NAME), new PortMapEntry(ICMP_UNREACHABLE, ICMP_UNREACHABLE_NAME), new PortMapEntry("", -1)};
    public static PortMapEntry[] igmpTypeTable = new PortMapEntry[]{new PortMapEntry(IGMP_DVMRP_NAME, IGMP_DVMRP), new PortMapEntry(IGMP_HOSTQUERY_NAME, IGMP_HOSTQUERY), new PortMapEntry(IGMP_HOSTRPT_NAME, IGMP_HOSTRPT), new PortMapEntry(IGMP_PIM_NAME, IGMP_PIM), new PortMapEntry(IGMP_TRACE_NAME, IGMP_TRACE), new PortMapEntry("", -1)};
    public static PortMapEntry[] ipProtTable = new PortMapEntry[]{new PortMapEntry("ahp", 51), new PortMapEntry("eigrp", 88), new PortMapEntry("esp", 50), new PortMapEntry("gre", 47), new PortMapEntry("icmp", 1), new PortMapEntry("igmp", 2), new PortMapEntry("igrp", 9), new PortMapEntry("ip", 0), new PortMapEntry("ipinip", 4), new PortMapEntry("nos", 94), new PortMapEntry("ospf", 89), new PortMapEntry("pcp", 108), new PortMapEntry("pim", 103), new PortMapEntry("tcp", 6), new PortMapEntry("udp", 17), new PortMapEntry("", -1)};
    private static Hashtable _icmpMap = null;

    public static void discoverUdpPortSupported(IOSCmdResponse[] resps) {
        String[] udpOptions = new String[]{"biff", "bootpc", "bootps", "discard", "dnsix", "domain", "echo", "isakmp", "mobile-ip", "nameserver", "netbios-dgm", "netbios-ns", "netbios-ss", "non500-isakmp", "ntp", "pim-auto-rp", "rip", "snmp", "snmptrap", "sunrpc", "syslog", "tacacs", "talk", "tftp", "time", "who", "xdmcp"};
        String[] tcpOptions = new String[]{"bgp", "chargen", "cmd", "daytime", "discard", "domain", "echo", "exec", "finger", "ftp", "ftp-data", "gopher", "hostname", "ident", "irc", "klogin", "kshell", "login", "lpd", "nntp", "pim-auto-rp", "pop2", "pop3", "smtp", "sunrpc", "syslog", "tacacs", "talk", "telnet", "time", "uucp", "whois", "www"};
        boolean[] results = null;
        results = XDMDiscovery.getOptionsSupportedOnCmd(resps[0], udpOptions);
        if (_udpPortsSupported == null) {
            _udpPortsSupported = new Vector();
        } else {
            _udpPortsSupported.removeAllElements();
        }
        int i = 0;
        while (i < results.length) {
            if (results[i]) {
                _udpPortsSupported.addElement(udpOptions[i]);
            }
            ++i;
        }
        results = null;
        results = XDMDiscovery.getOptionsSupportedOnCmd(resps[1], tcpOptions);
        if (_tcpPortsSupported == null) {
            _tcpPortsSupported = new Vector();
        } else {
            _tcpPortsSupported.removeAllElements();
        }
        int i2 = 0;
        while (i2 < results.length) {
            if (results[i2]) {
                _tcpPortsSupported.addElement(tcpOptions[i2]);
            }
            ++i2;
        }
    }

    public static String findApplByPort(int proto, int port) {
        if (proto == 6) {
            return PortMap.findKeyByValue(port, tcpPortTable);
        }
        if (proto == 17) {
            return PortMap.findKeyByValue(port, udpPortTable);
        }
        if (proto == 1) {
            return PortMap.findKeyByValue(port, icmpTypeTable);
        }
        return null;
    }

    public static String findApplByPort(String proto, int port) {
        int prot = PortMap.findValueByKey(proto, ipProtTable);
        return PortMap.findApplByPort(prot, port);
    }

    public static String findICMPNameByType(int type) {
        return PortMap.findKeyByValue(type, icmpTypeTable);
    }

    public static int findICMPTypeByName(String name) {
        return PortMap.findValueByKey(name, icmpTypeTable);
    }

    public static String findIPNameByProt(int prot) {
        return PortMap.findKeyByValue(prot, ipProtTable);
    }

    public static int findIPProtByName(String prot) {
        int protNum = PortMap.findValueByKey(prot, ipProtTable);
        if (protNum != -1) {
            if (!ACEProtocols.isProtocolSupported(prot)) {
                return -1;
            }
            return protNum;
        }
        try {
            protNum = Integer.parseInt(prot);
            if (protNum >= 0 && protNum <= 255) {
                return protNum;
            }
            return -1;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static String findKeyByValue(int v, PortMapEntry[] tab) {
        int index = 0;
        while (tab[index].value != -1) {
            if (tab[index].value == v) {
                return tab[index].key;
            }
            ++index;
        }
        return null;
    }

    public static int findPortByAppl(int proto, String appl) {
        if (proto == 6) {
            return PortMap.findValueByKey(appl, tcpPortTable);
        }
        if (proto == 17) {
            return PortMap.findValueByKey(appl, udpPortTable);
        }
        if (proto == 1) {
            return PortMap.findValueByKey(appl, icmpTypeTable);
        }
        return -1;
    }

    public static int findPortByAppl(String proto, String appl) {
        int prot = PortMap.findValueByKey(proto, ipProtTable);
        return PortMap.findPortByAppl(prot, appl);
    }

    public static String findTcpApplByPort(int port) {
        return PortMap.findKeyByValue(port, tcpPortTable);
    }

    public static int findTcpPortByAppl(String appl) {
        return PortMap.findValueByKey(appl, tcpPortTable);
    }

    public static String findUdpApplByPort(int port) {
        return PortMap.findKeyByValue(port, udpPortTable);
    }

    public static int findUdpPortByAppl(String appl) {
        return PortMap.findValueByKey(appl, udpPortTable);
    }

    public static int findValueByKey(String s, PortMapEntry[] tab) {
        int index = 0;
        while (tab[index].value != -1) {
            if (tab[index].key.equalsIgnoreCase(s)) {
                return tab[index].value;
            }
            ++index;
        }
        return -1;
    }

    private static void generateIcmpMap() {
        _icmpMap = new Hashtable();
        _icmpMap.put(ICMP_ADMINPROHIBITED_KEY, ICMP_ADMINPROHIBITED_NAME);
        _icmpMap.put(ICMP_ALTADDRESS_KEY, ICMP_ALTADDRESS_NAME);
        _icmpMap.put(ICMP_CONVERSION_KEY, ICMP_CONVERSION_NAME);
        _icmpMap.put(ICMP_DODHOST_KEY, ICMP_DODHOST_NAME);
        _icmpMap.put(ICMP_DOCNET_KEY, ICMP_DOCNET_NAME);
        _icmpMap.put(ICMP_ECHO_KEY, ICMP_ECHO_NAME);
        _icmpMap.put(ICMP_ECHOREPLY_KEY, ICMP_ECHOREPLY_NAME);
        _icmpMap.put(ICMP_GENPARAM_KEY, ICMP_GENPARAM_NAME);
        _icmpMap.put(ICMP_HOSTISOLATED_KEY, ICMP_HOSTISOLATED_NAME);
        _icmpMap.put(ICMP_HOSTPRECED_KEY, ICMP_HOSTPRECED_NAME);
        _icmpMap.put(ICMP_HOSTREDIRECT_KEY, ICMP_HOSTREDIRECT_NAME);
        _icmpMap.put(ICMP_HOSTTOSREDIRECT_KEY, ICMP_HOSTTOSREDIRECT_NAME);
        _icmpMap.put(ICMP_HOSTTOSUNREACH_KEY, ICMP_HOSTTOSUNREACH_NAME);
        _icmpMap.put(ICMP_HOSTUNKNOWN_KEY, ICMP_HOSTUNKNOWN_NAME);
        _icmpMap.put(ICMP_HOSTUNREACH_KEY, ICMP_HOSTUNREACH_NAME);
        _icmpMap.put(ICMP_INFOREPLY_KEY, ICMP_INFOREPLY_NAME);
        _icmpMap.put(ICMP_INFOREQUEST_KEY, ICMP_INFOREQUEST_NAME);
        _icmpMap.put(ICMP_MASKREPLY_KEY, ICMP_MASKREPLY_NAME);
        _icmpMap.put(ICMP_MASKREQUEST_KEY, ICMP_MASKREQUEST_NAME);
        _icmpMap.put(ICMP_MOBILEREDIRECT_KEY, ICMP_MOBILEREDIRECT_NAME);
        _icmpMap.put(ICMP_NETREDIRECT_KEY, ICMP_NETREDIRECT_NAME);
        _icmpMap.put(ICMP_NETTOSREDIRECT_KEY, ICMP_NETTOSREDIRECT_NAME);
        _icmpMap.put(ICMP_NETTOSUNREACH_KEY, ICMP_NETTOSUNREACH_NAME);
        _icmpMap.put(ICMP_NETUNREACH_KEY, ICMP_NETUNREACH_NAME);
        _icmpMap.put(ICMP_NETWORKUNKNOWN_KEY, ICMP_NETWORKUNKNOWN_NAME);
        _icmpMap.put(ICMP_NOROOM_KEY, ICMP_NOROOM_NAME);
        _icmpMap.put(ICMP_OPTIONMISSING_KEY, ICMP_OPTIONMISSING_NAME);
        _icmpMap.put(ICMP_PACTOOBIG_KEY, ICMP_PACTOOBIG_NAME);
        _icmpMap.put(ICMP_PARAMETER_KEY, ICMP_PARAMETER_NAME);
        _icmpMap.put(ICMP_PORTUNREACH_KEY, ICMP_PORTUNREACH_NAME);
        _icmpMap.put(ICMP_PRECEDUNREACH_KEY, ICMP_PRECEDUNREACH_NAME);
        _icmpMap.put(ICMP_PROTOUNREACH_KEY, ICMP_PROTOUNREACH_NAME);
        _icmpMap.put(ICMP_REASSEMBLYTIMEOUT_KEY, ICMP_REASSEMBLYTIMEOUT_NAME);
        _icmpMap.put(ICMP_REDIRECT_KEY, ICMP_REDIRECT_NAME);
        _icmpMap.put(ICMP_RDPADVERT_KEY, ICMP_RDPADVERT_NAME);
        _icmpMap.put(ICMP_RDPSOLICIT_KEY, ICMP_RDPSOLICIT_NAME);
        _icmpMap.put(ICMP_QUENCH_KEY, ICMP_QUENCH_NAME);
        _icmpMap.put(ICMP_SRCROUTEFAIL_KEY, ICMP_SRCROUTEFAIL_NAME);
        _icmpMap.put(ICMP_TIMEEXCEEDED_KEY, ICMP_TIMEEXCEEDED_NAME);
        _icmpMap.put(ICMP_TIMESTAMPREPLY_KEY, ICMP_TIMESTAMPREPLY_NAME);
        _icmpMap.put(ICMP_TIMESTAMP_KEY, ICMP_TIMESTAMP_NAME);
        _icmpMap.put(ICMP_TRACEROUTE_KEY, ICMP_TRACEROUTE_NAME);
        _icmpMap.put(ICMP_TTLEXCEED_KEY, ICMP_TTLEXCEED_NAME);
        _icmpMap.put(ICMP_UNREACHABLE_KEY, ICMP_UNREACHABLE_NAME);
    }

    public static Vector getICMPTypes() {
        if (icmpVector == null) {
            icmpVector = PortMap.makeICMPVector();
        }
        return icmpVector;
    }

    public static Vector getIPProtocols() {
        if (ipVector == null) {
            ipVector = PortMap.makeIPProtVector();
        }
        return ipVector;
    }

    public static String getIcmpTypeName(int icmpType) {
        return PortMap.getIcmpTypeName(icmpType, -1);
    }

    public static String getIcmpTypeName(int icmpType, int icmpCode) {
        String key = String.valueOf(icmpType);
        if (icmpCode != -1) {
            key = String.valueOf(key) + ":" + String.valueOf(icmpCode);
        }
        if (_icmpMap == null) {
            PortMap.generateIcmpMap();
        }
        return (String)_icmpMap.get(new String(key));
    }

    public static Vector getTCPApplNames() {
        if (tcpVector == null) {
            tcpVector = PortMap.makeTCPVector();
        }
        return tcpVector;
    }

    public static Vector getUDPApplNames() {
        if (udpVector == null) {
            udpVector = PortMap.makeUDPVector();
        }
        return udpVector;
    }

    public static boolean isTcpPortSupported(String port) {
        return _tcpPortsSupported.contains(port);
    }

    public static boolean isUdpPortSupported(String port) {
        return _udpPortsSupported.contains(port);
    }

    private static Vector makeICMPVector() {
        Vector<String> ret = new Vector<String>();
        int index = 0;
        while (PortMap.icmpTypeTable[index].value != -1) {
            ret.addElement(PortMap.icmpTypeTable[index].key);
            ++index;
        }
        return ret;
    }

    private static Vector makeIPProtVector() {
        Vector<String> ret = new Vector<String>();
        int index = 0;
        while (PortMap.ipProtTable[index].value != -1) {
            ret.addElement(PortMap.ipProtTable[index].key);
            ++index;
        }
        return ret;
    }

    private static Vector makeTCPVector() {
        Vector<String> ret = new Vector<String>();
        int index = 0;
        while (PortMap.tcpPortTable[index].value != -1) {
            ret.addElement(PortMap.tcpPortTable[index].key);
            ++index;
        }
        return ret;
    }

    private static Vector makeUDPVector() {
        Vector<String> ret = new Vector<String>();
        int index = 0;
        while (PortMap.udpPortTable[index].value != -1) {
            ret.addElement(PortMap.udpPortTable[index].key);
            ++index;
        }
        return ret;
    }

    public static int portStringToNumber(String portStr, int ipProto) {
        int result;
        switch (ipProto) {
            case 1: {
                result = PortMap.findICMPTypeByName(portStr);
                break;
            }
            case 6: {
                result = PortMap.findTcpPortByAppl(portStr);
                break;
            }
            case 17: {
                result = PortMap.findUdpPortByAppl(portStr);
                break;
            }
            default: {
                throw new IllegalArgumentException("PDM internal error : portStringToNumber can only handle tcp, udp and icmp");
            }
        }
        if (result == -1) {
            try {
                result = Integer.parseInt(portStr);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException(String.valueOf(Env.getString((int)10321)) + " " + portStr);
            }
            if (ipProto == 6 || ipProto == 17) {
                if (result < 0 || result > 65535) {
                    throw new IllegalArgumentException(Env.getString((int)10320));
                }
            } else if (ipProto == 1 && (result < 0 || result > 255)) {
                throw new IllegalArgumentException(Env.getString((int)10319));
            }
        }
        return result;
    }
}

