/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.common;

import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.acl.ACL;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.StandardACE;
import com.cisco.xdm.data.atm.AdslInfo;
import com.cisco.xdm.data.atm.AdslOverIsdnInfo;
import com.cisco.xdm.data.atm.AtmHelper;
import com.cisco.xdm.data.atm.Pvc;
import com.cisco.xdm.data.atm.PvcCollection;
import com.cisco.xdm.data.atm.ShdslInfo;
import com.cisco.xdm.data.authentication.PPPAuthentication;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.IPAddressType;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.dialer.DialerList;
import com.cisco.xdm.data.dialer.DialerListCollection;
import com.cisco.xdm.data.interfaces.Atm;
import com.cisco.xdm.data.interfaces.AtmSubInterface;
import com.cisco.xdm.data.interfaces.Dialer;
import com.cisco.xdm.data.interfaces.Ethernet;
import com.cisco.xdm.data.interfaces.EthernetSubInterface;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.IfIPAddress;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import com.cisco.xdm.data.interfaces.XDMSubInterfaces;
import com.cisco.xdm.data.interfaces.XDMUnsupportedIf;
import com.cisco.xdm.data.nat.NatDynamicRule;
import com.cisco.xdm.data.nat.NatRule;
import com.cisco.xdm.data.routing.StaticRoute;
import com.cisco.xdm.data.vpdn.VPDN;
import com.cisco.xdm.data.vpdn.VPDNGroup;
import com.cisco.xdm.data.vpdn.VPDNGroupCollection;
import java.util.Enumeration;
import java.util.Vector;

public class WANHelperBase {
    public static int TCP_SIZE = 1412;
    public static int DONT_DELETE_VPDN = 0;
    public static int DELETE_VPDN_WITH_WARN = 1;
    public static int DELETE_VPDN = 2;

    private static void adjustTCPSize(DeviceBase dev) {
        XDMInterfaces Ifs = dev.getIfs();
        Enumeration e = Ifs.elements();
        while (e.hasMoreElements()) {
            XDMInterfaceBase If = (XDMInterfaceBase)e.nextElement();
            if (If.getBridgeGroup() != 0) continue;
            if (If.getIfID().isL3Ethernet()) {
                if (((Ethernet)If).getConnectionType() == 0 && (((Ethernet)If).getTcpSize() == -1 || ((Ethernet)If).getTcpSize() > TCP_SIZE)) {
                    ((Ethernet)If).setTcpSize(TCP_SIZE);
                }
                if (((Ethernet)If).getIpAddr() == null || ((Ethernet)If).getDir() != 0 || ((Ethernet)If).getTcpSize() != -1 && ((Ethernet)If).getTcpSize() <= TCP_SIZE) continue;
                ((Ethernet)If).setTcpSize(TCP_SIZE);
                continue;
            }
            if (If.getIfID().getType() != 1007 && If.getIfID().getType() != 1010 || If.getIpAddr() == null || If.getTcpSize() != -1 && If.getTcpSize() <= TCP_SIZE) continue;
            If.setTcpSize(TCP_SIZE);
        }
    }

    public static Dialer createPPPOAConnection(Atm atm, String equipmentType, String linerate, String operatingMode, int vpi, int vci, String encapsulation, IfIPAddress ipaddr, DeviceBase dev, PPPAuthentication ppp, String strDesc) throws XDMException {
        Log.getLog().debug("createPPPOAConnection() for " + atm.getIfID());
        Log.getLog().debug("atm\t" + atm + "\nequipmentType" + equipmentType + "\nlinerate\t" + linerate + "\noperatingMode\t" + operatingMode + "\nvpi\t" + vpi + "\nvci\t" + vci + "\nencapsulation\t" + encapsulation + "\nipaddr " + ipaddr);
        atm.shutdown(false);
        int id = atm.getSubInterfaces().getNextAvailableID();
        IfID ifid = new IfID(atm.getIfID().getType(), atm.getIfID().getSlot(), atm.getIfID().getModuleSlot(), atm.getIfID().getPort(), atm.getIfID().getChannel(), id);
        AtmSubInterface subif = new AtmSubInterface(ifid, atm);
        subif.setParent(atm.getSubInterfaces());
        atm.getSubInterfaces().put(subif);
        if (subif.getIfID().getType() == 504) {
            if (linerate != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslLinerate(linerate);
            }
            if (operatingMode != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
            if (equipmentType != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslEquipmentType(equipmentType);
            }
        } else if (subif.getIfID().getType() == 503) {
            if (operatingMode != null) {
                ((AdslInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
        } else if (subif.getIfID().getType() == 532) {
            if (operatingMode != null) {
                ((AdslOverIsdnInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
        } else {
            subif.getIfID().getType();
        }
        PvcCollection pvcs = subif.getPvcs();
        Pvc pvc = new Pvc(pvcs, false);
        pvc.setVPI(vpi);
        pvc.setVCI(vci);
        pvc.setEncapsulation(encapsulation);
        pvc.setAal5muxProtocol("ppp");
        pvc.setProtocol("PPPoA");
        pvc.setConnectionType("PPPoA");
        pvcs.addPvc(pvc);
        DialerListCollection dlc = dev.getDialerListCollection();
        DialerList dl = dlc.createDialerList();
        dlc.addDialerList(dl);
        XDMInterfaces ifs = dev.getIfs();
        Dialer d = (Dialer)ifs.createNextLogicIf(1001);
        ifs.put(d);
        d.setEncapsulation("ppp");
        int dialpool = ifs.getNextDialPoolNumber();
        d.setDialPoolNumber(dialpool);
        pvc.setDialPoolNumber(dialpool);
        d.setDialerGroup(dl.getGroup());
        d.setIpAddr(ipaddr);
        d.setPPPAuthentication(ppp);
        if (strDesc != null) {
            subif.setDesc(strDesc);
        }
        return d;
    }

    public static Dialer createPPPOAConnection(Atm atm, String equipmentType, String linerate, String operatingMode, int vpi, int vci, String encapsulation, IfIPAddress ipaddr, DeviceBase dev, PPPAuthentication ppp, String strDesc, boolean multilink) throws XDMException {
        Log.getLog().debug("createPPPOAConnection() for " + atm.getIfID());
        Log.getLog().debug("atm\t" + atm + "\nequipmentType" + equipmentType + "\nlinerate\t" + linerate + "\noperatingMode\t" + operatingMode + "\nvpi\t" + vpi + "\nvci\t" + vci + "\nencapsulation\t" + encapsulation + "\nipaddr " + ipaddr);
        atm.shutdown(false);
        int id = atm.getSubInterfaces().getNextAvailableID();
        IfID ifid = new IfID(atm.getIfID().getType(), atm.getIfID().getSlot(), atm.getIfID().getModuleSlot(), atm.getIfID().getPort(), atm.getIfID().getChannel(), id);
        AtmSubInterface subif = new AtmSubInterface(ifid, atm);
        subif.setParent(atm.getSubInterfaces());
        atm.getSubInterfaces().put(subif);
        if (subif.getIfID().getType() == 504) {
            if (linerate != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslLinerate(linerate);
            }
            if (operatingMode != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
            if (equipmentType != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslEquipmentType(equipmentType);
            }
        } else if (subif.getIfID().getType() == 503) {
            if (operatingMode != null) {
                ((AdslInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
        } else if (subif.getIfID().getType() == 532) {
            if (operatingMode != null) {
                ((AdslOverIsdnInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
        } else {
            subif.getIfID().getType();
        }
        PvcCollection pvcs = subif.getPvcs();
        Pvc pvc = new Pvc(pvcs, false);
        pvc.setVPI(vpi);
        pvc.setVCI(vci);
        pvc.setEncapsulation(encapsulation);
        pvc.setAal5muxProtocol("ppp");
        pvc.setProtocol("PPPoA");
        pvc.setConnectionType("PPPoA");
        pvcs.addPvc(pvc);
        DialerListCollection dlc = dev.getDialerListCollection();
        DialerList dl = dlc.createDialerList();
        dlc.addDialerList(dl);
        XDMInterfaces ifs = dev.getIfs();
        Dialer d = (Dialer)ifs.createNextLogicIf(1001);
        ifs.put(d);
        d.setEncapsulation("ppp");
        int dialpool = ifs.getNextDialPoolNumber();
        d.setDialPoolNumber(dialpool);
        pvc.setDialPoolNumber(dialpool);
        d.setDialerGroup(dl.getGroup());
        d.setIpAddr(ipaddr);
        d.setPPPAuthentication(ppp);
        if (multilink) {
            d.setMultilink();
        }
        if (strDesc != null) {
            subif.setDesc(strDesc);
        }
        return d;
    }

    public static Dialer createPPPOEConnection(Atm atm, String equipmentType, String linerate, String operatingMode, int vpi, int vci, String encapsulation, IfIPAddress ipaddr, DeviceBase dev, PPPAuthentication ppp, String strDesc) throws XDMException {
        VPDN vpdn;
        Log.getLog().debug("createPPPOEConnection() for " + atm.getIfID());
        Log.getLog().debug("atm\t" + atm + "\nequipmentType" + equipmentType + "\nlinerate\t" + linerate + "\noperatingMode\t" + operatingMode + "\nvpi\t" + vpi + "\nvci\t" + vci + "\nencapsulation\t" + encapsulation + "\nipaddr " + ipaddr);
        atm.shutdown(false);
        int id = atm.getSubInterfaces().getNextAvailableID();
        IfID ifid = new IfID(atm.getIfID().getType(), atm.getIfID().getSlot(), atm.getIfID().getModuleSlot(), atm.getIfID().getPort(), atm.getIfID().getChannel(), id);
        AtmSubInterface subif = new AtmSubInterface(ifid, atm);
        subif.setParent(atm.getSubInterfaces());
        atm.getSubInterfaces().put(subif);
        if (subif.getIfID().getType() == 504) {
            if (linerate != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslLinerate(linerate);
            }
            if (operatingMode != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
            if (equipmentType != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslEquipmentType(equipmentType);
            }
        } else if (subif.getIfID().getType() == 503) {
            if (operatingMode != null) {
                ((AdslInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
        } else if (subif.getIfID().getType() == 532) {
            if (operatingMode != null) {
                ((AdslOverIsdnInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
        } else {
            subif.getIfID().getType();
        }
        PvcCollection pvcs = subif.getPvcs();
        Pvc pvc = new Pvc(pvcs, false);
        pvc.setEncapsulation("PPPoE");
        pvc.setConnectionType("PPPoE");
        pvc.setVPI(vpi);
        pvc.setVCI(vci);
        pvcs.addPvc(pvc);
        DialerListCollection dlc = dev.getDialerListCollection();
        DialerList dl = dlc.createDialerList();
        dlc.addDialerList(dl);
        XDMInterfaces ifs = dev.getIfs();
        Dialer d = (Dialer)ifs.createNextLogicIf(1001);
        d.setMtu(1452);
        ifs.put(d);
        d.setEncapsulation("ppp");
        int dialpool = ifs.getNextDialPoolNumber();
        d.setDialPoolNumber(dialpool);
        pvc.setDialPoolNumber(dialpool);
        d.setDialerGroup(dl.getGroup());
        d.setIpAddr(ipaddr);
        d.setPPPAuthentication(ppp);
        boolean isVpdnRequired = dev.getDevInfoBase().isPPPoENeedVpdn();
        if (isVpdnRequired && (vpdn = dev.getVPDN()) != null) {
            VPDNGroupCollection groups = vpdn.getVPDNGroupCollection();
            if (!groups.isPPPOESet()) {
                VPDNGroup group = groups.createVPDNGroup();
                groups.addVPDNGroup(group);
            }
            vpdn.setVpdnEnabled(true);
            vpdn.setNoVpdnLogging(true);
        }
        WANHelperBase.adjustTCPSize(dev);
        if (strDesc != null) {
            subif.setDesc(strDesc);
        }
        return d;
    }

    public static Dialer createPPPOEConnection(Atm atm, String equipmentType, String linerate, String operatingMode, int vpi, int vci, String encapsulation, IfIPAddress ipaddr, DeviceBase dev, PPPAuthentication ppp, String strDesc, boolean multilink) throws XDMException {
        VPDN vpdn;
        boolean isVpdnRequired;
        Log.getLog().debug("createPPPOEConnection() for " + atm.getIfID());
        Log.getLog().debug("atm\t" + atm + "\nequipmentType" + equipmentType + "\nlinerate\t" + linerate + "\noperatingMode\t" + operatingMode + "\nvpi\t" + vpi + "\nvci\t" + vci + "\nencapsulation\t" + encapsulation + "\nipaddr " + ipaddr);
        atm.shutdown(false);
        int id = atm.getSubInterfaces().getNextAvailableID();
        IfID ifid = new IfID(atm.getIfID().getType(), atm.getIfID().getSlot(), atm.getIfID().getModuleSlot(), atm.getIfID().getPort(), atm.getIfID().getChannel(), id);
        AtmSubInterface subif = new AtmSubInterface(ifid, atm);
        subif.setParent(atm.getSubInterfaces());
        atm.getSubInterfaces().put(subif);
        if (subif.getIfID().getType() == 504) {
            if (linerate != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslLinerate(linerate);
            }
            if (operatingMode != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
            if (equipmentType != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslEquipmentType(equipmentType);
            }
        } else if (subif.getIfID().getType() == 503) {
            if (operatingMode != null) {
                ((AdslInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
        } else if (subif.getIfID().getType() == 532) {
            if (operatingMode != null) {
                ((AdslOverIsdnInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
        } else {
            subif.getIfID().getType();
        }
        PvcCollection pvcs = subif.getPvcs();
        Pvc pvc = new Pvc(pvcs, false);
        pvc.setEncapsulation("PPPoE");
        pvc.setConnectionType("PPPoE");
        pvc.setVPI(vpi);
        pvc.setVCI(vci);
        pvcs.addPvc(pvc);
        DialerListCollection dlc = dev.getDialerListCollection();
        DialerList dl = dlc.createDialerList();
        dlc.addDialerList(dl);
        XDMInterfaces ifs = dev.getIfs();
        Dialer d = (Dialer)ifs.createNextLogicIf(1001);
        d.setMtu(1452);
        ifs.put(d);
        d.setEncapsulation("ppp");
        int dialpool = ifs.getNextDialPoolNumber();
        d.setDialPoolNumber(dialpool);
        pvc.setDialPoolNumber(dialpool);
        d.setDialerGroup(dl.getGroup());
        d.setIpAddr(ipaddr);
        d.setPPPAuthentication(ppp);
        if (multilink) {
            d.setMultilink();
        }
        if ((isVpdnRequired = dev.getDevInfoBase().isPPPoENeedVpdn()) && (vpdn = dev.getVPDN()) != null) {
            VPDNGroupCollection groups = vpdn.getVPDNGroupCollection();
            if (!groups.isPPPOESet()) {
                VPDNGroup group = groups.createVPDNGroup();
                groups.addVPDNGroup(group);
            }
            vpdn.setVpdnEnabled(true);
            vpdn.setNoVpdnLogging(true);
        }
        WANHelperBase.adjustTCPSize(dev);
        if (strDesc != null) {
            subif.setDesc(strDesc);
        }
        return d;
    }

    public static Dialer createPPPOEConnection(Ethernet eth, IfIPAddress ipaddr, DeviceBase dev, PPPAuthentication ppp) throws XDMException {
        Log.getLog().debug("createPPPOEConnection() for " + eth.getIfID());
        Log.getLog().debug("Ethernet\t" + eth + "\nipaddr " + ipaddr);
        eth.setPPPOE(true);
        DialerListCollection dlc = dev.getDialerListCollection();
        DialerList dl = dlc.createDialerList();
        dlc.addDialerList(dl);
        XDMInterfaces ifs = dev.getIfs();
        Dialer d = (Dialer)ifs.createNextLogicIf(1001);
        d.setMtu(1452);
        ifs.put(d);
        d.setEncapsulation("ppp");
        int dialpool = ifs.getNextDialPoolNumber();
        d.setDialPoolNumber(dialpool);
        eth.setDialPoolNumber(dialpool);
        eth.shutdown(false);
        d.setDialerGroup(dl.getGroup());
        d.setIpAddr(ipaddr);
        d.setPPPAuthentication(ppp);
        boolean isVpdnRequired = dev.getDevInfoBase().isPPPoENeedVpdn();
        if (isVpdnRequired) {
            VPDN vpdn = dev.getVPDN();
            Log.getLog().debug("createPPPOEConnection() : VPDN = " + vpdn);
            if (vpdn != null) {
                VPDNGroupCollection groups = vpdn.getVPDNGroupCollection();
                if (!groups.isPPPOESet()) {
                    VPDNGroup group = groups.createVPDNGroup();
                    groups.addVPDNGroup(group);
                }
                vpdn.setVpdnEnabled(true);
                vpdn.setNoVpdnLogging(true);
            }
        }
        WANHelperBase.adjustTCPSize(dev);
        return d;
    }

    public static AtmSubInterface createRFC1483Connection(Atm atm, String equipmentType, String linerate, String operatingMode, int vpi, int vci, String encapsulation, IPAddress ipaddr, IfIPAddress interfaceipaddr) throws XDMException {
        Log.getLog().debug("createRFC1483Connection() for " + atm.getIfID());
        Log.getLog().debug("atm\t" + atm + "\nequipmentType" + equipmentType + "\nlinerate\t" + linerate + "\noperatingMode\t" + operatingMode + "\nvpi\t" + vpi + "\nvci\t" + vci + "\nencapsulation\t" + encapsulation + "\nipaddr " + ipaddr + "\ninterfaceipaddr\t" + interfaceipaddr);
        atm.shutdown(false);
        int id = atm.getSubInterfaces().getNextAvailableID();
        IfID ifid = new IfID(atm.getIfID().getType(), atm.getIfID().getSlot(), atm.getIfID().getModuleSlot(), atm.getIfID().getPort(), atm.getIfID().getChannel(), id);
        AtmSubInterface subif = new AtmSubInterface(ifid, atm);
        subif.setParent(atm.getSubInterfaces());
        atm.getSubInterfaces().put(subif);
        if (atm.getIfID().getType() == 504) {
            if (linerate != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslLinerate(linerate);
            }
            if (operatingMode != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
            if (equipmentType != null) {
                ((ShdslInfo)atm.getDslInfo()).setDslEquipmentType(equipmentType);
            }
        } else if (atm.getIfID().getType() == 503) {
            if (operatingMode != null) {
                ((AdslInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
            }
        } else if (atm.getIfID().getType() == 532 && operatingMode != null) {
            ((AdslOverIsdnInfo)atm.getDslInfo()).setDslOperatingMode(operatingMode);
        }
        subif.setIpAddr(interfaceipaddr);
        PvcCollection pvcs = subif.getPvcs();
        Pvc pvc = new Pvc(pvcs, false);
        pvc.setVPI(vpi);
        pvc.setVCI(vci);
        pvcs.addPvc(pvc);
        pvc.setEncapsulation(encapsulation);
        pvc.setProtocol("ip");
        pvc.setProtocolIPAddress(ipaddr);
        return subif;
    }

    public static void deletePAT(DeviceBase dev, XDMInterfaceBase If) {
        NatDynamicRule rule;
        if (If.getLogicalIf() != null) {
            If = If.getLogicalIf();
        }
        if ((rule = (NatDynamicRule)WANHelperBase.getPATRule(dev, If)) != null) {
            ACL acl = null;
            if (rule.getACL() != null) {
                acl = (ACL)dev.getAcls().getACL(rule.getACL());
                if (acl != null) {
                    XDMInterfaceBase insideIf;
                    String temp;
                    String remark = acl.getRemark();
                    if (remark.indexOf("INSIDE_IF") != -1 && (temp = remark.substring(remark.indexOf("INSIDE_IF") + 10)) != null && (insideIf = dev.getIfs().getIfFromString(temp)) != null) {
                        insideIf.setNat(0);
                    }
                    dev.getAcls().deleteACL(rule.getACL());
                }
            } else if (rule.getRouteMap() != null && dev.getRouteMaps().get(rule.getRouteMap()) != null) {
                dev.getRouteMaps().remove(rule.getRouteMap());
            }
            dev.getNAT().removeRule(rule);
        }
        If.setNat(0);
    }

    public static void deletePPPOAConnection(XDMInterfaceBase atm, int vpi, int vci, DeviceBase dev) {
        WANHelperBase.deletePPPOEConnection(atm, vpi, vci, dev);
    }

    public static void deletePPPOEConnection(Ethernet eth, DeviceBase dev) {
        Log.getLog().debug("deletePPPOEConnection() for " + eth.getIfID());
        Log.getLog().debug("Ethernet\t" + eth);
        Dialer d = (Dialer)eth.getLogicalIf();
        int group = d.getDialerGroup();
        dev.getIfs().remove(d.getIfID());
        DialerListCollection dlc = dev.getDialerListCollection();
        dlc.remove(String.valueOf(group) + "ip");
        eth.resetWANConnection();
    }

    public static void deletePPPOEConnection(XDMInterfaceBase atm, int vpi, int vci, DeviceBase dev) {
        AtmHelper ah = null;
        Log.getLog().debug("deletePPPOEConnection() for " + atm.getIfID());
        Log.getLog().debug("atm\t" + atm + "\nvpi\t" + vpi + "\nvci\t" + vci);
        if (atm instanceof Atm) {
            Atm atmif = (Atm)atm;
            ah = atmif.getAtmHelper();
        }
        if (atm instanceof AtmSubInterface) {
            AtmSubInterface subif = (AtmSubInterface)atm;
            XDMSubInterfaces ifcs = (XDMSubInterfaces)subif.getParent();
            ifcs.remove(subif.getIfID().getSubIfID());
            ah = subif.getAtmHelper();
        }
        Dialer d = (Dialer)ah.getLogicalIf();
        Log.getLog().debug("Dialer to be deleted is " + d.getIfID());
        int group = d.getDialerGroup();
        dev.getIfs().remove(d.getIfID());
        if (atm instanceof Atm) {
            Atm atmif = (Atm)atm;
            PvcCollection pvcs = atmif.getPvcs();
            Pvc pvc = pvcs.getPvc(vpi, vci);
            pvcs.deletePvc(vpi, vci);
            atm.setIpAddr(null);
        }
        DialerListCollection dlc = dev.getDialerListCollection();
        dlc.remove(String.valueOf(group) + "ip");
    }

    public static void deleteRFC1483Connection(XDMInterfaceBase atm, int vpi, int vci) {
        Log.getLog().debug("deleteRFC1483Connection() for " + atm.getIfID());
        Log.getLog().debug("atm\t" + atm + "\nvpi\t" + vpi + "\nvci\t" + vci);
        if (atm instanceof Atm) {
            Atm atmif = (Atm)atm;
            PvcCollection pvcs = atmif.getPvcs();
            pvcs.deletePvc(vpi, vci);
            atm.setIpAddr(null);
            if (atmif.getIfID().getType() == 504) {
                ((ShdslInfo)atmif.getDslInfo()).setDslEquipmentType(null);
            }
            return;
        }
        if (atm instanceof AtmSubInterface) {
            Atm mainIf;
            AtmSubInterface subif = (AtmSubInterface)atm;
            XDMSubInterfaces ifcs = (XDMSubInterfaces)subif.getParent();
            ifcs.remove(subif.getIfID().getSubIfID());
            if (ifcs.size() == 0 && (mainIf = (Atm)ifcs.getParent()).getIfID().getType() == 504) {
                ((ShdslInfo)mainIf.getDslInfo()).setDslEquipmentType(null);
            }
        }
    }

    public static boolean deleteVPDNGroup(DeviceBase dev) {
        boolean retVal = false;
        Log.getLog().debug("deleteVPDNGroup : ");
        VPDN vpdn = dev.getVPDN();
        if (vpdn != null) {
            VPDNGroupCollection vpdnColl = vpdn.getVPDNGroupCollection();
            VPDNGroup group = vpdnColl.getPPPOEVPDNGroup();
            Log.getLog().debug("deleteVPDNGroup Group: " + group);
            if (group != null) {
                vpdnColl.removeVPDNGroup(group);
                retVal = true;
            }
            vpdn.setVpdnEnabled(false);
            vpdn.setNoVpdnLogging(false);
        }
        return retVal;
    }

    public static void generateDefaultNATConfig(DeviceBase dev, XDMInterfaceBase insideIf, XDMInterfaceBase outsideIf) {
        insideIf.setNat(1);
        outsideIf.setNat(2);
        IPAddress network = new IPAddress(insideIf.getIpAddr().getIPAddress(), insideIf.getIpAddr().getNetmask());
        ACL acl = new ACL(0);
        int n = dev.getAcls().getNextAvailableACLNumber();
        acl.setNameOrNumber(Integer.toString(n));
        acl.addToCategory(2);
        StandardACE ace1 = new StandardACE(true, network.toString(), insideIf.getIpAddr().getNetmask().reverseMask().toString());
        if (WANHelperBase.getACLwithACE(dev, ace1) == null) {
            acl.addACE(ace1);
            dev.getAcls().addACL(acl);
        } else {
            acl = WANHelperBase.getACLwithACE(dev, ace1);
        }
        String remark = "INSIDE_IF=" + insideIf.getIfID().toString();
        acl.setRemark(remark);
        NatDynamicRule dynRule = new NatDynamicRule();
        dynRule.setInterface(outsideIf.getIfID().toString(), dev);
        dynRule.setACL(acl.getNameOrNumber());
        dynRule.setOverload(true);
        dev.getNAT().addRule(dynRule);
    }

    public static void generateDefaultRoutingConfig(DeviceBase dev, XDMInterfaceBase nextHopIf, IPAddress nexthopIp) {
        StaticRoute defRoute = new StaticRoute();
        IPAddress ip = new IPAddress("0.0.0.0");
        Netmask mask = new Netmask("0.0.0.0");
        defRoute.setPrefix(ip);
        defRoute.setMask(mask);
        if (nexthopIp != null) {
            defRoute.setNextHopIp(nexthopIp);
        } else {
            defRoute.setNextHopIntf(nextHopIf.getIfID());
        }
        defRoute.setAdminDist(StaticRoute.getDefaultAdminDist(dev));
        dev.getStaticRoutes().addElement(defRoute);
    }

    private static ACL getACLwithACE(DeviceBase dev, StandardACE ace) {
        Enumeration acls = dev.getAcls().getACLsByCategory(2);
        while (acls.hasMoreElements()) {
            ACLBase tempACL = (ACLBase)acls.nextElement();
            if (!((ACL)tempACL).isDuplicateACE(ace)) continue;
            return (ACL)tempACL;
        }
        return null;
    }

    public static Vector getLANifsForPAT(DeviceBase dev, XDMInterfaceBase selectedIf, IfIPAddress ifIp) {
        Vector<String> lanIfs = new Vector<String>();
        XDMInterfaces Ifs = dev.getIfs();
        Enumeration e = Ifs.elements();
        while (e.hasMoreElements()) {
            XDMInterfaceBase If = (XDMInterfaceBase)e.nextElement();
            if (If.getIfID().isL3Ethernet()) {
                if (((Ethernet)If).getConnectionType() != 1 && If.getIfID() != selectedIf.getIfID() && If.getIpAddr() != null && If.getIpAddr().getIPAddressType() == IPAddressType.STATIC) {
                    if (ifIp.getIPAddressType() == IPAddressType.UNNUMBERED && ifIp.getIPUnnumberedIntf().equals(If.getIfID())) continue;
                    lanIfs.addElement(If.getIfID().toString());
                    continue;
                }
                if (!(If instanceof Ethernet) || !((Ethernet)If).isSubinterfaceConfigured()) continue;
                XDMSubInterfaces subIfs = ((Ethernet)If).getSubInterfaces();
                Enumeration en = subIfs.elements();
                while (en.hasMoreElements()) {
                    EthernetSubInterface subIf = (EthernetSubInterface)en.nextElement();
                    if (subIf.getConnectionType() == 1 || subIf.getIfID() == selectedIf.getIfID() || subIf.getIpAddr() == null || subIf.getIpAddr().getIPAddressType() != IPAddressType.STATIC || ifIp.getIPAddressType() == IPAddressType.UNNUMBERED && ifIp.getIPUnnumberedIntf().equals(subIf.getIfID())) continue;
                    lanIfs.addElement(subIf.getIfID().toString());
                }
                continue;
            }
            if (If.getIfID().getType() == 1007) {
                if (If.getIfID() == selectedIf.getIfID() || If.getIpAddr() == null || If.getIpAddr().getIPAddressType() != IPAddressType.STATIC) continue;
                lanIfs.addElement(If.getIfID().toString());
                continue;
            }
            if (If.getIfID().getType() != 1010 || If.getIfID() == selectedIf.getIfID() || If.getIpAddr() == null || If.getIpAddr().getIPAddressType() != IPAddressType.STATIC) continue;
            lanIfs.addElement(If.getIfID().toString());
        }
        return lanIfs;
    }

    public static NatRule getPATRule(DeviceBase dev, XDMInterfaceBase overloadedIf) {
        NatRule[] ruleArray = dev.getNAT().getRules();
        int i = 0;
        while (i < ruleArray.length) {
            NatDynamicRule tmpRule;
            if (ruleArray[i] instanceof NatDynamicRule && (tmpRule = (NatDynamicRule)ruleArray[i]).getApplication() == 1 && tmpRule.getOverload() && tmpRule.getBaseInterface() != null && tmpRule.getBaseInterface().equals(overloadedIf.getIfID().toString()) && (tmpRule.getACL() != null && dev.getAcls().getACL(tmpRule.getACL()) != null || tmpRule.getRouteMap() != null && dev.getRouteMaps().get(tmpRule.getRouteMap()) != null)) {
                return tmpRule;
            }
            ++i;
        }
        return null;
    }

    public static int getVPDNDeleteStatus(XDMInterfaceBase If, DeviceBase dev) {
        boolean warn = true;
        boolean isUnsupportedIf = false;
        int noOfPPPoE = 0;
        Log.getLog().info("getVPDNDeleteStatus : " + If);
        VPDN vpdn = dev.getVPDN();
        if (vpdn != null) {
            VPDNGroupCollection vpdnColl = vpdn.getVPDNGroupCollection();
            VPDNGroup group = vpdnColl.getPPPOEVPDNGroup();
            if (group == null) {
                return DONT_DELETE_VPDN;
            }
        } else {
            return DONT_DELETE_VPDN;
        }
        XDMInterfaces xifs = dev.getIfs();
        Enumeration enum_if = xifs.getSortedIfs().elements();
        while (enum_if.hasMoreElements()) {
            Ethernet eth;
            XDMInterfaceBase xif = (XDMInterfaceBase)enum_if.nextElement();
            if (xif.equals(If)) continue;
            if (xif instanceof XDMUnsupportedIf) {
                isUnsupportedIf = true;
                Log.getLog().debug("======= Unnsupportedd If = " + xif.getIfID());
            }
            if (xif instanceof Atm || xif instanceof AtmSubInterface) {
                if (!WANHelperBase.isATMConfiguredForPPPoE(xif)) continue;
                Log.getLog().debug("getVPDNDeleteStatus isATMConfiguredForPPPoE = true:" + xif);
                ++noOfPPPoE;
                continue;
            }
            if (!(xif instanceof Ethernet) || !(eth = (Ethernet)xif).isPPPOESet()) continue;
            Log.getLog().debug("getVPDNDeleteStatus isPPPOESet = true:" + xif);
            ++noOfPPPoE;
        }
        if (noOfPPPoE > 0) {
            Log.getLog().debug("RETURNING DO NOT DELETE PPPoE = " + noOfPPPoE);
            return DONT_DELETE_VPDN;
        }
        if (isUnsupportedIf) {
            Log.getLog().debug("RETURNING DELETE WITH WARN for UnsupportedIf");
            return DELETE_VPDN_WITH_WARN;
        }
        Log.getLog().debug("shouldWarn :" + vpdn.getDeleteVPDN());
        if (!vpdn.getDeleteVPDN()) {
            Log.getLog().debug("RETURNING DELETE WITH WARN for getDeleteVPDN");
            return DELETE_VPDN_WITH_WARN;
        }
        return DELETE_VPDN;
    }

    public static boolean isATMConfiguredForPPPoA(XDMInterfaceBase atm) {
        AtmHelper ah = atm instanceof AtmSubInterface ? ((AtmSubInterface)atm).getAtmHelper() : ((Atm)atm).getAtmHelper();
        return ah.isATMConfiguredForPPPoA();
    }

    public static boolean isATMConfiguredForPPPoE(XDMInterfaceBase atm) {
        AtmHelper ah = atm instanceof AtmSubInterface ? ((AtmSubInterface)atm).getAtmHelper() : ((Atm)atm).getAtmHelper();
        return ah.isATMConfiguredForPPPoE();
    }

    public static boolean isATMConfiguredForRFCMUX(XDMInterfaceBase atm) {
        AtmHelper ah = atm instanceof AtmSubInterface ? ((AtmSubInterface)atm).getAtmHelper() : ((Atm)atm).getAtmHelper();
        return ah.isATMConfiguredForRFCMUX();
    }

    public static boolean isATMConfiguredForRFCSNAP(XDMInterfaceBase atm) {
        AtmHelper ah = atm instanceof AtmSubInterface ? ((AtmSubInterface)atm).getAtmHelper() : ((Atm)atm).getAtmHelper();
        return ah.isATMConfiguredForRFCSNAP();
    }

    public static boolean isATMConnected(XDMInterfaceBase atm) {
        AtmHelper ah = atm instanceof AtmSubInterface ? ((AtmSubInterface)atm).getAtmHelper() : ((Atm)atm).getAtmHelper();
        return ah.isATMConnected();
    }

    public static boolean isDDNSExists(XDMInterfaceBase If, DeviceBase dev) {
        if (!If.isDDNSReadOnly() && If.getLogicalIf() == null) {
            String method = If.getDDNSMethod() == null ? "" : If.getDDNSMethod();
            String ddnshost = If.getDDNSHostname() == null ? "" : If.getDDNSHostname();
            boolean ddnsdhcp = If.isDDNSDHCPCmdPresent();
            if (method.length() > 0 || ddnshost.length() > 0 || ddnsdhcp) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPATExists(DeviceBase dev) {
        NatRule[] ruleArray = dev.getNAT().getRules();
        int i = 0;
        while (i < ruleArray.length) {
            NatDynamicRule tmpRule;
            if (ruleArray[i] instanceof NatDynamicRule && (tmpRule = (NatDynamicRule)ruleArray[i]).getApplication() == 1 && tmpRule.getOverload()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPATExists(DeviceBase dev, XDMInterfaceBase If) {
        if (If.getLogicalIf() != null) {
            If = If.getLogicalIf();
        }
        return WANHelperBase.getPATRule(dev, If) != null && If.getNat() != 0;
    }

    private static boolean isPPPoEConnExists(XDMInterfaceBase If, DeviceBase dev) {
        boolean pppoeExists = false;
        XDMInterfaces xifs = dev.getIfs();
        Enumeration enum_if = xifs.getSortedIfs().elements();
        while (enum_if.hasMoreElements()) {
            Ethernet eth;
            XDMInterfaceBase xif = (XDMInterfaceBase)enum_if.nextElement();
            if (xif.equals(If)) continue;
            if (xif instanceof Atm || xif instanceof AtmSubInterface) {
                if (!WANHelperBase.isATMConfiguredForPPPoE(xif)) continue;
                Log.getLog().debug("isPPPoEConnExists isATMConfiguredForPPPoE = true:" + xif);
                pppoeExists = true;
                break;
            }
            if (!(xif instanceof Ethernet) || !(eth = (Ethernet)xif).isPPPOESet()) continue;
            Log.getLog().debug("isPPPoEConnExists isPPPOESet = true:" + xif);
            pppoeExists = true;
            break;
        }
        return pppoeExists;
    }

    public static boolean isZoneExists(DeviceBase dev) {
        Vector vectIf = dev.getIfs().getIfs();
        Enumeration enum_if = vectIf.elements();
        while (enum_if.hasMoreElements()) {
            XDMInterfaceBase If = (XDMInterfaceBase)enum_if.nextElement();
            String zone = If.getZone();
            if (zone == null || zone.length() == 0) continue;
            return true;
        }
        return false;
    }

    public static void resetTCPSize(DeviceBase dev) {
        XDMInterfaces Ifs = dev.getIfs();
        Enumeration e = Ifs.elements();
        while (e.hasMoreElements()) {
            XDMInterfaceBase If = (XDMInterfaceBase)e.nextElement();
            if (If.getIfID().isL3Ethernet()) {
                if (((Ethernet)If).getConnectionType() == 0 && ((Ethernet)If).getTcpSize() == TCP_SIZE) {
                    ((Ethernet)If).setTcpSize(-1);
                }
                if (((Ethernet)If).getIpAddr() == null || ((Ethernet)If).getDir() != 0 || ((Ethernet)If).getTcpSize() != TCP_SIZE) continue;
                ((Ethernet)If).setTcpSize(-1);
                continue;
            }
            if (If.getIfID().getType() != 1007 && If.getIfID().getType() != 1010 || If.getIpAddr() == null || If.getTcpSize() != TCP_SIZE) continue;
            If.setTcpSize(-1);
        }
    }

    public static boolean shouldWarnTCPSize(XDMInterfaceBase If, DeviceBase dev) {
        if (WANHelperBase.isPPPoEConnExists(If, dev)) {
            return false;
        }
        XDMInterfaces Ifs = dev.getIfs();
        Enumeration e = Ifs.elements();
        while (e.hasMoreElements()) {
            XDMInterfaceBase Iface = (XDMInterfaceBase)e.nextElement();
            if (Iface.getBridgeGroup() != 0) continue;
            if (Iface.getIfID().isL3Ethernet()) {
                if (((Ethernet)Iface).getConnectionType() == 0 && ((Ethernet)Iface).getTcpSize() == TCP_SIZE) {
                    return true;
                }
                if (((Ethernet)Iface).getIpAddr() == null || ((Ethernet)Iface).getDir() != 0 || ((Ethernet)Iface).getTcpSize() != TCP_SIZE) continue;
                return true;
            }
            if (Iface.getIfID().getType() != 1007 && Iface.getIfID().getType() != 1010 || Iface.getIpAddr() == null || Iface.getTcpSize() != TCP_SIZE) continue;
            return true;
        }
        return false;
    }
}

