/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.controllers;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.controllers.DSLController;
import com.cisco.xdm.data.interfaces.Atm;
import com.cisco.xdm.data.interfaces.IfID;

public class ATMControllerData
extends XDMObject {
    public static final int LINE_2_WIRE = 0;
    public static final int LINE_4_WIRE = 1;
    private int _line_mode = 0;
    public static final int LINE_2_WIRE_0 = 0;
    public static final int LINE_2_WIRE_1 = 1;
    private int _line_2_wire_line = 0;
    public static final String[] LINE_RATE_2_WIRE = new String[]{"auto", "192", "256", "320", "384", "448", "512", "576", "640", "704", "768", "832", "896", "960", "1024", "1088", "1152", "1216", "1280", "1344", "1408", "1472", "1536", "1600", "1664", "1728", "1792", "1856", "1920", "1984", "2048", "2112", "2176", "2240", "2304"};
    public static final String[] LINE_RATE_4_WIRE = new String[]{"384", "512", "640", "768", "896", "1024", "1152", "1280", "1408", "1536", "1664", "1792", "1920", "2048", "2176", "2304", "2432", "2560", "2688", "2816", "2944", "3072", "3200", "3328", "3456", "3584", "3712", "3840", "3968", "4096", "4224", "4352", "4480", "4608"};
    private String _line_rate = "";
    private static final String KEY_LINE_MODE = "line-mode";
    private static final String KEY_MODE = "mode";
    private static final String KEY_LINE = "line";
    private static final String KEY_LINE_RATE = "line-rate";
    private static final String KEY_RATE = "rate";
    private static final String KEY_2_WIRE = "2-wire";
    private static final String KEY_4_WIRE = "4-wire";
    private static final String KEY_LINE_ONE = "line-one";
    private static final String KEY_LINE_ZERO = "line-zero";

    public ATMControllerData(DSLController controller) {
        super(controller);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        CmdValues cmd;
        ATMControllerData bData = null;
        if (backup != null) {
            bData = (ATMControllerData)backup;
        }
        boolean lmChange = false;
        if (bData == null || bData._line_mode != this._line_mode || bData._line_mode == 0 && this._line_2_wire_line != bData._line_2_wire_line) {
            lmChange = true;
            cmd = new CmdValues(KEY_LINE_MODE);
            if (this._line_mode == 1) {
                cmd.addValue(KEY_MODE, KEY_4_WIRE);
            } else {
                cmd.addValue(KEY_MODE, KEY_2_WIRE);
                if (this._line_2_wire_line == 1) {
                    cmd.addValue(KEY_LINE, KEY_LINE_ONE);
                } else {
                    cmd.addValue(KEY_LINE, KEY_LINE_ZERO);
                }
            }
            values.addCmdValues(cmd);
        }
        if (lmChange && this._line_rate.length() > 0 || this._line_rate.length() > 0 && (bData == null || !bData._line_rate.equalsIgnoreCase(this._line_rate))) {
            cmd = new CmdValues(KEY_LINE_RATE);
            cmd.addValue(KEY_RATE, this._line_rate);
            values.addCmdValues(cmd);
        }
    }

    public int get2WireOpt() {
        return this._line_2_wire_line;
    }

    public Atm getAtmInterface() {
        DSLController parent = (DSLController)this.getParent();
        IfID ifid = new IfID(1008, parent.getID().getSlot(), parent.getID().getModuleSlot(), parent.getID().getPort(), -1, 0);
        DeviceBase dev = (DeviceBase)this.getDevice();
        return (Atm)dev.getIfs().get(ifid);
    }

    public int getLineMode() {
        return this._line_mode;
    }

    public String getLineRate() {
        return this._line_rate;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        ConfigValues subCmds = cmdVal.getModeCmdsValues();
        if (subCmds != null) {
            int i = 0;
            while (i < subCmds.numCmds()) {
                CmdValues cmd = subCmds.getCmdValues(i);
                String cmdName = cmd.getCmdName();
                if (cmdName.compareTo(KEY_LINE_RATE) == 0) {
                    this._line_rate = cmd.getValue(KEY_RATE);
                } else if (cmdName.compareTo(KEY_LINE_MODE) == 0) {
                    String val = cmd.getValue(KEY_MODE);
                    int n = this._line_mode = val.compareTo(KEY_2_WIRE) == 0 ? 0 : 1;
                    if (this._line_mode == 0 && cmd.containsKey(KEY_LINE)) {
                        String line = cmd.getValue(KEY_LINE);
                        this._line_2_wire_line = line.compareTo(KEY_LINE_ONE) == 0 ? 1 : 0;
                    }
                }
                ++i;
            }
        }
    }

    public boolean set2WireOpt(int opt) {
        if (opt != 0 && opt != 1) {
            return false;
        }
        this._line_2_wire_line = opt;
        this.setModified();
        return true;
    }

    public boolean setLineMode(int mode) {
        if (mode != 0 && mode != 1) {
            return false;
        }
        this._line_mode = mode;
        this._line_2_wire_line = 0;
        this.setModified();
        return true;
    }

    public boolean setLineRate(String val) {
        if (val == null || val.length() == 0) {
            this._line_rate = "";
            this.setModified();
            return true;
        }
        String[] rates = null;
        rates = this._line_mode == 0 ? LINE_RATE_2_WIRE : LINE_RATE_4_WIRE;
        int i = 0;
        while (i < rates.length) {
            if (val.equalsIgnoreCase(rates[i])) {
                this._line_rate = val;
                this.setModified();
                return true;
            }
            ++i;
        }
        return false;
    }
}

