/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.controllers;

import com.cisco.xdm.data.base.HWConfig;
import com.cisco.xdm.data.discovery.ControllerType;
import com.cisco.xdm.data.discovery.HWDictionary;

public class ControllerID {
    public static final int CNID_INVALID_TYPE = 2000;
    public static final int CNID_INVALID_LOCATION = -1;
    private int _type;
    private int _slot;
    private int _module_slot;
    private int _port;
    private String _unsupported;

    public ControllerID(int type, int slot, int module_slot, int port) {
        this._type = type;
        this._slot = slot;
        this._module_slot = module_slot;
        this._port = port;
        this._unsupported = null;
    }

    public ControllerID(String unsupported, int slot, int module_slot, int port) {
        this._type = 2000;
        this._slot = slot;
        this._module_slot = module_slot;
        this._port = port;
        this._unsupported = unsupported;
    }

    public int compare(ControllerID obj) {
        int less = -1;
        int greater = 1;
        int equal = 0;
        int ret = this.comparePos(this._slot, obj._slot, true);
        if (ret != 0) {
            return ret;
        }
        ret = this.comparePos(this._module_slot, obj._module_slot, false);
        if (ret != 0) {
            return ret;
        }
        ret = this.getTypeString().compareTo(obj.getTypeString());
        if (ret > 0) {
            return greater;
        }
        if (ret < 0) {
            return less;
        }
        if (this._port > obj._port) {
            return greater;
        }
        if (this._port < obj._port) {
            return less;
        }
        return equal;
    }

    private int comparePos(int p1, int p2, boolean invalidIsGreater) {
        if (p1 == -1 && p2 != -1) {
            return invalidIsGreater ? 1 : -1;
        }
        if (p2 == -1 && p1 != -1) {
            return invalidIsGreater ? -1 : 1;
        }
        if (p1 > p2) {
            return 1;
        }
        if (p1 < p2) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ControllerID)) {
            return false;
        }
        ControllerID controllerIDObj = (ControllerID)obj;
        return this._type == controllerIDObj._type && this._slot == controllerIDObj._slot && this._module_slot == controllerIDObj._module_slot && this._port == controllerIDObj._port && (this._unsupported == null && controllerIDObj._unsupported == null || this._unsupported != null && this._unsupported.equals(controllerIDObj._unsupported) || controllerIDObj._unsupported != null && controllerIDObj._unsupported.equals(this._unsupported));
    }

    public static ControllerID fromString(String word, String location, HWConfig hwConfig) {
        int port;
        int slot;
        if (word == null || location == null) {
            return null;
        }
        if (word.length() == 0 || location.length() == 0) {
            return null;
        }
        int mslot = -1;
        int s1 = location.indexOf("/");
        if (s1 < 0) {
            slot = -1;
            port = Integer.valueOf(location);
        } else {
            slot = Integer.valueOf(location.substring(0, s1));
            int s2 = location.lastIndexOf("/");
            if (s1 != s2) {
                mslot = Integer.valueOf(location.substring(s1 + 1, s2));
                s1 = s2;
            }
            port = Integer.valueOf(location.substring(s1 + 1));
        }
        int type = 2000;
        type = slot == -1 ? hwConfig.findHWControllerType(word, port) : hwConfig.findHWControllerType(word, slot, mslot, port);
        ControllerID id = type != 2000 ? new ControllerID(type, slot, mslot, port) : new ControllerID(word, slot, mslot, port);
        return id;
    }

    public int getModuleSlot() {
        return this._module_slot;
    }

    public int getPort() {
        return this._port;
    }

    public int getSlot() {
        return this._slot;
    }

    public int getType() {
        return this._type;
    }

    private String getTypeString() {
        String str = new String();
        if (this._unsupported == null) {
            HWDictionary dict = HWDictionary.GetInstance();
            ControllerType cType = dict.getController(this._type);
            str = cType.getPhrase();
        } else {
            str = this._unsupported;
        }
        return str;
    }

    public String getUnsupportControllerStr() {
        return this._unsupported;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isSupported() {
        boolean ret = false;
        ControllerType cType = HWDictionary.GetInstance().getController(this._type);
        if (cType != null) {
            ret = cType.isSupport();
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getTypeString());
        sb.append(" ");
        if (this._slot != -1) {
            sb.append(String.valueOf(String.valueOf(this._slot)) + "/");
        }
        if (this._module_slot != -1) {
            sb.append(String.valueOf(String.valueOf(this._module_slot)) + "/");
        }
        if (this._port != -1) {
            sb.append(String.valueOf(this._port));
        }
        return sb.toString();
    }
}

