/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.dhcp;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.IPAddressRange;
import com.cisco.xdm.data.common.IPAddressType;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.dhcp.DHCPPool;
import com.cisco.xdm.data.dhcp.ExcludedVector;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import com.cisco.xdm.data.systemproperties.SystemProp;
import java.util.Enumeration;
import java.util.Vector;

public class DHCPPoolCollection
extends XDMHashCollection
implements Cloneable {
    private Vector _excluded;
    private int _poolNumber = 1;
    private static int INIT_VALUE = 254;
    private int _dhcpAdmindistance = INIT_VALUE;

    public DHCPPoolCollection() {
    }

    public DHCPPoolCollection(XDMObject parent) {
        super(parent);
    }

    public void addDHCPPool(DHCPPool newpool) throws NullPointerException {
        if (newpool == null) {
            throw new NullPointerException();
        }
        String newKey = newpool.getName();
        if (newKey == null) {
            throw new NullPointerException();
        }
        super.put(newKey, newpool);
        SystemProp sysprop = ((DeviceBase)this.getDevice()).getSystemProp();
        if (!sysprop.getDHCPService()) {
            sysprop.setDHCPService(true);
        }
        this.setModified();
    }

    public void addExcludedAddress(IPAddressRange excludedIpRange) {
        if (this._excluded == null) {
            this._excluded = new Vector();
        }
        if (!this._excluded.contains(excludedIpRange)) {
            this._excluded.addElement(excludedIpRange);
        }
        this.setModified();
    }

    public void addExcludedAddress(Vector excludedIpRangeVector) {
        if (excludedIpRangeVector != null) {
            int size = excludedIpRangeVector.size();
            int i = 0;
            while (i < size) {
                IPAddressRange range = (IPAddressRange)excludedIpRangeVector.elementAt(i);
                this.addExcludedAddress(range);
                ++i;
            }
        }
        this.setModified();
    }

    private void calculateStartEndIP() {
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            DHCPPool pool = this.getPool((String)e.nextElement());
            DeviceBase dev = (DeviceBase)this.getDevice();
            XDMInterfaces intfs = dev.getIfs();
            XDMInterfaceBase dhcpIntf = intfs.getIfByIPSubnet(pool.getNetwork(), pool.getMask());
            IPAddress addr = null;
            if (dhcpIntf != null && dhcpIntf.getIpAddr().getIPAddressType() == IPAddressType.STATIC) {
                addr = dhcpIntf.getIpAddr().getIPAddress();
            }
            if (addr != null) {
                this.calculateStartEndIP(pool, addr);
                continue;
            }
            this.calculateStartEndIP(pool);
        }
    }

    private void calculateStartEndIP(DHCPPool pool) {
        IPAddress network = pool.getNetwork();
        Netmask mask = pool.getMask();
        if (network != null) {
            ExcludedVector matchedExcluded = this.getMatchedExcludedVector(network, mask);
            this.findStartEndIP(pool, matchedExcluded);
        }
    }

    private void calculateStartEndIP(DHCPPool pool, IPAddress addr) {
        IPAddress network = pool.getNetwork();
        Netmask mask = pool.getMask();
        if (network != null) {
            ExcludedVector matchedExcluded = this.getMatchedExcludedVector(network, mask, addr);
            boolean originalReadOnlyState = pool.isPoolReadOnly();
            pool.makeReadOnly(false);
            this.findStartEndIP(pool, matchedExcluded);
            if (!pool.isPoolReadOnly()) {
                pool.makeReadOnly(originalReadOnlyState);
            }
        }
    }

    public Object clone() {
        DHCPPoolCollection newDHCPCollection = (DHCPPoolCollection)super.clone();
        if (this._excluded != null) {
            newDHCPCollection._excluded = (Vector)this._excluded.clone();
        }
        return newDHCPCollection;
    }

    public boolean equals(Object poolColl) {
        if (poolColl == null || !(poolColl instanceof DHCPPoolCollection)) {
            return false;
        }
        if (super.equals(poolColl)) {
            IPAddressRange obj;
            DHCPPoolCollection toCmp = (DHCPPoolCollection)poolColl;
            Vector toCmpVector = toCmp._excluded;
            if (this._excluded != null) {
                int i = 0;
                while (i < this._excluded.size()) {
                    obj = (IPAddressRange)this._excluded.elementAt(i);
                    if (!toCmpVector.contains(obj)) {
                        return false;
                    }
                    ++i;
                }
            }
            if (toCmpVector != null) {
                int j = 0;
                while (j < toCmpVector.size()) {
                    obj = (IPAddressRange)toCmpVector.elementAt(j);
                    if (!this._excluded.contains(obj)) {
                        return false;
                    }
                    ++j;
                }
            }
            return this._dhcpAdmindistance == toCmp._dhcpAdmindistance;
        }
        return false;
    }

    private void findStartEndIP(DHCPPool pool, ExcludedVector matchedExcluded) {
        IPAddress network = pool.getNetwork();
        Netmask mask = pool.getMask();
        IPAddress startPool = network.getBeginningHostAddress(mask);
        IPAddress endPool = network.getFinalHostAddress(mask);
        boolean endPoolFlag = false;
        if (matchedExcluded.size() > 0) {
            matchedExcluded.sort();
            int j = 0;
            while (j < matchedExcluded.size()) {
                IPAddressRange range = (IPAddressRange)matchedExcluded.elementAt(j);
                IPAddress low = range.getLowIPAddress();
                IPAddress high = range.getHighIPAddress();
                if (low.lessThanOrEqual(startPool)) {
                    startPool = high != null ? new IPAddress(high.getIntValue() + 1) : new IPAddress(low.getIntValue() + 1);
                }
                if (low.greaterThan(startPool) && !endPoolFlag) {
                    endPool = new IPAddress(low.getIntValue() - 1);
                    endPoolFlag = true;
                    if (high != null && !high.equals(network.getFinalHostAddress(mask))) {
                        Log.getLog().debug("Marking " + pool.getName() + " as readonly. found discontinous pools..");
                        pool.makeReadOnly(true);
                    }
                } else if (endPoolFlag) {
                    Log.getLog().debug("Marking " + pool.getName() + " as readonly. found discontinous pools");
                    pool.makeReadOnly(true);
                    break;
                }
                ++j;
            }
        }
        pool.setStartAddress(startPool);
        pool.setEndAddress(endPool);
    }

    private CmdValues generateDHCPClinetAD(int action, int admindistance) {
        CmdValues cmdVal = new CmdValues("ip");
        cmdVal.addValue("dhcp-client", "dhcp-client");
        cmdVal.addValue("default-router", "default-router");
        cmdVal.addValue("distance", "distance");
        cmdVal.addValue("adminDist", Integer.toString(admindistance));
        switch (action) {
            case 1: {
                cmdVal.setAction(1);
                return cmdVal;
            }
            case 2: {
                cmdVal.setAction(2);
                return cmdVal;
            }
        }
        return null;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        if (this.isModified()) {
            CmdValues cmdval;
            IPAddressRange obj;
            super.generateDelta(backup, values);
            Vector backupVector = ((DHCPPoolCollection)backup)._excluded;
            if (this._excluded != null) {
                int i = 0;
                while (i < this._excluded.size()) {
                    obj = (IPAddressRange)this._excluded.elementAt(i);
                    if (backupVector == null || !backupVector.contains(obj)) {
                        cmdval = new CmdValues("ip");
                        cmdval.addValue("dhcp", "dhcp");
                        cmdval.addValue("excluded-address", "excluded-address");
                        cmdval.addValue("lowAddr", obj.getLowIPAddress().toString());
                        if (obj.getHighIPAddress() != null) {
                            cmdval.addValue("highAddr", obj.getHighIPAddress().toString());
                        }
                        cmdval.setAction(1);
                        values.addCmdValues(cmdval);
                    }
                    ++i;
                }
            }
            if (backupVector != null) {
                int j = 0;
                while (j < backupVector.size()) {
                    obj = (IPAddressRange)backupVector.elementAt(j);
                    if (this._excluded == null || !this._excluded.contains(obj)) {
                        cmdval = new CmdValues("ip");
                        cmdval.addValue("dhcp", "dhcp");
                        cmdval.addValue("excluded-address", "excluded-address");
                        cmdval.addValue("lowAddr", obj.getLowIPAddress().toString());
                        if (obj.getHighIPAddress() != null) {
                            cmdval.addValue("highAddr", obj.getHighIPAddress().toString());
                        }
                        cmdval.setAction(2);
                        values.addCmdValues(cmdval);
                    }
                    ++j;
                }
            }
            DHCPPoolCollection _backupdhcp = (DHCPPoolCollection)backup;
            if (this._dhcpAdmindistance == INIT_VALUE) {
                if (_backupdhcp._dhcpAdmindistance != INIT_VALUE) {
                    CmdValues cmdVal = this.generateDHCPClinetAD(2, _backupdhcp._dhcpAdmindistance);
                    values.addCmdValues(cmdVal);
                }
            } else if (_backupdhcp._dhcpAdmindistance != this._dhcpAdmindistance) {
                CmdValues cmdVal1 = this.generateDHCPClinetAD(1, this._dhcpAdmindistance);
                values.addCmdValues(cmdVal1);
            }
        }
    }

    public int getDHCPAdminDist() {
        return this._dhcpAdmindistance;
    }

    public Vector getExcludedAddresses() {
        return this._excluded;
    }

    private ExcludedVector getMatchedExcludedVector(IPAddress network, Netmask mask) {
        ExcludedVector matchedExcluded = new ExcludedVector();
        int vecSize = 0;
        if (this._excluded != null) {
            vecSize = this._excluded.size();
        }
        int i = 0;
        while (i < vecSize) {
            IPAddressRange range = (IPAddressRange)this._excluded.elementAt(i);
            IPAddress low = range.getLowIPAddress();
            IPAddress lowNtwk = new IPAddress(low, mask);
            IPAddress high = range.getHighIPAddress();
            if (high == null) {
                if (lowNtwk.equals(network)) {
                    matchedExcluded.addElement(range);
                }
            } else {
                IPAddress highNtwk = new IPAddress(high, mask);
                if (lowNtwk.equals(network) && highNtwk.equals(network)) {
                    matchedExcluded.addElement(range);
                }
            }
            ++i;
        }
        return matchedExcluded;
    }

    private ExcludedVector getMatchedExcludedVector(IPAddress network, Netmask mask, IPAddress addr) {
        ExcludedVector matchedExcluded = new ExcludedVector();
        int vecSize = 0;
        if (this._excluded != null) {
            vecSize = this._excluded.size();
        }
        int i = 0;
        while (i < vecSize) {
            IPAddressRange range = (IPAddressRange)this._excluded.elementAt(i);
            IPAddress low = range.getLowIPAddress();
            IPAddress lowNtwk = new IPAddress(low, mask);
            IPAddress high = range.getHighIPAddress();
            if (high == null) {
                if (lowNtwk.equals(network) && !low.equals(addr)) {
                    matchedExcluded.addElement(range);
                }
            } else {
                IPAddress highNtwk = new IPAddress(high, mask);
                if (lowNtwk.equals(network) && highNtwk.equals(network)) {
                    matchedExcluded.addElement(range);
                }
            }
            ++i;
        }
        return matchedExcluded;
    }

    protected Vector getMatchedVector(IPAddress network, Netmask mask) {
        ExcludedVector matchedExcluded = new ExcludedVector();
        int vecSize = 0;
        if (this._excluded != null) {
            vecSize = this._excluded.size();
        }
        int i = 0;
        while (i < vecSize) {
            IPAddressRange range = (IPAddressRange)this._excluded.elementAt(i);
            IPAddress low = range.getLowIPAddress();
            IPAddress lowNtwk = new IPAddress(low, mask);
            IPAddress high = range.getHighIPAddress();
            if (high == null) {
                if (lowNtwk.equals(network)) {
                    matchedExcluded.addElement(range);
                }
            } else {
                IPAddress highNtwk = new IPAddress(high, mask);
                if (lowNtwk.equals(network) && highNtwk.equals(network)) {
                    matchedExcluded.addElement(range);
                }
            }
            ++i;
        }
        return matchedExcluded;
    }

    public String getNextPoolName() {
        String proposed = "sdm-pool" + this._poolNumber;
        Log.getLog().debug("DHCP: Prosposed pool name is " + proposed);
        while (this.isPoolExists(proposed)) {
            proposed = "sdm-pool" + ++this._poolNumber;
            Log.getLog().debug("DHCP: Prosposed pool name is " + proposed);
        }
        Log.getLog().debug("DHCP: Returning a unique pool name " + proposed);
        return proposed;
    }

    public DHCPPool getPool(String poolname) {
        if (poolname != null) {
            return (DHCPPool)super.get(poolname);
        }
        return null;
    }

    public String getPoolForHost(String hostIP) {
        if (hostIP == null || hostIP.length() <= 0) {
            return null;
        }
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            DHCPPool pool = this.getPool((String)e.nextElement());
            if (!pool.isHostPool() || pool.getHostIP() == null || !pool.getHostIP().toString().equals(hostIP)) continue;
            return pool.getName();
        }
        return null;
    }

    public String getPoolForMac(String macAddr) {
        if (macAddr == null || macAddr.length() <= 0) {
            return null;
        }
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            DHCPPool pool = this.getPool((String)e.nextElement());
            if (!pool.isHostPool()) continue;
            if (pool.getHardwareAddress() != null && pool.getHardwareAddress().toString().equals(macAddr)) {
                return pool.getName();
            }
            if (pool.getClientIdentifier() == null || !pool.getClientIdentifier().toString().equals(macAddr)) continue;
            return pool.getName();
        }
        return null;
    }

    public String getPoolName(IPAddress ipaddr, Netmask mask) {
        if (ipaddr == null || mask == null) {
            return null;
        }
        IPAddress network = ipaddr.getSubnet(mask);
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            DHCPPool pool = this.getPool((String)e.nextElement());
            Log.getLog().debug("DHCPPoolCollection: getPoolName: printing each pool");
            pool.print();
            IPAddress poolNetwork = pool.getNetwork();
            Netmask poolMask = pool.getMask();
            if (poolNetwork == null || poolMask == null || !poolNetwork.equals(network) || !poolMask.equals(mask)) continue;
            Log.getLog().debug("DHCPPoolCollection: getPoolName: Calling calculateStartEndIP again to update start & end IPs");
            this.calculateStartEndIP(pool, ipaddr);
            pool.print();
            return pool.getName();
        }
        return null;
    }

    public boolean isPoolExists(String name) {
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String pool = (String)e.nextElement();
            if (!pool.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void populate(ConfigValues cfgvals, CmdValues cmdvals) throws XDMException, CliGPBException {
        Log.getLog().debug("DHCPPoolCollection: populate Start ");
        if (cfgvals != null) {
            int numberOfCmds = cfgvals.numCmds();
            int i = 0;
            while (i < numberOfCmds) {
                CmdValues eachCmdValue = cfgvals.getCmdValues(i);
                if (eachCmdValue.getCmdName().equals("ip") && eachCmdValue.containsKey("dhcp") && eachCmdValue.containsKey("pool") && eachCmdValue.containsKey("poolName")) {
                    String poolname = eachCmdValue.getValue("poolName");
                    DHCPPool dhcppool = new DHCPPool(poolname, this);
                    dhcppool.populate(eachCmdValue.getModeCmdsValues(), eachCmdValue);
                    super.put(poolname, dhcppool);
                }
                if (eachCmdValue.getCmdName().equals("ip") && eachCmdValue.containsKey("dhcp") && eachCmdValue.containsKey("excluded-address") && eachCmdValue.containsKey("lowAddr")) {
                    String low = eachCmdValue.getValue("lowAddr");
                    IPAddress lowaddr = new IPAddress(low);
                    IPAddressRange range = new IPAddressRange(lowaddr);
                    if (eachCmdValue.containsKey("highAddr")) {
                        String high = eachCmdValue.getValue("highAddr");
                        IPAddress highaddr = new IPAddress(high);
                        range.setHighIPAddress(highaddr);
                    }
                    if (this._excluded == null) {
                        this._excluded = new Vector();
                    }
                    this._excluded.addElement(range);
                }
                if (eachCmdValue.getCmdName().equals("ip") && eachCmdValue.containsKey("dhcp-client") && eachCmdValue.containsKey("default-router") && eachCmdValue.containsKey("distance")) {
                    String dist = eachCmdValue.getValue("adminDist");
                    this._dhcpAdmindistance = Integer.parseInt(dist);
                }
                ++i;
            }
            Log.getLog().debug("DHCPPoolCollection: populate - parsing dhcp cmds end. ");
            this.print();
            Log.getLog().debug("DHCPPoolCollection: populate - calculating start & end addresses of each pool from excluded addresses");
            this.calculateStartEndIP();
            this.printStartEnd();
        }
        Log.getLog().debug("DHCPPoolCollection: populate End ");
    }

    public void print() {
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            DHCPPool pool = this.getPool((String)e.nextElement());
            Log.getLog().debug("DHCPPoolCollection: key is " + pool.getName());
            pool.print();
            Log.getLog().debug("-----------------------------------------");
        }
        if (this._excluded != null && this._excluded.size() > 0) {
            Log.getLog().debug("DHCPPoolCollection: Excluded addresses");
            int i = 0;
            while (i < this._excluded.size()) {
                ((IPAddressRange)this._excluded.elementAt(i)).print();
                ++i;
            }
        }
    }

    public void printStartEnd() {
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            DHCPPool pool = this.getPool((String)e.nextElement());
            Log.getLog().debug("DHCPPoolCollection: key is " + pool.getName());
            if (pool.getStartAddress() != null) {
                Log.getLog().debug("Start = " + pool.getStartAddress());
            }
            if (pool.getEndAddress() != null) {
                Log.getLog().debug("End = " + pool.getEndAddress());
            }
            Log.getLog().debug("-----------------------------------------");
        }
    }

    public void removeDHCPPool(String name) {
        super.remove(name);
        this.setModified();
    }

    public boolean removeExcludedAddress(IPAddressRange excludedIpRange) {
        if (this._excluded == null) {
            return false;
        }
        boolean val = this._excluded.removeElement(excludedIpRange);
        this.setModified();
        if (val && this._excluded.size() == 0) {
            this._excluded = null;
            return true;
        }
        this.setModified();
        return val;
    }

    public boolean removeExcludedAddress(Vector excludedIpRangeVector) {
        if (excludedIpRangeVector != null) {
            boolean retVal = true;
            int size = excludedIpRangeVector.size();
            int i = 0;
            while (i < size) {
                IPAddressRange range = (IPAddressRange)excludedIpRangeVector.elementAt(i);
                if (retVal) {
                    retVal = this.removeExcludedAddress(range);
                } else {
                    this.removeExcludedAddress(range);
                }
                ++i;
            }
            this.setModified();
            return retVal;
        }
        return false;
    }

    public void setDHCPAdminDist(int value) {
        this._dhcpAdmindistance = value;
        this.setModified();
    }
}

