/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.dialer;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMObject;

public class DialerList
extends XDMObject {
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARN = 3;
    public static final int ERROR = 4;
    public static final int FATAL = 5;
    public static int DEBUG_LEVEL = 3;
    private int _group = -1;
    private String _protocol;
    private String _action;
    private String _list;

    public DialerList() {
        if (DEBUG_LEVEL <= 1) {
            System.out.println("DialerList() " + this.getClass().getName());
        }
    }

    public DialerList(int groupnum) {
        this._group = groupnum;
        this._protocol = "ip";
        this._action = "permit";
    }

    public DialerList(XDMObject parent) {
        super(parent);
        if (DEBUG_LEVEL <= 1) {
            System.out.println("DialerList() " + this.getClass().getName());
        }
    }

    public DialerList(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
        if (DEBUG_LEVEL <= 1) {
            System.out.println("DialerList() " + this.getClass().getName());
        }
    }

    private boolean compareStrings(String first, String second) {
        if (first == second && first == null) {
            return true;
        }
        if (first == null) {
            return false;
        }
        return first.equals(second);
    }

    public boolean equals(Object obj) {
        if (DEBUG_LEVEL <= 1) {
            System.out.println("equals() " + this.getClass().getName());
        }
        if (obj != null && obj.getClass().equals(this.getClass())) {
            DialerList ifObj = (DialerList)obj;
            return this._group == ifObj._group && this.compareStrings(this._protocol, ifObj._protocol) && this.compareStrings(this._action, ifObj._action) && super.equals(obj);
        }
        return false;
    }

    private void generateAddCmd(ConfigValues cv) {
        if (DEBUG_LEVEL <= 2) {
            System.out.println("generateAddCommand() " + this.getClass().getName());
        }
        CmdValues cmd = new CmdValues("dialer-list");
        this.setValues(this, cmd, 1);
        cv.addCmdValues(cmd);
        if (DEBUG_LEVEL <= 1) {
            System.out.println("Cmd Values " + this.getClass().getName());
            System.out.println(cmd.toString());
        }
    }

    private void generateChangeCmd(DialerList old, ConfigValues cv) {
        if (DEBUG_LEVEL <= 2) {
            System.out.println("generateChangeCommand() " + this.getClass().getName());
        }
        CmdValues cmd = new CmdValues("dialer-list");
        this.setValues(this, cmd, 3);
        this.setOldValues(old, cmd);
        cv.addCmdValues(cmd);
        if (DEBUG_LEVEL <= 1) {
            System.out.println("Cmd Values " + this.getClass().getName());
            System.out.println(cmd.toString());
        }
    }

    private void generateDeleteCommand(ConfigValues cv) {
        if (DEBUG_LEVEL <= 2) {
            System.out.println("generateDeleteCommand() " + this.getClass().getName());
        }
        CmdValues cmd = new CmdValues("dialer-list");
        this.setValues(this, cmd, 2);
        cv.addCmdValues(cmd);
        if (DEBUG_LEVEL <= 1) {
            System.out.println("Cmd Values " + this.getClass().getName());
            System.out.println(cmd.toString());
        }
    }

    public void generateDelta(XDMObject backup, ConfigValues cv) {
        if (DEBUG_LEVEL <= 2) {
            System.out.println("generateDelta() " + this.getClass().getName());
        }
        DialerList backupList = null;
        if (!this.isReadOnly() && this.isModified()) {
            if (this.isBackup()) {
                this.generateDeleteCommand(cv);
            } else if (backup == null) {
                this.generateAddCmd(cv);
            } else {
                backupList = (DialerList)backup;
                this.generateChangeCmd(backupList, cv);
            }
        }
    }

    public String getAction() {
        return this._action;
    }

    public int getGroup() {
        return this._group;
    }

    public String getList() {
        return this._list;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public void populate(ConfigValues cv, CmdValues cvalues) {
        if (DEBUG_LEVEL <= 2) {
            System.out.println("populate() " + this.getClass().getName());
        }
        if (DEBUG_LEVEL <= 1) {
            System.out.println("Cmd Values " + this.getClass().getName());
            System.out.println(cvalues.toString());
        }
        this._group = Integer.parseInt(cvalues.getValue("DIALERGROUP"));
        this._protocol = cvalues.getValue("PROTOCOL");
        this._action = cvalues.getValue("permit");
        if (this._action == null) {
            this._action = cvalues.getValue("list");
            if (this._action != null) {
                this._list = cvalues.getValue("ACCESSLIST");
            }
        }
        if (this._action == null) {
            this.setReadOnly(true);
            if (DEBUG_LEVEL <= 3) {
                System.out.println("populate(): Action is not permit. Setting DialerList to read only " + this.getClass().getName());
            }
            this._action = cvalues.getValue("deny");
            if (this._action == null) {
                this._action = cvalues.getValue("list");
            }
        }
    }

    public void setAction(String action) {
        this._action = action;
        this.setModified();
    }

    public void setGroup(int group) {
        this._group = group;
        this.setModified();
    }

    public void setList(String list) {
        this._list = list;
        this.setModified();
    }

    private void setOldValues(DialerList dl, CmdValues cmd) {
        cmd.addOldValue("DIALERGROUP", String.valueOf(dl._group));
        cmd.addOldValue("PROTOCOL", dl._protocol);
        cmd.addOldValue("permit", dl._action);
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
        this.setModified();
    }

    private void setValues(DialerList dl, CmdValues cmd, int action) {
        cmd.addValue("DIALERGROUP", String.valueOf(dl._group));
        cmd.addValue("PROTOCOL", dl._protocol);
        cmd.addValue(dl._action, dl._action);
        if (dl._action.equals("list")) {
            cmd.addValue("ACCESSLIST", this._list);
        }
        cmd.setAction(action);
    }

    public String toString() {
        return "dialer-list " + this._group + " protocol " + this._protocol + " " + this._action;
    }
}

