/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.discovery;

import com.cisco.xdm.data.discovery.HWComponent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HWEntity {
    public static final int ENTITY_TYPE_WIC = 2;
    public static final int ENTITY_TYPE_NM = 1;
    public static final int ENTITY_TYPE_Device = 0;
    protected String _name;
    protected String _label;
    protected int _type;
    protected String _partno;
    protected String _family;
    protected Vector _hwComponents;
    protected Hashtable _extras = null;

    HWEntity(int type, String name, String label, String family) {
        this._type = type;
        this._label = label;
        this._name = name;
        this._family = family;
        this._partno = null;
        this._hwComponents = new Vector();
    }

    HWEntity(int type, String name, String label, String partno, String _family) {
        this._type = type;
        this._label = label;
        this._name = name;
        this._partno = partno;
        this._family = _family;
        this._hwComponents = new Vector();
    }

    public void addHWComponent(HWComponent comp) {
        this._hwComponents.addElement(comp);
    }

    public String findPNFromExtra(String str) {
        String pn = null;
        if (this.hasExtras() && str != null && str.length() > 0) {
            Enumeration e = this._extras.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (str.indexOf(key) < 0) continue;
                pn = (String)this._extras.get(key);
                break;
            }
        }
        return pn;
    }

    public String getFamily() {
        return this._family;
    }

    public Vector getHWComponents() {
        return this._hwComponents;
    }

    public String getLabel() {
        return this._label;
    }

    public String getName() {
        return this._name;
    }

    public String getPartNo() {
        return this._partno;
    }

    public int getType() {
        return this._type;
    }

    public boolean hasExtras() {
        return this._extras != null && this._extras.size() > 0;
    }

    void setExtras(Hashtable extras) {
        this._extras = extras;
    }

    public void setHWComponents(Vector comp) {
        Enumeration e = comp.elements();
        while (e.hasMoreElements()) {
            HWComponent ob = (HWComponent)e.nextElement();
            this._hwComponents.addElement(ob);
        }
    }
}

