/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.atm.AtmHelper;
import com.cisco.xdm.data.atm.PvcCollection;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.Atm;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMSubInterface;

public class AtmSubInterface
extends XDMSubInterface {
    private AtmHelper _atm = new AtmHelper(this, false);
    String _type = "point-to-point";

    public AtmSubInterface(IfID ifID, XDMInterface mainIf) {
        super(ifID, mainIf);
        Log.getLog().debug("AtmSubInterface() " + this.getClass().getName());
        this.DEF_IPROUTECACHEFLOW = false;
        this.DEF_IPROUTECACHECEF = false;
        this.setSupport(0, 1);
        this.setSupport(1, 1);
        this.setSupport(2, 1);
        this.setSupport(3, 1);
        this.setSupport(4, 1);
        this.setSupport(5, 1);
        this.setSupport(6, 0);
        this.setSupport(19, 1);
        this.setSupport(18, 1);
        this.setSupport(21, 1);
    }

    public Object clone() {
        Log.getLog().debug("clone() " + this.getClass().getName());
        AtmSubInterface newIf = (AtmSubInterface)super.clone();
        if (this._atm != null) {
            newIf._atm = (AtmHelper)this._atm.clone();
            newIf._atm.setParent(newIf);
        }
        return newIf;
    }

    private boolean compareStrings(String first, String second) {
        if (first == second && first == null) {
            return true;
        }
        if (first == null) {
            return false;
        }
        return first.equals(second);
    }

    public boolean containsPvc(int vpi, int vci) {
        Log.getLog().info("containsPvc() " + this.getClass().getName());
        if (this._atm.containsPvc(vpi, vci)) {
            Log.getLog().warn("containsPvc(): Sub interface already contains this PVC " + vpi + "/" + vci + " " + this.getClass().getName());
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        Log.getLog().debug("equals() " + this.getClass().getName());
        if (obj != null && obj.getClass().equals(this.getClass())) {
            AtmSubInterface ifObj = (AtmSubInterface)obj;
            return this._atm.equals(ifObj._atm) && this.compareStrings(this._type, ifObj._type) && super.equals(obj);
        }
        return false;
    }

    private void generateAddCmd(CmdValues parent) throws XDMException {
        parent.addValue("param1", this._type);
        ConfigValues cv = parent.getModeCmdsValues();
        if (cv == null) {
            cv = new ConfigValues();
        }
        this._atm.generateDelta(null, cv);
        if (!cv.isEmpty()) {
            parent.setModeCmdsValues(cv);
            Log.getLog().debug("generateAddCmd(): cv is" + cv);
        } else {
            Log.getLog().debug("generateChangeCmd(): cv is empty " + this.getClass().getName());
        }
    }

    private void generateChangeCmd(AtmSubInterface old, CmdValues parent) throws XDMException {
        Log.getLog().info("generateChangeCmd() " + this.getClass().getName());
        ConfigValues cv = parent.getModeCmdsValues();
        if (cv == null) {
            cv = new ConfigValues();
        }
        if (this._type != old._type) {
            parent.addValue("param1", this._type);
        }
        this._atm.generateDelta(old._atm, cv);
        if (!cv.isEmpty()) {
            parent.setModeCmdsValues(cv);
            Log.getLog().debug("generateAddCmd(): cv is " + parent);
        } else {
            Log.getLog().debug("generateChangeCmd(): cv is empty " + this.getClass().getName());
        }
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
        Log.getLog().info("generateDelta() " + this.getClass().getName());
        if (!this.isReadOnly() && this.isModified()) {
            AtmSubInterface backupAtm = null;
            if (!this.isBackup()) {
                if (backup == null) {
                    this.generateAddCmd(cmdVal);
                } else {
                    backupAtm = (AtmSubInterface)backup;
                    this.generateChangeCmd(backupAtm, cmdVal);
                }
            }
        }
    }

    public AtmHelper getAtmHelper() {
        return this._atm;
    }

    public String getInterfaceType() {
        return this._type;
    }

    public XDMInterfaceBase getLogicalIf() {
        return this._atm.getLogicalIf();
    }

    public PvcCollection getPvcs() {
        return this._atm.getPvcs();
    }

    public boolean isATMConfiguredForPPPoE() {
        return this._atm.isATMConfiguredForPPPoE();
    }

    public boolean isATMConfiguredForRFCMUX() {
        return this._atm.isATMConfiguredForRFCMUX();
    }

    public boolean isATMConfiguredForRFCSNAP() {
        return this._atm.isATMConfiguredForRFCSNAP();
    }

    public boolean isConfigurable() {
        Log.getLog().info("isConfigurable() " + this.getClass().getName());
        Atm atm = (Atm)this.getParent().getParent();
        if (!atm.isConfigurable()) {
            this.setConfigurable(false);
            this.setROReason(atm.getROReason());
            Log.getLog().warn("isConfigurable(): Parent is not configurable. ATM is non-configurable " + this.getClass().getName());
            return false;
        }
        if (!this._atm.isATMConnected() && this._atm.isReadOnly()) {
            this.setROReason(this._atm.getROReason());
            this.setConfigurable(false);
        }
        boolean result = super.isConfigurable();
        Log.getLog().info("isConfigurable(): Returning " + result + " for " + this.getIfID() + "  " + this.getClass().getName());
        if (!result) {
            Log.getLog().info("isConfigurable(): Not-configurable Reason " + Integer.toHexString(this.getROReason()));
        }
        return result;
    }

    public boolean isConfigured() {
        boolean result = this._atm.isATMConnected();
        Log.getLog().info("isConfigured(): Returning " + result + "for ATM interface " + this.getIfID() + "  " + this.getClass().getName());
        return result;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        Log.getLog().info("populate() " + this.getClass().getName());
        super.populate(config, cmdVal);
        this._type = cmdVal.getValue("param1");
        if (this._type.equals("multipoint")) {
            this.setConfigurable(false);
            this.setROReason(0x7000008);
            Log.getLog().warn("populate(): Setting multipoint AtmSubInterface to non-configurable " + this.getClass().getName());
        }
        ConfigValues subcmds = cmdVal.getModeCmdsValues();
        this._atm.populate(subcmds, cmdVal);
        if (this._atm.isReadOnly()) {
            this.setConfigurable(false);
            this.setROReason(this._atm.getROReason());
            Log.getLog().warn("populate(): Setting AtmSubInterface to non-configurable " + this.getClass().getName());
        }
    }

    public void resetModifiedFlag() {
        super.resetModifiedFlag();
        if (this._atm != null) {
            this._atm.resetModifiedFlag();
        }
    }

    public void setInterfaceType(String type) {
        this._type = type;
        this.setModified();
    }

    public void setPvcs(PvcCollection pvcs) {
        this._atm.setPvcs(pvcs);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(this._atm.toString());
        return sb.toString();
    }
}

