/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.IfIPAddress;
import com.cisco.xdm.data.interfaces.SSIDCollection;
import com.cisco.xdm.data.interfaces.XDMInterface;

public class Dot11Radio
extends XDMInterface {
    private SSIDCollection _ssids = new SSIDCollection(this);

    public Dot11Radio(IfID ifID) {
        super(ifID);
        this.setSupport(0, 1);
        this.setSupport(2, 1);
        this.setSupport(3, 1);
        this.setSupport(1, 1);
        this.setSupport(4, 1);
        this.setSupport(5, 1);
        this.setSupport(6, 1);
        this.setSupport(19, 1);
        this.setSupport(18, 1);
        this.setSupport(21, 1);
    }

    public boolean canSubIf() {
        return true;
    }

    public Object clone() {
        Dot11Radio newObj = (Dot11Radio)super.clone();
        newObj._ssids = (SSIDCollection)this._ssids.clone();
        newObj._ssids.setParent(newObj);
        return newObj;
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
        if (this.isBackup()) {
            return;
        }
        if (cmdVal == null) {
            return;
        }
        ConfigValues cv = cmdVal.getModeCmdsValues();
        if (cv == null) {
            cv = new ConfigValues();
        }
        SSIDCollection ssidsBackup = null;
        if (backup != null) {
            Dot11Radio radio = (Dot11Radio)backup;
            ssidsBackup = radio.getSSIDs();
        }
        this._ssids.generateDelta(ssidsBackup, cv);
        if (!cv.isEmpty()) {
            cmdVal.setModeCmdsValues(cv);
        }
    }

    public SSIDCollection getSSIDs() {
        return this._ssids;
    }

    public boolean isConfigured() {
        IfIPAddress ipAddr = this.getIpAddr();
        return ipAddr != null || this.getBridgeGroup() > 0;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        super.populate(config, cmdVal);
        if (cmdVal == null) {
            return;
        }
        this._ssids.populate(config, cmdVal);
    }

    public void resetModifiedFlag() {
        super.resetModifiedFlag();
        if (this._ssids != null) {
            this._ssids.resetModifiedFlag();
        }
    }
}

