/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.Description;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.IPAddressType;
import com.cisco.xdm.data.dhcp.DHCPPool;
import com.cisco.xdm.data.dhcp.DHCPPoolCollection;
import com.cisco.xdm.data.interfaces.Dialer;
import com.cisco.xdm.data.interfaces.EthernetSubInterface;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.IfIPAddress;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMSubInterfaces;
import java.util.Enumeration;
import java.util.Vector;

public class Ethernet
extends XDMInterface {
    public static int DEBUG = 1;
    public static int INFO = 2;
    public static int WARN = 3;
    public static int ERROR = 4;
    public static int FATAL = 5;
    public static int DEBUG_LEVEL = ERROR;
    private int _dialpoolnum = -1;
    private boolean pppoeEnabled = false;
    private int _channelGroup = -1;
    public static final int DHCP_NONE = 0;
    public static final int DHCP_SERVER = 1;
    public static final int DHCP_RELAY = 2;
    public static final int DHCP_SERVER_RELAY = 3;
    public static final int TYPE_LAN = 0;
    public static final int TYPE_WAN = 1;
    public static final int TYPE_UNKNOWN = 2;
    String _reason = null;
    String _direction = null;
    int _dhcpMode = 0;
    int _connectionType = 2;
    DHCPPool _dhcpPool = null;
    public static final String SDM_ETH_LAN = "$ETH-LAN$";
    public static final String SDM_ETH_WAN = "$ETH-WAN$";
    public static final String SDM_ETH_LAUNCHSW = "$ETH-SW-LAUNCH$";
    public static final String SDM_INTF_INFO = "$INTF-INFO-";
    public static final int ETH_NONE = 0;
    public static final int ETH_WAN = 1;
    public static final int ETH_LAN = 2;
    public static final int ETH_LAUNCHSW = 1;

    public Ethernet(IfID ifID) {
        super(ifID);
        this.DEF_MOP = true;
        this.setSupport(0, 1);
        this.setSupport(1, 1);
        this.setSupport(2, 1);
        this.setSupport(3, 1);
        this.setSupport(4, 1);
        this.setSupport(5, 1);
        this.setSupport(6, 1);
        this.setSupport(19, 1);
        this.setSupport(18, 1);
        this.setSupport(21, 1);
    }

    public boolean canSubIf() {
        return true;
    }

    public void delAllSunIf() {
        if (this.isSubInterfaceExist()) {
            XDMSubInterfaces subIfs = this.getSubInterfaces();
            Enumeration en = subIfs.elements();
            while (en.hasMoreElements()) {
                EthernetSubInterface subIf = (EthernetSubInterface)en.nextElement();
                XDMSubInterfaces ifcs = (XDMSubInterfaces)subIf.getParent();
                ifcs.remove(subIf.getIfID().getSubIfID());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (DEBUG_LEVEL <= DEBUG) {
            System.out.println("equals() " + this.getClass().getName());
        }
        if (obj == null) return false;
        if (!obj.getClass().equals(this.getClass())) return false;
        Ethernet eth = (Ethernet)obj;
        if (this._dialpoolnum != eth._dialpoolnum) return false;
        if (this._connectionType != eth._connectionType) return false;
        if (this._dhcpPool == null) {
            if (this._dhcpPool != eth._dhcpPool) {
                return false;
            }
        } else {
            boolean bl = this._dhcpPool.equals(eth._dhcpPool);
            if (!bl) return false;
        }
        if (super.equals(obj)) return true;
        return false;
    }

    private void generateAddCmd(CmdValues parent) {
        if (DEBUG_LEVEL <= INFO) {
            System.out.println("generateAddCmd() " + this.getClass().getName());
        }
        CmdValues cmd = null;
        ConfigValues cv = parent.getModeCmdsValues();
        if (cv == null) {
            cv = new ConfigValues();
        }
        if (this._dialpoolnum != -1) {
            cmd = new CmdValues("pppoe-client");
            cmd.addValue("DIALPOOL", String.valueOf(this._dialpoolnum));
            cmd.setAction(1);
            cv.addCmdValues(cmd);
        }
        if (this.isPPPOESet()) {
            cmd = new CmdValues("pppoe");
            cmd.addValue("enable", "enable");
            cmd.setAction(1);
            cv.addCmdValues(cmd);
        }
        if (!cv.isEmpty()) {
            cmd.setModeCmdsValues(cv);
            if (DEBUG_LEVEL <= DEBUG) {
                System.out.println("generateAddCmd(): cv is " + this.getClass().getName());
                cv.print();
            }
        } else if (DEBUG_LEVEL <= DEBUG) {
            System.out.println("generateAddCmd(): cv is empty " + this.getClass().getName());
        }
    }

    private void generateChangeCmd(Ethernet old, CmdValues parent) throws XDMException {
        if (DEBUG_LEVEL <= INFO) {
            System.out.println("generateChangeCmd() " + this.getClass().getName());
        }
        CmdValues cmd = null;
        ConfigValues cv = parent.getModeCmdsValues();
        if (cv == null) {
            cv = new ConfigValues();
        }
        if (DEBUG_LEVEL <= INFO) {
            System.err.println("OLD dialpoolno = " + old._dialpoolnum);
            System.err.println("dialpoolnum = " + this._dialpoolnum);
        }
        if (this._dialpoolnum != -1 && old._dialpoolnum != this._dialpoolnum) {
            cmd = new CmdValues("pppoe-client");
            if (old._dialpoolnum == -1) {
                cmd.addValue("DIALPOOL", String.valueOf(this._dialpoolnum));
                cmd.setAction(1);
            } else {
                cmd.addValue("DIALPOOL", String.valueOf(this._dialpoolnum));
                cmd.addOldValue("DIALPOOL", String.valueOf(old._dialpoolnum));
                cmd.setAction(3);
            }
            cv.addCmdValues(cmd);
        } else if (this._dialpoolnum == -1 && old._dialpoolnum != this._dialpoolnum) {
            cmd = new CmdValues("pppoe-client");
            cmd.addValue("DIALPOOL", String.valueOf(old._dialpoolnum));
            cmd.setAction(2);
            cv.addCmdValues(cmd);
        }
        if (DEBUG_LEVEL <= INFO) {
            System.err.println("OLD PPPOE = " + old.isPPPOESet());
            System.err.println("PPPOE = " + this.isPPPOESet());
        }
        if (old.isPPPOESet() != this.isPPPOESet()) {
            cmd = new CmdValues("pppoe");
            cmd.addValue("enable", "enable");
            if (this.isPPPOESet()) {
                cmd.setAction(1);
            } else {
                cmd.setAction(2);
            }
            cv.addCmdValues(cmd);
        }
        if (!cv.isEmpty()) {
            parent.setModeCmdsValues(cv);
            if (DEBUG_LEVEL <= DEBUG) {
                System.out.println("generateChangeCmd(): cv is" + this.getClass().getName());
                cv.print();
            }
        } else if (DEBUG_LEVEL <= DEBUG) {
            System.out.println("generateChangeCmd(): cv is empty " + this.getClass().getName());
        }
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
        if (!this.isReadOnly() && this.isModified()) {
            Ethernet backupEthernet = null;
            if (!this.isBackup()) {
                if (backup == null) {
                    this.generateAddCmd(cmdVal);
                } else {
                    backupEthernet = (Ethernet)backup;
                    this.generateChangeCmd(backupEthernet, cmdVal);
                }
            }
        }
    }

    public int getConnectionType() {
        return this._connectionType;
    }

    public int getDhcpMode() {
        return this._dhcpMode;
    }

    public DHCPPool getDhcpPool() {
        String poolName;
        DHCPPool dhcpPool = null;
        IfIPAddress ipAddr = this.getIpAddr();
        DHCPPoolCollection dhcpPools = ((DeviceBase)this.getDevice()).getDhcp();
        if (ipAddr != null && dhcpPools != null && (poolName = dhcpPools.getPoolName(ipAddr.getIPAddress(), ipAddr.getNetmask())) != null) {
            dhcpPool = dhcpPools.getPool(poolName);
        }
        return dhcpPool;
    }

    public int getDialPoolNumber() {
        return this._dialpoolnum;
    }

    public int getDir() {
        int ret = 0;
        if (Description.isFlagExist(this.getDesc(), SDM_ETH_LAN)) {
            ret = 2;
        }
        if (Description.isFlagExist(this.getDesc(), SDM_ETH_WAN)) {
            ret = 1;
        }
        return ret;
    }

    protected Vector getFlags() {
        Vector flags = super.getFlags();
        flags.addElement(SDM_ETH_LAN);
        flags.addElement(SDM_ETH_WAN);
        flags.addElement(SDM_ETH_LAUNCHSW);
        flags.addElement(SDM_INTF_INFO);
        return flags;
    }

    public String getIntfInfo() {
        String info = Description.getFlagContent(this.getDesc(), SDM_INTF_INFO);
        if (info != null && info.length() > 0) {
            return info.substring(SDM_INTF_INFO.length(), info.length() - 1);
        }
        return "";
    }

    public XDMInterfaceBase getLogicalIf() {
        if (this._dialpoolnum == -1) {
            return null;
        }
        Vector ifs = ((DeviceBase)this.getDevice()).getIfs().getIfsByType(1001);
        Enumeration e2 = ifs.elements();
        while (e2.hasMoreElements()) {
            Dialer item = (Dialer)e2.nextElement();
            if (DEBUG_LEVEL <= INFO) {
                System.err.println("Dialer Dial Pool number===== " + item.getDialPoolNumber());
                System.err.println("Interface Dial Pool number== " + this._dialpoolnum);
            }
            if (item.getDialPoolNumber() != this._dialpoolnum) continue;
            return item;
        }
        return null;
    }

    public String getReason() {
        return this._reason;
    }

    public boolean getSW() {
        return Description.isFlagExist(this.getDesc(), SDM_ETH_LAUNCHSW);
    }

    public boolean isChannelGroupConfigured() {
        return this._channelGroup > 0;
    }

    public boolean isConfigurable() {
        DeviceBase dev;
        this._reason = "";
        boolean configurable = true;
        configurable = super.isConfigurable();
        if (DEBUG_LEVEL <= DEBUG) {
            System.err.println("Ethernet " + this.getIfID() + " super isConfigurable = " + configurable);
        }
        if (configurable && this.isSubInterfaceExist()) {
            XDMSubInterfaces subIfs = this.getSubInterfaces();
            Enumeration en = subIfs.elements();
            while (en.hasMoreElements()) {
                EthernetSubInterface subIf = (EthernetSubInterface)en.nextElement();
                if (subIf.getEncapMethod().equals("dot1Q") && (subIf.getIpAddr() != null || subIf.getBridgeGroup() != 0)) continue;
                this.setConfigurable(false);
                configurable = false;
                this._reason = String.valueOf(this._reason) + "Sub interface Exist with ISL encapsulation method";
                break;
            }
        }
        if (configurable && this.pppoeEnabled) {
            Dialer dialer = (Dialer)this.getLogicalIf();
            if (dialer == null || this._dialpoolnum == -1) {
                this.setConfigurable(false);
                configurable = false;
                this._reason = String.valueOf(this._reason) + "Dialer is null";
            }
            if (configurable && (dialer.getEncapsulation() == null || !dialer.getEncapsulation().equals("ppp"))) {
                this.setConfigurable(false);
                configurable = false;
                this._reason = String.valueOf(this._reason) + "PPP encapsulation not present";
            }
            if (configurable && dialer.getIpAddr() == null) {
                this.setConfigurable(false);
                configurable = false;
                this._reason = String.valueOf(this._reason) + "Dialer does not have an IP Address";
            }
            if (configurable && dialer.getIpAddr() != null && this.getIpAddr() != null) {
                this.setConfigurable(false);
                configurable = false;
                this._reason = String.valueOf(this._reason) + "Both interface and associated dialer have an IP Address";
            }
            boolean vpdnRequired = ((DeviceBase)this.getDevice()).getDevInfoBase().isPPPoENeedVpdn();
            if (configurable && vpdnRequired && !((DeviceBase)this.getDevice()).getVPDN().getVPDNGroupCollection().isPPPOESet()) {
                this.setConfigurable(false);
                configurable = false;
                this._reason = String.valueOf(this._reason) + "VPDN not present";
            }
        }
        if (configurable && this.isWANConfigured() && !this.pppoeEnabled && this.getIpAddr() == null) {
            this.setConfigurable(false);
            configurable = false;
            this._reason = String.valueOf(this._reason) + "IP Address is not present on the interface";
        }
        if (DEBUG_LEVEL <= DEBUG) {
            System.err.println("Ethernet " + this.getIfID() + " isConfigurable = " + configurable + " Reason = " + this._reason);
        }
        if (configurable && this._channelGroup > 0) {
            this.setConfigurable(false);
            configurable = false;
            this._reason = String.valueOf(this._reason) + "CHANNEL GROUP command present";
        }
        if ((dev = (DeviceBase)this.getDevice()).getDevInfoBase().getModel().indexOf("7") == 0 && this.isWANConfigured()) {
            this.setConfigurable(false);
            configurable = false;
            this._reason = String.valueOf(this._reason) + "SDM does not support WAN configuration on 7xxx router";
        }
        return configurable;
    }

    public boolean isConfigured() {
        IfIPAddress ipAddr;
        boolean configured = false;
        if (this.isWANConfigured() || this.isLANConfigured() || this.isSubinterfaceConfigured()) {
            configured = true;
        } else if (!(this.isWANConfigured() || this.isLANConfigured() || this.isSubinterfaceConfigured() || (ipAddr = this.getIpAddr()) == null && this.getBridgeGroup() <= 0)) {
            configured = true;
        }
        return configured;
    }

    public boolean isConfiguredForStraightRouting() {
        IfIPAddress ipAddr;
        boolean configured = false;
        if (!this.isWANConfigured() && !this.isLANConfigured() && (ipAddr = this.getIpAddr()) != null) {
            configured = true;
        }
        return configured;
    }

    public boolean isLAN() {
        boolean isLan = true;
        if (this._connectionType != 0) {
            isLan = false;
        }
        return isLan;
    }

    public boolean isLANConfigured() {
        boolean isLanConfigured = false;
        if (this._dhcpMode == 1 || this._dhcpMode == 2 || this._dhcpMode == 3) {
            isLanConfigured = true;
        }
        String desc = this.getDesc();
        IfIPAddress ipAddr = this.getIpAddr();
        if (!(this.getDir() != 2 && !Description.isFlagExist(this.getDesc(), "$ES_LAN$") || ipAddr == null && this.getBridgeGroup() <= 0)) {
            isLanConfigured = true;
        }
        if (DEBUG_LEVEL <= DEBUG) {
            System.err.println("Returning from isLANConfigured =" + isLanConfigured);
        }
        return isLanConfigured;
    }

    public boolean isPPPOESet() {
        return this.pppoeEnabled;
    }

    public boolean isSubinterfaceConfigured() {
        if (this.isSubInterfaceExist()) {
            XDMSubInterfaces subIfs = this.getSubInterfaces();
            Enumeration en = subIfs.elements();
            while (en.hasMoreElements()) {
                EthernetSubInterface subIf = (EthernetSubInterface)en.nextElement();
                if (subIf.getEncapMethod().equals("dot1Q") && (subIf.getIpAddr() != null || subIf.getBridgeGroup() != 0)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isSubinterfacehasbridgegroup() {
        if (this.isSubInterfaceExist()) {
            XDMSubInterfaces subIfs = this.getSubInterfaces();
            Enumeration en = subIfs.elements();
            while (en.hasMoreElements()) {
                EthernetSubInterface subIf = (EthernetSubInterface)en.nextElement();
                if (!subIf.getEncapMethod().equals("dot1Q") || subIf.getBridgeGroup() <= 0) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isWAN() {
        boolean isWan = true;
        if (this._connectionType != 1) {
            isWan = false;
        }
        return isWan;
    }

    public boolean isWANConfigured() {
        boolean isWanConfigured = false;
        if (this.pppoeEnabled && this._dialpoolnum != -1) {
            isWanConfigured = true;
        } else {
            IfIPAddress ipAddr = this.getIpAddr();
            if (ipAddr != null && ipAddr.getIPAddressType() == IPAddressType.DYNAMIC) {
                isWanConfigured = true;
            } else {
                String desc = this.getDesc();
                if ((this.getDir() == 1 || Description.isFlagExist(this.getDesc(), "$ES_WAN$")) && ipAddr != null) {
                    isWanConfigured = true;
                }
            }
        }
        if (DEBUG_LEVEL <= DEBUG) {
            System.err.println("Returning from isWANConfigured for Ethernet " + this.getIfID() + " =" + isWanConfigured);
        }
        return isWanConfigured;
    }

    public boolean isyyyWANConfigured() {
        boolean isWanConfigured = false;
        if (this.pppoeEnabled && this._dialpoolnum != -1) {
            isWanConfigured = true;
        } else {
            IfIPAddress ipAddr = this.getIpAddr();
            if (ipAddr != null && ipAddr.getIPAddressType() == IPAddressType.DYNAMIC) {
                isWanConfigured = true;
            } else {
                String desc = this.getDesc();
                if (this.getDir() == 1) {
                    isWanConfigured = true;
                }
            }
        }
        if (DEBUG_LEVEL <= DEBUG) {
            System.err.println("Returning from isWANConfigured for Ethernet " + this.getIfID() + " =" + isWanConfigured);
        }
        return isWanConfigured;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        super.populate(config, cmdVal);
        ConfigValues subcmds = cmdVal.getModeCmdsValues();
        this.populateDialPoolInfo(subcmds);
        this.populatePPPoE(subcmds);
        this.populateType();
        if (this.isLAN()) {
            this.populateDHCP(subcmds);
        }
        this.populateUnsupportedCommands(subcmds);
    }

    private void populateDHCP(ConfigValues subcmds) throws CliGPBException {
        IfIPAddress ipAddr;
        this._dhcpMode = 0;
        if (this.getDhcpRelayAddr() != null) {
            this._dhcpMode = 2;
        }
        if ((ipAddr = this.getIpAddr()) == null || ipAddr.getIPAddress() == null) {
            return;
        }
        IPAddress network = new IPAddress(ipAddr.getIPAddress(), ipAddr.getNetmask());
        DHCPPoolCollection dhcpPools = ((DeviceBase)this.getDevice()).getDhcp();
        String poolName = dhcpPools.getPoolName(ipAddr.getIPAddress(), ipAddr.getNetmask());
        if (poolName != null) {
            this._dhcpPool = dhcpPools.getPool(poolName);
        }
        if (this._dhcpPool != null) {
            this._dhcpMode = this._dhcpMode == 2 ? 3 : 1;
        }
    }

    private void populateDialPoolInfo(ConfigValues subcmds) throws CliGPBException {
        ConfigValues cv;
        if (DEBUG_LEVEL <= INFO) {
            System.out.println("populateDialPoolInfo() " + this.getClass().getName());
        }
        if ((cv = subcmds.getCmds("pppoe-client", ".*", ".*", false)) == null) {
            return;
        }
        if (DEBUG_LEVEL <= INFO) {
            cv.print();
        }
        if (cv.numCmds() != 1) {
            this.setConfigurable(false);
            this._reason = String.valueOf(this._reason) + "Multiple PPPoE Client Commands.";
        }
        CmdValues cmd = cv.getCmdValues(0);
        this._dialpoolnum = Integer.parseInt(cmd.getValue("DIALPOOL"));
        if (cmd.getValue("dial-on-demand") != null) {
            this.setConfigurable(false);
            this._reason = String.valueOf(this._reason) + "Dial on Demand present.";
            Log.getLog().warn("populateDialPoolInfo(): dial-on-demand for PPPoE. Setting read only flag " + this.getClass().getName());
        }
    }

    private void populatePPPoE(ConfigValues subcmds) throws CliGPBException {
        ConfigValues cv;
        if (DEBUG_LEVEL <= INFO) {
            System.out.println("populatePPPoE() " + this.getClass().getName());
            subcmds.print();
        }
        if ((cv = subcmds.getCmds("pppoe", ".*", ".*", false)) == null) {
            return;
        }
        this.pppoeEnabled = true;
    }

    private void populateType() {
        this._connectionType = this.isWANConfigured() ? 1 : (this.isLANConfigured() ? 0 : 2);
    }

    private void populateUnsupportedCommands(ConfigValues subcmds) throws CliGPBException {
        ConfigValues cvcg;
        if (DEBUG_LEVEL <= INFO) {
            System.out.println("populateUnsupportedCommands() " + this.getClass().getName());
        }
        if ((cvcg = subcmds.getCmds("channel-group", ".*", ".*", false)) != null) {
            CmdValues cmd = cvcg.getCmdValues(0);
            this._channelGroup = Integer.parseInt(cmd.getValue("CHANNELNUMBER"));
        }
        if (this._channelGroup > 0) {
            this._connectionType = 0;
            this.setConfigurable(false);
            this.setSupport(0, 0);
            this.setSupport(1, 0);
            this.setSupport(2, 0);
            this.setSupport(3, 0);
            this.setSupport(4, 0);
            this.setSupport(5, 0);
            this.setSupport(6, 0);
            this.setSupport(7, 0);
            this.setSupport(8, 0);
            this.setSupport(9, 0);
            this.setSupport(10, 0);
            this.setSupport(11, 0);
            this.setSupport(12, 0);
            this.setSupport(13, 0);
            this.setSupport(14, 0);
            this.setSupport(15, 0);
            this.setSupport(16, 0);
            this.setSupport(17, 0);
            this.setSupport(18, 0);
        }
    }

    public void resetDesc() {
        this.setDir(0);
        this.setDesc(Description.removeFlag(this.getDesc(), "$ES_LAN$"));
        this.setDesc(Description.removeFlag(this.getDesc(), "$ES_WAN$"));
    }

    public void resetLANConnection() {
        this.resetDesc();
        this.setDhcpMode(0);
        DHCPPoolCollection dhcpPools = ((DeviceBase)this.getDevice()).getDhcp();
        if (this._dhcpPool != null) {
            if (this.getIpAddr() != null && this.getIpAddr().getIPAddress() != null) {
                dhcpPools.removeExcludedAddress(this._dhcpPool.generateExcludedAddresses((DeviceBase)this.getDevice(), this.getIpAddr()));
            }
            dhcpPools.removeDHCPPool(this._dhcpPool.getName());
        }
        this.setDhcpRelayAddr(null);
        this.setIpAddr(null);
        this.setConnectionType(2);
        this.shutdown(true);
    }

    public void resetSW() {
        this.setDesc(Description.removeFlag(this.getDesc(), SDM_ETH_LAUNCHSW));
    }

    public void resetWANConnection() {
        this.resetDesc();
        this.setPPPOE(false);
        this.setDialPoolNumber(-1);
        this.setIpAddr(null);
        this.setConnectionType(2);
    }

    public void setConnectionType(int type) {
        this._connectionType = type < 2 ? type : 2;
    }

    public void setDhcpMode(int mode) {
        this._dhcpMode = mode;
        this.setModified();
    }

    public void setDhcpPool(DHCPPool pool) {
        this._dhcpPool = pool;
        this.setModified();
    }

    public void setDialPoolNumber(int dialpoolnum) {
        this._dialpoolnum = dialpoolnum;
        this.setModified();
    }

    public void setDir(int dir) {
        if (dir != 0 && dir != 1 && dir != 2) {
            return;
        }
        this.setDesc(Description.removeFlag(this.getDesc(), SDM_ETH_WAN));
        this.setDesc(Description.removeFlag(this.getDesc(), SDM_ETH_LAN));
        if (dir == 1) {
            this.setDesc(Description.addFlag(this.getDesc(), SDM_ETH_WAN));
        } else if (dir == 2) {
            this.setDesc(Description.addFlag(this.getDesc(), SDM_ETH_LAN));
        }
    }

    public void setPPPOE(boolean flag) {
        this.pppoeEnabled = flag;
        this.setModified();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("  pppoeEnabled = " + this.pppoeEnabled);
        sb.append("  Dial Pool nu = " + this._dialpoolnum);
        sb.append("  Connection Type = " + this._connectionType);
        return sb.toString();
    }
}

