/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.XDMInterface;
import java.util.Vector;

public class IDSSensor
extends XDMInterface {
    private static final String HEADER_IDMADDR = "$IDMADDR:";
    private static final String END_IDMADDR = "$";

    public IDSSensor(IfID ifID) {
        super(ifID);
        this.setSupport(0, 1);
        this.setSupport(2, 1);
        this.setSupport(3, 1);
        this.setSupport(1, 1);
        this.setSupport(4, 1);
        this.setSupport(5, 1);
        this.setSupport(6, 1);
        this.setSupport(19, 1);
        this.setSupport(21, 1);
    }

    public boolean canSubIf() {
        return false;
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
    }

    protected Vector getFlags() {
        Vector flags = super.getFlags();
        flags.addElement(HEADER_IDMADDR);
        return flags;
    }

    public String getIDMAddr() {
        String desc = this.getDesc();
        int start = desc.indexOf(HEADER_IDMADDR);
        if (start == -1) {
            return "";
        }
        int end = desc.indexOf(END_IDMADDR, start + HEADER_IDMADDR.length());
        if (end == -1) {
            return "";
        }
        return desc.substring(start + HEADER_IDMADDR.length(), end);
    }

    private String getStringWithoutIDMAddr(String buf) {
        int start = buf.indexOf(HEADER_IDMADDR);
        if (start == -1) {
            return buf;
        }
        int end = buf.indexOf(END_IDMADDR, start + HEADER_IDMADDR.length());
        if (end == -1) {
            return buf;
        }
        StringBuffer sb = new StringBuffer(buf.substring(0, start));
        if (end < buf.length() - 1) {
            sb.append(buf.substring(end + 1));
        }
        return sb.toString();
    }

    public void setIDMAddr(String addr) {
        StringBuffer sb = new StringBuffer(this.getStringWithoutIDMAddr(this.getDesc()));
        if (addr != null && addr.length() > 0) {
            sb.append(HEADER_IDMADDR);
            sb.append(addr);
            sb.append(END_IDMADDR);
        }
        this.setDesc(sb.toString());
        this.setModified();
    }
}

