/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.xdm.data.base.HWConfig;
import com.cisco.xdm.data.discovery.HWDictionary;
import com.cisco.xdm.data.discovery.IfType;
import com.cisco.xdm.parser.InterfaceParser;
import java.util.Enumeration;
import java.util.Hashtable;

public class IfID {
    public static final int IFID_INVALID_TYPE = 0;
    public static final int IFID_INVALID_CHANNEL = -1;
    public static final int IFID_INVALID_SUBIF = 0;
    public static final int IFID_INVALID_LOCATION = -1;
    private int _type;
    private int _slot;
    private int _module_slot;
    private int _port;
    private int _channel;
    private int _subIfID;
    private String _unsupported;

    public IfID(int type, int slot, int module_slot, int port, int channel, int subIfID) {
        this._type = type;
        this._slot = slot;
        this._module_slot = module_slot;
        this._port = port;
        this._channel = channel;
        this._subIfID = subIfID;
        this._unsupported = null;
    }

    public IfID(String unsupported, int slot, int module_slot, int port, int channel, int subIfID) {
        this._type = 0;
        this._slot = slot;
        this._module_slot = module_slot;
        this._port = port;
        this._channel = channel;
        this._subIfID = subIfID;
        this._unsupported = unsupported;
    }

    public int compare(IfID obj) {
        int less = -1;
        int greater = 1;
        int equal = 0;
        int ret = this.comparePos(this._slot, obj._slot, true);
        if (ret != 0) {
            return ret;
        }
        ret = this.comparePos(this._module_slot, obj._module_slot, false);
        if (ret != 0) {
            return ret;
        }
        ret = this.getTypeString().compareTo(obj.getTypeString());
        if (ret > 0) {
            return greater;
        }
        if (ret < 0) {
            return less;
        }
        if (this._port > obj._port) {
            return greater;
        }
        if (this._port < obj._port) {
            return less;
        }
        if (this._channel > obj._channel) {
            return greater;
        }
        if (this._channel < obj._channel) {
            return less;
        }
        if (this._subIfID > obj._subIfID) {
            return greater;
        }
        if (this._subIfID < obj._subIfID) {
            return less;
        }
        return equal;
    }

    private int comparePos(int p1, int p2, boolean invalidIsGreater) {
        if (p1 == -1 && p2 != -1) {
            return invalidIsGreater ? 1 : -1;
        }
        if (p2 == -1 && p1 != -1) {
            return invalidIsGreater ? -1 : 1;
        }
        if (p1 > p2) {
            return 1;
        }
        if (p1 < p2) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IfID)) {
            return false;
        }
        IfID ifIDObj = (IfID)obj;
        return this._type == ifIDObj._type && this._slot == ifIDObj._slot && this._module_slot == ifIDObj._module_slot && this._port == ifIDObj._port && this._channel == ifIDObj._channel && this._subIfID == ifIDObj._subIfID && (this._unsupported == null && ifIDObj._unsupported == null || this._unsupported != null && this._unsupported.equals(ifIDObj._unsupported) || ifIDObj._unsupported != null && ifIDObj._unsupported.equals(this._unsupported));
    }

    public static IfID fromString(String str, HWConfig hwConfig) {
        int subif;
        int channel;
        int port;
        Integer newInt;
        Hashtable ht = InterfaceParser.parseInterface(str);
        int slot = -1;
        int mslot = -1;
        if (ht.containsKey("part2")) {
            newInt = Integer.valueOf((String)ht.get("part0"));
            slot = newInt;
            newInt = Integer.valueOf((String)ht.get("part1"));
            mslot = newInt;
            newInt = Integer.valueOf((String)ht.get("part2"));
            port = newInt;
        } else if (ht.containsKey("part1")) {
            newInt = Integer.valueOf((String)ht.get("part0"));
            slot = newInt;
            newInt = Integer.valueOf((String)ht.get("part1"));
            port = newInt;
        } else {
            newInt = Integer.valueOf((String)ht.get("part0"));
            port = newInt;
        }
        if (ht.containsKey("timeslot")) {
            newInt = Integer.valueOf((String)ht.get("timeslot"));
            channel = newInt;
        } else {
            channel = -1;
        }
        if (ht.containsKey("subinterface")) {
            newInt = Integer.valueOf((String)ht.get("subinterface"));
            subif = newInt;
        } else {
            subif = 0;
        }
        String word = (String)ht.get("type");
        int type = 0;
        if (channel == -1) {
            HWDictionary dict = HWDictionary.GetInstance();
            if (slot == -1) {
                if (!word.equalsIgnoreCase("atm")) {
                    Hashtable ifs = dict.getifs();
                    Enumeration e = ifs.elements();
                    while (e.hasMoreElements()) {
                        IfType ifType = (IfType)e.nextElement();
                        if (!word.equalsIgnoreCase(ifType.getPhrase())) continue;
                        if (!ifType.isLogicalIf()) break;
                        type = ifType.getType();
                        break;
                    }
                }
                if (type == 0) {
                    type = word.equalsIgnoreCase("atm") && hwConfig.findController("DSL", slot, mslot, port) ? 1008 : hwConfig.findHWIfType(word, port);
                }
            } else {
                type = word.equalsIgnoreCase("atm") && hwConfig.findController("DSL", slot, mslot, port) ? 1008 : hwConfig.findHWIfType(word, slot, mslot, port);
            }
        }
        IfID id = type != 0 ? new IfID(type, slot, mslot, port, channel, subif) : new IfID(word, slot, mslot, port, channel, subif);
        return id;
    }

    public int getChannel() {
        return this._channel;
    }

    public int getModuleSlot() {
        return this._module_slot;
    }

    public int getPort() {
        return this._port;
    }

    public int getSlot() {
        return this._slot;
    }

    public int getSubIfID() {
        return this._subIfID;
    }

    public int getType() {
        return this._type;
    }

    private String getTypeString() {
        String str = new String();
        if (this._unsupported == null) {
            HWDictionary dict = HWDictionary.GetInstance();
            IfType ifType = dict.getif(this._type);
            str = ifType.getPhrase();
        } else {
            str = this._unsupported;
        }
        return str;
    }

    public String getUnsupportIfStr() {
        return this._unsupported;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isChannel() {
        return this._channel != -1;
    }

    public boolean isL2Ethernet() {
        return this._type == 5 || this._type == 6;
    }

    public boolean isL3Ethernet() {
        return this._type == 2 || this._type == 1 || this._type == 4 || this._type == 3;
    }

    public boolean isLogical() {
        IfType ifType = HWDictionary.GetInstance().getif(this._type);
        return this.isSubInterface() || this.isChannel() || this._type != 0 && ifType.isLogicalIf();
    }

    public boolean isSamePort(IfID ifID) {
        if (ifID == null) {
            return false;
        }
        if (this._type == 0) {
            return ifID._unsupported.equalsIgnoreCase(this._unsupported) && ifID._slot == this._slot && ifID._module_slot == this._module_slot && ifID._port == this._port;
        }
        return ifID._type == this._type && ifID._slot == this._slot && ifID._module_slot == this._module_slot && ifID._port == this._port;
    }

    public boolean isSubInterface() {
        return this._subIfID != 0;
    }

    public boolean isSupported() {
        boolean ret = false;
        IfType ifType = HWDictionary.GetInstance().getif(this._type);
        if (ifType != null) {
            ret = ifType.isSupport();
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getTypeString());
        if (this._slot != -1) {
            sb.append(String.valueOf(String.valueOf(this._slot)) + "/");
        }
        if (this._module_slot != -1) {
            sb.append(String.valueOf(String.valueOf(this._module_slot)) + "/");
        }
        if (this._port != -1) {
            sb.append(String.valueOf(this._port));
        }
        if (this._channel != -1) {
            sb.append(":");
            sb.append(String.valueOf(this._channel));
        }
        if (this._subIfID != 0) {
            sb.append(".");
            sb.append(String.valueOf(this._subIfID));
        }
        return sb.toString();
    }
}

