/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.ParserUtils;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import java.util.Hashtable;

public class NHRPMap
extends XDMObject {
    int _type;
    String _nbma_ip = new String();
    String _dest_ip = new String();
    String _dest_mask = new String();

    public NHRPMap() {
        this._type = 0;
    }

    public NHRPMap(String nbmaip) {
        this._nbma_ip = nbmaip.trim();
        this._type = 1;
    }

    public NHRPMap(String destip, String nbmaip) {
        this._nbma_ip = nbmaip.trim();
        this._dest_ip = destip.trim();
        this._type = 2;
    }

    public NHRPMap(String destip, String destmask, String nbmaip) {
        this._dest_mask = destmask.trim();
        this._nbma_ip = nbmaip.trim();
        this._dest_ip = destip.trim();
        this._type = 3;
    }

    public Object clone() {
        NHRPMap nhrpClone = (NHRPMap)super.clone();
        return nhrpClone;
    }

    private void generateAddCmd(ConfigValues values) throws XDMException {
        String cliCommand = "ip";
        String[] keywordNames = new String[]{"nhrp", "map"};
        Hashtable<String, String> valuesTable = new Hashtable<String, String>();
        switch (this._type) {
            case 0: {
                valuesTable.put("multicast", "multicast");
                valuesTable.put("dynamic", "dynamic");
                break;
            }
            case 1: {
                valuesTable.put("multicast", "multicast");
                valuesTable.put("NBMAIp", this._nbma_ip);
                break;
            }
            case 2: {
                valuesTable.put("DestIp", this._dest_ip);
                valuesTable.put("NBMAIp", this._nbma_ip);
                break;
            }
            case 3: {
                valuesTable.put("DestIp", this._dest_ip);
                valuesTable.put("DestMask", this._dest_mask);
                valuesTable.put("NBMAIp", this._nbma_ip);
                break;
            }
        }
        CmdValues cmdVal = ParserUtils.createCLICommand(cliCommand, keywordNames, 1, valuesTable, null);
        values.addCmdValues(cmdVal);
    }

    private void generateChangeCmd(NHRPMap backup, ConfigValues values) throws XDMException {
    }

    private void generateDeleteCommand(ConfigValues values) {
        String cliCommand = "ip";
        String[] keywordNames = new String[]{"nhrp", "map"};
        Hashtable<String, String> valuesTable = new Hashtable<String, String>();
        switch (this._type) {
            case 0: {
                valuesTable.put("multicast", "multicast");
                valuesTable.put("dynamic", "dynamic");
                break;
            }
            case 1: {
                valuesTable.put("multicast", "multicast");
                valuesTable.put("NBMAIp", this._nbma_ip);
                break;
            }
            case 2: {
                valuesTable.put("DestIp", this._dest_ip);
                valuesTable.put("NBMAIp", this._nbma_ip);
                break;
            }
            case 3: {
                valuesTable.put("DestIp", this._dest_ip);
                valuesTable.put("NBMAIp", this._nbma_ip);
                valuesTable.put("DestMask", this._dest_mask);
                break;
            }
        }
        CmdValues cmdVal = ParserUtils.createCLICommand(cliCommand, keywordNames, 2, valuesTable, null);
        values.addCmdValues(cmdVal);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        if (this.isBackup()) {
            this.generateDeleteCommand(values);
        } else if (backup == null) {
            this.generateAddCmd(values);
        }
    }

    public String getDestIP() {
        return this._dest_ip;
    }

    public String getDestMask() {
        return this._dest_mask;
    }

    public String getNBMAIP() {
        return this._nbma_ip;
    }

    public int getType() {
        return this._type;
    }

    public void populate(ConfigValues configValues, CmdValues cmdVal) throws XDMException {
        if (cmdVal.getValue("dynamic") != null) {
            this._type = 0;
            return;
        }
        this._nbma_ip = cmdVal.getValue("NBMAIp");
        this._dest_ip = cmdVal.getValue("DestIp");
        this._dest_mask = cmdVal.getValue("DestMask");
        if (this._dest_mask != null && this._dest_mask.trim().length() > 0) {
            this._type = 3;
            return;
        }
        this._type = this._dest_ip != null && this._dest_ip.trim().length() > 0 ? 2 : 1;
    }

    public String toString() {
        switch (this._type) {
            case 0: {
                return "multicast dynamic";
            }
            case 1: {
                StringBuffer sb = new StringBuffer("multicast ");
                sb.append(this._nbma_ip);
                return sb.toString();
            }
            case 2: {
                StringBuffer sb = new StringBuffer(this._dest_ip);
                sb.append(" ").append(this._nbma_ip);
                return sb.toString();
            }
            case 3: {
                StringBuffer sb = new StringBuffer(this._dest_ip);
                sb.append(" ").append(this._dest_mask).append(" ").append(this._nbma_ip);
                return sb.toString();
            }
        }
        return null;
    }
}

