/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.SSID;

public class SSIDCollection
extends XDMHashCollection {
    private static final String KEY_SSID = "ssid";
    private static final String KEY_ID = "ID";

    public SSIDCollection(XDMObject parent) {
        super(parent);
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        super.populate(config, cmdVal);
        if (cmdVal == null) {
            return;
        }
        ConfigValues subCmds = cmdVal.getModeCmdsValues();
        if (subCmds == null) {
            return;
        }
        int i = 0;
        while (i < subCmds.numCmds()) {
            CmdValues cmd = subCmds.getCmdValues(i);
            String cmdName = cmd.getCmdName();
            if (cmdName.equals(KEY_SSID)) {
                String id = cmd.getValue(KEY_ID);
                SSID ssid = new SSID(id);
                this.put(id, ssid);
                ssid.populate(config, cmd);
            }
            ++i;
        }
    }

    public synchronized XDMObject put(SSID ssid) throws XDMException {
        if (ssid == null) {
            throw new XDMException(4);
        }
        return this.put(ssid.getID(), ssid);
    }
}

