/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdSet;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.FilterIf;
import com.cisco.nm.xms.cliparser.KeywordParamNode;
import com.cisco.xdm.commonutils.FilterFactory;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.commonutils.StringUtils;
import com.cisco.xdm.data.acl.ACL;
import com.cisco.xdm.data.acl.ACLCollection;
import com.cisco.xdm.data.acl.ExtendedACE;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.HostIdentity;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.IPAddressType;
import com.cisco.xdm.data.common.IfIdentity;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.IfIPAddress;
import com.cisco.xdm.data.interfaces.NHRPMapCollection;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class Tunnel
extends XDMInterface
implements Observer {
    public static final int UNKNOWN_TUNNEL = -1;
    public static final int GRE = 1;
    public static final int AURP = 2;
    public static final int CAYMAN = 3;
    public static final int DVMRP = 4;
    public static final int EON = 5;
    public static final int IPIP = 6;
    public static final int IPTALK = 7;
    public static final int IPV6IP = 8;
    public static final int NOS = 9;
    public static final int MPLS = 10;
    private static final int MIN_MODE = 1;
    private static final int MAX_MODE = 10;
    public static final int IP = 20;
    public static final int MULTIPOINT = 21;
    public static final String SHOW_INT = "show interfaces ";
    private IfIdentity _source;
    private HostIdentity _dest;
    private int _keepAliveTime = -1;
    private int _keepAliveRetries;
    private int _aclNumber;
    private int _mode;
    private int _submode;
    private boolean _autoMtuDiscovery = false;
    private boolean _ospfMtuIgnore;
    private String _profile = new String();
    private long _key = -1L;
    private NHRPMapCollection _nhrpmap_collection;
    private boolean _enableQOS;
    public static final int MIN_BW_BACKUP_TUNNEL = 1;
    public static final int MIN_BW_PRIMARY_TUNNEL = 25;

    public Tunnel(IfID ifID) {
        super(ifID);
        this.setSupport(0, 1);
        this.setSupport(2, 1);
        this.setSupport(3, 0);
        this.setSupport(1, 0);
        this.setSupport(4, 1);
        this.setSupport(5, 1);
        this.setSupport(6, 0);
        this.setSupport(19, 1);
        this.setSupport(18, 1);
        this.setSupport(21, 1);
        this._nhrpmap_collection = new NHRPMapCollection(this);
    }

    public Tunnel(IfID ifID, XDMObject parent) {
        this(ifID);
        this.setParent(parent);
    }

    public int calculateMode(String mode) {
        mode.trim();
        if (mode.equalsIgnoreCase("gre")) {
            return 1;
        }
        if (mode.equalsIgnoreCase("aurp")) {
            return 2;
        }
        if (mode.equalsIgnoreCase("cayman")) {
            return 3;
        }
        if (mode.equalsIgnoreCase("dvmrp")) {
            return 4;
        }
        if (mode.equalsIgnoreCase("eon")) {
            return 5;
        }
        if (mode.equalsIgnoreCase("ipip")) {
            return 6;
        }
        if (mode.equalsIgnoreCase("iptalk")) {
            return 7;
        }
        if (mode.equalsIgnoreCase("ipv6ip")) {
            return 8;
        }
        if (mode.equalsIgnoreCase("nos")) {
            return 9;
        }
        if (mode.equalsIgnoreCase("mpls")) {
            return 10;
        }
        return -1;
    }

    public int calculateSubMode(String submode) {
        submode.trim();
        if (submode.equalsIgnoreCase("ip")) {
            return 20;
        }
        if (submode.equalsIgnoreCase("multipoint")) {
            return 21;
        }
        return 0;
    }

    public boolean canSubIf() {
        return false;
    }

    private boolean checkIP() {
        IfIPAddress ipAddr = this.getIpAddr();
        if (ipAddr == null) {
            return false;
        }
        IPAddressType type = ipAddr.getIPAddressType();
        if (type == null) {
            return false;
        }
        if (type == IPAddressType.STATIC) {
            IPAddress addr = ipAddr.getIPAddress();
            Netmask mask = ipAddr.getNetmask();
            if (addr == null || mask == null) {
                return false;
            }
        } else if (type == IPAddressType.UNNUMBERED) {
            IfID intf = ipAddr.getIPUnnumberedIntf();
            if (intf == null) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public Object clone() {
        Tunnel newObj = (Tunnel)super.clone();
        if (this._dest != null) {
            newObj._dest = (HostIdentity)this._dest.clone();
        }
        newObj._nhrpmap_collection = (NHRPMapCollection)this._nhrpmap_collection.clone();
        newObj._nhrpmap_collection.setParent(newObj);
        return newObj;
    }

    public void disableQoSPreClassify() {
        this._enableQOS = false;
        this.setModified();
    }

    public void enableQoSPreClassify() {
        this._enableQOS = true;
        this.setModified();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Tunnel)) {
            return false;
        }
        if (super.equals(obj)) {
            Tunnel tunnel = (Tunnel)obj;
            if (this._enableQOS != tunnel._enableQOS) {
                return false;
            }
            if (this._source != null && tunnel._source != null ? !this._source.equals(tunnel._source) : this._source != null || tunnel._source != null) {
                return false;
            }
            if (this._dest != null && tunnel._dest != null ? !this._dest.equals(tunnel._dest) : this._dest != null || tunnel._dest != null) {
                return false;
            }
            if (this._mode != tunnel._mode) {
                return false;
            }
            if (this._submode != tunnel._submode) {
                return false;
            }
            if (this._keepAliveTime != tunnel._keepAliveTime || this._keepAliveRetries != tunnel._keepAliveRetries) {
                return false;
            }
            if (this._autoMtuDiscovery != tunnel._autoMtuDiscovery) {
                return false;
            }
            if (this._ospfMtuIgnore != tunnel._ospfMtuIgnore) {
                return false;
            }
            if (!this._nhrpmap_collection.equals(tunnel._nhrpmap_collection)) {
                return false;
            }
            return this._profile.equals(tunnel._profile) && this._key == tunnel._key;
        }
        return false;
    }

    private Vector generateCmds(int action) {
        CmdValues cdmval;
        CmdValues cdmval2;
        Vector<CmdValues> retval = new Vector<CmdValues>(11);
        if (this._enableQOS) {
            cdmval2 = new CmdValues("qos");
            cdmval2.addValue("pre-classify", "pre-classify");
            cdmval2.setAction(action);
            retval.addElement(cdmval2);
        }
        if (this._source != null) {
            String ifname = this._source.getIfName();
            if (ifname != null) {
                cdmval = new CmdValues("tunnel");
                cdmval.addValue("source", "source");
                cdmval.addValue("tunnelSrc", ifname);
                cdmval.setAction(action);
                retval.addElement(cdmval);
            } else if (this._source.getIpAddressAsString() != null) {
                cdmval = new CmdValues("tunnel");
                cdmval.addValue("source", "source");
                cdmval.addValue("tunnelSrcIp", this._source.getIpAddressAsString());
                cdmval.setAction(action);
                retval.addElement(cdmval);
            }
        }
        if (this._dest != null) {
            String hostname = this._dest.getHostName();
            if (hostname != null) {
                cdmval = new CmdValues("tunnel");
                cdmval.addValue("destination", "destination");
                cdmval.addValue("tunnelDestName", hostname);
                cdmval.setAction(action);
                retval.addElement(cdmval);
            } else if (this._dest.getIpAddressAsString() != null) {
                cdmval = new CmdValues("tunnel");
                cdmval.addValue("destination", "destination");
                cdmval.addValue("tunnelDestIP", this._dest.getIpAddressAsString());
                cdmval.setAction(action);
                retval.addElement(cdmval);
            }
        }
        if (this._mode >= 1 && this._mode <= 10) {
            cdmval2 = new CmdValues("tunnel");
            cdmval2.addValue("mode", "mode");
            cdmval2.addValue("tunnelMode", this.getModeString());
            if (this._submode == 20 || this._submode == 21) {
                cdmval2.addValue("tunnelSubMode", this.getSubModeString());
            }
            cdmval2.setAction(action);
            retval.addElement(cdmval2);
        }
        if (this._keepAliveTime >= 0) {
            cdmval2 = new CmdValues("keepalive");
            cdmval2.addValue("keepAliveTime", String.valueOf(this._keepAliveTime));
            if (this._keepAliveRetries > 0) {
                cdmval2.addValue("keepAliveRetries", String.valueOf(this._keepAliveRetries));
            }
            cdmval2.setAction(action);
            retval.addElement(cdmval2);
        }
        if (this._autoMtuDiscovery) {
            cdmval2 = new CmdValues("tunnel");
            cdmval2.addValue("path-mtu-discovery", "path-mtu-discovery");
            cdmval2.setAction(action);
            retval.addElement(cdmval2);
        }
        if (this._ospfMtuIgnore) {
            cdmval2 = new CmdValues("ip");
            cdmval2.addValue("ospf", "ospf");
            cdmval2.addValue("mtu-ignore", "mtu-ignore");
            cdmval2.setAction(action);
            retval.addElement(cdmval2);
        }
        if (this._profile != null && this._profile.trim().length() != 0) {
            cdmval2 = new CmdValues("tunnel");
            cdmval2.addValue("protection", "protection");
            cdmval2.addValue("ipsec", "ipsec");
            cdmval2.addValue("profile", "profile");
            cdmval2.addValue("ProfileName", this._profile);
            cdmval2.setAction(action);
            retval.addElement(cdmval2);
        }
        if (this._key >= 0L) {
            cdmval2 = new CmdValues("tunnel");
            cdmval2.addValue("key", "key");
            cdmval2.addValue("TunnelKey", String.valueOf(this._key));
            cdmval2.setAction(action);
            retval.addElement(cdmval2);
        }
        return retval;
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
        if (!this.isReadOnly() && this.isConfigurable() && this.isModified()) {
            ConfigValues subcfgval = cmdVal.getModeCmdsValues();
            if (subcfgval == null) {
                subcfgval = new ConfigValues();
                cmdVal.setModeCmdsValues(subcfgval);
            }
            if (backup == null) {
                this._nhrpmap_collection.generateDelta(null, subcfgval);
            } else {
                this._nhrpmap_collection.generateDelta(((Tunnel)backup)._nhrpmap_collection, subcfgval);
            }
            Vector tunnelCmds = this.generateTunnelCmds((Tunnel)backup);
            if (tunnelCmds.size() > 0) {
                int i = 0;
                while (i < tunnelCmds.size()) {
                    subcfgval.addCmdValues((CmdValues)tunnelCmds.elementAt(i));
                    ++i;
                }
            }
        }
    }

    private Vector generateModifyCmds(Tunnel backup) {
        CmdValues cdmval;
        CmdValues cdmval2;
        String ifname;
        CmdValues cdmval3;
        Vector<CmdValues> retval = new Vector<CmdValues>(9);
        if (this._enableQOS && !backup._enableQOS) {
            cdmval3 = new CmdValues("qos");
            cdmval3.addValue("pre-classify", "pre-classify");
            cdmval3.setAction(1);
            retval.addElement(cdmval3);
        } else if (!this._enableQOS && backup._enableQOS) {
            cdmval3 = new CmdValues("qos");
            cdmval3.addValue("pre-classify", "pre-classify");
            cdmval3.setAction(2);
            retval.addElement(cdmval3);
        }
        if (this._source != null) {
            if (backup._source == null || backup._source != null && !this._source.equals(backup._source)) {
                ifname = this._source.getIfName();
                if (ifname != null) {
                    cdmval2 = new CmdValues("tunnel");
                    cdmval2.addValue("source", "source");
                    cdmval2.addValue("tunnelSrc", ifname);
                    cdmval2.setAction(1);
                    retval.addElement(cdmval2);
                } else if (this._source.getIpAddressAsString() != null) {
                    cdmval2 = new CmdValues("tunnel");
                    cdmval2.addValue("source", "source");
                    cdmval2.addValue("tunnelSrcIp", this._source.getIpAddressAsString());
                    cdmval2.setAction(1);
                    retval.addElement(cdmval2);
                }
            }
        } else if (backup._source != null) {
            ifname = backup._source.getIfName();
            if (ifname != null) {
                cdmval2 = new CmdValues("tunnel");
                cdmval2.addValue("source", "source");
                cdmval2.addValue("tunnelSrc", ifname);
                cdmval2.setAction(2);
                retval.addElement(cdmval2);
            } else if (backup._source.getIpAddressAsString() != null) {
                cdmval2 = new CmdValues("tunnel");
                cdmval2.addValue("source", "source");
                cdmval2.addValue("tunnelSrcIp", backup._source.getIpAddressAsString());
                cdmval2.setAction(2);
                retval.addElement(cdmval2);
            }
        }
        boolean bgenMode = false;
        boolean bgenDestination = false;
        if (this._mode == 1) {
            if (this._submode != backup._submode && this._submode == 21) {
                cdmval = new CmdValues("tunnel");
                cdmval.addValue("destination", "destination");
                cdmval.setAction(2);
                retval.addElement(cdmval);
                bgenDestination = true;
                this._dest = null;
            }
            if (this._dest != null && !this._dest.equals(backup._dest)) {
                cdmval = new CmdValues("tunnel");
                cdmval.addValue("mode", "mode");
                cdmval.setAction(2);
                retval.addElement(cdmval);
                bgenMode = true;
                this._submode = 20;
            }
        }
        if (!bgenDestination) {
            if (this._dest != null) {
                if (backup._dest == null || !this._dest.equals(backup._dest)) {
                    cdmval = new CmdValues("tunnel");
                    cdmval.addValue("destination", "destination");
                    String hostname = this._dest.getHostName();
                    if (hostname != null) {
                        cdmval.addValue("tunnelDestName", hostname);
                    } else if (this._dest.getIpAddressAsString() != null) {
                        cdmval.addValue("tunnelDestIP", this._dest.getIpAddressAsString());
                    }
                    cdmval.setAction(1);
                    retval.addElement(cdmval);
                }
            } else if (backup._dest != null) {
                cdmval = new CmdValues("tunnel");
                cdmval.addValue("destination", "destination");
                String hostname = backup._dest.getHostName();
                if (hostname != null) {
                    cdmval.addValue("tunnelDestName", hostname);
                } else if (backup._dest.getIpAddressAsString() != null) {
                    cdmval.addValue("tunnelDestIP", backup._dest.getIpAddressAsString());
                }
                cdmval.setAction(2);
                retval.addElement(cdmval);
            }
        }
        if (!(bgenMode || this._mode == backup._mode && this._submode == backup._submode)) {
            if (this._mode >= 1 && this._mode <= 10) {
                if (backup._mode >= 1 && backup._mode <= 10 || this._mode != backup._mode) {
                    cdmval = new CmdValues("tunnel");
                    cdmval.addValue("mode", "mode");
                    cdmval.addValue("tunnelMode", this.getModeString());
                    if (this._submode == 20 || this._submode == 21) {
                        cdmval.addValue("tunnelSubMode", this.getSubModeString());
                    }
                    cdmval.setAction(1);
                    retval.addElement(cdmval);
                }
            } else if (backup._mode >= 1 && backup._mode <= 10) {
                cdmval = new CmdValues("tunnel");
                cdmval.addValue("mode", "mode");
                cdmval.addValue("tunnelMode", backup.getModeString());
                if (backup._submode == 20 || backup._submode == 21) {
                    cdmval.addValue("tunnelSubMode", backup.getSubModeString());
                }
                cdmval.setAction(2);
                retval.addElement(cdmval);
            }
        }
        if (this._keepAliveTime != -1) {
            if (this._keepAliveTime != backup._keepAliveTime) {
                cdmval = new CmdValues("keepalive");
                cdmval.addValue("keepAliveTime", String.valueOf(this._keepAliveTime));
                if (this._keepAliveRetries > 0) {
                    cdmval.addValue("keepAliveRetries", String.valueOf(this._keepAliveRetries));
                }
                cdmval.setAction(1);
                retval.addElement(cdmval);
            }
        } else if (backup._keepAliveTime != -1) {
            cdmval = new CmdValues("keepalive");
            cdmval.addValue("keepAliveTime", String.valueOf(backup._keepAliveTime));
            if (backup._keepAliveRetries > 0) {
                cdmval.addValue("keepAliveRetries", String.valueOf(backup._keepAliveRetries));
            }
            cdmval.setAction(2);
            retval.addElement(cdmval);
        }
        if (this._autoMtuDiscovery != backup._autoMtuDiscovery) {
            cdmval = new CmdValues("tunnel");
            cdmval.addValue("path-mtu-discovery", "path-mtu-discovery");
            if (this._autoMtuDiscovery) {
                cdmval.setAction(1);
            } else {
                cdmval.setAction(2);
            }
            retval.addElement(cdmval);
        }
        if (this._ospfMtuIgnore != backup._ospfMtuIgnore) {
            cdmval = new CmdValues("ip");
            cdmval.addValue("ospf", "ospf");
            cdmval.addValue("mtu-ignore", "mtu-ignore");
            if (this._ospfMtuIgnore) {
                cdmval.setAction(1);
            } else {
                cdmval.setAction(2);
            }
            retval.addElement(cdmval);
        }
        if (!this._profile.equals(backup._profile)) {
            cdmval = new CmdValues("tunnel");
            cdmval.addValue("protection", "protection");
            cdmval.addValue("ipsec", "ipsec");
            cdmval.addValue("profile", "profile");
            cdmval.addValue("ProfileName", this._profile);
            if (this._profile.trim().length() == 0) {
                cdmval.setAction(2);
            } else {
                cdmval.setAction(1);
            }
            retval.addElement(cdmval);
        }
        if (this._key != backup._key) {
            cdmval = new CmdValues("tunnel");
            cdmval.addValue("key", "key");
            cdmval.addValue("TunnelKey", String.valueOf(this._key));
            if (this._key < 0L) {
                cdmval.setAction(2);
            } else {
                cdmval.setAction(1);
            }
            retval.addElement(cdmval);
        }
        return retval;
    }

    public Vector generateTunnelCmds(Tunnel backup) {
        if (backup == null) {
            return this.generateCmds(1);
        }
        return this.generateModifyCmds(backup);
    }

    public boolean getAutoMtuDiscovery() {
        return this._autoMtuDiscovery;
    }

    private ExtendedACE getCryptoGREAce() {
        if (!this.isConfigurable() || this._source == null || this._dest == null) {
            return null;
        }
        String aclSourceIp = this.getSourceAsIPAddressStr();
        if (aclSourceIp == null) {
            return null;
        }
        String aclDestIp = this._dest.isHostName() ? this._dest.getHostName() : this._dest.getIpAddressAsString();
        if (aclDestIp == null) {
            return null;
        }
        ExtendedACE ace1 = new ExtendedACE();
        ace1.setGrant(true);
        ace1.setProtocol("gre");
        ace1.setSourceHost(aclSourceIp);
        ace1.setDestHost(aclDestIp);
        return ace1;
    }

    public ExtendedACE getDefaultGREAce() {
        if (!this.isConfigurable() || this._source == null || this._dest == null) {
            return null;
        }
        String aclSourceIp = this.getSourceAsIPAddressStr();
        if (aclSourceIp == null) {
            return null;
        }
        String aclDestIp = this._dest.isHostName() ? this._dest.getHostName() : this._dest.getIpAddressAsString();
        if (aclDestIp == null) {
            return null;
        }
        ExtendedACE ace1 = new ExtendedACE();
        ace1.setGrant(true);
        ace1.setProtocol("gre");
        ace1.setSourceHost(aclDestIp);
        ace1.setDestHost(aclSourceIp);
        return ace1;
    }

    public ACL getDefaultGREAcl() {
        ExtendedACE ace1 = this.getCryptoGREAce();
        if (ace1 == null) {
            return null;
        }
        DeviceBase device = (DeviceBase)this.getDevice();
        ACLCollection aclCollection = device.getAcls();
        this._aclNumber = aclCollection.getNextAvalableExtendedACLNumber();
        ACL greACL = new ACL(1);
        greACL.setNameOrNumber(Integer.toString(this._aclNumber));
        greACL.addToCategory(3);
        greACL.addACE(ace1, 0);
        return greACL;
    }

    public static int getDefaultKeepAliveRetries(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("interface", "keepAliveRetries", true);
        return Integer.parseInt(param.getDefaultValue());
    }

    public static int getDefaultKeepAliveTime(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("interface", "keepAliveTime", true);
        return Integer.parseInt(param.getDefaultValue());
    }

    private static int getDefaultMtuByIOS(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("interface", "SIZE", true);
        return Integer.parseInt(param.getDefaultValue());
    }

    public HostIdentity getDest() {
        return this._dest;
    }

    public int getKeepAliveRetries() {
        return this._keepAliveRetries;
    }

    public int getKeepAliveTime() {
        return this._keepAliveTime;
    }

    public long getKey() {
        return this._key;
    }

    public static long getMaxKeepAliveRetries(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("interface", "keepAliveRetries", true);
        return param.getMaxRange();
    }

    public static long getMaxKeepAliveTime(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("interface", "keepAliveTime", true);
        return param.getMaxRange();
    }

    public static long getMinKeepAliveRetries(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("interface", "keepAliveRetries", true);
        return param.getMinRange();
    }

    public static long getMinKeepAliveTime(DeviceBase dev) {
        CmdSet cmdset = dev.getDevInfoBase().getParser().getCmdSet();
        KeywordParamNode param = cmdset.getParamNode("interface", "keepAliveTime", true);
        return param.getMinRange();
    }

    public int getMode() {
        if (this._mode == 0) {
            return 1;
        }
        return this._mode;
    }

    public String getModeString() {
        switch (this._mode) {
            case 0: {
                return "gre";
            }
            case 1: {
                return "gre";
            }
            case 2: {
                return "aurp";
            }
            case 3: {
                return "cayman";
            }
            case 4: {
                return "dvmrp";
            }
            case 5: {
                return "eon";
            }
            case 6: {
                return "ipip";
            }
            case 7: {
                return "iptalk";
            }
            case 8: {
                return "ipv6ip";
            }
            case 9: {
                return "nos";
            }
            case 10: {
                return "mpls";
            }
            case -1: {
                return "unknown";
            }
        }
        return null;
    }

    public NHRPMapCollection getNHRPMap() {
        return this._nhrpmap_collection;
    }

    public boolean getOspfMtuIgnore() {
        return this._ospfMtuIgnore;
    }

    public String getProfile() {
        return this._profile;
    }

    public IfIdentity getSource() {
        return this._source;
    }

    public String getSourceAsIPAddressStr() {
        if (this._source == null) {
            return null;
        }
        DeviceBase device = (DeviceBase)this.getDevice();
        String sourceIp = null;
        if (this._source.isIfName()) {
            XDMInterfaces intfs = device.getIfs();
            if (intfs != null) {
                IfID ifid = this._source.getIf();
                if (ifid == null) {
                    return null;
                }
                String ifname = ifid.toString();
                XDMInterfaceBase intf = intfs.getIfFromCompositeLabel(ifname);
                if (intf != null) {
                    IfIPAddress ipaddr = intf.getIpAddr();
                    if (ipaddr != null) {
                        XDMInterfaceBase unnumberedintf;
                        IfIPAddress unnumberedipaddr;
                        if (ipaddr.getIPAddressType() == IPAddressType.STATIC) {
                            sourceIp = ipaddr.getIPAddress().toString();
                        } else if (ipaddr.getIPAddressType() == IPAddressType.UNNUMBERED && (unnumberedipaddr = (unnumberedintf = (XDMInterfaceBase)device.getIfs().get(ipaddr.getIPUnnumberedIntf())).getIpAddr()) != null && unnumberedipaddr.getIPAddressType() == IPAddressType.STATIC) {
                            sourceIp = unnumberedipaddr.getIPAddress().toString();
                        }
                    }
                } else {
                    Log.getLog().debug("Tunnel: getSourceAsIPAddressStr: Cannot get " + this._source.getIf().toString() + " from device Interface Collection ");
                }
            } else {
                Log.getLog().debug("Tunnel: getSourceAsIPAddressStr: Cannot get Interface Collection from device");
            }
        } else {
            sourceIp = this._source.getIpAddressAsString();
        }
        return sourceIp;
    }

    public IPAddressType getSourceIPAddressType() {
        if (this._source == null) {
            return null;
        }
        DeviceBase device = (DeviceBase)this.getDevice();
        XDMInterfaces intfs = device.getIfs();
        if (this._source.isIfName()) {
            if (intfs != null) {
                IfIPAddress ipaddr;
                IfID ifid = this._source.getIf();
                if (ifid == null) {
                    return null;
                }
                String ifname = ifid.toString();
                XDMInterfaceBase intf = intfs.getIfFromCompositeLabel(ifname);
                if (intf != null && (ipaddr = intf.getIpAddr()) != null) {
                    return ipaddr.getIPAddressType();
                }
            } else {
                Log.getLog().debug("Tunnel: getSourceIPAddressType: Cannot get Interface Collection from device");
            }
        } else {
            IPAddress srcIPAddr = this._source.getIpAddress();
            XDMInterfaceBase intf = null;
            IfIPAddress ipaddr = null;
            if (srcIPAddr != null) {
                intf = intfs.getIfByIP(srcIPAddr);
            }
            if (intf != null) {
                ipaddr = intf.getIpAddr();
            }
            if (ipaddr != null) {
                return ipaddr.getIPAddressType();
            }
        }
        return null;
    }

    public int getSubMode() {
        return this._submode;
    }

    public String getSubModeString() {
        switch (this._submode) {
            case 20: {
                return "ip";
            }
            case 21: {
                return "multipoint";
            }
        }
        return null;
    }

    public static int[] getTunnelBandwidthValues(DeviceBase device, Tunnel tunnelIf) {
        String tunnelSrcIfStr = null;
        int[] tunnelBWVals = new int[]{25, 1};
        IfIdentity tunnelSrcIf = tunnelIf.getSource();
        if (tunnelSrcIf.isIfName()) {
            tunnelSrcIfStr = tunnelSrcIf.getIfName();
        } else {
            XDMInterfaces ifs = device.getIfs();
            XDMInterfaceBase ifBase = ifs.getIfByIP(tunnelSrcIf.getIpAddress());
            if (ifBase != null) {
                Log.getLog().debug("TUNNEL:...Tunnel Source IP Address's Interface is " + ifBase.getIfID().toString());
                tunnelSrcIfStr = ifBase.getIfID().toString();
            }
        }
        IOSCmdService cmdService = device.getDevInfoBase().getComm();
        String[] cmds = new String[]{SHOW_INT + tunnelSrcIfStr};
        String bwStr = null;
        try {
            IOSCmdResponse[] res = cmdService.exec(cmds);
            String output = res[0].getOutput();
            bwStr = StringUtils.getImmediateNextWord(output, "BW");
            Log.getLog().debug("Tunnel:...bwVal is " + bwStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int bwVal = Integer.parseInt(bwStr);
        if (bwVal > 25) {
            tunnelBWVals[0] = bwVal / 2 + 12;
            tunnelBWVals[1] = bwVal / 2 - 12;
        }
        return tunnelBWVals;
    }

    public boolean isConfigured() {
        return !(this._mode != 0 && this._mode != 1 || this._source == null || this._dest == null && this._submode != 21) && this.checkIP();
    }

    public boolean isDMVPNTunnel() {
        if (this.getMode() != 1) {
            return false;
        }
        IfIPAddress tunIfIPAddr = this.getIpAddr();
        if (tunIfIPAddr == null) {
            return false;
        }
        IPAddressType tunIPAddrType = tunIfIPAddr.getIPAddressType();
        if (tunIPAddrType != IPAddressType.STATIC && tunIPAddrType != IPAddressType.DYNAMIC && tunIPAddrType != IPAddressType.NEGOTIATED) {
            return false;
        }
        if (this.getSource() == null) {
            return false;
        }
        if (this.getDest() == null && this.getSubMode() != 21) {
            return false;
        }
        if (!(this.getProfile() != null && this.getProfile().length() != 0 || this.getCryptoMap() != null && this.getCryptoMap().length() != 0)) {
            return false;
        }
        if (this.getKey() == -1L) {
            return false;
        }
        if (this.getNHRPAuth() == null || this.getNHRPAuth().length() == 0) {
            return false;
        }
        if (this.getNHRPID() == -1L) {
            return false;
        }
        String tunCryptoMap = this.getCryptoMap();
        String srcCryptoMap = "";
        XDMInterfaceBase srcIntf = null;
        XDMInterfaces ifs = ((DeviceBase)this.getDevice()).getIfs();
        IfIdentity srcIntfIdent = this.getSource();
        String srcIfName = null;
        if (srcIntfIdent != null) {
            srcIfName = srcIntfIdent.getIfName();
        }
        if (srcIfName != null && srcIfName.length() != 0) {
            srcIntf = ifs.getIfFromString(srcIfName);
        }
        if (srcIntf != null) {
            srcCryptoMap = srcIntf.getCryptoMap();
        }
        return srcCryptoMap == null || tunCryptoMap == null || tunCryptoMap.length() == 0 || srcCryptoMap.length() == 0 || !srcCryptoMap.equals(tunCryptoMap);
    }

    public boolean isQoSPreClassified() {
        return this._enableQOS;
    }

    /*
     * Unable to fully structure code
     */
    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        block23: {
            super.populate(config, cmdVal);
            if (cmdVal == null || (subCmds = cmdVal.getModeCmdsValues()) == null) break block23;
            this.populateNHRPSubcommands(subCmds, null);
            i = 0;
            while (i < subCmds.numCmds()) {
                cmd = subCmds.getCmdValues(i);
                cmdName = cmd.getCmdName();
                if (!cmdName.equals("tunnel")) ** GOTO lbl-1000
                if (!cmd.containsKey("source")) ** GOTO lbl-1000
                if (cmd.containsKey("tunnelSrc")) {
                    tmp = cmd.getValue("tunnelSrc");
                    dev = (DeviceBase)this.getDevice();
                    ifId = IfID.fromString(tmp, dev.getDevInfoBase().getHWConfig());
                    this._source = new IfIdentity(ifId);
                } else if (cmd.containsKey("tunnelSrcIp")) {
                    tmp = cmd.getValue("tunnelSrcIp");
                    this._source = new IfIdentity(new IPAddress(tmp));
                } else if (cmd.containsKey("destination") && cmd.containsKey("tunnelDestName")) {
                    tmp = cmd.getValue("tunnelDestName");
                    this._dest = new HostIdentity(tmp);
                } else if (cmd.containsKey("tunnelDestIP")) {
                    tmp = cmd.getValue("tunnelDestIP");
                    this._dest = new HostIdentity(new IPAddress(tmp));
                } else if (cmd.containsKey("mode") && cmd.containsKey("tunnelMode")) {
                    this._mode = this.calculateMode(cmd.getValue("tunnelMode"));
                    if (this._mode == 1) {
                        this._submode = cmd.containsKey("tunnelSubMode") ? this.calculateSubMode(cmd.getValue("tunnelSubMode")) : 20;
                    }
                } else {
                    if (cmd.containsKey("protection") && cmd.containsKey("ProfileName")) {
                        this._profile = cmd.getValue("ProfileName");
                    }
                    if (cmd.containsKey("key") && cmd.containsKey("TunnelKey")) {
                        this._key = Long.parseLong(cmd.getValue("TunnelKey"));
                    }
                    if (cmd.containsKey("path-mtu-discovery")) {
                        this._autoMtuDiscovery = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (cmdName.equals("keepalive")) {
                            if (cmd.containsKey("keepAliveTime")) {
                                this._keepAliveTime = Integer.parseInt(cmd.getValue("keepAliveTime"));
                            }
                            if (cmd.containsKey("keepAliveRetries")) {
                                this._keepAliveRetries = Integer.parseInt(cmd.getValue("keepAliveRetries"));
                            }
                        }
                        if (cmdName.equals("ip") && cmd.containsKey("ospf") && cmd.containsKey("mtu-ignore")) {
                            this._ospfMtuIgnore = true;
                        }
                        if (cmdName.equals("qos") && cmd.containsKey("pre-classify")) {
                            this._enableQOS = true;
                        }
                    }
                }
                ++i;
            }
            if (this._mode != 0 && this._mode != 1) {
                this.setConfigurable(false);
            }
            if (this.getMtu() == -1) {
                this.setMtu(Tunnel.getDefaultMtuByIOS((DeviceBase)this.getDevice()));
            }
        }
    }

    public void populateNHRPSubcommands(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        String[] keywords = new String[]{"nhrp", "map"};
        FilterIf filter = FilterFactory.getKeywordFilter("ip", keywords);
        ConfigValues nhrpcfg = config.getCmds(filter);
        if (nhrpcfg != null) {
            this._nhrpmap_collection.populate(config, null);
        }
    }

    public void print() {
        if (this._source != null) {
            Log.getLog().debug("Source: ");
            this._source.print();
        }
        if (this._dest != null) {
            Log.getLog().debug("Dest: ");
            this._dest.print();
        }
        if (this._mode >= 1 && this._mode <= 10) {
            Log.getLog().debug("Mode is " + this.getModeString());
        }
        if (this._submode == 20 || this._submode == 21) {
            Log.getLog().debug("subMode is " + this.getSubModeString());
        }
        if (this._keepAliveTime >= 0) {
            Log.getLog().debug("keepalive time is " + this._keepAliveTime);
        }
        if (this._keepAliveRetries > 0) {
            Log.getLog().debug("keepalive retries is " + this._keepAliveRetries);
        }
        if (this._autoMtuDiscovery) {
            Log.getLog().debug("Tunnel auto MTU discovery is enabled");
        }
        if (this._ospfMtuIgnore) {
            Log.getLog().debug("Tunnel ip ospf mtu-ignore is enabled");
        }
    }

    public void setAutoMtuDiscovery(boolean autoMTUFlag) {
        this._autoMtuDiscovery = autoMTUFlag;
        this.setModified();
    }

    public void setDest(HostIdentity dest) {
        this._dest = dest;
        this.setModified();
    }

    public void setKeepAliveRetries(int count) {
        this._keepAliveRetries = count;
        this.setModified();
    }

    public void setKeepAliveTime(int seconds) {
        this._keepAliveTime = seconds;
        this.setModified();
    }

    public void setKey(long key) {
        this._key = key;
        this.setModified();
    }

    public boolean setMode(int mode) {
        if (mode != 1) {
            return false;
        }
        this._mode = mode;
        this.setModified();
        return true;
    }

    public void setModeGreIp() {
        this._mode = 1;
        this._submode = 20;
        this.setModified();
    }

    public void setOspfMtuIgnore(boolean flag) {
        this._ospfMtuIgnore = flag;
        this.setModified();
    }

    public void setProfile(String profile) {
        this._profile = profile;
        this.setModified();
    }

    public void setSource(IfIdentity src) {
        this._source = src;
        this.setModified();
    }

    public boolean setSubMode(int submode) {
        if (this._mode != 1) {
            return false;
        }
        if (submode == 20 || submode == 21) {
            this._submode = submode;
            this.setModified();
            return true;
        }
        return false;
    }

    public void update(Observable o, Object a) {
    }

    public static boolean validateKeepAliveRetries(int keepaliveretry, DeviceBase dev) {
        return (long)keepaliveretry >= Tunnel.getMinKeepAliveRetries(dev) && (long)keepaliveretry <= Tunnel.getMaxKeepAliveRetries(dev);
    }

    public static boolean validateKeepAliveTime(int keepalivetime, DeviceBase dev) {
        return (long)keepalivetime >= Tunnel.getMinKeepAliveTime(dev) && (long)keepalivetime <= Tunnel.getMaxKeepAliveTime(dev);
    }
}

