/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DevInfoBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.Description;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.IfIPAddress;
import com.cisco.xdm.data.interfaces.XDMInterface;
import java.util.Vector;

public class VLANIf
extends XDMInterface {
    public static final String SDM_ETH_LAUNCHSW = "$ETH-SW-LAUNCH$";
    public static final String SDM_INTF_INFO = "$INTF-INFO-";
    public static final int ETH_LAUNCHSW = 1;
    private int _vlanID = 1;

    public VLANIf(int vlanId) {
        this(new IfID(1007, -1, -1, vlanId, -1, 0));
    }

    public VLANIf(IfID ifID) {
        super(ifID);
        this._vlanID = ifID.getPort();
        this.setSupport(0, 1);
        this.setSupport(2, 1);
        this.setSupport(3, 1);
        this.setSupport(1, 1);
        this.setSupport(4, 1);
        this.setSupport(5, 1);
        this.setSupport(6, 1);
        this.setSupport(19, 1);
        this.setSupport(18, 1);
        this.setSupport(21, 1);
    }

    public boolean canSubIf() {
        return false;
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
    }

    protected Vector getFlags() {
        Vector flags = super.getFlags();
        flags.addElement(SDM_ETH_LAUNCHSW);
        flags.addElement(SDM_INTF_INFO);
        return flags;
    }

    public String getIntfInfo() {
        String info = Description.getFlagContent(this.getDesc(), SDM_INTF_INFO);
        if (info != null && info.length() > 0) {
            return info.substring(SDM_INTF_INFO.length(), info.length() - 1);
        }
        return "";
    }

    public boolean getSW() {
        return Description.isFlagExist(this.getDesc(), SDM_ETH_LAUNCHSW);
    }

    public int getVlanID() {
        return this._vlanID;
    }

    public boolean isConfigured() {
        IfIPAddress ipAddr = this.getIpAddr();
        return ipAddr != null || this.getBridgeGroup() > 0;
    }

    public static boolean isRestrictedRange(int vlan, DevInfoBase dev) {
        String platform = dev.getModel();
        String iosImage = dev.getImageName();
        Log.getLog().debug("platform,ios:" + platform + "," + iosImage);
        if (platform.startsWith("85")) {
            return true;
        }
        return platform.startsWith("87") && iosImage.toLowerCase().indexOf("advsecurity") != -1;
    }

    public static boolean isValidVlanRange(int vlan, DevInfoBase dev) {
        boolean bUnrestricted = dev == null ? true : VLANIf.isRestrictedRange(vlan, dev) ^ true;
        return bUnrestricted && vlan >= 1 && vlan <= 1005;
    }
}

