/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.atm.Pvc;
import com.cisco.xdm.data.atm.PvcCollection;
import com.cisco.xdm.data.base.CmdPositionHandler;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.IPAddressType;
import com.cisco.xdm.data.common.IfIdentity;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.discovery.HWDictionary;
import com.cisco.xdm.data.discovery.IfType;
import com.cisco.xdm.data.discovery.XDMDiscovery;
import com.cisco.xdm.data.interfaces.Async;
import com.cisco.xdm.data.interfaces.Atm;
import com.cisco.xdm.data.interfaces.AtmSubInterface;
import com.cisco.xdm.data.interfaces.BRI;
import com.cisco.xdm.data.interfaces.BVI;
import com.cisco.xdm.data.interfaces.Dialer;
import com.cisco.xdm.data.interfaces.Dot11Radio;
import com.cisco.xdm.data.interfaces.Ethernet;
import com.cisco.xdm.data.interfaces.EthernetSubInterface;
import com.cisco.xdm.data.interfaces.EthernetSwitchPort;
import com.cisco.xdm.data.interfaces.FastEthernetSwitchPort;
import com.cisco.xdm.data.interfaces.GigEthernetSwitchPort;
import com.cisco.xdm.data.interfaces.IDSSensor;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.IfIPAddress;
import com.cisco.xdm.data.interfaces.Loopback;
import com.cisco.xdm.data.interfaces.Null;
import com.cisco.xdm.data.interfaces.SubDot11Radio;
import com.cisco.xdm.data.interfaces.SwitchDMInterface;
import com.cisco.xdm.data.interfaces.Tunnel;
import com.cisco.xdm.data.interfaces.VLANIf;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMSubInterface;
import com.cisco.xdm.data.interfaces.XDMSubInterfaces;
import com.cisco.xdm.data.interfaces.XDMUnsupportedIf;
import com.cisco.xdm.data.routing.StaticRouteVector;
import com.cisco.xdm.data.serial.SerialInterface;
import com.cisco.xdm.data.serial.SerialSubInterface;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class XDMInterfaces
extends XDMHashCollection
implements CmdPositionHandler {
    private Hashtable _idb = null;
    private Hashtable _deleteds = null;
    private Vector _sortedIfsBeforeModification = null;
    public static final int IF_STAT_NO_ON_DEVICE = 0;
    public static final int IF_STAT_ON_DEVICE_SHUTDOWN = 1;
    public static final int IF_STAT_ON_DEVICE_NO_SHUTDONW = 2;

    public XDMInterfaces(XDMObject parent) {
        super(parent);
    }

    private void AssignFeatureSupportedFlagsFromDict(XDMInterfaceBase newIf) {
        Hashtable attrs;
        HWDictionary dict = HWDictionary.GetInstance();
        IfType iftype = dict.getif(newIf.getIfID().getType());
        if (iftype != null && (attrs = iftype.getAttrs()) != null) {
            this.setAttrFlagFromDict(newIf, 0, attrs, "acl");
            this.setAttrFlagFromDict(newIf, 1, attrs, "nat");
            this.setAttrFlagFromDict(newIf, 4, attrs, "cbac");
            this.setAttrFlagFromDict(newIf, 2, attrs, "crypto");
            this.setAttrFlagFromDict(newIf, 3, attrs, "ezvpn");
            this.setAttrFlagFromDict(newIf, 5, attrs, "cdp");
            this.setAttrFlagFromDict(newIf, 6, attrs, "mop");
            this.setAttrFlagFromDict(newIf, 18, attrs, "ips");
            this.setAttrFlagFromDict(newIf, 19, attrs, "qos");
        }
    }

    private void addResetList(ConfigValues cv, ConfigValues noshuts, XDMInterfaceBase item) {
        CmdValues cmd1 = item.generateInterfaceCmd();
        ConfigValues subcfg1 = new ConfigValues();
        CmdValues subcmd1 = new CmdValues("shutdown");
        subcfg1.addCmdValues(subcmd1);
        cmd1.setModeCmdsValues(subcfg1);
        cv.addCmdValues(cmd1);
        CmdValues cmd2 = item.generateInterfaceCmd();
        ConfigValues subcfg2 = new ConfigValues();
        CmdValues subcmd2 = new CmdValues("shutdown");
        subcmd2.setAction(2);
        subcfg2.addCmdValues(subcmd2);
        cmd2.setModeCmdsValues(subcfg2);
        noshuts.addCmdValues(cmd2);
    }

    private XDMInterfaceBase createIfFromCmd(CmdValues cmd) {
        XDMInterfaceBase newIf;
        DeviceBase dev;
        IfID ifID;
        if (cmd == null) {
            return null;
        }
        String str = cmd.getValue("ifname");
        if (str == null || str.length() == 0) {
            String ifstr = cmd.getValue("strIfName");
            if (ifstr == null || ifstr.length() == 0) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(ifstr);
            str = st.nextToken();
        }
        if ((ifID = IfID.fromString(str, (dev = (DeviceBase)this.getDevice()).getDevInfoBase().getHWConfig())).isSubInterface()) {
            switch (ifID.getType()) {
                case 501: 
                case 502: 
                case 507: {
                    newIf = new SerialSubInterface(ifID, null);
                    break;
                }
                case 503: 
                case 504: 
                case 532: 
                case 1008: {
                    newIf = new AtmSubInterface(ifID, null);
                    break;
                }
                case 7: {
                    newIf = new SubDot11Radio(ifID, null);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    newIf = new EthernetSubInterface(ifID, null);
                    break;
                }
                default: {
                    newIf = new XDMSubInterface(ifID, null);
                    break;
                }
            }
        } else {
            switch (ifID.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    newIf = new Ethernet(ifID);
                    break;
                }
                case 5: {
                    int key1 = EthernetSwitchPort.pack(ifID.getSlot(), ifID.getModuleSlot());
                    dev.addSwitchModule(key1);
                    String model = dev.getDevInfoBase().getModel();
                    if (model.startsWith("c83") && !this.isRealSwitchPort(ifID)) {
                        newIf = new XDMUnsupportedIf(ifID);
                        dev.setSwitchPort(key1, false);
                        break;
                    }
                    newIf = new FastEthernetSwitchPort(ifID);
                    dev.setSwitchPort(key1, true);
                    break;
                }
                case 8: {
                    newIf = new SwitchDMInterface(ifID);
                    break;
                }
                case 6: {
                    newIf = new GigEthernetSwitchPort(ifID);
                    int key2 = EthernetSwitchPort.pack(ifID.getSlot(), ifID.getModuleSlot());
                    dev.addSwitchModule(key2);
                    dev.setSwitchPort(key2, true);
                    break;
                }
                case 1001: {
                    newIf = new Dialer(ifID);
                    break;
                }
                case 503: 
                case 504: 
                case 532: 
                case 1008: {
                    newIf = new Atm(ifID);
                    break;
                }
                case 1002: {
                    newIf = new Tunnel(ifID);
                    break;
                }
                case 501: 
                case 502: 
                case 507: {
                    newIf = new SerialInterface(ifID);
                    break;
                }
                case 1003: {
                    newIf = new Loopback(ifID);
                    break;
                }
                case 1010: {
                    newIf = new BVI(ifID);
                    break;
                }
                case 1007: {
                    newIf = new VLANIf(ifID);
                    break;
                }
                case 505: {
                    newIf = new BRI(ifID);
                    break;
                }
                case 1009: {
                    newIf = new Async(ifID);
                    break;
                }
                case 1006: {
                    newIf = new Null(ifID);
                    break;
                }
                case 533: {
                    newIf = new IDSSensor(ifID);
                    break;
                }
                case 7: {
                    newIf = new Dot11Radio(ifID);
                    break;
                }
                default: {
                    newIf = new XDMUnsupportedIf(ifID);
                    break;
                }
            }
        }
        this.AssignFeatureSupportedFlagsFromDict(newIf);
        Log log = Log.getLog();
        log.debug("Created interface object: " + newIf.getClass().toString() + " from " + ifID.toString());
        return newIf;
    }

    public XDMInterface createNextLogicIf(int type) {
        IfID ifID = null;
        int i = 0;
        if (type == 1010) {
            ++i;
        }
        while (true) {
            ifID = new IfID(type, -1, -1, i, -1, 0);
            if ((!this.isModified() || this.get(ifID) == null) && !this.getIDB().containsKey(ifID.toString())) break;
            ++i;
        }
        XDMInterface newIf = null;
        switch (type) {
            case 1001: {
                newIf = new Dialer(ifID);
                break;
            }
            case 1002: {
                newIf = new Tunnel(ifID);
                break;
            }
            case 1003: {
                newIf = new Loopback(ifID);
                break;
            }
            case 1010: {
                newIf = new BVI(ifID);
                break;
            }
            default: {
                newIf = null;
            }
        }
        if (newIf != null) {
            newIf.setParent(this);
        }
        return newIf;
    }

    Hashtable getDeleteds() {
        block2: {
            if (this._deleteds != null) break block2;
            DeviceBase dev = (DeviceBase)this.getDevice();
            try {
                this._deleteds = XDMDiscovery.getDeletedSubif(dev.getDevInfoBase().getComm());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this._deleteds;
    }

    public Vector getExistingIfTypes() {
        Vector<Integer> types = new Vector<Integer>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface item = (XDMInterface)e.nextElement();
            int type = item.getIfID().getType();
            boolean newType = true;
            int i = 0;
            while (i < types.size()) {
                Integer element = (Integer)types.elementAt(i);
                if (element == type) {
                    newType = false;
                    break;
                }
                ++i;
            }
            if (!newType) continue;
            types.addElement(new Integer(type));
        }
        return types;
    }

    public Vector getFWIfs(int dir) {
        Vector<XDMInterfaceBase> newList = new Vector<XDMInterfaceBase>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface mainIf;
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            if (item.getFWDir() == dir) {
                newList.addElement(item);
            }
            if (!(mainIf = (XDMInterface)item).isSubInterfaceExist()) continue;
            XDMSubInterfaces subIfs = mainIf.getSubInterfaces();
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                if (sif.getFWDir() != dir) continue;
                newList.addElement(sif);
            }
        }
        return newList;
    }

    public Vector getFeatureSupportedIfStrings(int feature) {
        return this.getIfCompositeStrings(true, feature, false);
    }

    public Vector getFeatureSupportedIfStringsWOCheckingConfig(int feature) {
        return this.getIfCompositeStrings(true, feature, true);
    }

    public Vector getFeatureSupportedIfs(int feature) {
        Vector<XDMInterfaceBase> newList = new Vector<XDMInterfaceBase>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface mainIf;
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            if (item.isSupported(feature)) {
                newList.addElement(item);
            }
            if (!(mainIf = (XDMInterface)item).isSubInterfaceExist()) continue;
            XDMSubInterfaces subIfs = mainIf.getSubInterfaces();
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                if (!sif.isSupported(feature)) continue;
                newList.addElement(sif);
            }
        }
        return newList;
    }

    public int getFirstCmdPosition(String module, ConfigValues config, boolean noCmd) {
        int ret = -1;
        if (config == null) {
            return ret;
        }
        int size = config.numCmds();
        int i = 0;
        while (i < size) {
            CmdValues cmd = config.getCmdValues(i);
            String name = cmd.getCmdName();
            if (name.equalsIgnoreCase("interface") && (cmd.getAction() == 2 && noCmd || cmd.getAction() != 2 && !noCmd)) {
                ret = i;
                break;
            }
            ++i;
        }
        return ret;
    }

    Hashtable getIDB() {
        block2: {
            if (this._idb != null) break block2;
            DeviceBase dev = (DeviceBase)this.getDevice();
            try {
                this._idb = XDMDiscovery.getIDB(dev.getDevInfoBase().getComm());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this._idb;
    }

    public XDMInterfaceBase getIfByIP(IPAddress address) {
        if (address == null) {
            return null;
        }
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            IfIPAddress ifIPAddress = item.getIpAddr();
            if (ifIPAddress != null && ifIPAddress.isStaticIpMatch(address)) {
                return item;
            }
            XDMInterface mainIf = (XDMInterface)item;
            if (!mainIf.isSubInterfaceExist()) continue;
            XDMSubInterfaces subIfs = mainIf.getSubInterfaces();
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                IfIPAddress sifIPAddress = sif.getIpAddr();
                if (sifIPAddress == null || !sifIPAddress.isStaticIpMatch(address)) continue;
                return sif;
            }
        }
        return null;
    }

    public XDMInterfaceBase getIfByIPSubnet(IPAddress address, Netmask mask) {
        if (address == null || mask == null) {
            return null;
        }
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            IfIPAddress ifIPAddress = item.getIpAddr();
            if (ifIPAddress != null && ifIPAddress.isStaticIpSubnetMatch(address, mask)) {
                return item;
            }
            XDMInterface mainIf = (XDMInterface)item;
            if (!mainIf.isSubInterfaceExist()) continue;
            XDMSubInterfaces subIfs = mainIf.getSubInterfaces();
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                IfIPAddress sifIPAddress = sif.getIpAddr();
                if (sifIPAddress == null || !sifIPAddress.isStaticIpSubnetMatch(address, mask)) continue;
                return sif;
            }
        }
        return null;
    }

    public Vector getIfCompositeStrings() {
        return this.getIfCompositeStrings(false, 0, true);
    }

    private Vector getIfCompositeStrings(boolean checkFeature, int feature, boolean includeUnconfigured) {
        Vector<String> ret = new Vector<String>();
        Vector ifs = this.getSortedIfs();
        Hashtable ht = this.getLogicalPhysicalAssociations();
        XDMSubInterface dummySubIf = new XDMSubInterface(null, null);
        String cnSubIf = dummySubIf.getClass().getName();
        Enumeration e = ifs.elements();
        while (e.hasMoreElements()) {
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            IfID ifid = item.getIfID();
            if (item instanceof XDMUnsupportedIf || item.getClass().getName().equals(cnSubIf)) {
                if (checkFeature && (!checkFeature || !item.checkIsSupportedWithoutDetectAll(feature))) continue;
                ret.addElement(ifid.toString());
                continue;
            }
            if (checkFeature && !item.checkIsSupportedWithoutDetectAll(feature) || !includeUnconfigured && !item.isConfigured() || item.getLogicalIf() != null) continue;
            if (ifid.isSubInterface()) {
                ret.addElement(ifid.toString());
                continue;
            }
            XDMInterface mainIf = (XDMInterface)item;
            if (mainIf.isSubInterfaceExist()) continue;
            Vector physicals = (Vector)ht.get(mainIf.getIfID());
            ret.addElement(item.getLabel(physicals));
        }
        return ret;
    }

    public XDMInterfaceBase getIfFromCompositeLabel(String label) {
        if (label == null || label.length() == 0) {
            return null;
        }
        int index = label.indexOf(" {");
        String key = index == -1 ? label : label.substring(0, index);
        return this.getIfFromString(key);
    }

    public XDMInterfaceBase getIfFromString(String name) {
        XDMInterfaceBase ret = null;
        DeviceBase dev = (DeviceBase)this.getDevice();
        IfID ifID = IfID.fromString(name, dev.getDevInfoBase().getHWConfig());
        if (ifID != null) {
            if (ifID.isSubInterface()) {
                XDMSubInterfaces sifs;
                IfID mainID = null;
                mainID = ifID.getType() == 0 ? new IfID(ifID.getUnsupportIfStr(), ifID.getSlot(), ifID.getModuleSlot(), ifID.getPort(), ifID.getChannel(), 0) : new IfID(ifID.getType(), ifID.getSlot(), ifID.getModuleSlot(), ifID.getPort(), ifID.getChannel(), 0);
                XDMInterface mainIf = (XDMInterface)this.get(mainID);
                if (mainIf != null && (sifs = mainIf.getSubInterfaces()) != null) {
                    ret = sifs.get(ifID.getSubIfID());
                }
            } else {
                ret = (XDMInterfaceBase)this.get(ifID);
            }
        }
        return ret;
    }

    public int getIfObjStat(XDMInterfaceBase intface) {
        DeviceBase dev;
        XDMInterfaceBase bIf;
        int ret = 0;
        if (intface != null && (bIf = (dev = (DeviceBase)this.getDevice()).getBackup().getIfs().getIfFromString(intface.getIfID().toString())) != null) {
            ret = bIf.isShutdown() ? 1 : 2;
        }
        return ret;
    }

    public Vector getIfs() {
        Vector<XDMInterfaceBase> ret = new Vector<XDMInterfaceBase>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            ret.addElement(item);
            XDMInterface mainIf = (XDMInterface)item;
            XDMSubInterfaces subIfs = mainIf.getSubInterfaces();
            if (subIfs == null) continue;
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                ret.addElement(sif);
            }
        }
        return ret;
    }

    public Vector getIfs(int feature, String value) {
        Vector<XDMInterfaceBase> newList = new Vector<XDMInterfaceBase>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface mainIf;
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            if (item.isUsing(feature, value)) {
                newList.addElement(item);
            }
            if (!(mainIf = (XDMInterface)item).isSubInterfaceExist()) continue;
            XDMSubInterfaces subIfs = mainIf.getSubInterfaces();
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                if (!sif.isUsing(feature, value)) continue;
                newList.addElement(sif);
            }
        }
        return newList;
    }

    public Vector getIfsByIPSubnet(IPAddress address, Netmask mask) {
        if (address == null || mask == null) {
            return null;
        }
        Vector<XDMInterfaceBase> retVal = new Vector<XDMInterfaceBase>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface mainIf;
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            IfIPAddress ifIPAddress = item.getIpAddr();
            if (ifIPAddress != null && ifIPAddress.isStaticIpSubnetMatch(address, mask)) {
                retVal.addElement(item);
            }
            if (!(mainIf = (XDMInterface)item).isSubInterfaceExist()) continue;
            XDMSubInterfaces subIfs = mainIf.getSubInterfaces();
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                IfIPAddress sifIPAddress = sif.getIpAddr();
                if (sifIPAddress == null || !sifIPAddress.isStaticIpSubnetMatch(address, mask)) continue;
                retVal.addElement(sif);
            }
        }
        return retVal;
    }

    public Vector getIfsByIPUnnumberedIntf(IfID unnumberedIntf) {
        if (unnumberedIntf == null) {
            return null;
        }
        Vector<XDMInterfaceBase> retVal = new Vector<XDMInterfaceBase>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface mainIf;
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            IfIPAddress ifIPAddress = item.getIpAddr();
            if (ifIPAddress != null && unnumberedIntf.equals(ifIPAddress.getIPUnnumberedIntf())) {
                retVal.addElement(item);
            }
            if (!(mainIf = (XDMInterface)item).isSubInterfaceExist()) continue;
            XDMSubInterfaces subIfs = mainIf.getSubInterfaces();
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                IfIPAddress sifIPAddress = sif.getIpAddr();
                if (sifIPAddress == null || !unnumberedIntf.equals(sifIPAddress.getIPUnnumberedIntf())) continue;
                retVal.addElement(sif);
            }
        }
        return retVal;
    }

    public Vector getIfsByModule(int slot, int module) {
        Vector<XDMInterface> newList = new Vector<XDMInterface>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface item = (XDMInterface)e.nextElement();
            if (item.getIfID().getSlot() != slot || item.getIfID().getModuleSlot() != module) continue;
            newList.addElement(item);
        }
        return newList;
    }

    public Vector getIfsBySlot(int slot) {
        Vector<XDMInterface> newList = new Vector<XDMInterface>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface item = (XDMInterface)e.nextElement();
            if (item.getIfID().getSlot() != slot) continue;
            newList.addElement(item);
        }
        return newList;
    }

    public Vector getIfsByType(int type) {
        Vector<XDMInterface> newList = new Vector<XDMInterface>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface item = (XDMInterface)e.nextElement();
            if (item.getIfID().getType() != type) continue;
            newList.addElement(item);
        }
        return newList;
    }

    public Vector getLANIfs() {
        Vector<XDMInterface> newList = new Vector<XDMInterface>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface item = (XDMInterface)e.nextElement();
            if (item.isWAN()) continue;
            newList.addElement(item);
        }
        return newList;
    }

    public Vector getLogicalIfs() {
        Vector<XDMInterface> newList = new Vector<XDMInterface>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface item = (XDMInterface)e.nextElement();
            if (!item.getIfID().isLogical()) continue;
            newList.addElement(item);
        }
        return newList;
    }

    public Hashtable getLogicalPhysicalAssociations() {
        Hashtable<IfID, Vector<XDMInterfaceBase>> ret = new Hashtable<IfID, Vector<XDMInterfaceBase>>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface mainIf;
            XDMSubInterfaces subIfs;
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            XDMInterfaceBase logical = item.getLogicalIf();
            if (logical != null) {
                Vector<XDMInterfaceBase> list = (Vector<XDMInterfaceBase>)ret.get(logical.getIfID());
                if (list == null) {
                    list = new Vector<XDMInterfaceBase>();
                    ret.put(logical.getIfID(), list);
                }
                list.addElement(item);
            }
            if ((subIfs = (mainIf = (XDMInterface)item).getSubInterfaces()) == null) continue;
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                XDMInterfaceBase logicalSub = sif.getLogicalIf();
                if (logicalSub == null) continue;
                Vector<XDMInterfaceBase> list = (Vector<XDMInterfaceBase>)ret.get(logicalSub.getIfID());
                if (list == null) {
                    list = new Vector<XDMInterfaceBase>();
                    ret.put(logicalSub.getIfID(), list);
                }
                list.addElement(sif);
            }
        }
        return ret;
    }

    public Vector getLowSpeedInterfaces() {
        Vector<XDMInterface> result = new Vector<XDMInterface>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface item = (XDMInterface)e.nextElement();
            int type = item.getIfID().getType();
            if (type != 1009 && type != 507 && type != 508) continue;
            result.addElement(item);
        }
        return result;
    }

    public int getNextDialPoolNumber() {
        Vector ifs = this.getIfsByType(1001);
        int[] nextDL = new int[255];
        int i = 0;
        while (i < 255) {
            nextDL[i] = 0;
            ++i;
        }
        Enumeration e = ifs.elements();
        while (e.hasMoreElements()) {
            Dialer item = (Dialer)e.nextElement();
            if (item.getDialPoolNumber() == -1) continue;
            nextDL[item.getDialPoolNumber() - 1] = 1;
        }
        ifs = this.getIfsByType(503);
        Vector ifs2 = this.getIfsByType(504);
        int i2 = 0;
        while (i2 < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i2));
            ++i2;
        }
        ifs2 = this.getIfsByType(532);
        int i3 = 0;
        while (i3 < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i3));
            ++i3;
        }
        Enumeration e2 = ifs.elements();
        while (e2.hasMoreElements()) {
            Atm item = (Atm)e2.nextElement();
            PvcCollection pvcs = item.getPvcs();
            Enumeration en = pvcs.elements();
            while (en.hasMoreElements()) {
                Pvc pvc = (Pvc)en.nextElement();
                if (pvc.getDialPoolNumber() == -1) continue;
                nextDL[pvc.getDialPoolNumber() - 1] = 1;
            }
            XDMSubInterfaces si = item.getSubInterfaces();
            Enumeration e22 = si.elements();
            while (e22.hasMoreElements()) {
                AtmSubInterface asub = (AtmSubInterface)e22.nextElement();
                PvcCollection pvcs2 = asub.getPvcs();
                Enumeration en2 = pvcs2.elements();
                while (en2.hasMoreElements()) {
                    Pvc pvc = (Pvc)en2.nextElement();
                    if (pvc.getDialPoolNumber() == -1) continue;
                    nextDL[pvc.getDialPoolNumber() - 1] = 1;
                }
            }
        }
        ifs = this.getIfsByType(1);
        ifs2 = this.getIfsByType(2);
        int i4 = 0;
        while (i4 < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i4));
            ++i4;
        }
        ifs2 = this.getIfsByType(3);
        int i5 = 0;
        while (i5 < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i5));
            ++i5;
        }
        ifs2 = this.getIfsByType(4);
        int i6 = 0;
        while (i6 < ifs2.size()) {
            ifs.addElement(ifs2.elementAt(i6));
            ++i6;
        }
        Enumeration e3 = ifs.elements();
        while (e3.hasMoreElements()) {
            Ethernet item = (Ethernet)e3.nextElement();
            if (item.getDialPoolNumber() == -1) continue;
            nextDL[item.getDialPoolNumber() - 1] = 1;
        }
        int i7 = 0;
        while (i7 < 255) {
            if (nextDL[i7] == 0) {
                return i7 + 1;
            }
            ++i7;
        }
        return 1;
    }

    public Vector getPhysicalIfs() {
        Vector<XDMInterface> newList = new Vector<XDMInterface>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface item = (XDMInterface)e.nextElement();
            if (item.getIfID().isLogical()) continue;
            newList.addElement(item);
        }
        return newList;
    }

    public Vector getSortedIfs() {
        if (!this.isModified() && this._sortedIfsBeforeModification != null) {
            return this._sortedIfsBeforeModification;
        }
        Vector ret = new Vector();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            this.insert2SortedVector(ret, item);
            XDMInterface mainIf = (XDMInterface)item;
            XDMSubInterfaces subIfs = mainIf.getSubInterfaces();
            if (subIfs == null) continue;
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                this.insert2SortedVector(ret, sif);
            }
        }
        if (!this.isModified()) {
            this._sortedIfsBeforeModification = ret;
        }
        return ret;
    }

    public Vector getSupportedIfs() {
        Vector<XDMInterface> newList = new Vector<XDMInterface>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface item = (XDMInterface)e.nextElement();
            if (!item.getIfID().isSupported()) continue;
            newList.addElement(item);
        }
        return newList;
    }

    public Vector getSupportedPassiveIntfsforDynRting() {
        Vector<XDMInterfaceBase> ret = new Vector<XDMInterfaceBase>();
        Vector sortedIfs = this.getSortedIfs();
        int i = 0;
        while (i < sortedIfs.size()) {
            XDMInterfaceBase ifbase = (XDMInterfaceBase)sortedIfs.elementAt(i);
            if (ifbase.getIfID().getType() != 1006 && ifbase.getIfID().getType() != 5 && ifbase.getIfID().getType() != 6) {
                ret.addElement(ifbase);
            }
            ++i;
        }
        return ret;
    }

    public Vector getSupportedTunnelSourceIfs() {
        return this.getSupportedTunnelSourceIfs(100);
    }

    public Vector getSupportedTunnelSourceIfs(int nContext) {
        Vector<String> newList = new Vector<String>();
        Vector allIfs = this.getIfCompositeStrings();
        int i = 0;
        while (i < allIfs.size()) {
            IfIPAddress ip;
            Ethernet eth;
            String intfCompName = (String)allIfs.elementAt(i);
            XDMInterfaceBase item = this.getIfFromCompositeLabel(intfCompName);
            if (!(item.getIfID().getType() == 1006 || item.getIfID().getType() == 1003 || item.getIfID().getType() == 1002 || item.getBridgeGroup() > 0 || item instanceof Ethernet && (eth = (Ethernet)item).isChannelGroupConfigured() || (ip = item.getIpAddr()) == null)) {
                switch (nContext) {
                    case 100: {
                        if (!ip.isStatic() && !ip.isIPUnnumbered()) break;
                        newList.addElement(intfCompName);
                        break;
                    }
                    case 2: {
                        if (IPAddressType.DYNAMIC == ip.getIPAddressType() || IPAddressType.NEGOTIATED == ip.getIPAddressType()) {
                            newList.addElement(intfCompName);
                        }
                    }
                    case 0: {
                        XDMInterfaceBase unnumberedintf;
                        IfIPAddress unnumberedipaddr;
                        if (ip.isStatic() || ip.isIPUnnumbered()) {
                            newList.addElement(intfCompName);
                            break;
                        }
                        if (!item.getIpAddr().isIPUnnumbered() || (unnumberedipaddr = (unnumberedintf = (XDMInterfaceBase)this.get(ip.getIPUnnumberedIntf())).getIpAddr()) == null || unnumberedipaddr.getIPAddressType() != IPAddressType.STATIC) break;
                        newList.addElement(intfCompName);
                    }
                }
            }
            ++i;
        }
        return newList;
    }

    public Vector getTunnelIfsBySrc(XDMInterfaceBase intf) {
        Vector<Tunnel> retVal = new Vector<Tunnel>();
        if (intf == null) {
            return retVal;
        }
        IfID ifId = intf.getIfID();
        IfIPAddress ipAddr = intf.getIpAddr();
        IPAddress ip = null;
        if (ipAddr != null) {
            if (ipAddr.getIPAddressType().getValue() == 1) {
                ip = ipAddr.getIPAddress();
            } else if (ipAddr.getIPAddressType().getValue() == 3) {
                ip = ipAddr.getIPUnnumIntfIPAddress();
            }
        }
        Vector tunnels = this.getIfsByType(1002);
        int i = 0;
        while (i < tunnels.size()) {
            Tunnel tun = (Tunnel)tunnels.elementAt(i);
            IfIdentity tunSrc = tun.getSource();
            if (tunSrc != null) {
                if (tunSrc.isIfName()) {
                    IfID tunSrcIntf = tunSrc.getIf();
                    if (ifId.equals(tunSrcIntf)) {
                        retVal.addElement(tun);
                    }
                } else {
                    IPAddress tunSrcIp = tunSrc.getIpAddress();
                    if (ip != null && ip.equals(tunSrcIp)) {
                        retVal.addElement(tun);
                    }
                }
            }
            ++i;
        }
        return retVal;
    }

    public Vector getWANIfs() {
        Vector<XDMInterface> newList = new Vector<XDMInterface>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            XDMInterface item = (XDMInterface)e.nextElement();
            if (!item.isWAN()) continue;
            newList.addElement(item);
        }
        return newList;
    }

    private void insert2SortedVector(Vector v, XDMInterfaceBase item) {
        int ind = 0;
        int begin = 0;
        int end = v.size() - 1;
        int res = 0;
        XDMInterfaceBase element = null;
        while (begin <= end) {
            if (begin == end) {
                element = (XDMInterfaceBase)v.elementAt(begin);
                res = element.getIfID().compare(item.getIfID());
                break;
            }
            if (begin + 1 == end) {
                ind = begin;
                element = (XDMInterfaceBase)v.elementAt(begin);
                res = element.getIfID().compare(item.getIfID());
                if (res == 1) break;
                ind = end;
                element = (XDMInterfaceBase)v.elementAt(end);
                res = element.getIfID().compare(item.getIfID());
                break;
            }
            ind = end + begin >> 1;
            element = (XDMInterfaceBase)v.elementAt(ind);
            res = element.getIfID().compare(item.getIfID());
            if (res == 1) {
                end = ind;
                continue;
            }
            begin = ind;
        }
        if (res == -1) {
            ++ind;
        }
        v.insertElementAt(item, ind);
    }

    public boolean isFeatureAssociationChanged(int feature, String value) {
        DeviceBase dev = (DeviceBase)this.getDevice();
        Vector cur = this.getIfs(feature, value);
        Vector old = dev.getBackup().getIfs().getIfs(feature, value);
        if (cur.size() != old.size()) {
            return true;
        }
        Enumeration e = cur.elements();
        while (e.hasMoreElements()) {
            XDMInterfaceBase curItem = (XDMInterfaceBase)e.nextElement();
            boolean found = false;
            Enumeration eOld = old.elements();
            while (eOld.hasMoreElements()) {
                XDMInterfaceBase oldItem = (XDMInterfaceBase)eOld.nextElement();
                if (!curItem.getIfID().toString().equalsIgnoreCase(oldItem.getIfID().toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    public boolean isIfOnDevice(XDMInterfaceBase intface) {
        boolean ret = false;
        if (intface != null) {
            DeviceBase dev = (DeviceBase)this.getDevice();
            ret = dev.getBackup().getIfs().getIfFromString(intface.getIfID().toString()) != null;
        }
        return ret;
    }

    private boolean isRealSwitchPort(IfID ifid) {
        int packedValue;
        DeviceBase dev = (DeviceBase)this.getDevice();
        Boolean b = dev.getSwitchPort(packedValue = EthernetSwitchPort.pack(ifid.getSlot(), ifid.getModuleSlot()));
        if (b != null) {
            return b;
        }
        String ifStr = ifid.toString();
        String[] cmds = new String[]{"interface " + ifStr, " switchport ?", " exit"};
        IOSCmdService cmdsvc = dev.getDevInfoBase().getComm();
        try {
            IOSCmdResponse[] resp = cmdsvc.config(cmds);
            boolean isFake = resp[1].getOutput().toLowerCase().indexOf("unrecognized") != -1 || resp[1].getStatus() == 2;
            Log.getLog().debug("isRealSwitchPort " + ifStr + "? " + (isFake ^ true));
            return isFake ^ true;
        }
        catch (IOSCmdServiceException cse) {
            cse.printStackTrace();
            return true;
        }
    }

    public boolean isVlanInUse(int vlan) {
        IfID ifid = new IfID(1007, -1, -1, vlan, -1, 0);
        return this.get(ifid) != null;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        ConfigValues unknowns;
        Log log = Log.getLog();
        XDMInterface mainIf = null;
        ConfigValues ifCVs = config.getCmds("interface", "ifname", ".*", false);
        if (ifCVs != null) {
            int i = 0;
            while (i < ifCVs.numCmds()) {
                CmdValues cmd = ifCVs.getCmdValues(i);
                XDMInterfaceBase newIf = this.createIfFromCmd(cmd);
                if (newIf != null) {
                    if (newIf.getIfID().isSubInterface()) {
                        XDMSubInterface subIf = (XDMSubInterface)newIf;
                        if (mainIf == null) {
                            throw new XDMException(2, this);
                        }
                        XDMSubInterfaces sifs = mainIf.getSubInterfaces();
                        if (sifs == null) {
                            log.error("Found sub interface belong to an interface that does not support sub interfacing. This sub IF will be ignored");
                        } else {
                            subIf.setMainInterface(mainIf);
                            sifs.put(subIf);
                            subIf.populate(config, cmd);
                        }
                    } else {
                        mainIf = (XDMInterface)newIf;
                        this.put(mainIf);
                        mainIf.populate(config, cmd);
                    }
                }
                ++i;
            }
        }
        if ((unknowns = config.getCmds("interface", "strIfName", ".*", false)) != null) {
            mainIf = null;
            int i = 0;
            while (i < unknowns.numCmds()) {
                CmdValues cmd = unknowns.getCmdValues(i);
                XDMInterfaceBase newIf = this.createIfFromCmd(cmd);
                if (newIf.getIfID().isSubInterface()) {
                    XDMSubInterface subIf = (XDMSubInterface)newIf;
                    if (mainIf == null) {
                        throw new XDMException(2, this);
                    }
                    XDMSubInterfaces sifs = mainIf.getSubInterfaces();
                    if (sifs == null) {
                        log.error("Found sub interface belong to an interface that does not support sub interfacing. This sub IF will be ignored");
                    } else {
                        subIf.setMainInterface(mainIf);
                        sifs.put(subIf);
                        subIf.populate(config, cmd);
                    }
                } else {
                    mainIf = (XDMInterface)newIf;
                    this.put(newIf);
                    newIf.populate(config, cmd);
                }
                ++i;
            }
        }
    }

    public synchronized XDMObject put(XDMInterfaceBase newIf) throws XDMException {
        if (newIf == null) {
            throw new XDMException(4);
        }
        this.setModified();
        return super.put(newIf.getIfID(), newIf);
    }

    public synchronized Object remove(Object key) {
        XDMInterfaceBase item = (XDMInterfaceBase)this.get(key);
        if (item != null) {
            if (item.getIfID().isLogical()) {
                Object obj = super.remove(key);
                if (obj != null) {
                    XDMInterfaceBase intface = (XDMInterfaceBase)obj;
                    intface.setACLCategory(null, intface.getIpAccessGroupIn());
                    intface.setACLCategory(null, intface.getIpAccessGroupOut());
                    DeviceBase dev = (DeviceBase)this.getDevice();
                    StaticRouteVector sRoutes = dev.getStaticRoutes();
                    sRoutes.removeEntries(intface.getIfID());
                }
            } else {
                item = null;
            }
        }
        return item;
    }

    public void resetModifiedFlag() {
        this._idb = null;
        this._deleteds = null;
        this._sortedIfsBeforeModification = null;
        super.resetModifiedFlag();
    }

    private void setAttrFlagFromDict(XDMInterfaceBase newIf, int index, Hashtable attrs, String key) {
        String value = (String)attrs.get(key);
        if (value != null) {
            if (value.equals("yes")) {
                newIf.setSupport(index, 1);
            } else if (value.equals("no")) {
                newIf.setSupport(index, 0);
            }
        }
    }

    void setShutdownInBackup(XDMInterfaceBase intface, boolean flag) {
        DeviceBase dev;
        XDMInterfaceBase backupIf;
        if (intface != null && (backupIf = (dev = (DeviceBase)this.getDevice()).getBackup().getIfs().getIfFromString(intface.getIfID().toString())) != null) {
            backupIf.shutdown(flag);
        }
    }
}

