/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.interfaces;

import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMSubInterface;
import com.cisco.xdm.data.routing.StaticRouteVector;
import java.util.Enumeration;

public class XDMSubInterfaces
extends XDMHashCollection {
    public XDMSubInterfaces(XDMInterface mainIf) {
        super(mainIf);
    }

    public XDMSubInterface get(int subIfID) {
        return (XDMSubInterface)this.get(new Integer(subIfID));
    }

    public int getNextAvailableID() {
        XDMObject parent = this.getParent();
        XDMInterface pIf = (XDMInterface)parent;
        DeviceBase dev = (DeviceBase)this.getDevice();
        int ret = 1;
        while (true) {
            if (this.get(new Integer(ret)) == null) {
                IfID newId = new IfID(pIf.getIfID().getType(), pIf.getIfID().getSlot(), pIf.getIfID().getModuleSlot(), pIf.getIfID().getPort(), pIf.getIfID().getChannel(), ret);
                String newStr = newId.toString();
                if (!dev.getIfs().getDeleteds().containsKey(newStr)) break;
            }
            ++ret;
        }
        return ret;
    }

    private boolean isInSameIf(XDMSubInterface subIf) {
        if (subIf == null) {
            return false;
        }
        if (this.size() > 0) {
            Enumeration e = this.elements();
            XDMSubInterface item = (XDMSubInterface)e.nextElement();
            return subIf.getIfID().isSamePort(item.getIfID());
        }
        XDMObject parent = this.getParent();
        if (parent == null || !(parent instanceof XDMInterface)) {
            return false;
        }
        XDMInterface parentIf = (XDMInterface)parent;
        IfID subID = subIf.getIfID();
        return subID != null && subID.isSamePort(parentIf.getIfID());
    }

    public synchronized XDMObject put(XDMSubInterface newIf) throws XDMException {
        if (newIf == null || !this.isInSameIf(newIf)) {
            throw new XDMException(4);
        }
        return this.put(new Integer(newIf.getIfID().getSubIfID()), newIf);
    }

    public synchronized XDMObject put(Object key, XDMObject value) {
        XDMSubInterface newIf = (XDMSubInterface)value;
        newIf.setMainInterface((XDMInterface)this.getParent());
        return super.put(key, value);
    }

    public synchronized Object remove(int subID) {
        Integer key = new Integer(subID);
        Object obj = super.remove(key);
        if (obj != null) {
            XDMInterfaceBase intface = (XDMInterfaceBase)obj;
            intface.setACLCategory(null, intface.getIpAccessGroupIn());
            intface.setACLCategory(null, intface.getIpAccessGroupOut());
            DeviceBase dev = (DeviceBase)this.getDevice();
            StaticRouteVector sRoutes = dev.getStaticRoutes();
            sRoutes.removeEntries(intface.getIfID());
        }
        return obj;
    }

    public synchronized Object remove(Object key) {
        Object obj = super.remove(key);
        if (obj != null) {
            XDMInterfaceBase intface = (XDMInterfaceBase)obj;
            intface.setACLCategory(null, intface.getIpAccessGroupIn());
            intface.setACLCategory(null, intface.getIpAccessGroupOut());
            DeviceBase dev = (DeviceBase)this.getDevice();
            StaticRouteVector sRoutes = dev.getStaticRoutes();
            sRoutes.removeEntries(intface.getIfID());
        }
        return obj;
    }
}

