/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.nat;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.nat.NatPoolCollection;

public class NatPool
extends XDMObject {
    private static final int XDM_NAT_VALUE_NOT_SET = -1;
    private boolean _bIsPAT;
    private String _strName;
    private IPAddress _ipStart;
    private IPAddress _ipEnd;
    private Netmask _ipMask;
    private int _iMaskBits;
    private int _iUnsupportedReason;
    private Log _theLog;

    public NatPool() {
        this._iUnsupportedReason = 0;
        this._bIsPAT = false;
        this._strName = null;
        this._ipStart = null;
        this._ipEnd = null;
        this._ipMask = null;
        this._iMaskBits = -1;
        this._theLog = Log.getLog();
    }

    public NatPool(XDMObject parent, int iUnsupported, String strPoolName) {
        super(parent, iUnsupported != 0);
        this._iUnsupportedReason = iUnsupported;
        this._bIsPAT = false;
        this._strName = strPoolName;
        this._ipStart = null;
        this._ipEnd = null;
        this._ipMask = null;
        this._iMaskBits = -1;
        this._theLog = Log.getLog();
    }

    public Object clone() {
        NatPool dup = (NatPool)super.clone();
        dup._bIsPAT = this._bIsPAT;
        dup._strName = this._strName == null ? null : this._strName;
        dup._ipStart = this._ipStart == null ? null : (IPAddress)this._ipStart.clone();
        dup._ipEnd = this._ipEnd == null ? null : (IPAddress)this._ipEnd.clone();
        dup._ipMask = this._ipMask == null ? null : (Netmask)this._ipMask.clone();
        dup._iMaskBits = this._iMaskBits;
        return dup;
    }

    private Netmask createMask(IPAddress ipStart, IPAddress ipEnd) {
        long maskVal = -1L;
        int shiftFactor = 0;
        boolean bWorking = true;
        while (bWorking) {
            long bitmask = ~(1 << shiftFactor);
            if ((maskVal &= bitmask) == 0L) {
                bWorking = false;
                continue;
            }
            Netmask mask = new Netmask((int)maskVal);
            IPAddress netStart = new IPAddress(ipStart, mask);
            IPAddress netEnd = new IPAddress(ipEnd, mask);
            if (!netStart.equals(netEnd)) continue;
            return mask;
        }
        return new Netmask(0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof NatPool)) {
            return false;
        }
        NatPool pool = (NatPool)o;
        return super.equals(pool) && this._bIsPAT == pool._bIsPAT && (this._strName != null && this._strName.equals(pool._strName) || this._strName == null && pool._strName == null) && (this._ipStart != null && this._ipStart.equals(pool._ipStart) || this._ipStart == null && pool._ipStart == null) && (this._ipEnd != null && this._ipEnd.equals(pool._ipEnd) || this._ipEnd == null && pool._ipEnd == null) && (this._ipMask != null && this._ipMask.equals(pool._ipMask) || this._ipMask == null && pool._ipMask == null) && this._iMaskBits == pool._iMaskBits;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) {
        if (this.equals(backup)) {
            return;
        }
        CmdValues cmd = new CmdValues("ip");
        cmd.addValue("nat", "nat");
        cmd.addValue("poolkey", "pool");
        cmd.addValue("poolname", this._strName);
        cmd.addValue("startip", this._ipStart.toString());
        if (this._ipEnd != null) {
            cmd.addValue("endip", this._ipEnd.toString());
        } else {
            cmd.addValue("endip", this._ipStart.toString());
        }
        if (this._ipMask != null) {
            cmd.addValue("netmask", "netmask");
            cmd.addValue("mask", this._ipMask.toString());
        }
        if (this._iMaskBits != -1) {
            cmd.addValue("prefix-length", "prefix-length");
            cmd.addValue("prefix", Integer.toString(this._iMaskBits));
        }
        if (!this.isBackup()) {
            if (backup == null) {
                cmd.setAction(1);
            } else {
                cmd.setAction(3);
                NatPool oldPool = (NatPool)backup;
                cmd.addOldValue("nat", "nat");
                cmd.addOldValue("poolkey", "pool");
                cmd.addOldValue("poolname", oldPool._strName);
                cmd.addOldValue("startip", oldPool._ipStart.toString());
                cmd.addOldValue("endip", oldPool._ipEnd.toString());
                if (oldPool._ipMask != null) {
                    cmd.addOldValue("netmask", "netmask");
                    cmd.addOldValue("mask", oldPool._ipMask.toString());
                }
                if (oldPool._iMaskBits != -1) {
                    cmd.addOldValue("prefix-length", "prefix-length");
                    cmd.addOldValue("prefix", Integer.toString(oldPool._iMaskBits));
                }
            }
        } else {
            cmd.setAction(2);
        }
        values.addCmdValues(cmd);
    }

    public IPAddress getEndIP() {
        return this._ipEnd;
    }

    public Netmask getMask() {
        return this._ipMask;
    }

    public int getMaskBits() {
        return this._iMaskBits;
    }

    public String getName() {
        return this._strName;
    }

    public int getReason() {
        return this._iUnsupportedReason;
    }

    public IPAddress getStartIP() {
        return this._ipStart;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public boolean isPAT() {
        return this._bIsPAT;
    }

    public static boolean isValidRange(IPAddress ipStart, IPAddress ipEnd, int iMaskBits) {
        if (ipStart == null) {
            return false;
        }
        if (ipEnd == null) {
            return true;
        }
        if (!Netmask.isLegalNetmask(iMaskBits)) {
            return false;
        }
        Netmask mask = new Netmask(iMaskBits);
        IPAddress ipStartNet = new IPAddress(ipStart, mask);
        IPAddress ipEndNet = new IPAddress(ipEnd, mask);
        if (!ipStartNet.equals(ipEndNet)) {
            return false;
        }
        return ipEnd.greaterThanOrEqual(ipStart);
    }

    public static boolean isValidRange(IPAddress ipStart, IPAddress ipEnd, Netmask mask) {
        IPAddress ipEndNet;
        IPAddress ipStartNet;
        if (ipStart == null) {
            return false;
        }
        if (ipEnd == null) {
            return true;
        }
        if (mask != null && !(ipStartNet = new IPAddress(ipStart, mask)).equals(ipEndNet = new IPAddress(ipEnd, mask))) {
            return false;
        }
        return ipEnd.greaterThanOrEqual(ipStart);
    }

    public void populate(ConfigValues config, CmdValues cmdVals) {
    }

    public void setIPAddressRange(IPAddress ipStart, IPAddress ipEnd, int iMaskBits) {
        this.setModified();
        this._ipStart = ipStart;
        this._ipEnd = ipEnd;
        if (ipEnd == null) {
            this._iMaskBits = -1;
            this._ipMask = null;
        } else {
            this._iMaskBits = iMaskBits;
            this._ipMask = new Netmask(Netmask.lengthToString(iMaskBits));
        }
    }

    public void setIPAddressRange(IPAddress ipStart, IPAddress ipEnd, Netmask ipMask) {
        this.setModified();
        this._ipStart = ipStart;
        this._ipEnd = ipEnd;
        if (ipEnd == null) {
            this._iMaskBits = -1;
            this._ipMask = null;
        } else {
            this._ipMask = ipMask == null ? this.createMask(ipStart, ipEnd) : ipMask;
            this._iMaskBits = ipMask.getMaskLength();
        }
    }

    public void setName(String poolName) {
        this.setModified();
        XDMObject o = this.getParent();
        if (o instanceof NatPoolCollection) {
            NatPool pool;
            NatPoolCollection pools = (NatPoolCollection)o;
            if (this._strName != null && pools.containsKey(this._strName) && (pool = (NatPool)pools.get(this._strName)) == this) {
                pools.remove(this._strName);
            }
            pools.put(poolName, this);
        }
        this._strName = poolName;
    }

    public void setPAT(boolean bPat) {
        this.setModified();
        this._bIsPAT = bPat;
    }

    public String toString() {
        String s = "Pool:{name}" + this._strName + "PAT?:" + this._bIsPAT + "{IPs}" + this._ipStart + "," + this._ipEnd + "{mask}" + this._ipMask + "," + this._iMaskBits;
        return s;
    }
}

