/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.nat;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.FilterIf;
import com.cisco.xdm.commonutils.FilterFactory;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.commonutils.ParserUtils;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.ACLCollection;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class RouteMapEntry
extends XDMObject {
    private Vector _aclList;
    private Vector _intfList;
    private Vector _nxtHopIPAddrList;
    private Vector _outputIntfNameList;
    private String _name;
    private int _seqNumber;
    private boolean _action;
    private boolean _nxtHopDHCP = false;
    private static final String CLI_SEPARATOR = "?";
    private static final char CLI_SEPARATOR_CHAR = '?';

    public RouteMapEntry(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
        this._name = null;
        this._seqNumber = 0;
        this._aclList = new Vector();
        this._intfList = new Vector();
        this._nxtHopIPAddrList = new Vector();
        this._outputIntfNameList = new Vector();
        this._action = true;
    }

    public RouteMapEntry(String name, int sequenceNumber) {
        this._name = name;
        this._seqNumber = sequenceNumber;
        this._aclList = new Vector();
        this._intfList = new Vector();
        this._nxtHopIPAddrList = new Vector();
        this._outputIntfNameList = new Vector();
        this._action = true;
    }

    public void addACL(String acl) {
        this._aclList.addElement(acl);
        this.setModified();
    }

    public void addInterface(String intf) {
        this._intfList.addElement(intf);
        this.setModified();
    }

    public void addNxtHopIPAddress(IPAddress ipaddrNxtHop) {
        String strIPAddr = ipaddrNxtHop.toString();
        this._nxtHopIPAddrList.addElement(strIPAddr);
        this.setModified();
    }

    public void addNxtHopIPAddress(IPAddress ipaddrNxtHop, int index) {
        String strIPAddr = ipaddrNxtHop.toString();
        this._nxtHopIPAddrList.insertElementAt(strIPAddr, index);
        this.setModified();
    }

    public void addOutputIntfName(String strIntfName) {
        String strLCaseIntfName = strIntfName.toLowerCase();
        this._outputIntfNameList.addElement(strLCaseIntfName);
        Log.getLog().info("addOutputIntfName(), strLCaseIntfName: " + strLCaseIntfName);
        this.setModified();
    }

    public void addOutputIntfName(String strIntfName, int index) {
        String strLCaseIntfName = strIntfName.toLowerCase();
        this._outputIntfNameList.insertElementAt(strLCaseIntfName, index);
        Log.getLog().info("addOutputIntfName(), strLCaseIntfName: " + strLCaseIntfName);
        this.setModified();
    }

    public Object clone() {
        RouteMapEntry rMapEntry = (RouteMapEntry)super.clone();
        rMapEntry._aclList = (Vector)this._aclList.clone();
        rMapEntry._intfList = (Vector)this._intfList.clone();
        rMapEntry._nxtHopIPAddrList = (Vector)this._nxtHopIPAddrList.clone();
        rMapEntry._outputIntfNameList = (Vector)this._outputIntfNameList.clone();
        return rMapEntry;
    }

    private void generateAddCmd(ConfigValues configValues) {
        CmdValues mapMode = null;
        ConfigValues subcfg = new ConfigValues();
        mapMode = this.generateRMapEntryCli(1);
        this.generateMatchACLCli(mapMode, subcfg, 1);
        this.generateMatchInterfaceCli(mapMode, subcfg, 1);
        this.generateNextHopIPAddrCli(mapMode, subcfg, 1);
        this.generateOutputIntfNameCli(mapMode, subcfg, 1);
        this.generateNextHopDHCPCli(mapMode, subcfg, 1);
        configValues.addCmdValues(mapMode);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        if (this.isBackup()) {
            CmdValues mapMode = this.generateRMapEntryCli(2);
            values.addCmdValues(mapMode);
            Log.getLog().error("Deletion of route map is not supported");
        } else if (backup == null) {
            this.generateAddCmd(values);
        } else {
            Log.getLog().error("Modification of route map is not supported");
        }
    }

    private void generateMatchACLCli(CmdValues mapMode, ConfigValues subComandHolder, int action) {
        if (this._aclList == null && action == 1) {
            Log.getLog().error("ACL is null in generateMatchACLCli");
            return;
        }
        Hashtable<String, String> valuesTable = new Hashtable<String, String>();
        valuesTable.put("ip", "ip");
        valuesTable.put("address", "address");
        String aclNames = null;
        StringBuffer aclBuf = new StringBuffer();
        int count = 0;
        while (count < this._aclList.size()) {
            aclBuf.append(this._aclList.elementAt(count));
            aclBuf.append(CLI_SEPARATOR);
            ++count;
        }
        aclNames = aclBuf.toString();
        if (aclNames.charAt(aclNames.length() - 1) == '?') {
            aclNames = aclNames.substring(0, aclNames.length() - 1);
        }
        if (aclNames != null) {
            valuesTable.put("RouteMapAcl", aclNames);
        }
        ParserUtils.generateSubModeCli("match", valuesTable, subComandHolder, action);
        mapMode.setModeCmdsValues(subComandHolder);
    }

    private void generateMatchInterfaceCli(CmdValues mapMode, ConfigValues subComandHolder, int action) {
        if (this._intfList == null && action == 1 || this._intfList.size() <= 0) {
            Log.getLog().error("Interface Name is null in generateMatchInterfaceCli");
            return;
        }
        Hashtable<String, String> valuesTable = new Hashtable<String, String>();
        valuesTable.put("interface", "interface");
        String interfaceNames = null;
        StringBuffer interfaceBuf = new StringBuffer();
        int count = 0;
        while (count < this._intfList.size()) {
            interfaceBuf.append(this._intfList.elementAt(count));
            interfaceBuf.append(CLI_SEPARATOR);
            ++count;
        }
        interfaceNames = interfaceBuf.toString();
        if (interfaceNames.charAt(interfaceNames.length() - 1) == '?') {
            interfaceNames = interfaceNames.substring(0, interfaceNames.length() - 1);
        }
        Log.getLog().info("RouteMapEntry::generateMatchInterfaceCli() interfaceNames: " + interfaceNames);
        if (interfaceNames != null) {
            valuesTable.put("RouteMapIntf", interfaceNames);
        }
        ParserUtils.generateSubModeCli("match", valuesTable, subComandHolder, action);
        mapMode.setModeCmdsValues(subComandHolder);
    }

    private void generateModifyCmd(ConfigValues configValues) {
        CmdValues mapMode = null;
        mapMode = this.generateRMapEntryCli(2);
        configValues.addCmdValues(mapMode);
        this.generateAddCmd(configValues);
    }

    private void generateNextHopDHCPCli(CmdValues mapMode, ConfigValues subComandHolder, int action) {
        Log.getLog().info("RouteMapEntry::generateNextHopDHCPCli() Start-1, _nxtHopDHCP: " + this._nxtHopDHCP);
        if (!this._nxtHopDHCP) {
            return;
        }
        Hashtable<String, String> valuesTable = new Hashtable<String, String>();
        valuesTable.put("ip", "ip");
        valuesTable.put("next-hop", "next-hop");
        valuesTable.put("dynamic", "dynamic");
        valuesTable.put("dhcp", "dhcp");
        ParserUtils.generateSubModeCli("set", valuesTable, subComandHolder, action);
        mapMode.setModeCmdsValues(subComandHolder);
    }

    private void generateNextHopIPAddrCli(CmdValues mapMode, ConfigValues subComandHolder, int action) {
        Log.getLog().info("RouteMapEntry::generateNextHopIPAddrCli() Start-1");
        if (this._nxtHopIPAddrList == null && action == 1 || this._nxtHopIPAddrList.size() <= 0) {
            Log.getLog().error("_nxtHopIPAddrList is null in generateNextHopIPAddrCli");
            return;
        }
        Log.getLog().info("RouteMapEntry::generateNextHopIPAddrCli() Start-1");
        Hashtable<String, String> valuesTable = new Hashtable<String, String>();
        valuesTable.put("ip", "ip");
        valuesTable.put("next-hop", "next-hop");
        String strNxtHopIPAddress = null;
        StringBuffer nxtHopIPBuf = new StringBuffer();
        int count = 0;
        while (count < this._nxtHopIPAddrList.size()) {
            nxtHopIPBuf.append(this._nxtHopIPAddrList.elementAt(count));
            nxtHopIPBuf.append(CLI_SEPARATOR);
            ++count;
        }
        strNxtHopIPAddress = nxtHopIPBuf.toString();
        if (strNxtHopIPAddress.charAt(strNxtHopIPAddress.length() - 1) == '?') {
            strNxtHopIPAddress = strNxtHopIPAddress.substring(0, strNxtHopIPAddress.length() - 1);
        }
        Log.getLog().info("RouteMapEntry::generateNextHopIPAddrCli() strNxtHopIPAddress: " + strNxtHopIPAddress);
        if (strNxtHopIPAddress != null) {
            valuesTable.put("nextHopIntfIp", strNxtHopIPAddress);
        }
        ParserUtils.generateSubModeCli("set", valuesTable, subComandHolder, action);
        mapMode.setModeCmdsValues(subComandHolder);
    }

    private void generateOutputIntfNameCli(CmdValues mapMode, ConfigValues subComandHolder, int action) {
        Log.getLog().info("RouteMapEntry::generateOutputIntfNameCli() Start-1");
        if (this._outputIntfNameList == null && action == 1 || this._outputIntfNameList.size() <= 0) {
            Log.getLog().error("_nxtHopIPAddrList is null in generateOutputIntfNameCli");
            return;
        }
        Log.getLog().info("RouteMapEntry::generateOutputIntfNameCli() Start-2");
        Hashtable<String, String> valuesTable = new Hashtable<String, String>();
        valuesTable.put("interface", "interface");
        String strOutputIntfNames = null;
        StringBuffer outputIntfBuf = new StringBuffer();
        int count = 0;
        while (count < this._outputIntfNameList.size()) {
            outputIntfBuf.append(this._outputIntfNameList.elementAt(count));
            outputIntfBuf.append(CLI_SEPARATOR);
            ++count;
        }
        strOutputIntfNames = outputIntfBuf.toString();
        if (strOutputIntfNames.charAt(strOutputIntfNames.length() - 1) == '?') {
            strOutputIntfNames = strOutputIntfNames.substring(0, strOutputIntfNames.length() - 1);
        }
        Log.getLog().info("RouteMapEntry::generateOutputIntfNameCli() strOutputIntfNames: " + strOutputIntfNames);
        if (strOutputIntfNames != null) {
            valuesTable.put("outputIntf", strOutputIntfNames);
        }
        ParserUtils.generateSubModeCli("set", valuesTable, subComandHolder, action);
        mapMode.setModeCmdsValues(subComandHolder);
    }

    private CmdValues generateRMapEntryCli(int action) {
        CmdValues cmdVal = new CmdValues("route-map");
        cmdVal.setAction(action);
        cmdVal.addValue("MapTag", this._name);
        if (this._action) {
            cmdVal.addValue("Action", "permit");
        } else {
            cmdVal.addValue("Action", "deny");
        }
        cmdVal.addValue("SeqNumber", Integer.toString(this._seqNumber));
        return cmdVal;
    }

    public Vector getACLs() {
        return this._aclList;
    }

    public boolean getAction() {
        return this._action;
    }

    public Vector getInterfaces() {
        return this._intfList;
    }

    public String getName() {
        return this._name;
    }

    public boolean getNextHopDHCP() {
        return this._nxtHopDHCP;
    }

    public Vector getNxtHopIPAddreses() {
        return this._nxtHopIPAddrList;
    }

    public Vector getOutputIntfNames() {
        return this._outputIntfNameList;
    }

    public int getSequenceNumber() {
        return this._seqNumber;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException {
        ConfigValues configValue;
        try {
            this._seqNumber = Integer.parseInt(cmdVal.getValue("SeqNumber"));
            String action = cmdVal.getValue("Action");
            if (action == null) {
                this._action = true;
            }
            if (action.equals("permit")) {
                this._action = true;
            }
            if (action.equals("deny")) {
                this._action = false;
            }
        }
        catch (NumberFormatException ex) {
            Log.getLog().error("Error populating sequenceNumber in " + this.getClass().getName());
            Log.getLog().error("Cause of error is " + ex.getMessage());
        }
        this.populateAccessList(cmdVal);
        this.populateInterfaceList(cmdVal);
        this.populateNextHopIPAddrList(cmdVal);
        this.populateOutputIntfNameList(cmdVal);
        if (cmdVal == null) {
            this._nxtHopDHCP = false;
            return;
        }
        Vector subCommandVals = new Vector();
        if (cmdVal.getModeCmdsValues() != null) {
            String[] keywords = new String[]{"ip", "next-hop", "dynamic", "dhcp"};
            ConfigValues subcommands = cmdVal.getModeCmdsValues();
            FilterIf subcommandFilter = FilterFactory.getKeywordFilter("set", keywords);
            Object subCommandEntry = null;
            configValue = subcommands.getCmds(subcommandFilter);
            if (configValue == null) {
                this._nxtHopDHCP = false;
                return;
            }
        } else {
            this._nxtHopDHCP = false;
            return;
        }
        this._nxtHopDHCP = true;
        Log.getLog().info("RouteMapEntry: populate: : configValue: " + configValue + " _nxtHopDHCP: " + this._nxtHopDHCP);
    }

    private void populateAccessList(CmdValues cmdVal) {
        String[] keywords = new String[]{"ip", "address"};
        String[] subCmdValues = ParserUtils.getSubCommandValue(cmdVal, "match", keywords, "RouteMapAcl");
        if (subCmdValues != null) {
            String aclNames = subCmdValues[0].trim();
            StringTokenizer tokenizer = new StringTokenizer(aclNames, CLI_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this._aclList.addElement(tokenizer.nextToken());
            }
        }
    }

    private void populateInterfaceList(CmdValues cmdVal) {
        String[] keywords = new String[]{"interface"};
        String[] subCmdValues = ParserUtils.getSubCommandValue(cmdVal, "match", keywords, "RouteMapIntf");
        if (subCmdValues != null) {
            String interfaceNames = subCmdValues[0].trim();
            StringTokenizer tokenizer = new StringTokenizer(interfaceNames, CLI_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                String strNxtToken = tokenizer.nextToken();
                Log.getLog().info("RouteMapEntry: populateInterfaceList() strNxtToken: " + strNxtToken);
                this._intfList.addElement(strNxtToken);
            }
        }
    }

    private void populateNextHopIPAddrList(CmdValues cmdVal) {
        String[] keywords = new String[]{"ip", "next-hop"};
        String[] subCmdValues = ParserUtils.getSubCommandValue(cmdVal, "set", keywords, "nextHopIntfIp");
        if (subCmdValues != null && subCmdValues[0] != null) {
            String strNxtHopIPs = subCmdValues[0].trim();
            StringTokenizer tokenizer = new StringTokenizer(strNxtHopIPs, CLI_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                String strNxtToken = tokenizer.nextToken();
                Log.getLog().info("RouteMapEntry: populateNextHopIPAddrList() strNxtToken: " + strNxtToken);
                this._nxtHopIPAddrList.addElement(strNxtToken);
            }
        }
    }

    private void populateOutputIntfNameList(CmdValues cmdVal) {
        String[] keywords = new String[]{"interface"};
        String[] subCmdValues = ParserUtils.getSubCommandValue(cmdVal, "set", keywords, "outputIntf");
        if (subCmdValues != null) {
            String strOutputIntfNames = subCmdValues[0].trim();
            StringTokenizer tokenizer = new StringTokenizer(strOutputIntfNames, CLI_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                String strNxtToken = tokenizer.nextToken();
                Log.getLog().info("RouteMapEntry: populateOutputIntfNameList() strNxtToken: " + strNxtToken);
                this.addOutputIntfName(strNxtToken);
            }
        }
    }

    public void registerWithACL(DeviceBase device) {
        Vector aclList = this.getACLs();
        if (aclList != null) {
            int count = 0;
            while (count < aclList.size()) {
                ACLCollection aclCollection;
                ACLBase acl;
                String aclName = (String)aclList.elementAt(count);
                if (aclName != null && device != null && (acl = (aclCollection = device.getAcls()).getACL(aclName)) != null) {
                    acl.addToCategory(2);
                }
                ++count;
            }
        }
    }

    public void removeACL(String acl) {
        this._aclList.removeElement(acl);
        this.setModified();
    }

    public void removeAllNxtHopIPAddress() {
        this._nxtHopIPAddrList.removeAllElements();
        this.setModified();
    }

    public void removeAllOutputIntfName() {
        this._outputIntfNameList.removeAllElements();
        this.setModified();
    }

    public void removeInterface(String intf) {
        this._intfList.removeElement(intf);
        this.setModified();
    }

    public void removeNxtHopIPAddress(IPAddress ipaddrNxtHop) {
        String strIPAddr = ipaddrNxtHop.toString();
        this._nxtHopIPAddrList.removeElement(strIPAddr);
        this.setModified();
    }

    public void removeOutputIntfName(String strIntfName) {
        String strLCaseIntfName = strIntfName.toLowerCase();
        boolean bRemElem = this._outputIntfNameList.removeElement(strLCaseIntfName);
        Log.getLog().info("removeOutputIntfName(), strLCaseIntfName: " + strLCaseIntfName + " bRemElem: " + bRemElem);
        this.setModified();
    }

    public void setAction(boolean permit) {
        this._action = permit;
        this.setModified();
    }

    public void setName(String name) {
        this._name = name;
        this.setModified();
    }

    public void setNextHopDHCP(boolean nxtHopDHCP) {
        this._nxtHopDHCP = nxtHopDHCP;
        this.setModified();
    }

    public void setSequenceNumber(int seqNo) {
        this._seqNumber = seqNo;
        this.setModified();
    }
}

