/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.routing;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.XDMEditableVector;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.routing.StaticRoute;
import java.util.Enumeration;
import java.util.Vector;

public class StaticRouteVector
extends XDMEditableVector {
    private IPAddress _defaultGwy;

    public StaticRouteVector() {
    }

    public StaticRouteVector(XDMObject parent) {
        super(parent);
    }

    public Object clone() {
        StaticRouteVector newObj = (StaticRouteVector)super.clone();
        if (this._defaultGwy != null) {
            newObj._defaultGwy = (IPAddress)this._defaultGwy.clone();
        }
        return newObj;
    }

    public void deleteDefaultRoute(IPAddress nextHopIP) {
        if (nextHopIP == null) {
            return;
        }
        Vector defRts = this.getDefaultRoutes();
        if (defRts == null) {
            return;
        }
        int i = 0;
        while (i < defRts.size()) {
            StaticRoute stcRt = (StaticRoute)defRts.elementAt(i);
            IPAddress nxtHop = stcRt.getNextHopIp();
            if (nextHopIP.equals(nxtHop)) {
                super.removeElement(stcRt);
                return;
            }
            ++i;
        }
    }

    public void deleteDefaultRoute(IfID nextHopIntf) {
        if (nextHopIntf == null) {
            return;
        }
        Vector defRts = this.getDefaultRoutes();
        if (defRts == null) {
            return;
        }
        int i = 0;
        while (i < defRts.size()) {
            StaticRoute stcRt = (StaticRoute)defRts.elementAt(i);
            IfID nxtHop = stcRt.getNextHopIntf();
            if (nextHopIntf.equals(nxtHop)) {
                super.removeElement(stcRt);
                return;
            }
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StaticRouteVector)) {
            return false;
        }
        StaticRouteVector tmp = (StaticRouteVector)obj;
        int i = 0;
        while (i < this._vector.size()) {
            StaticRoute obj1 = (StaticRoute)this._vector.elementAt(i);
            if (!tmp.contains(obj1)) {
                return false;
            }
            ++i;
        }
        int j = 0;
        while (j < tmp._vector.size()) {
            StaticRoute obj2 = (StaticRoute)tmp._vector.elementAt(j);
            if (!this._vector.contains(obj2)) {
                return false;
            }
            ++j;
        }
        if (this._defaultGwy == null) {
            if (tmp._defaultGwy != null) {
                return false;
            }
        } else {
            if (tmp._defaultGwy == null) {
                return false;
            }
            if (!this._defaultGwy.equals(tmp._defaultGwy)) {
                return false;
            }
        }
        return true;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        Log log = Log.getLog();
        log.info("StaticRouteVector: generateDelta");
        StaticRouteVector backupObj = (StaticRouteVector)backup;
        super.generateDelta(backup, values);
        if (this._defaultGwy == null) {
            if (backupObj._defaultGwy != null) {
                log.info("StaticRouteVector: generateDelta: generating no ip defaul-gateway command.");
                CmdValues cmdval = new CmdValues("ip");
                cmdval.addValue("default-gateway", "default-gateway");
                cmdval.addValue("defGwy", backupObj._defaultGwy.toString());
                cmdval.setAction(2);
                values.addCmdValues(cmdval);
            }
        } else if (backupObj._defaultGwy == null || !this._defaultGwy.equals(backupObj._defaultGwy)) {
            log.info("StaticRouteVector: generateDelta: generating ip defaul-gateway command");
            CmdValues cmdval = new CmdValues("ip");
            cmdval.addValue("default-gateway", "default-gateway");
            cmdval.addValue("defGwy", this._defaultGwy.toString());
            cmdval.setAction(1);
            values.addCmdValues(cmdval);
        }
    }

    public StaticRoute getDeafaultRoute() {
        Vector defRoutes = this.getDefaultRoutes();
        if (defRoutes != null && defRoutes.size() > 0) {
            return (StaticRoute)defRoutes.elementAt(0);
        }
        return null;
    }

    public IPAddress getDefaultGwy() {
        return this._defaultGwy;
    }

    public Vector getDefaultRoutes() {
        return this.getRoutes(IPAddress.WILD_ANY, Netmask.WILD_MASK);
    }

    public Vector getRoutes(IPAddress prefix, Netmask prefixMask) {
        Vector<StaticRoute> retVal = null;
        Enumeration e = this._vector.elements();
        while (e.hasMoreElements()) {
            StaticRoute elem = (StaticRoute)e.nextElement();
            if (!elem.getPrefix().equals(prefix) || !elem.getMask().equals(prefixMask)) continue;
            Log.getLog().debug("Found route with prefix = " + prefix + " prefix mask " + prefixMask);
            if (retVal == null) {
                retVal = new Vector<StaticRoute>();
            }
            retVal.addElement(elem);
        }
        return retVal;
    }

    public Vector getRoutes(IfID nextHopIntfName) {
        if (nextHopIntfName == null) {
            return null;
        }
        Vector<StaticRoute> retVal = new Vector<StaticRoute>();
        Enumeration e = this._vector.elements();
        while (e.hasMoreElements()) {
            StaticRoute elem = (StaticRoute)e.nextElement();
            if (!nextHopIntfName.equals(elem.getNextHopIntf())) continue;
            retVal.addElement(elem);
        }
        return retVal;
    }

    public boolean isDefaultRouteExists() {
        if (this._defaultGwy != null || this.getDeafaultRoute() != null) {
            Log.getLog().debug("isDeafultRouteExists() returning true");
            return true;
        }
        return false;
    }

    public boolean isDefaultRouteExists(IPAddress nextHopIP) {
        if (nextHopIP == null) {
            return false;
        }
        Vector defRts = this.getDefaultRoutes();
        if (defRts == null) {
            return false;
        }
        int i = 0;
        while (i < defRts.size()) {
            StaticRoute stcRt = (StaticRoute)defRts.elementAt(i);
            IPAddress nxtHop = stcRt.getNextHopIp();
            if (nextHopIP.equals(nxtHop)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isDefaultRouteExists(IfID nextHopIntf) {
        if (nextHopIntf == null) {
            return false;
        }
        Vector defRts = this.getDefaultRoutes();
        if (defRts == null) {
            return false;
        }
        int i = 0;
        while (i < defRts.size()) {
            StaticRoute stcRt = (StaticRoute)defRts.elementAt(i);
            IfID nxtHop = stcRt.getNextHopIntf();
            if (nextHopIntf.equals(nxtHop)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void populate(ConfigValues configValues, CmdValues cmdval) throws XDMException, CliGPBException {
        Log log = Log.getLog();
        log.info("StaticRouteVector: populate");
        int numberOfCmds = configValues.numCmds();
        int i = 0;
        while (i < numberOfCmds) {
            CmdValues eachCmdValue = configValues.getCmdValues(i);
            String cmdName = eachCmdValue.getCmdName();
            if (cmdName.equals("ip")) {
                if (eachCmdValue.containsKey("route")) {
                    StaticRoute entry = new StaticRoute(this);
                    entry.populate(null, eachCmdValue);
                    this._vector.addElement(entry);
                } else if (eachCmdValue.containsKey("default-gateway") && eachCmdValue.containsKey("defGwy")) {
                    this._defaultGwy = new IPAddress(eachCmdValue.getValue("defGwy"));
                    log.info("StaticRouteVector: populate: default-gwy" + this._defaultGwy);
                }
            }
            ++i;
        }
    }

    public void print() {
        Log.getLog().debug("StaticRouteVector: Print()");
        Enumeration e = this._vector.elements();
        while (e.hasMoreElements()) {
            StaticRoute elem = (StaticRoute)e.nextElement();
            elem.print();
        }
        if (this._defaultGwy != null) {
            Log.getLog().debug("StaticRouteVector: DefaultGwy: " + this._defaultGwy);
        }
    }

    public void removeEntries(IfID ifID) {
        Vector associates = this.getRoutes(ifID);
        if (associates != null) {
            Enumeration e = associates.elements();
            while (e.hasMoreElements()) {
                XDMObject obj = (XDMObject)e.nextElement();
                this.removeElement(obj);
            }
        }
    }

    public void setDefaultGwy(IPAddress gwy) {
        this._defaultGwy = gwy;
        this.setModified();
    }
}

