/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.serial;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.serial.ClockSettings;

public class ClockT1Settings
extends ClockSettings {
    public static final int SOURCE_INTERNAL = 1;
    public static final int SOURCE_LINE = 2;
    public static final int DATAENCODING_INVERTED = 1;
    public static final int DATAENCODING_NORMAL = 2;
    public static final int FRAMING_SF = 1;
    public static final int FRAMING_ESF = 2;
    public static final int LBO_15DB = 1;
    public static final int LBO_7_5DB = 2;
    public static final int LBO_NONE = 3;
    public static final int LINECODE_AMI = 1;
    public static final int LINECODE_B8ZS = 2;
    public static final int REMOTELOOPBACK_FULL = 1;
    public static final int REMOTELOOPBACK_ALTERNATE = 2;
    public static final int REMOTELOOPBACK_FULL_ALTERNATE = 3;
    public static final int REMOTELOOPBACK_PAYLOAD = 4;
    public static final int REMOTELOOPBACK_V54 = 8;
    public static final int REMOTELOOPBACK_PAYLOAD_V54 = 12;
    public static final int FDL_ANSI = 1;
    public static final int FDL_ATT = 2;
    public static final int FDL_BOTH = 3;
    public static final int FDL_NONE = 4;
    public static final int DEFAULT_SOURCE = 2;
    public static final int DEFAULT_DATAENCODING = 2;
    public static final int DEFAULT_FRAMING = 2;
    public static final int DEFAULT_LBO = 3;
    public static final int DEFAULT_LINECODE = 2;
    public static final int DEFAULT_REMOTELOOPBACK = 1;
    public static final String DEFAULT_REMOTELOOPBACK_STR = "full";
    public static final int DEFAULT_FDL = 4;
    public static final boolean DEFAULT_REMOTEALARM = false;
    public static final int VALUE_NOT_SET = 0;
    private int _iClockSource = 2;
    private int _iDataCoding = 2;
    private int _iFraming = 2;
    private int _iLbo = 3;
    private int _iLinecode = 2;
    private boolean _bRemoteAlarm = false;
    private int _iRemoteLoopback = 1;
    private int _iFdl = 4;
    private boolean _bAll56k = false;
    private Log _theLog = Log.getLog();

    public ClockT1Settings(XDMObject parent) {
        super("t1", parent);
    }

    public Object clone() {
        ClockT1Settings cs = (ClockT1Settings)super.clone();
        cs._iClockSource = this._iClockSource;
        cs._iDataCoding = this._iDataCoding;
        cs._iFraming = this._iFraming;
        cs._iLbo = this._iLbo;
        cs._iLinecode = this._iLinecode;
        cs._bRemoteAlarm = this._bRemoteAlarm;
        cs._iRemoteLoopback = this._iRemoteLoopback;
        cs._iFdl = this._iFdl;
        return cs;
    }

    private CmdValues createServiceModuleCmd() {
        CmdValues cmd = new CmdValues("service-module");
        cmd.addValue("t1", "t1");
        return cmd;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClockT1Settings) || !super.equals(o)) {
            return false;
        }
        ClockT1Settings cs = (ClockT1Settings)o;
        return cs._iClockSource == this._iClockSource && cs._iDataCoding == this._iDataCoding && cs._iFraming == this._iFraming && cs._iLbo == this._iLbo && cs._iLinecode == this._iLinecode && cs._bRemoteAlarm == this._bRemoteAlarm && cs._iRemoteLoopback == this._iRemoteLoopback && cs._iFdl == this._iFdl;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) {
        String oldFt;
        String ft;
        CmdValues cmd;
        ClockT1Settings oldClock = (ClockT1Settings)backup;
        if (this.equals(oldClock)) {
            return;
        }
        CmdValues fdlCmd = null;
        CmdValues framingCmd = null;
        if (this._iClockSource != oldClock._iClockSource) {
            String oldClType;
            String clType;
            cmd = this.createServiceModuleCmd();
            cmd.addValue("clock", "clock");
            cmd.addValue("source", "source");
            String string = this._iClockSource == 1 ? "internal" : (clType = this._iClockSource == 2 ? "line" : "");
            String string2 = oldClock._iClockSource == 1 ? "internal" : (oldClType = oldClock._iClockSource == 2 ? "line" : "");
            if (clType.equals("")) {
                cmd.setAction(2);
                cmd.addValue("clockType", oldClType);
            } else {
                cmd.setAction(1);
                cmd.addValue("clockType", clType);
            }
            values.addCmdValues(cmd);
        }
        if (this._iDataCoding != oldClock._iDataCoding) {
            String oldDc;
            String dc;
            cmd = this.createServiceModuleCmd();
            cmd.addValue("data-coding", "data-coding");
            String string = this._iDataCoding == 1 ? "inverted" : (dc = this._iDataCoding == 2 ? "normal" : "");
            String string3 = oldClock._iDataCoding == 1 ? "inverted" : (oldDc = oldClock._iDataCoding == 2 ? "normal" : "");
            if (dc.equals("")) {
                cmd.setAction(2);
                cmd.addValue("codingType", oldDc);
            } else {
                cmd.setAction(1);
                cmd.addValue("codingType", dc);
            }
            values.addCmdValues(cmd);
        }
        if (this._iFdl != oldClock._iFdl) {
            cmd = this.createServiceModuleCmd();
            cmd.addValue("fdl", "fdl");
            String string = this._iFdl == 1 ? "ansi" : (this._iFdl == 2 ? "att" : (ft = this._iFdl == 3 ? "both" : ""));
            String string4 = oldClock._iFdl == 1 ? "ansi" : (oldClock._iFdl == 2 ? "att" : (oldFt = oldClock._iFdl == 3 ? "both" : ""));
            if (ft.equals("")) {
                cmd.setAction(2);
                cmd.addValue("fdlType", oldFt);
            } else {
                cmd.setAction(1);
                cmd.addValue("fdlType", ft);
            }
            fdlCmd = cmd;
        }
        if (this._iFraming != oldClock._iFraming) {
            cmd = this.createServiceModuleCmd();
            cmd.addValue("framing", "framing");
            String string = this._iFraming == 1 ? "sf" : (ft = this._iFraming == 2 ? "esf" : "");
            String string5 = oldClock._iFraming == 1 ? "sf" : (oldFt = oldClock._iFraming == 2 ? "esf" : "");
            if (ft.equals("")) {
                cmd.setAction(2);
                cmd.addValue("framingType", oldFt);
            } else {
                cmd.setAction(1);
                cmd.addValue("framingType", ft);
            }
            framingCmd = cmd;
        }
        if (fdlCmd != null && framingCmd != null) {
            if (fdlCmd.getAction() == 2) {
                values.addCmdValues(fdlCmd);
                values.addCmdValues(framingCmd);
            } else {
                values.addCmdValues(framingCmd);
                values.addCmdValues(fdlCmd);
            }
        } else if (fdlCmd != null) {
            values.addCmdValues(fdlCmd);
        } else if (framingCmd != null) {
            values.addCmdValues(framingCmd);
        }
        if (this._iLbo != oldClock._iLbo) {
            String oldLbo;
            String lbo;
            cmd = this.createServiceModuleCmd();
            cmd.addValue("lbo", "lbo");
            String string = this._iLbo == 1 ? "-15db" : (this._iLbo == 2 ? "-7.5db" : (lbo = this._iLbo == 3 ? "none" : ""));
            String string6 = oldClock._iLbo == 1 ? "-15db" : (oldClock._iLbo == 2 ? "-7.5db" : (oldLbo = oldClock._iLbo == 3 ? "none" : ""));
            if (lbo.equals("")) {
                cmd.setAction(2);
                cmd.addValue("lboType", oldLbo);
            } else {
                cmd.setAction(1);
                cmd.addValue("lboType", lbo);
            }
            values.addCmdValues(cmd);
        }
        if (this._iLinecode != oldClock._iLinecode) {
            String oldLc;
            String lc;
            cmd = this.createServiceModuleCmd();
            cmd.addValue("linecode", "linecode");
            String string = this._iLinecode == 1 ? "ami" : (lc = this._iLinecode == 2 ? "b8zs" : "");
            String string7 = oldClock._iLinecode == 1 ? "ami" : (oldLc = oldClock._iLinecode == 2 ? "b8zs" : "");
            if (lc.equals("")) {
                cmd.setAction(2);
                cmd.addValue("lcType", oldLc);
            } else {
                cmd.setAction(1);
                cmd.addValue("lcType", lc);
            }
            values.addCmdValues(cmd);
        }
        if (this._bRemoteAlarm != oldClock._bRemoteAlarm) {
            cmd = this.createServiceModuleCmd();
            cmd.addValue("remote-alarm-enable", "remote-alarm-enable");
            if (this._bRemoteAlarm) {
                cmd.setAction(1);
            } else {
                cmd.setAction(2);
            }
            values.addCmdValues(cmd);
        }
        if (this._iRemoteLoopback != oldClock._iRemoteLoopback) {
            String oldLoopback;
            String loopback;
            CmdValues cmd1 = this.createServiceModuleCmd();
            cmd1.addValue("remote-loopback", "remote-loopback");
            String string = (this._iRemoteLoopback & 1) != 0 ? DEFAULT_REMOTELOOPBACK_STR : (loopback = (this._iRemoteLoopback & 4) != 0 ? "payload" : "");
            String string8 = (oldClock._iRemoteLoopback & 1) != 0 ? DEFAULT_REMOTELOOPBACK_STR : (oldLoopback = (oldClock._iRemoteLoopback & 4) != 0 ? "payload" : "");
            if (loopback.equals("")) {
                cmd1.setAction(2);
                cmd1.addValue("loopbackType", oldLoopback);
                if (!oldLoopback.equals(DEFAULT_REMOTELOOPBACK_STR)) {
                    CmdValues cmd2 = this.createServiceModuleCmd();
                    cmd2.addValue("remote-loopback", "remote-loopback");
                    cmd2.setAction(2);
                    cmd2.addValue("loopbackType", DEFAULT_REMOTELOOPBACK_STR);
                    values.addCmdValues(cmd2);
                }
            } else {
                cmd1.setAction(1);
                cmd1.addValue("loopbackType", loopback);
                if ((this._iRemoteLoopback & 2) != 0) {
                    cmd1.addValue("alternate", "alternate");
                }
                if ((this._iRemoteLoopback & 8) != 0) {
                    cmd1.addValue("v54", "v54");
                }
                if (oldLoopback.equals("payload") && loopback.equals(DEFAULT_REMOTELOOPBACK_STR)) {
                    CmdValues cmd2 = this.createServiceModuleCmd();
                    cmd2.addValue("remote-loopback", "remote-loopback");
                    cmd2.setAction(2);
                    cmd2.addValue("loopbackType", oldLoopback);
                    values.addCmdValues(cmd2);
                }
            }
            values.addCmdValues(cmd1);
        }
    }

    public boolean getAll56k() {
        return this._bAll56k;
    }

    public int getClockSource() {
        return this._iClockSource;
    }

    public int getDataCoding() {
        return this._iDataCoding;
    }

    public int getFdl() {
        return this._iFdl;
    }

    public int getFraming() {
        return this._iFraming;
    }

    public int getLbo() {
        return this._iLbo;
    }

    public int getLinecode() {
        return this._iLinecode;
    }

    public boolean getRemoteAlarm() {
        return this._bRemoteAlarm;
    }

    public int getRemoteLoopback() {
        return this._iRemoteLoopback;
    }

    public void populate(ConfigValues config, CmdValues cmdVals) {
        block41: {
            ConfigValues svt1Cmds;
            ConfigValues cmds = cmdVals.getModeCmdsValues();
            try {
                svt1Cmds = cmds.getCmds("service-module", "t1", ".*", false);
            }
            catch (CliGPBException e) {
                this._theLog.error("Parser exception");
                e.printStackTrace();
                return;
            }
            if (svt1Cmds == null) break block41;
            int i = 0;
            while (i < svt1Cmds.numCmds()) {
                block43: {
                    String lineSpeed;
                    CmdValues cv;
                    block42: {
                        cv = svt1Cmds.getCmdValues(i);
                        if (cv.containsKey("clock")) {
                            String clockType = cv.getValue("clockType");
                            if (clockType.equals("internal")) {
                                this._iClockSource = 1;
                            } else if (clockType.equals("line")) {
                                this._iClockSource = 2;
                            }
                        }
                        if (cv.containsKey("data-coding")) {
                            String codingType = cv.getValue("codingType");
                            if (codingType.equals("inverted")) {
                                this._iDataCoding = 1;
                            } else if (codingType.equals("normal")) {
                                this._iDataCoding = 2;
                            }
                        }
                        if (cv.containsKey("fdl")) {
                            String fdlType = cv.getValue("fdlType");
                            if (fdlType.equals("ansi")) {
                                this._iFdl = 1;
                            } else if (fdlType.equals("att")) {
                                this._iFdl = 2;
                            } else if (fdlType.equals("both")) {
                                this._iFdl = 3;
                            }
                        }
                        if (cv.containsKey("framing")) {
                            String framingType = cv.getValue("framingType");
                            if (framingType.equals("esf")) {
                                this._iFraming = 2;
                            } else if (framingType.equals("sf")) {
                                this._iFraming = 1;
                            }
                        }
                        if (cv.containsKey("lbo")) {
                            String lboType = cv.getValue("lboType");
                            if (lboType.equals("-15db")) {
                                this._iLbo = 1;
                            } else if (lboType.equals("-7.5db")) {
                                this._iLbo = 2;
                            } else if (lboType.equals("none")) {
                                this._iLbo = 3;
                            }
                        }
                        if (cv.containsKey("linecode")) {
                            String lcType = cv.getValue("lcType");
                            if (lcType.equals("ami")) {
                                this._iLinecode = 1;
                            } else if (lcType.equals("b8zs")) {
                                this._iLinecode = 2;
                            }
                        }
                        if (cv.containsKey("remote-alarm-enable")) {
                            this._bRemoteAlarm = cv.isNoCmd() ^ true;
                        }
                        if (!cv.containsKey("remote-loopback")) break block42;
                        String loopbackType = cv.getValue("loopbackType");
                        this._iRemoteLoopback = 0;
                        if (cv.isNoCmd()) break block43;
                        if (loopbackType.equals(DEFAULT_REMOTELOOPBACK_STR)) {
                            this._iRemoteLoopback |= 1;
                        } else if (loopbackType.equals("payload")) {
                            this._iRemoteLoopback |= 4;
                        }
                        if (cv.containsKey("alternate")) {
                            this._iRemoteLoopback |= 2;
                        }
                        if (cv.containsKey("v54")) {
                            this._iRemoteLoopback |= 8;
                        }
                    }
                    if (cv.containsKey("timeslots") && cv.containsKey("all") && cv.containsKey("speed") && (lineSpeed = cv.getValue("lineSpeed")).equals("56")) {
                        this._bAll56k = true;
                    }
                }
                ++i;
            }
        }
    }

    public void resetDefaultValues() {
        this.setClockSource(2);
        this.setDataCoding(2);
        this.setFraming(2);
        this.setLbo(3);
        this.setFdl(4);
        this.setLinecode(2);
        this.setRemoteLoopback(1);
        this.setRemoteAlarm(false);
    }

    public void setClockSource(int clocksource) {
        this.setModified();
        this._iClockSource = clocksource;
    }

    public void setDataCoding(int datacoding) {
        this.setModified();
        this._iDataCoding = datacoding;
    }

    public void setFdl(int fdl) {
        this.setModified();
        this._iFdl = fdl;
    }

    public void setFraming(int framing) {
        this.setModified();
        this._iFraming = framing;
    }

    public void setLbo(int lbo) {
        this.setModified();
        this._iLbo = lbo;
    }

    public void setLinecode(int linecode) {
        this.setModified();
        this._iLinecode = linecode;
    }

    public void setRemoteAlarm(boolean remotealarm) {
        this.setModified();
        this._bRemoteAlarm = remotealarm;
    }

    public void setRemoteLoopback(int remoteloopback) {
        this.setModified();
        this._iRemoteLoopback = remoteloopback;
    }

    public String toString() {
        String[] sourceStrs = new String[]{"not set", "internal", "line"};
        String[] encodingStrs = new String[]{"not set", "inverted", "normal"};
        String[] framingStrs = new String[]{"not set", "sf", "esf"};
        String[] lboStrs = new String[]{"not set", "-15db", "-7.5db", "none"};
        String[] linecodeStrs = new String[]{"not set", "ami", "b8zs"};
        String[] fdlStrs = new String[]{"not set", "ansi", "att", "both", "none"};
        StringBuffer remoteLB = new StringBuffer();
        if ((this._iRemoteLoopback & 1) != 0) {
            remoteLB.append("full ");
        }
        if ((this._iRemoteLoopback & 2) != 0) {
            remoteLB.append("alternate ");
        }
        if ((this._iRemoteLoopback & 4) != 0) {
            remoteLB.append("payload ");
        }
        if ((this._iRemoteLoopback & 8) != 0) {
            remoteLB.append("v54 ");
        }
        String remoteLBStr = new String(remoteLB).trim();
        return "ClockT1Settings:{source:" + sourceStrs[this._iClockSource] + "#encoding:" + encodingStrs[this._iDataCoding] + "#framing:" + framingStrs[this._iFraming] + "#lbo:" + lboStrs[this._iLbo] + "#linecode:" + linecodeStrs[this._iLinecode] + "#fdl:" + fdlStrs[this._iFdl] + "#alarm:" + (this._bRemoteAlarm ? "true" : "false") + "#loopback:" + remoteLBStr + "}";
    }
}

