/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.serial;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.authentication.PPPAuthentication;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.serial.EncapsulationType;

public class EncapsulationPPP
extends EncapsulationType {
    private PPPAuthentication _authPPP = new PPPAuthentication(this);

    public EncapsulationPPP(XDMObject parent) {
        super("ppp", parent);
    }

    public Object clone() {
        EncapsulationPPP encap = (EncapsulationPPP)super.clone();
        encap._authPPP = (PPPAuthentication)this._authPPP.clone();
        return encap;
    }

    public boolean equals(Object o) {
        if (!(o instanceof EncapsulationPPP) || !super.equals(o)) {
            return false;
        }
        EncapsulationPPP encap = (EncapsulationPPP)o;
        return this._authPPP.equals(encap._authPPP);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) {
        EncapsulationType backupEncap = (EncapsulationType)backup;
        if (this.equals(backupEncap)) {
            return;
        }
        super.generateDelta(backup, values);
        if (backup == null || !this.getEncapsulation().equals(((EncapsulationType)backup).getEncapsulation())) {
            CmdValues cmd = new CmdValues("encapsulation");
            cmd.addValue("encapType", "ppp");
            values.addCmdValues(cmd);
        }
        PPPAuthentication backupAuth = null;
        if (backupEncap instanceof EncapsulationPPP) {
            backupAuth = ((EncapsulationPPP)backupEncap)._authPPP;
        }
        try {
            if (this._authPPP.isModified() && !this._authPPP.equals(backupAuth)) {
                this._authPPP.generateDelta(backupAuth, values);
            }
        }
        catch (XDMException xDMException) {
            Log.getLog().debug("PPPAuthentication.generateDelta exception");
        }
    }

    public PPPAuthentication getPPPAuthentication() {
        return this._authPPP;
    }

    public void populate(ConfigValues config, CmdValues cmdVals) throws XDMException, CliGPBException {
        ConfigValues cv = cmdVals.getModeCmdsValues();
        this._authPPP.populate(cv, null);
        ConfigValues multiCmd = cv.getCmds("ppp", "multilink", ".*", false);
        if (multiCmd != null && multiCmd.numCmds() > 0) {
            this.setReadOnly(true);
        }
    }

    protected int removeSubCommands(EncapsulationType encap, ConfigValues cv, int pos) {
        PPPAuthentication nullAuth = new PPPAuthentication(encap);
        ConfigValues cvTmp = new ConfigValues();
        try {
            nullAuth.setProtocolNames(null);
            nullAuth.generateDelta(this._authPPP, cvTmp);
        }
        catch (XDMException xDMException) {
            Log.getLog().debug("PPPAuthentication.generateDelta exception");
        }
        int i = 0;
        while (i < cvTmp.numCmds()) {
            CmdValues cmd = cvTmp.getCmdValues(i);
            cv.insertCmdValues(cmd, pos + i);
            ++i;
        }
        return cvTmp.numCmds();
    }

    public void setPPPAuthentication(PPPAuthentication pppAuth) {
        this._authPPP = pppAuth == null ? new PPPAuthentication(this) : pppAuth;
    }

    public String toString() {
        return "EncapsulationPPP:{" + (this._authPPP == null ? "null" : this._authPPP.toString()) + "}";
    }
}

