/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.serial;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.serial.EncapsulationData;
import com.cisco.xdm.data.serial.EncapsulationFR;
import com.cisco.xdm.data.serial.EncapsulationType;
import com.cisco.xdm.data.serial.SerialInterface;
import com.cisco.xdm.data.serial.SerialSubInterface;

public class FRData
extends EncapsulationData {
    private int _iDlci = 0;
    private boolean _bIetf;

    public FRData(XDMObject parent) {
        super(parent);
    }

    public Object clone() {
        FRData data = (FRData)super.clone();
        data._iDlci = this._iDlci;
        data._bIetf = this._bIetf;
        return data;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FRData) || !super.equals(o)) {
            return false;
        }
        FRData data = (FRData)o;
        return data._iDlci == this._iDlci && data._bIetf == this._bIetf;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) {
        CmdValues cmd;
        EncapsulationData backupData = (EncapsulationData)backup;
        if (this.equals(backupData)) {
            return;
        }
        FRData backupFR = null;
        if (backupData instanceof FRData) {
            backupFR = (FRData)backupData;
        }
        if (this._iDlci != 0 && backupFR == null) {
            cmd = this.makeCmd(this);
            values.addCmdValues(cmd);
        }
        if (this._iDlci != 0 && backupFR != null && (this._iDlci != backupFR._iDlci || this._bIetf != backupFR._bIetf)) {
            cmd = null;
            if (backupFR._iDlci != 0) {
                cmd = this.makeCmd(backupFR);
                cmd.setAction(2);
                values.addCmdValues(cmd);
            }
            cmd = this.makeCmd(this);
            values.addCmdValues(cmd);
        }
    }

    public int getDLCI() {
        return this._iDlci;
    }

    public boolean getIETF() {
        Log.getLog().debug("getIETF:" + this._bIetf);
        return this._bIetf;
    }

    private boolean inheritedIETF() {
        EncapsulationType encap;
        SerialInterface serif;
        SerialSubInterface subif = (SerialSubInterface)this.getParent();
        if (subif != null && (serif = (SerialInterface)subif.getMainInterface()) != null && (encap = serif.getEncapsulationType()) instanceof EncapsulationFR) {
            return ((EncapsulationFR)encap).getIETF();
        }
        return false;
    }

    private CmdValues makeCmd(FRData frd) {
        CmdValues cmd = new CmdValues("frame-relay");
        cmd.addValue("interface-dlci", "interface-dlci");
        cmd.addValue("dlci", Integer.toString(frd._iDlci));
        if (frd._bIetf) {
            cmd.addValue("encapType", "IETF");
        } else {
            cmd.addValue("encapType", "CISCO");
        }
        return cmd;
    }

    public void populate(ConfigValues config, CmdValues values) throws CliGPBException {
        ConfigValues frDLCICmd;
        ConfigValues cmds = values.getModeCmdsValues();
        ConfigValues frPriorityCmd = cmds.getCmds("frame-relay", "priority-dlci-group", ".*", false);
        if (frPriorityCmd != null && frPriorityCmd.numCmds() > 0) {
            this.setReadOnly(true);
        }
        if ((frDLCICmd = cmds.getCmds("frame-relay", "interface-dlci", ".*", false)) != null) {
            CmdValues cv = frDLCICmd.getCmdValues(0);
            String dlci = cv.getValue("dlci");
            this._iDlci = Integer.parseInt(dlci);
            String encapType = cv.getValue("encapType");
            if (encapType == null) {
                this._bIetf = this.inheritedIETF();
            } else if ((encapType = encapType.toUpperCase()).equals("CISCO")) {
                this._bIetf = false;
            } else if (encapType.equals("IETF")) {
                this._bIetf = true;
            }
            if (cv.containsKey("ppp")) {
                this.setReadOnly(true);
            }
            if (cv.containsKey("protocol")) {
                this.setReadOnly(true);
            }
            if (cv.containsKey("switched")) {
                this.setReadOnly(true);
            }
        }
    }

    public void setDLCI(int dlci) throws XDMException {
        Log.getLog().debug("Setting dlci:" + dlci);
        if (dlci < 16 && dlci > 1007) {
            throw new XDMException(201, this);
        }
        this.setModified();
        this._iDlci = dlci;
    }

    public void setIETF(boolean bIetf) {
        this.setModified();
        this._bIetf = bIetf;
        Log.getLog().debug("setIETF:" + bIetf);
    }

    public String toString() {
        return "FRData:{dlci:" + Integer.toString(this._iDlci) + "}";
    }
}

