/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.serial;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddressType;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.IfIPAddress;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.serial.ClockSettings;
import com.cisco.xdm.data.serial.ClockT1Settings;
import com.cisco.xdm.data.serial.EncapsulationFR;
import com.cisco.xdm.data.serial.EncapsulationHDLC;
import com.cisco.xdm.data.serial.EncapsulationOther;
import com.cisco.xdm.data.serial.EncapsulationPPP;
import com.cisco.xdm.data.serial.EncapsulationType;

public class SerialInterface
extends XDMInterface {
    static final String KEY_SHUTDOWN = "shutdown";
    private EncapsulationType _encapsulation;
    private ClockSettings _clockParms;
    private Log _theLog;

    public SerialInterface(IfID id) {
        super(id);
        this._clockParms = id.getType() == 502 ? new ClockT1Settings(this) : null;
        this.setFeatures();
        this._encapsulation = null;
        this._theLog = Log.getLog();
    }

    public boolean canSubIf() {
        return this._encapsulation == null || this._encapsulation instanceof EncapsulationOther || this._encapsulation instanceof EncapsulationHDLC || this._encapsulation instanceof EncapsulationFR;
    }

    public Object clone() {
        SerialInterface ser = (SerialInterface)super.clone();
        ser._clockParms = (ClockSettings)(this._clockParms == null ? null : this._clockParms.clone());
        ser._encapsulation = this._encapsulation == null ? null : (EncapsulationType)this._encapsulation.clone();
        return ser;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SerialInterface) || !super.equals(o)) {
            return false;
        }
        SerialInterface ser = (SerialInterface)o;
        return (this._encapsulation == null && ser._encapsulation == null || this._encapsulation != null && this._encapsulation.equals(ser._encapsulation)) && (this._clockParms == null && ser._clockParms == null || this._clockParms != null && this._clockParms.equals(ser._clockParms));
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
        boolean bShut;
        EncapsulationType backupEncap = ((SerialInterface)backup)._encapsulation;
        if (cmdVal.getModeCmdsValues() == null) {
            cmdVal.setModeCmdsValues(new ConfigValues());
        }
        ConfigValues subvals = cmdVal.getModeCmdsValues();
        if (this._clockParms != null) {
            ClockSettings backupClock = ((SerialInterface)backup)._clockParms;
            this._clockParms.generateDelta(backupClock, subvals);
        }
        boolean bl = bShut = this._encapsulation == null && backupEncap != null || this._encapsulation != null && backupEncap != null && !this._encapsulation.getEncapsulation().equals(backupEncap.getEncapsulation());
        if (bShut) {
            int pos = -1;
            pos = 0;
            while (pos < subvals.numCmds()) {
                CmdValues checkCmd = subvals.getCmdValues(pos);
                String cmdName = checkCmd.getCmdName();
                if (cmdName.compareTo(KEY_SHUTDOWN) == 0 && checkCmd.getAction() == 1) break;
                ++pos;
            }
            CmdValues cmd = null;
            if (pos == subvals.numCmds()) {
                cmd = new CmdValues(KEY_SHUTDOWN);
                subvals.insertCmdValues(cmd, 0);
                pos = 1;
            } else {
                ++pos;
            }
            int nCmds = backupEncap.removeSubCommands(null, subvals, pos);
            cmd = new CmdValues("encapsulation");
            cmd.addValue("encapType", backupEncap.getEncapsulation());
            cmd.setAction(2);
            subvals.insertCmdValues(cmd, pos + nCmds);
        }
        if (this._encapsulation != null) {
            this._encapsulation.generateDelta(backupEncap, subvals);
            if (bShut && !this.isShutdown()) {
                CmdValues cmd = new CmdValues(KEY_SHUTDOWN);
                cmd.setAction(2);
                subvals.addCmdValues(cmd);
                bShut = false;
            }
        }
    }

    public ClockSettings getClockSettings() {
        return this._clockParms;
    }

    public EncapsulationType getEncapsulationType() {
        return this._encapsulation;
    }

    public boolean isConfigured() {
        boolean bCfg = (this._encapsulation == null || this._encapsulation instanceof EncapsulationHDLC || this._encapsulation instanceof EncapsulationPPP) && this.getIpAddr() != null || this._encapsulation instanceof EncapsulationFR && (this.getIpAddr() != null || ((EncapsulationFR)this._encapsulation).getDLCI() != 0);
        return bCfg;
    }

    public boolean isReset() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        DeviceBase backupDev = dev.getBackup();
        if (backupDev != null && this.getEncapsulationType() instanceof EncapsulationPPP) {
            SerialInterface backupIf = (SerialInterface)backupDev.getIfs().getIfFromString(this.getIfID().toString());
            this._theLog.debug("isReset backup interface:" + backupIf);
            if (backupIf != null) {
                IfIPAddress _ipAddr = this.getIpAddr();
                IfIPAddress _backupIpAddr = backupIf.getIpAddr();
                if (_ipAddr != null && _ipAddr.getIPAddressType() == IPAddressType.NEGOTIATED && _backupIpAddr != null && _backupIpAddr.getIPAddressType() != IPAddressType.NEGOTIATED) {
                    this._theLog.debug("SerialInterface.isReset returning true");
                    return true;
                }
            }
        }
        boolean b = super.isReset();
        this._theLog.debug("SerialInterface.isReset returning " + b + " from base class");
        return b;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        CmdValues cv;
        String physicalType;
        ConfigValues layerCmd;
        super.populate(config, cmdVal);
        ConfigValues cmds = cmdVal.getModeCmdsValues();
        ConfigValues encapCmd = cmds.getCmds("encapsulation", ".*", ".*", false);
        if (encapCmd == null) {
            this._encapsulation = null;
        } else {
            CmdValues cv2 = encapCmd.getCmdValues(0);
            if (cv2.containsKey("encapType")) {
                String eType = cv2.getValue("encapType");
                if (eType.equals("hdlc")) {
                    this._encapsulation = new EncapsulationHDLC(this);
                    this.setConfigurable(true);
                } else if (eType.equals("ppp")) {
                    this._encapsulation = new EncapsulationPPP(this);
                    this.setConfigurable(true);
                    this._encapsulation.populate(config, cmdVal);
                    if (this._encapsulation.isReadOnly()) {
                        this.setConfigurable(false);
                    }
                } else if (eType.equals("frame-relay")) {
                    this._encapsulation = new EncapsulationFR(this, cv2.containsKey("IETF"));
                    this.setConfigurable(true);
                    this._encapsulation.populate(config, cmdVal);
                    if (cv2.containsKey("MFR")) {
                        this.setConfigurable(false);
                    }
                }
            } else if (cv2.containsKey("otherType")) {
                this._encapsulation = new EncapsulationOther(cv2.getValue("otherType"), this);
                this.setConfigurable(false);
            } else {
                throw new XDMException(9999);
            }
        }
        if (this._clockParms != null) {
            this._clockParms.populate(config, cmdVal);
        }
        if (this._encapsulation instanceof EncapsulationFR && this.getIpAddr() != null) {
            this.setConfigurable(false);
        }
        if (this.getIfID().getType() == 508) {
            this.setConfigurable(false);
        }
        if ((layerCmd = cmds.getCmds("physical-layer", ".*", ".*", false)) != null && layerCmd.numCmds() > 0 && (physicalType = (cv = layerCmd.getCmdValues(0)).getValue("physicalType")) != null && physicalType.equals("async")) {
            this.setConfigurable(false);
        }
        if ((this._encapsulation == null || this._encapsulation instanceof EncapsulationHDLC) && this.getIpAddr() != null && this.getIpAddr().getIPAddressType() == IPAddressType.NEGOTIATED) {
            this.setConfigurable(false);
        }
    }

    public void setEncapsulationType(EncapsulationType encap) throws XDMException {
        this._theLog.debug("Setting encapsulation:" + encap);
        this._encapsulation = encap;
        this.setConfigurable(encap == null || !(encap instanceof EncapsulationOther));
        this.setModified();
        if (encap != null) {
            encap.setParent(this);
        }
    }

    private void setFeatures() {
        this.setSupport(2, 1);
        this.setSupport(4, 1);
        this.setSupport(1, 1);
        this.setSupport(0, 1);
        this.setSupport(3, 1);
        this.setSupport(5, 1);
        this.setSupport(6, 1);
        this.setSupport(19, 1);
    }

    public String toString() {
        return "SerialInterface:{" + (this._clockParms == null ? "null" : this._clockParms.toString()) + "#" + (this._encapsulation == null ? "null" : this._encapsulation.toString()) + "}";
    }
}

