/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.serial;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMSubInterface;
import com.cisco.xdm.data.serial.EncapsulationData;
import com.cisco.xdm.data.serial.EncapsulationFR;
import com.cisco.xdm.data.serial.FRData;
import com.cisco.xdm.data.serial.SerialInterface;

public class SerialSubInterface
extends XDMSubInterface {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_MULTIPOINT = 1;
    public static final int TYPE_POINT_TO_POINT = 2;
    private static final String[] printStrs = new String[]{"unknown", "multipoint", "point-to-point"};
    private EncapsulationData _encapData;
    private int _iConnType = 0;
    private Log _theLog;

    public SerialSubInterface(IfID ifID, XDMInterface mainIf) {
        super(ifID, mainIf);
        SerialInterface serif = (SerialInterface)mainIf;
        if (serif != null && serif.getEncapsulationType() instanceof EncapsulationFR) {
            this._encapData = new FRData(this);
            this._iConnType = 2;
        }
        this.setConfigurable(this._encapData instanceof FRData);
        this.setFeatures(this._encapData instanceof FRData);
        this._theLog = Log.getLog();
    }

    public Object clone() {
        SerialSubInterface sub = (SerialSubInterface)super.clone();
        sub._iConnType = this._iConnType;
        sub._encapData = (EncapsulationData)(this._encapData == null ? null : this._encapData.clone());
        return sub;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SerialSubInterface) || !super.equals(o)) {
            return false;
        }
        SerialSubInterface sub = (SerialSubInterface)o;
        return sub._iConnType == this._iConnType && (this._encapData == null && sub._encapData == null || this._encapData != null && this._encapData.equals(sub._encapData));
    }

    protected void generateDeltaByThisIf(XDMObject backup, CmdValues cmdVal) throws XDMException {
        if (this.isBackup()) {
            return;
        }
        boolean bFR = ((SerialInterface)this.getMainInterface()).getEncapsulationType() instanceof EncapsulationFR;
        if (bFR) {
            if (this._iConnType == 2) {
                cmdVal.addValue("param1", "point-to-point");
            } else if (this._iConnType == 1) {
                cmdVal.addValue("param1", "multipoint");
            }
        }
        if (this._encapData != null) {
            EncapsulationData backupData = backup == null ? null : ((SerialSubInterface)backup)._encapData;
            ConfigValues modecv = cmdVal.getModeCmdsValues();
            if (modecv == null) {
                modecv = new ConfigValues();
                cmdVal.setModeCmdsValues(modecv);
            }
            this._encapData.generateDelta(backupData, modecv);
        }
    }

    public int getConnectionType() {
        return this._iConnType;
    }

    public EncapsulationData getEncapsulationData() {
        return this._encapData;
    }

    public boolean isConfigured() {
        boolean bCfg = this.getIpAddr() != null && this._encapData instanceof FRData && ((FRData)this._encapData).getDLCI() != 0 || this._iConnType == 1;
        return bCfg;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        super.populate(config, cmdVal);
        if (cmdVal.containsKey("param1")) {
            String connType = cmdVal.getValue("param1");
            if (connType.equals("point-to-point")) {
                this._iConnType = 2;
                this.setSupport(12, 0);
            } else if (connType.equals("multipoint")) {
                this.setConfigurable(false);
                this._iConnType = 1;
            }
        } else {
            this._iConnType = 2;
        }
        this._encapData = ((SerialInterface)this.getMainInterface()).getEncapsulationType() instanceof EncapsulationFR ? new FRData(this) : null;
        if (this._encapData != null) {
            this._encapData.populate(config, cmdVal);
        }
        this.setConfigurable(this._encapData instanceof FRData && this._iConnType == 2 && !this._encapData.isReadOnly());
        if (this._encapData instanceof FRData) {
            this.setSupport(12, 0);
        }
    }

    public void setConnectionType(int connType) throws XDMException {
        if (connType != 1 && connType != 2) {
            throw new XDMException(203, this);
        }
        this.setModified();
        this._iConnType = connType;
    }

    private void setFeatures(boolean bIsFrameRelay) {
        this.setSupport(2, 1);
        this.setSupport(4, 1);
        this.setSupport(1, 1);
        this.setSupport(0, 1);
        this.setSupport(3, 1);
        this.setSupport(5, 1);
        this.setSupport(6, 1);
        this.setSupport(19, 1);
        if (bIsFrameRelay) {
            this.setSupport(12, 0);
        }
    }

    public String toString() {
        return "SerialSubInterface:{" + (this._encapData == null ? "null" : this._encapData.toString()) + "#" + printStrs[this._iConnType] + "}";
    }
}

