/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.systemproperties;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.systemproperties.PAMBaseEntry;

public class PAMEntry
extends PAMBaseEntry {
    int[] ports;

    public PAMEntry() {
    }

    public PAMEntry(XDMObject parent, String protocol, String layer4Protocol, int[] ports, int list) {
        super(parent, protocol, layer4Protocol, list);
        this.ports = ports;
    }

    public CmdValues createPAMEntry() {
        CmdValues cmd = new CmdValues("ip");
        cmd.addValue("port-map", "port-map");
        cmd.addValue("portmapprot", this.getProtocol());
        cmd.addValue("port", "port");
        if (this.getL4Protocol() != null && this.getL4Protocol().length() > 0) {
            cmd.addValue("l4prot", this.getL4Protocol());
        }
        int i = 0;
        while (i < this.ports.length) {
            cmd.addValue("portnumber", Integer.toString(this.ports[i]));
            ++i;
        }
        if (this.list != -1) {
            cmd.addValue("list", "list");
            cmd.addValue("portmaplist", Integer.toString(this.getList()));
        }
        if (this.description != null && this.description.length() > 0) {
            cmd.addValue("description", "description");
            cmd.addValue("desc", this.getDescription());
        }
        return cmd;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PAMEntry)) {
            return false;
        }
        PAMEntry entry = (PAMEntry)o;
        boolean isPortsEqual = true;
        if (this.ports.length != entry.ports.length) {
            return false;
        }
        int i = 0;
        while (i < this.ports.length) {
            isPortsEqual = isPortsEqual && this.ports[i] == entry.ports[i];
            ++i;
        }
        return isPortsEqual && super.equals(o);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        CmdValues cmd = this.createPAMEntry();
        if (this.isBackup()) {
            cmd.setAction(2);
        } else {
            cmd.setAction(1);
        }
        values.addCmdValues(cmd);
    }

    public int[] getPortNumbers() {
        return this.ports;
    }

    public String getPorts() {
        StringBuffer sbPorts = new StringBuffer();
        int i = 0;
        while (i < this.ports.length) {
            sbPorts.append("," + this.ports[i]);
            ++i;
        }
        return sbPorts.toString().substring(1);
    }

    public boolean isEntryWithRange() {
        return false;
    }

    public boolean isExists(int port) {
        int i = 0;
        while (i < this.ports.length) {
            if (port == this.ports[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        String sPorts = "";
        int i = 0;
        while (i < this.ports.length) {
            sPorts = String.valueOf(sPorts) + this.ports[i];
            ++i;
        }
        return String.valueOf(super.toString()) + sPorts;
    }
}

