/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.systemproperties;

import com.cisco.xdm.data.systemproperties.PAMCommonEntry;

public class PAMSysDefinedEntry
implements PAMCommonEntry {
    String protocolName;
    String layer4Protocol;
    String port;
    int type;
    String description = "";
    public static final int SYSTEM_DEFINED = 0;
    public static final int USER_DEFINED = 1;

    public PAMSysDefinedEntry() {
    }

    public PAMSysDefinedEntry(String protocolName, String port) {
        this.protocolName = protocolName;
        this.port = port;
    }

    public PAMSysDefinedEntry(String protocolName, String layer4Protocol, String port, int type) {
        this.protocolName = protocolName;
        this.layer4Protocol = layer4Protocol;
        this.port = port;
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public int getEndingPort() {
        int endPort;
        block2: {
            endPort = -1;
            if (!this.isEntryWithRange()) break block2;
            try {
                endPort = Integer.parseInt(this.port.substring(this.port.lastIndexOf("-") + 1));
            }
            catch (Exception e) {
                e.printStackTrace();
                endPort = -1;
            }
        }
        return endPort;
    }

    public String getL4Protocol() {
        return this.layer4Protocol;
    }

    public int getList() {
        return -1;
    }

    public String getPorts() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocolName;
    }

    public int getStartingPort() {
        int stPort;
        block2: {
            stPort = -1;
            if (!this.isEntryWithRange()) break block2;
            try {
                stPort = Integer.parseInt(this.port.substring(0, this.port.indexOf("-")));
            }
            catch (Exception e) {
                e.printStackTrace();
                stPort = -1;
            }
        }
        return stPort;
    }

    public int getType() {
        return this.type;
    }

    public boolean isEntryWithRange() {
        return this.port != null && this.port.indexOf(45) != -1;
    }

    public boolean isEntryWithSequence() {
        return this.port != null && this.port.indexOf(44) != -1;
    }

    public boolean isEntryWithUnknownSequence() {
        return this.port != null && this.port.indexOf("...") != -1;
    }

    public boolean isGroup() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLayer4Protocol(String layer4Protocol) {
        this.layer4Protocol = layer4Protocol;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setProtocolName(String protocolName) {
        this.protocolName = protocolName;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String toString() {
        return String.valueOf(this.protocolName) + "##" + this.layer4Protocol + "##" + this.port + "##";
    }
}

