/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.systemproperties;

import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.systemproperties.PAM;
import com.cisco.xdm.data.systemproperties.PAMParse;
import com.cisco.xdm.data.systemproperties.PAMSysDefinedEntry;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PAMSystemDefinedCollection {
    Hashtable htPAMSysEntries;
    Hashtable htPAMGroupedEntries = new Hashtable();
    Hashtable htFileEntries;
    Vector vctPAMGroupedEntries;
    Hashtable htPorts;
    String cmdOutput;
    String discoveredProt;
    public static final String SH_PAM = "show ip port-map | include system defined";
    public static final String SH_PAM_HELP = "show ip port-map ?";
    public static final String SH_PAM_DET = "show ip port-map";
    PAMSysDefinedEntry pamSysEntry;
    DeviceBase _device;
    Vector protocolNames;

    public PAMSystemDefinedCollection(DeviceBase _device) {
        this._device = _device;
        this.vctPAMGroupedEntries = _device.getSystemProp().getPAM().getGroupEntries();
    }

    public PAMSystemDefinedCollection(String cmdOutput) {
        this.cmdOutput = cmdOutput;
    }

    public void addSysEntry(String key, PAMSysDefinedEntry sysEntry) {
        this.htPAMSysEntries.put(key, sysEntry);
        if (this.htPorts != null) {
            this.htPorts.put(String.valueOf(sysEntry.getL4Protocol()) + "," + sysEntry.getPorts(), sysEntry);
        }
    }

    public void discoverProtocols() {
        String[] cli = new String[]{SH_PAM_HELP};
        try {
            IOSCmdService cmdService = this._device.getDevInfoBase().getComm();
            String[] cmds = new String[]{SH_PAM_HELP};
            IOSCmdResponse[] cmdResponse = cmdService.exec(cmds);
            if (cmdResponse[0].getStatus() == 1 || cmdResponse[0].getStatus() == 0) {
                this.discoveredProt = cmdResponse[0].getOutput();
            }
            this.discoveredProt = PAMSystemDefinedCollection.removeCmdFromCliOutput(this.discoveredProt, SH_PAM_HELP);
        }
        catch (IOSCmdServiceException iosException) {
            iosException.printStackTrace();
        }
    }

    public Vector getDiscoveredProtocols() {
        Vector<String> protocols = new Vector<String>();
        StringTokenizer tknProtocols = new StringTokenizer(this.discoveredProt, "\n");
        while (tknProtocols.hasMoreTokens()) {
            String tknEntry = tknProtocols.nextToken();
            String protocol = tknEntry.trim();
            int endIndex = protocol.indexOf(32);
            protocol = endIndex != -1 ? protocol.substring(0, endIndex) : protocol.substring(0);
            if (protocol.equals("|") || protocol.equals("<cr>") || protocol.indexOf("user-") != -1 || protocol.trim().length() == 0) continue;
            protocols.addElement(protocol);
        }
        return protocols;
    }

    public PAMSysDefinedEntry getEntry(String key) {
        if (this.htPAMSysEntries == null) {
            return null;
        }
        return (PAMSysDefinedEntry)this.htPAMSysEntries.get(key);
    }

    public int getEntryCount() {
        return this.htPAMSysEntries.size();
    }

    public PAMSysDefinedEntry getPAMEntryForPort(int portNumber) {
        PAMSysDefinedEntry sysEntry = null;
        Enumeration enProtocolEntries = this.htPAMSysEntries.elements();
        while (enProtocolEntries.hasMoreElements()) {
            sysEntry = (PAMSysDefinedEntry)enProtocolEntries.nextElement();
            String port = sysEntry.getPorts();
            if (!port.equalsIgnoreCase(String.valueOf(portNumber))) continue;
            return sysEntry;
        }
        return null;
    }

    public PAMSysDefinedEntry getPAMEntryForPort(String l4Protocol, int portNumber) {
        PAMSysDefinedEntry sysEntry;
        if (this.htPorts == null) {
            this.htPorts = new Hashtable();
            if (this.htPAMSysEntries == null) {
                this.htPAMSysEntries = new Hashtable();
                this.populate();
            }
            Enumeration enProtocolEntries = this.htPAMSysEntries.elements();
            while (enProtocolEntries.hasMoreElements()) {
                sysEntry = (PAMSysDefinedEntry)enProtocolEntries.nextElement();
                if (sysEntry.isEntryWithRange()) {
                    int stPort = sysEntry.getStartingPort();
                    int enPort = sysEntry.getEndingPort();
                    int i = stPort;
                    while (i <= enPort) {
                        this.htPorts.put(String.valueOf(sysEntry.getL4Protocol()) + "," + String.valueOf(i), sysEntry);
                        ++i;
                    }
                    continue;
                }
                if (sysEntry.isEntryWithSequence()) {
                    String ports = sysEntry.getPorts();
                    int stIndex = 0;
                    while (stIndex != -1) {
                        int endIndex = ports.indexOf(44, stIndex + 1);
                        if (endIndex != -1) {
                            this.htPorts.put(String.valueOf(sysEntry.getL4Protocol()) + "," + ports.substring(stIndex, endIndex), sysEntry);
                        } else {
                            this.htPorts.put(String.valueOf(sysEntry.getL4Protocol()) + "," + ports.substring(stIndex), sysEntry);
                        }
                        stIndex = endIndex;
                        if (stIndex == -1) continue;
                        ++stIndex;
                    }
                    continue;
                }
                this.htPorts.put(String.valueOf(sysEntry.getL4Protocol()) + "," + sysEntry.getPorts(), sysEntry);
            }
        }
        sysEntry = (PAMSysDefinedEntry)this.htPorts.get(String.valueOf(l4Protocol) + "," + String.valueOf(portNumber));
        return sysEntry;
    }

    public String getPortSequence(String l4Protocol, String protocolName) {
        String[] cmds = new String[]{"show ip port-map " + protocolName + " detail"};
        String cmdOutput = "";
        try {
            IOSCmdService cmdService = this._device.getDevInfoBase().getComm();
            IOSCmdResponse[] cmdResponse = cmdService.exec(cmds);
            if (cmdResponse[0].getStatus() == 1 || cmdResponse[0].getStatus() == 0) {
                cmdOutput = cmdResponse[0].getOutput();
            }
        }
        catch (IOSCmdServiceException iosException) {
            iosException.printStackTrace();
        }
        return PAMParse.getPortSequence(cmdOutput, l4Protocol);
    }

    public String getProtocolNameForPort(String l4Protocol, int portNumber) {
        PAMSysDefinedEntry entry = this.getPAMEntryForPort(l4Protocol, portNumber);
        if (entry != null) {
            return entry.getProtocol();
        }
        return null;
    }

    public Vector getProtocolNames() {
        return this.protocolNames;
    }

    public boolean isProtocolExist(String protocolName) {
        if (this.protocolNames == null) {
            return false;
        }
        return this.protocolNames.contains(protocolName);
    }

    public void loadEntries() {
        String[] cli = new String[]{SH_PAM};
        try {
            IOSCmdService cmdService = this._device.getDevInfoBase().getComm();
            String[] cmds = new String[]{SH_PAM};
            IOSCmdResponse[] cmdResponse = cmdService.exec(cmds);
            if (cmdResponse[0].getStatus() == 1 || cmdResponse[0].getStatus() == 0) {
                this.cmdOutput = cmdResponse[0].getOutput();
            }
            this.cmdOutput = PAMSystemDefinedCollection.removeCmdFromCliOutput(this.cmdOutput, SH_PAM);
        }
        catch (IOSCmdServiceException iosException) {
            iosException.printStackTrace();
        }
    }

    public static void main(String[] ar) {
    }

    public void populate() {
        this.discoverProtocols();
        if (this._device.getDevInfoBase().isGranularPAMSupported()) {
            this.populateSystemDefinedEntries();
        } else {
            this.populateBaseSystemDefinedEntries();
        }
    }

    public void populateBaseSystemDefinedEntries() {
        PAM pam = this._device.getSystemProp().getPAM();
        if (this.htPAMSysEntries == null) {
            this.htPAMSysEntries = new Hashtable();
        }
        this.htPAMSysEntries.put("dns", new PAMSysDefinedEntry("dns", "53"));
        this.htPAMSysEntries.put("vdolive", new PAMSysDefinedEntry("vdolive", "7000"));
        this.htPAMSysEntries.put("sunrpc", new PAMSysDefinedEntry("sunrpc", "111"));
        this.htPAMSysEntries.put("netshow", new PAMSysDefinedEntry("netshow", "1755"));
        this.htPAMSysEntries.put("cuseeme", new PAMSysDefinedEntry("cuseeme", "7648"));
        this.htPAMSysEntries.put("tftp", new PAMSysDefinedEntry("tftp", "69"));
        this.htPAMSysEntries.put("rtsp", new PAMSysDefinedEntry("rtsp", "8554"));
        this.htPAMSysEntries.put("realmedia", new PAMSysDefinedEntry("realmedia", "7070"));
        this.htPAMSysEntries.put("streamworks", new PAMSysDefinedEntry("streamworks", "1558"));
        this.htPAMSysEntries.put("ftp", new PAMSysDefinedEntry("ftp", "21"));
        this.htPAMSysEntries.put("telnet", new PAMSysDefinedEntry("telnet", "23"));
        this.htPAMSysEntries.put("rtsp", new PAMSysDefinedEntry("rtsp", "554"));
        this.htPAMSysEntries.put("h323", new PAMSysDefinedEntry("h323", "1720"));
        this.htPAMSysEntries.put("sip", new PAMSysDefinedEntry("sip", "5060"));
        this.htPAMSysEntries.put("smtp", new PAMSysDefinedEntry("smtp", "25"));
        this.htPAMSysEntries.put("http", new PAMSysDefinedEntry("http", "80"));
        this.htPAMSysEntries.put("msrpc", new PAMSysDefinedEntry("msrpc", "135"));
        this.htPAMSysEntries.put("exec", new PAMSysDefinedEntry("exec", "512"));
        this.htPAMSysEntries.put("login", new PAMSysDefinedEntry("login", "513"));
        this.htPAMSysEntries.put("login", new PAMSysDefinedEntry("sql-net", "1521"));
        this.htPAMSysEntries.put("shell", new PAMSysDefinedEntry("shell", "514"));
        this.htPAMSysEntries.put("mgcp", new PAMSysDefinedEntry("mgcp", "2427"));
        this.htPAMSysEntries.put("https", new PAMSysDefinedEntry("https", "443"));
        this.htPAMSysEntries.put("login", new PAMSysDefinedEntry("login", "513"));
        this.htPAMSysEntries.put("skinny", new PAMSysDefinedEntry("skinny", "2000"));
        if (this.protocolNames == null) {
            this.protocolNames = new Vector();
        }
        Enumeration enProtocolNames = this.htPAMSysEntries.keys();
        while (enProtocolNames.hasMoreElements()) {
            String protocolName = (String)enProtocolNames.nextElement();
            this.protocolNames.addElement(protocolName);
            PAMSysDefinedEntry sysEntry = (PAMSysDefinedEntry)this.htPAMSysEntries.get(protocolName);
            pam.addToGroup(sysEntry);
        }
        String[] nonDefProt = new String[]{"pop3", "finger", "gopher", "imap", "kerberos", "ldap", "lotusnote", "ms-sql", "msrpc", "nfs", "nntp", "pop2"};
        int jj = 0;
        while (jj < nonDefProt.length) {
            if (this.discoveredProt.indexOf(nonDefProt[jj]) != -1) {
                this.protocolNames.addElement(nonDefProt[jj]);
            }
            ++jj;
        }
    }

    public void populateSystemDefinedEntries() {
        PAM pam = this._device.getSystemProp().getPAM();
        if (this.cmdOutput == null) {
            this.loadEntries();
        }
        BufferedReader pamStream = new BufferedReader(new StringReader(this.cmdOutput));
        if (this.htPAMSysEntries == null) {
            this.htPAMSysEntries = new Hashtable();
        }
        this.protocolNames = this.getDiscoveredProtocols();
        try {
            String pamEntry;
            while ((pamEntry = pamStream.readLine()) != null) {
                this.pamSysEntry = PAMParse.parseEntry(pamEntry);
                String protocolName = this.pamSysEntry.getProtocol();
                String l4Prot = this.pamSysEntry.getL4Protocol();
                this.htPAMSysEntries.put(String.valueOf(protocolName) + "," + l4Prot, this.pamSysEntry);
                pam.addToGroup(this.pamSysEntry);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String removeCmdFromCliOutput(String cliOutput, String command) {
        int index = -1;
        try {
            index = cliOutput.indexOf(command);
            if (index != -1) {
                cliOutput = cliOutput.substring(index + command.length() + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            cliOutput = "";
        }
        return cliOutput;
    }
}

