/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.systemproperties;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.acl.ACEInterface;
import com.cisco.xdm.data.acl.ACL;
import com.cisco.xdm.data.acl.ACLCollection;
import com.cisco.xdm.data.acl.ExtUdpACE;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.HostIdentity;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.IPAddressType;
import com.cisco.xdm.data.common.Netmask;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import com.cisco.xdm.data.systemproperties.NTPACEFilter;
import com.cisco.xdm.data.systemproperties.SDM_NTPClients;
import java.util.Enumeration;
import java.util.Vector;

public class SDM_NTPClient
extends XDMObject {
    private String m_strNTPAddress = "";
    private String m_strNTPSource = "";
    private String m_strKeyNumber = "";
    private String m_strkeyValue = "";
    private boolean m_bPrefer = false;
    private NTPACEFilter _aceFilter;
    private static Vector NTPAuthKeyVector = new Vector();
    private static Vector NTPPeerAuthKeyVector = new Vector();
    private static Vector NTPPeerServerVector = new Vector();
    private static Vector NTPTrustedKeyVector = new Vector();
    private static boolean m_bauthenticateCommand = false;
    private boolean m_bauthenticateCommandbySDM = false;
    private static boolean m_bupdateCalendarCommand = false;
    private boolean m_bupdateCalendarCommandbySDM = false;
    private static final int START_LOCATION = 0;
    public static final String NTP_ACE_REMARK = "Auto generated by SDM for NTP (123) ";
    public boolean isIPModified = false;
    public boolean isAuthKeyModified = false;
    public boolean isPreferModified = false;
    public boolean isIfModified = false;
    public boolean isDeleteAll = false;
    public boolean isDeleteIP = false;
    public boolean isMinConf = false;
    private CmdValues firstNTP = null;
    public CmdValues removeNTP = null;
    private static final String KEY_NTP = "ntp";
    private static final String KEY_NTPSERVER = "ipNTPServer";
    private static final String KEY_SOURCEINTERFACE = "infName";
    private static final String KEY_KEYNUMBER = "keyVal";
    private static final String KEY_KEYVALUE = "keyStr";
    private static final String KEY_PREFER = "prefer";
    private static final String KEY_VERISON = "NTPVersion";
    private static final String KEY_SERVER = "server";
    private static final String KEY_SOURCE = "source";
    private static final String KEY_AUTHKEY = "key";
    private static final String KEY_AUTHENTICATIONKEY = "authentication-key";
    private static final String KEY_MD5 = "md5";
    private static final String KEY_TRUSTED = "trusted-key";
    private static final String KEY_TRUSTEDKEYVAL = "keytrusted";
    private static final String KEY_AUTHENTICATE = "authenticate";
    int x = 0;

    public SDM_NTPClient() {
        super(null);
    }

    public SDM_NTPClient(String strNTPAddress, String strNTPSource, String strKeyNumber, String strkeyValue, boolean bPrefer) {
        super(null);
        if (strNTPAddress != null) {
            this.m_strNTPAddress = strNTPAddress;
        }
        if (strNTPSource != null) {
            this.m_strNTPSource = strNTPSource;
        }
        if (strKeyNumber != null) {
            this.m_strKeyNumber = strKeyNumber;
        }
        if (strkeyValue != null) {
            this.m_strkeyValue = strkeyValue;
        }
        this.m_bPrefer = bPrefer;
    }

    public SDM_NTPClient(String strNTPAddress, String strNTPSource, boolean bPrefer) {
        super(null);
        if (strNTPAddress != null) {
            this.m_strNTPAddress = strNTPAddress;
        }
        if (strNTPSource != null) {
            this.m_strNTPSource = strNTPSource;
        }
        this.m_bPrefer = bPrefer;
    }

    public static void addNTPAuthKeyToVector(String strKeyNumber) {
        if (!NTPAuthKeyVector.contains(strKeyNumber)) {
            Log.getLog().debug("inside addNTPAuthKeyToVector" + strKeyNumber);
            NTPAuthKeyVector.addElement(strKeyNumber);
        }
    }

    public static void addNTPPeerAuthKeyToVector(String strKeyNumber) {
        NTPPeerAuthKeyVector.addElement(strKeyNumber);
    }

    public static void addNTPPeerServerToVector(String strPeerAddress) {
        NTPPeerServerVector.addElement(strPeerAddress);
    }

    public static void addNTPTrustedKeyToVector(String strKeyNumber) {
        NTPTrustedKeyVector.addElement(strKeyNumber);
    }

    public boolean checkIFNTPAceExists(ACL inACL, XDMInterfaceBase outsideIf, SDM_NTPClient sdm_ntpClient) {
        Log.getLog().debug("inside NTP client check NTPACE exists");
        if (inACL == null) {
            return true;
        }
        if (inACL.getACLType() == 0) {
            return false;
        }
        String source = sdm_ntpClient.getNTPAddress();
        if (source == null) {
            return true;
        }
        String destination = "any";
        if (outsideIf.getIpAddr().getIPAddressType() == IPAddressType.STATIC) {
            destination = outsideIf.getIpAddr().getIPAddressAsString();
        }
        ExtUdpACE ace3 = new ExtUdpACE();
        ace3.setGrant(true);
        ace3.setProtocol("udp");
        ace3.setSourceHost(source);
        ace3.setSourcePort("123", "eq");
        if (destination.equals("any")) {
            ace3.setDestAny();
        } else {
            ace3.setDestHost(destination);
        }
        ace3.setDestPort("123", "eq");
        ace3.setRemark(NTP_ACE_REMARK);
        return inACL.isDuplicateACE(ace3);
    }

    public static boolean checkIfDuplicateKey(String strKeyNumber) {
        boolean bReturn = false;
        if (NTPPeerAuthKeyVector != null && strKeyNumber != null && strKeyNumber.trim().length() != 0) {
            if (NTPPeerAuthKeyVector.indexOf(strKeyNumber.trim()) != -1) {
                bReturn = true;
            }
        } else {
            bReturn = false;
        }
        return bReturn;
    }

    public static boolean checkIfDuplicateServer(String strPeerAddress) {
        boolean bReturn = false;
        if (NTPPeerServerVector != null && strPeerAddress != null && strPeerAddress.trim().length() != 0) {
            if (NTPPeerServerVector.indexOf(strPeerAddress.trim()) != -1) {
                bReturn = true;
            }
        } else {
            bReturn = false;
        }
        return bReturn;
    }

    public void configureNTPACEs(ACL inACL, XDMInterfaceBase outsideIf, SDM_NTPClient sdm_ntpClient) {
        Log.getLog().debug("inside NTP client configureNTPACEs ");
        if (inACL == null) {
            return;
        }
        String source = sdm_ntpClient.getNTPAddress();
        if (source == null) {
            return;
        }
        String destination = "any";
        if (outsideIf.getIpAddr().getIPAddressType() == IPAddressType.STATIC) {
            destination = outsideIf.getIpAddr().getIPAddressAsString();
        }
        String NTP_ACE_RemarkMsg = NTP_ACE_REMARK;
        ExtUdpACE ace3 = new ExtUdpACE();
        ace3.setGrant(true);
        ace3.setProtocol("udp");
        ace3.setSourceHost(source);
        ace3.setSourcePort("123", "eq");
        if (destination.equals("any")) {
            ace3.setDestAny();
        } else {
            ace3.setDestHost(destination);
        }
        ace3.setDestPort("123", "eq");
        ace3.setRemark(String.valueOf(NTP_ACE_RemarkMsg) + sdm_ntpClient.getNTPAddress());
        inACL.addACE(ace3, 0);
    }

    public void createNTPACEFilter(String m_strNTPAddress) {
        this._aceFilter = new NTPACEFilter(m_strNTPAddress);
    }

    public static void delNTPAuthKeyToVector(String strKeyNumber) {
        NTPAuthKeyVector.removeElement(strKeyNumber);
    }

    public static void delNTPTrustedKeyToVector(String strKeyNumber) {
        NTPTrustedKeyVector.removeElement(strKeyNumber);
    }

    public static void emptyAllKeyVectors() {
        if (NTPAuthKeyVector != null) {
            NTPAuthKeyVector.removeAllElements();
        }
        if (NTPTrustedKeyVector != null) {
            NTPTrustedKeyVector.removeAllElements();
        }
        if (NTPPeerAuthKeyVector != null) {
            NTPPeerAuthKeyVector.removeAllElements();
        }
        if (NTPPeerServerVector != null) {
            NTPPeerServerVector.removeAllElements();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SDM_NTPClient)) {
            return false;
        }
        SDM_NTPClient SDM_NTPClientObj = (SDM_NTPClient)obj;
        if (this.m_strNTPSource == null ? SDM_NTPClientObj.m_strNTPSource != null : !this.m_strNTPSource.equals(SDM_NTPClientObj.m_strNTPSource)) {
            return false;
        }
        if (this.m_strKeyNumber == null ? SDM_NTPClientObj.m_strKeyNumber != null : !this.m_strKeyNumber.equals(SDM_NTPClientObj.m_strKeyNumber)) {
            return false;
        }
        if (this.m_strkeyValue == null ? SDM_NTPClientObj.m_strkeyValue != null : !this.m_strkeyValue.equals(SDM_NTPClientObj.m_strkeyValue)) {
            return false;
        }
        return this.m_strNTPAddress.equalsIgnoreCase(SDM_NTPClientObj.m_strNTPAddress) && this.m_bPrefer == SDM_NTPClientObj.m_bPrefer;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        if (this.isBackup()) {
            CmdValues cmdval = this.generateRtrCmd(2, values);
            Log.getLog().debug("Delete commands");
            values.addCmdValues(cmdval);
            if (this.removeNTP != null) {
                values.addCmdValues(this.removeNTP);
                this.removeNTP = null;
            }
        } else if (backup == null) {
            Log.getLog().debug("Add commands");
            CmdValues cmdval = this.generateNewRtrCmd(1, values);
            values.addCmdValues(cmdval);
        } else {
            Log.getLog().debug("Modification commands");
            this.generateModifyCommands((SDM_NTPClient)backup, values);
        }
    }

    private void generateModifyCommands(SDM_NTPClient backup, ConfigValues cfgval) throws XDMException {
        XDMInterfaceBase If;
        Log.getLog().debug("inside generateModifyCommands ");
        CmdValues cmd = new CmdValues(KEY_NTP);
        cmd.addValue(KEY_SERVER, KEY_SERVER);
        cmd.addValue(KEY_NTPSERVER, this.m_strNTPAddress);
        DeviceBase dev = (DeviceBase)this.getDevice();
        DeviceBase backup1 = dev.getBackup();
        SDM_NTPClients clients = backup1.getSystemProp().getNTPClients();
        SDM_NTPClient backupClient = (SDM_NTPClient)clients.get(String.valueOf(this.getNTPAddress()) + this.getKeyNumber());
        boolean isSourceModified = false;
        boolean isPreferModified = false;
        isSourceModified = true;
        if (this.m_strNTPSource != null && this.m_strNTPSource.length() > 0 && (If = dev.getIfs().getIfFromString(this.m_strNTPSource)) != null) {
            cmd.addValue(KEY_SOURCE, KEY_SOURCE);
            cmd.addValue(KEY_SOURCEINTERFACE, this.m_strNTPSource);
        }
        isPreferModified = true;
        if (this.m_bPrefer) {
            cmd.addValue(KEY_PREFER, KEY_PREFER);
            isPreferModified = true;
        }
        Log.getLog().debug("inside generateModifyCommands m_strKeyNumber" + this.m_strKeyNumber + "m_strkeyValue" + this.m_strkeyValue);
        if (this.m_strKeyNumber != null && this.m_strKeyNumber.trim().length() != 0 && !this.isIPModified) {
            cmd.addValue(KEY_AUTHKEY, KEY_AUTHKEY);
            cmd.addValue(KEY_KEYNUMBER, this.m_strKeyNumber);
        }
        CmdValues AuthKeycmd = new CmdValues(KEY_NTP);
        AuthKeycmd.addValue(KEY_AUTHENTICATIONKEY, KEY_AUTHENTICATIONKEY);
        AuthKeycmd.addValue(KEY_KEYNUMBER, this.m_strKeyNumber);
        AuthKeycmd.addValue(KEY_MD5, KEY_MD5);
        if (this.m_strkeyValue != null && this.m_strkeyValue.length() > 0) {
            AuthKeycmd.addValue(KEY_KEYVALUE, this.m_strkeyValue);
            AuthKeycmd.setAction(1);
            cfgval.addCmdValues(AuthKeycmd);
        }
        cfgval.addCmdValues(cmd);
    }

    private CmdValues generateNewRtrCmd(int action, ConfigValues values) {
        XDMInterfaceBase If;
        DeviceBase dev = (DeviceBase)this.getDevice();
        CmdValues cmd = new CmdValues(KEY_NTP);
        cmd.addValue(KEY_SERVER, KEY_SERVER);
        cmd.addValue(KEY_NTPSERVER, this.m_strNTPAddress);
        if (this.m_strNTPSource != null && this.m_strNTPSource.trim().length() > 0 && (If = dev.getIfs().getIfFromString(this.m_strNTPSource)) != null) {
            cmd.addValue(KEY_SOURCE, KEY_SOURCE);
            cmd.addValue(KEY_SOURCEINTERFACE, this.m_strNTPSource);
        }
        if (this.m_bPrefer) {
            cmd.addValue(KEY_PREFER, KEY_PREFER);
        }
        dev = (DeviceBase)this.getDevice();
        DeviceBase backup = dev.getBackup();
        Log.getLog().debug("backup" + backup);
        boolean bHardWareClockPresentinDelta = false;
        if (backup != null) {
            int index = 0;
            Enumeration enumeration = backup.getSystemProp().getNTPClients().elements();
            Log.getLog().debug("Numners" + backup.getSystemProp().getNTPClients().size());
            while (enumeration.hasMoreElements()) {
                Log.getLog().debug("inside generateNewRtrCmd backup not null index" + index);
                SDM_NTPClient sdm_ntpclient = (SDM_NTPClient)enumeration.nextElement();
                if (sdm_ntpclient != null && sdm_ntpclient.isUpdateCalendarCommandconfiguredBySDM()) {
                    bHardWareClockPresentinDelta = true;
                    Log.getLog().debug("Update calendar cmd already in backup");
                    break;
                }
                ++index;
            }
        }
        int i = 0;
        while (i < values.numCmds()) {
            CmdValues iteratecmd = values.getCmdValues(i);
            Log.getLog().debug("iteratecmd" + iteratecmd);
            if (iteratecmd.containsKey("update-calendar")) {
                if (iteratecmd.getAction() != 2) {
                    bHardWareClockPresentinDelta = true;
                } else {
                    bHardWareClockPresentinDelta = false;
                    this.setUpdateCalendar(false);
                }
                Log.getLog().debug("Authenticate cmd already in delta");
                break;
            }
            ++i;
        }
        if (dev.getSystemProp().isHardwareClockSupported()) {
            Log.getLog().debug("this.isNTPCalendarCommandConfigured()" + SDM_NTPClient.isNTPCalendarCommandConfigured());
            Log.getLog().debug("bHardWareClockPresentinDelta" + bHardWareClockPresentinDelta);
            if (!SDM_NTPClient.isNTPCalendarCommandConfigured() && !bHardWareClockPresentinDelta) {
                Log.getLog().debug("inside generateNewRtrCmd Adding Update calendar");
                CmdValues UpdateCalendarcmd = new CmdValues(KEY_NTP);
                UpdateCalendarcmd.addValue("update-calendar", "update-calendar");
                UpdateCalendarcmd.setAction(action);
                values.addCmdValues(UpdateCalendarcmd);
                this.setUpdateCalendar(true);
            }
        }
        Log.getLog().debug("inside generateNewRtrCmd isIPModified" + this.isIPModified);
        if (this.isIPModified) {
            cmd.setAction(action);
            return cmd;
        }
        Log.getLog().debug("inside generateNewRtrCmd m_strKeyNumber" + this.m_strKeyNumber + "m_strkeyValue" + this.m_strkeyValue);
        if (this.m_strKeyNumber != null && this.m_strKeyNumber.trim().length() != 0 && !this.isIPModified) {
            cmd.addValue(KEY_AUTHKEY, KEY_AUTHKEY);
            cmd.addValue(KEY_KEYNUMBER, this.m_strKeyNumber);
            if (this.m_strkeyValue != null && this.m_strkeyValue.length() > 0) {
                CmdValues AuthKeycmd = new CmdValues(KEY_NTP);
                AuthKeycmd.addValue(KEY_AUTHENTICATIONKEY, KEY_AUTHENTICATIONKEY);
                AuthKeycmd.addValue(KEY_KEYNUMBER, this.m_strKeyNumber);
                AuthKeycmd.addValue(KEY_MD5, KEY_MD5);
                AuthKeycmd.addValue(KEY_KEYVALUE, this.m_strkeyValue);
                AuthKeycmd.setAction(action);
                values.addCmdValues(AuthKeycmd);
                SDM_NTPClient.addNTPAuthKeyToVector(this.m_strKeyNumber);
                Log.getLog().debug("inside generateNewRtrCmd values" + values);
                dev = (DeviceBase)this.getDevice();
                backup = dev.getBackup();
                Log.getLog().debug("backup" + backup);
                boolean bPresentinDeltaConfig = false;
                if (backup != null) {
                    int index = 0;
                    Enumeration enumeration = backup.getSystemProp().getNTPClients().elements();
                    while (enumeration.hasMoreElements()) {
                        Log.getLog().debug("inside generateNewRtrCmd backup not null index" + index);
                        SDM_NTPClient sdm_ntpclient = (SDM_NTPClient)enumeration.nextElement();
                        if (sdm_ntpclient != null) {
                            Log.getLog().debug("sdm_ntpclient.m_strKeyNumber " + sdm_ntpclient.m_strKeyNumber);
                            if (sdm_ntpclient.m_strKeyNumber != null && sdm_ntpclient.m_strKeyNumber.trim().length() != 0 && sdm_ntpclient.isAuthenticateCommandconfiguredBySDM()) {
                                bPresentinDeltaConfig = true;
                                Log.getLog().debug("Authenticate cmd already in backup");
                                break;
                            }
                        }
                        ++index;
                    }
                    int i2 = 0;
                    while (i2 < values.numCmds()) {
                        CmdValues iteratecmd = values.getCmdValues(i2);
                        Log.getLog().debug("iteratecmd" + iteratecmd);
                        if (iteratecmd.containsKey(KEY_AUTHENTICATE)) {
                            if (iteratecmd.getAction() != 2) {
                                bPresentinDeltaConfig = true;
                            } else {
                                bPresentinDeltaConfig = false;
                                SDM_NTPClient.setAuthenticateCommand(false);
                            }
                            Log.getLog().debug("Authenticate cmd already in delta");
                            break;
                        }
                        ++i2;
                    }
                }
                Log.getLog().debug("Authenticate cmd already configured in the router" + SDM_NTPClient.isAuthenticateCommandconfigured());
                Log.getLog().debug("NTP Authenticate command is needed NTPAuthKeyVector.size()" + NTPAuthKeyVector.size());
                Log.getLog().debug("bPresentinDeltaConfig" + bPresentinDeltaConfig);
                if (!SDM_NTPClient.isAuthenticateCommandconfigured() && NTPAuthKeyVector.size() > 0 && !bPresentinDeltaConfig) {
                    values.addCmdValues(this.setFirstNTP());
                    this.setAuthenticateCommandConfigured(true);
                }
            }
            if (this.isAuthKeyModified) {
                CmdValues TrustedKeycmd = new CmdValues(KEY_NTP);
                TrustedKeycmd.addValue(KEY_TRUSTED, KEY_TRUSTED);
                TrustedKeycmd.addValue(KEY_TRUSTEDKEYVAL, this.m_strKeyNumber);
                TrustedKeycmd.setAction(action);
                if (action == 1) {
                    SDM_NTPClient.addNTPTrustedKeyToVector(this.m_strKeyNumber);
                }
                values.addCmdValues(TrustedKeycmd);
            }
        }
        cmd.setAction(action);
        return cmd;
    }

    private CmdValues generateNoFormAuth(CmdValues cmd, ConfigValues values) {
        if (this.m_strKeyNumber != null && this.m_strKeyNumber.trim().length() != 0 && !this.isIPModified) {
            cmd.addValue(KEY_AUTHKEY, KEY_AUTHKEY);
            cmd.addValue(KEY_KEYNUMBER, this.m_strKeyNumber);
            if (this.m_strKeyNumber != null && this.m_strKeyNumber.length() > 0) {
                CmdValues AuthKeycmd = new CmdValues(KEY_NTP);
                AuthKeycmd.addValue(KEY_AUTHENTICATIONKEY, KEY_AUTHENTICATIONKEY);
                AuthKeycmd.addValue(KEY_KEYNUMBER, this.m_strKeyNumber);
                AuthKeycmd.addValue(KEY_MD5, KEY_MD5);
                AuthKeycmd.addValue(KEY_KEYVALUE, this.m_strkeyValue);
                AuthKeycmd.setAction(2);
                SDM_NTPClient.delNTPAuthKeyToVector(this.m_strKeyNumber);
                values.addCmdValues(AuthKeycmd);
                DeviceBase dev = (DeviceBase)this.getDevice();
                DeviceBase backup = dev.getBackup();
                Log.getLog().debug("backup" + backup);
                boolean bPresentinDeltaConfig = false;
                if (backup != null) {
                    int i = 0;
                    while (i < values.numCmds()) {
                        CmdValues iteratecmd = values.getCmdValues(i);
                        Log.getLog().debug("iteratecmd" + iteratecmd);
                        if (iteratecmd.containsKey(KEY_AUTHENTICATE)) {
                            bPresentinDeltaConfig = true;
                            Log.getLog().debug("Authenticate cmd already in delta");
                        }
                        ++i;
                    }
                }
                CmdValues TrustedKeycmd = new CmdValues(KEY_NTP);
                TrustedKeycmd.addValue(KEY_TRUSTED, KEY_TRUSTED);
                TrustedKeycmd.addValue(KEY_TRUSTEDKEYVAL, this.m_strKeyNumber);
                TrustedKeycmd.setAction(2);
                SDM_NTPClient.delNTPTrustedKeyToVector(this.m_strKeyNumber);
                values.addCmdValues(TrustedKeycmd);
                Log.getLog().debug("Authenticate cmd already configured in the router" + SDM_NTPClient.isAuthenticateCommandconfigured());
                Log.getLog().debug("NTP Authenticate command is needed NTPAuthKeyVector.size()" + NTPAuthKeyVector.size());
                Log.getLog().debug("bPresentinDeltaConfig" + bPresentinDeltaConfig);
                if (!SDM_NTPClient.isAuthenticateCommandconfigured() && NTPAuthKeyVector.size() == 0) {
                    CmdValues Authenticatecmd = new CmdValues(KEY_NTP);
                    Authenticatecmd.addValue(KEY_AUTHENTICATE, KEY_AUTHENTICATE);
                    Authenticatecmd.setAction(2);
                    values.addCmdValues(Authenticatecmd);
                }
            }
        }
        cmd.setAction(2);
        return cmd;
    }

    private CmdValues generateNoFormIPOnly(ConfigValues values) {
        CmdValues cmd = new CmdValues(KEY_NTP);
        cmd.addValue(KEY_SERVER, KEY_SERVER);
        cmd.addValue(KEY_NTPSERVER, this.m_strNTPAddress);
        if (this.m_strNTPSource != null && this.m_strNTPSource.trim().length() > 0) {
            cmd.addValue(KEY_SOURCE, KEY_SOURCE);
            cmd.addValue(KEY_SOURCEINTERFACE, this.m_strNTPSource);
        }
        if (this.m_bPrefer) {
            cmd.addValue(KEY_PREFER, KEY_PREFER);
        }
        return cmd;
    }

    private CmdValues generateRtrCmd(int action, ConfigValues values) {
        CmdValues cmd = this.generateNoFormIPOnly(values);
        DeviceBase dev = (DeviceBase)this.getDevice();
        if (dev.getSystemProp().isHardwareClockSupported() && !SDM_NTPClient.isNTPCalendarCommandConfigured()) {
            int index = 0;
            Enumeration enumeration = dev.getSystemProp().getNTPClients().elements();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++index;
            }
            Log.getLog().debug("inside delete generating no form of update calendar index" + index);
            if (index == 1) {
                CmdValues UpdateCalendarcmd = new CmdValues(KEY_NTP);
                UpdateCalendarcmd.addValue("update-calendar", "update-calendar");
                UpdateCalendarcmd.setAction(2);
                values.addCmdValues(UpdateCalendarcmd);
            }
        }
        if (this.isIPModified) {
            cmd.setAction(2);
            return cmd;
        }
        return this.generateNoFormAuth(cmd, values);
    }

    public String getKeyNumber() {
        return this.m_strKeyNumber;
    }

    public String getKeyValue() {
        return this.m_strkeyValue;
    }

    public int getLastCmdPositionInterface(ConfigValues config) {
        int ret = -1;
        if (config == null) {
            return ret;
        }
        int size = config.numCmds();
        int i = 0;
        while (i < size) {
            CmdValues cmd = config.getCmdValues(i);
            String name = cmd.getCmdName();
            if (name.equalsIgnoreCase("interface")) {
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    public String getNTPAddress() {
        return this.m_strNTPAddress;
    }

    public static Vector getNTPAuthKeyVector() {
        return NTPAuthKeyVector;
    }

    public static Vector getNTPPeerKeyVector() {
        return NTPPeerAuthKeyVector;
    }

    public static Vector getNTPPeerServerVector() {
        return NTPPeerServerVector;
    }

    public String getNTPSource() {
        return this.m_strNTPSource;
    }

    public static Vector getNTPTrustedKeyVector() {
        return NTPTrustedKeyVector;
    }

    public boolean getisPreffered() {
        return this.m_bPrefer;
    }

    public static boolean isAuthKeyPresentinVector(String strKeyNumber) {
        boolean bReturn = false;
        if (NTPAuthKeyVector != null && strKeyNumber != null) {
            if (NTPAuthKeyVector.indexOf(strKeyNumber.trim()) != -1) {
                bReturn = true;
            }
        } else {
            bReturn = false;
        }
        return bReturn;
    }

    public static boolean isAuthenticateCommandconfigured() {
        return m_bauthenticateCommand;
    }

    public boolean isAuthenticateCommandconfiguredBySDM() {
        return this.m_bauthenticateCommandbySDM;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public static boolean isNTPCalendarCommandConfigured() {
        return m_bupdateCalendarCommand;
    }

    public boolean isNTPServerOnLAN(String Source) {
        DeviceBase dev = (DeviceBase)this.getDevice();
        XDMInterfaces ifs = dev.getIfs();
        Enumeration interfaces = ifs.getSortedIfs().elements();
        while (interfaces.hasMoreElements()) {
            XDMInterfaceBase If = (XDMInterfaceBase)interfaces.nextElement();
            if (If.getFWDir() != 2) continue;
            Log.getLog().debug("Inside isNTPServerOnLAN Source" + Source);
            IPAddress ipNTPSource = !IPAddress.isLegalIPAddress(Source) ? HostIdentity.getIPFromHostname(Source, dev) : new IPAddress(Source);
            if (If.getIpAddr() == null) {
                return false;
            }
            IPAddress ipInsideInterface = If.getIpAddr().getIPAddress();
            Netmask ipInsideInterfaceMask = If.getIpAddr().getNetmask();
            if (ipInsideInterface == null || ipInsideInterfaceMask == null) {
                return false;
            }
            IPAddress ipNTPSourceSubnet = ipNTPSource.getSubnet(ipInsideInterfaceMask);
            IPAddress ipInsideInterfaceSubnet = ipInsideInterface.getSubnet(ipInsideInterfaceMask);
            if (!ipNTPSourceSubnet.toString().equalsIgnoreCase(ipInsideInterfaceSubnet.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isTrustedKeyPresentinVector(String strKeyNumber) {
        boolean bReturn = false;
        if (NTPTrustedKeyVector != null && strKeyNumber != null) {
            if (NTPTrustedKeyVector.indexOf(strKeyNumber.trim()) != -1) {
                bReturn = true;
            }
        } else {
            bReturn = false;
        }
        return bReturn;
    }

    public boolean isUpdateCalendarCommandconfiguredBySDM() {
        return this.m_bupdateCalendarCommandbySDM;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException {
        String strKeyNumber;
        String strNTPSource;
        String strNTPAddress;
        this.isIPModified = false;
        this.isAuthKeyModified = false;
        this.isPreferModified = false;
        this.isIfModified = false;
        this.isDeleteAll = false;
        this.isDeleteIP = false;
        this.isMinConf = false;
        this.firstNTP = null;
        this.removeNTP = null;
        if (cmdVal == null || !KEY_NTP.equals(cmdVal.getCmdName())) {
            throw new XDMException(4);
        }
        this.m_strNTPAddress = strNTPAddress = cmdVal.getValue(KEY_NTPSERVER);
        if (this.m_strNTPAddress != null) {
            this.createNTPACEFilter(this.m_strNTPAddress);
        }
        this.m_strNTPSource = strNTPSource = cmdVal.getValue(KEY_SOURCEINTERFACE);
        this.m_strKeyNumber = strKeyNumber = cmdVal.getValue(KEY_KEYNUMBER);
        if (strKeyNumber != null) {
            Log.getLog().debug("Checking for read only strKeyNumber" + strKeyNumber);
            if (!SDM_NTPClient.isAuthKeyPresentinVector(strKeyNumber)) {
                Log.getLog().debug("isAuthKeyPresentinVector returns false so read only");
                this.setReadOnly(true);
            } else if (!SDM_NTPClient.isAuthenticateCommandconfigured()) {
                Log.getLog().debug("isAuthenticateCommandconfigured returns false so read only");
                this.setReadOnly(true);
            } else if (!SDM_NTPClient.isTrustedKeyPresentinVector(strKeyNumber)) {
                Log.getLog().debug("isTrustedKeyPresentinVector returns false so read only");
                this.setReadOnly(true);
            }
            this.setAuthenticateCommandConfigured(SDM_NTPClient.isAuthenticateCommandconfigured());
        }
        if (cmdVal.containsKey(KEY_VERISON)) {
            Log.getLog().debug("Version command is Present so read only");
            this.setReadOnly(true);
        }
        this.m_bPrefer = cmdVal.containsKey(KEY_PREFER);
    }

    public void removeNTPACE() {
        Log.getLog().debug("Inside removeNTPACE()");
        DeviceBase dev = (DeviceBase)this.getDevice();
        XDMInterfaces ifs = dev.getIfs();
        Enumeration interfaces = ifs.getSortedIfs().elements();
        while (interfaces.hasMoreElements()) {
            XDMInterfaceBase If = (XDMInterfaceBase)interfaces.nextElement();
            String inAclName = If.getIpAccessGroupIn();
            Log.getLog().debug("Inside removeNTPACE() inAclName" + inAclName + "interface" + If);
            if (inAclName == null) continue;
            ACLCollection aclColl = dev.getAcls();
            ACL inACL = (ACL)aclColl.getACL(inAclName);
            Log.getLog().debug("Inside removeNTPACE() inACL" + inACL);
            if (inACL == null) continue;
            Log.getLog().debug("Inside removeNTPACE() _aceFilter" + this._aceFilter);
            Enumeration e = inACL.getFilteredACEs(this._aceFilter);
            while (e.hasMoreElements()) {
                ACEInterface ace = (ACEInterface)e.nextElement();
                int ind = inACL.getIndexOfACE(ace);
                boolean status = inACL.removeACE(ind);
                Log.getLog().debug("NTP: removed ACE(" + ace.toCLI() + ") status is " + status);
            }
        }
    }

    public void removeNTPACE(String NTPAddress, ACL inACL) {
        NTPACEFilter aceFilter = new NTPACEFilter(NTPAddress);
        Log.getLog().debug("Inside removeNTPACE() NTPAddress" + NTPAddress + "inACL" + inACL);
        Log.getLog().debug("Inside removeNTPACE() NTPAddress aceFilter" + aceFilter);
        Enumeration e = inACL.getFilteredACEs(aceFilter);
        while (e.hasMoreElements()) {
            ACEInterface ace = (ACEInterface)e.nextElement();
            int ind = inACL.getIndexOfACE(ace);
            boolean status = inACL.removeACE(ind);
            Log.getLog().debug("NTP: removed ACE(" + ace.toCLI() + ") status is " + status);
        }
    }

    public void removeNTPACEEntry(int index, ACL inACL) {
        Log.getLog().debug("Inside removeNTPACEEntry() NTPAddress index" + index);
        boolean status = inACL.removeACE(index);
        Log.getLog().debug("NTP: removed ACE status is " + status);
    }

    public static void setAuthenticateCommand(boolean bauthenticateCommand) {
        m_bauthenticateCommand = bauthenticateCommand;
        Log.getLog().debug("inside setAuthenticateCommand" + m_bauthenticateCommand);
    }

    public void setAuthenticateCommandConfigured(boolean bauthenticateCommand) {
        this.m_bauthenticateCommandbySDM = bauthenticateCommand;
        Log.getLog().debug("inside setAuthenticateCommandConfiguredBySDM" + m_bauthenticateCommand);
    }

    public CmdValues setFirstNTP() {
        if (this.firstNTP == null) {
            this.firstNTP = new CmdValues(KEY_NTP);
            this.firstNTP.addValue(KEY_AUTHENTICATE, KEY_AUTHENTICATE);
            this.firstNTP.setAction(1);
        }
        return this.firstNTP;
    }

    public void setIPModified(boolean flag) {
        SDM_NTPClient backupClient;
        this.isIPModified = flag;
        DeviceBase dev = (DeviceBase)this.getDevice();
        DeviceBase backup = dev.getBackup();
        SDM_NTPClients clients = backup.getSystemProp().getNTPClients();
        if (!this.isBackup() && (backupClient = (SDM_NTPClient)clients.get(String.valueOf(this.getNTPAddress()) + this.getKeyNumber())) != null) {
            backupClient.isIPModified = flag;
        }
    }

    public void setKeyNumber(String strKeyNumber) {
        this.m_strKeyNumber = strKeyNumber;
        this.setModified();
    }

    public void setKeyValue(String strkeyValue) {
        this.m_strkeyValue = strkeyValue;
        this.setModified();
        this.isAuthKeyModified = true;
    }

    private void setNTPAddress(String strNTPAddress) {
        this.m_strNTPAddress = strNTPAddress;
        this.setModified();
    }

    public static void setNTPCalendarCommand(boolean state) {
        m_bupdateCalendarCommand = state;
    }

    public void setNTPSource(String strNTPSource) {
        this.m_strNTPSource = strNTPSource;
        this.setModified();
        this.isIfModified = true;
    }

    public void setPrefer(boolean bPrefer) {
        this.m_bPrefer = bPrefer;
        this.setModified();
        this.isPreferModified = true;
    }

    public void setRemoveNTP() {
        this.removeNTP = new CmdValues(KEY_NTP);
        this.removeNTP.addValue(KEY_AUTHENTICATE, KEY_AUTHENTICATE);
        this.removeNTP.setAction(2);
        DeviceBase dev = (DeviceBase)this.getDevice();
        DeviceBase backup = dev.getBackup();
        if (backup != null) {
            SDM_NTPClient backupClient;
            SDM_NTPClients clients = backup.getSystemProp().getNTPClients();
            if (!this.isBackup() && (backupClient = (SDM_NTPClient)clients.get(String.valueOf(this.getNTPAddress()) + this.getKeyNumber())) != null) {
                backupClient.removeNTP = this.removeNTP;
            }
        }
    }

    public void setUpdateCalendar(boolean state) {
        this.m_bupdateCalendarCommandbySDM = state;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("_strNTPAddress = " + this.m_strNTPAddress);
        sb.append("\t _strNTPSource = " + this.m_strNTPSource);
        sb.append("\t _strKeyNumber= " + this.m_strKeyNumber);
        sb.append("\t _strkeyValue = " + this.m_strkeyValue);
        sb.append("\t _bPrefer = " + this.m_bPrefer);
        return sb.toString();
    }
}

