/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.systemproperties;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.KeywordParamNode;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.HostIdentity;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.discovery.XDMDiscovery;
import com.cisco.xdm.data.systemproperties.BootSystem;
import com.cisco.xdm.data.systemproperties.CLIView;
import com.cisco.xdm.data.systemproperties.CLIViews;
import com.cisco.xdm.data.systemproperties.FlowTopTalkers;
import com.cisco.xdm.data.systemproperties.HttpAAAMethods;
import com.cisco.xdm.data.systemproperties.Line;
import com.cisco.xdm.data.systemproperties.LocalPoolCollection;
import com.cisco.xdm.data.systemproperties.Logging;
import com.cisco.xdm.data.systemproperties.MgmtAccess;
import com.cisco.xdm.data.systemproperties.PAM;
import com.cisco.xdm.data.systemproperties.SDM_NTPClient;
import com.cisco.xdm.data.systemproperties.SDM_NTPClients;
import com.cisco.xdm.data.systemproperties.SDM_SNTPClient;
import com.cisco.xdm.data.systemproperties.SDM_SNTPClients;
import com.cisco.xdm.data.systemproperties.SNMP;
import com.cisco.xdm.data.systemproperties.SecretPassword;
import com.cisco.xdm.data.systemproperties.SecretPasswords;
import com.cisco.xdm.data.systemproperties.SyncPCDetails;
import com.cisco.xdm.data.systemproperties.Timestamp;
import com.cisco.xdm.data.systemproperties.TtyLines;
import com.cisco.xdm.data.systemproperties.User;
import com.cisco.xdm.data.systemproperties.Users;
import com.cisco.xdm.data.systemproperties.VtyLines;
import com.cisco.xdm.data.urlfilter.URLFilter;
import com.cisco.xdm.net.cmdsvc.CredentialRepository;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.PromptHandlerIf;
import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SystemProp
extends XDMObject
implements PromptHandlerIf {
    private String _hostName = "";
    private String _ipDomainName = "";
    private boolean _isDomainLookup = true;
    private IPAddress _ipDefaultGateway = null;
    private boolean _isIpRouting = true;
    private boolean _isIpCEF = false;
    public static final int PWD_ENCR_NONE = 0;
    public static final int PWD_ENCR_ENABLE = 7;
    private String _enablePWD = "";
    private int _enablePWDEncr = 0;
    private SecretPasswords _secretPWDs = new SecretPasswords((XDMObject)this);
    private SDM_NTPClients _sdm_ntpclients = new SDM_NTPClients(this);
    private SDM_SNTPClients _sdm_sntpclients = new SDM_SNTPClients((XDMObject)this);
    private SyncPCDetails objSyncPCDetails = new SyncPCDetails();
    private BootSystem bootSystem = new BootSystem((XDMObject)this);
    private Users _users = new Users((XDMObject)this);
    private SNMP _snmp = new SNMP((XDMObject)this);
    private URLFilter _urlfilter = new URLFilter((XDMObject)this);
    private VtyLines _vtyLines = new VtyLines(this);
    private String _modemCapValue = "";
    private TtyLines _ttyLines = new TtyLines((XDMObject)this);
    private MgmtAccess _mgmtAccess = null;
    private CLIViews _cliviews = new CLIViews((XDMObject)this);
    private Vector _logs = new Vector();
    private Vector _nameServers = new Vector();
    private LocalPoolCollection _localPoolCollection;
    private PAM _pam;
    private FlowTopTalkers _flowTopTalkers;
    private boolean _fingerService = false;
    private boolean _dhcpService = true;
    private boolean _padService = true;
    private boolean _tcpSmallServer = false;
    private boolean _udpSmallServer = false;
    private boolean _bootpServer = true;
    private boolean _ipIdentificationService = false;
    private boolean _cdpEnabled = true;
    private boolean _ipSourceRoute = true;
    private boolean _servicePassEncr = false;
    private boolean _ipGratuitousArps = false;
    private boolean _tcpKeepAliveIn = false;
    private boolean _tcpKeepAliveOut = false;
    private Timestamp _debugTimestamp;
    private Timestamp _logTimestamp;
    private boolean _sequenceNumbers = false;
    private int _schedulerInterval = -1;
    private int _schedulerInterruptTime = -1;
    private int _schedulerProcessTime = -1;
    private boolean _httpServer = false;
    public static final int HTTP_AUTHEN_NONE = 0;
    public static final int HTTP_AUTHEN_AAA = 1;
    public static final int HTTP_AUTHEN_ENABLE = 2;
    public static final int HTTP_AUTHEN_LOCAL = 3;
    public static final int HTTP_AUTHEN_TACACS = 4;
    private int _httpAuthentication = 0;
    private HttpAAAMethods _aaaMethods = null;
    private String _httpServerACL = "";
    private String _localPolicyRMapName = "";
    private boolean _deleteLocalRMapPolicy = false;
    private boolean _deleteHttpACL = false;
    private int _tcpSynwaitTime = -1;
    private boolean _httpSecureServer = false;
    private int _httpPort = 80;
    private int _httpSecurePort = 443;
    public final String OLDEST = "oldest";
    public final String RANDOM = "random";
    private String _interceptList = "";
    private int _interceptConnectionTimeout = 86400;
    private String _interceptDropMode = "oldest";
    private int _interceptFinrstTimeout = 5;
    private int _interceptMaxIncompleteHigh = 1100;
    private int _interceptMaxIncompleteLow = 900;
    private int _interceptWatchTimeOut = 30;
    private Logging _logging;
    private int _secAuthFailureRate = -1;
    private int _secPassMinLength = 0;
    private int _sshTimeout = 120;
    private int _sshAuthRetries = 3;
    private int _cryptoKeyModulus = -1;
    private boolean _spd;
    private int _spdHeadroom;
    private int _spdExtHeadroom;
    private Line _console;
    private Line _aux;
    private String _banner = "";
    private String _execBanner = "";
    private boolean _rsaCryptoKeyConfigured = false;
    private static boolean _cryptoKeyModulusSupported = false;
    private String _timezone = "UTC";
    private int _tzOffsetHour = 0;
    private int _tzOffsetMin = 0;
    private String _timeSource = "";
    private String _timezoneNoGMT = "UTC";
    private String _strStartMonth = "";
    private int _intStartDate = 1;
    private int _inStartYear = 2003;
    private String _strStartTime = "";
    private String _strEndMonth = "";
    private int _intEndDate = 1;
    private int _inEndYear = 2003;
    private String _strEndTime = "";
    private boolean _timeZoneDST = false;
    private String _DSTZoneName = "";
    private Vector vectTimeZone = new Vector();
    private Vector vectDSTStartTime = new Vector();
    private int _selectedTimeZoneDBindex = 0;
    private boolean _isIpSubnetZero = true;
    private boolean bDBPopulatedforGUI = false;
    private boolean _serviceConfig = false;
    private String _hostConfig = null;
    private String _networkConfig = null;
    public static boolean isISDNSwt = true;
    private String switchType = "";
    private static Hashtable _features = new Hashtable();
    private static final String OPT_IP_IDENT = "ipIdent";
    private static final String OPT_IP_INTERCEPT = "ipIntercept";
    private static final String OPT_SCHEDULER_INTERVAL = "schedulerInterval";
    private static final String OPT_SEC_AUTH_FAIL_RATE = "secAuthFailureRate";
    private static final String OPT_SSH = "ssh";
    private static final String OPT_SPD = "spd";
    private static final String OPT_SEC_PASS_MIN_LEN = "secPassMinLength";
    private static final String OPT_ROUTE_TRACKING = "routeTracking";
    private static final String OPT_TRACKING_RTR = "trackingRTRObject";
    private static final String OPT_HARDWARE_CLOCK = "hardwareClock";
    private static final String OPT_SCHEDULER_ALLOC = "schedulerAllocate";
    private static final String OPT_IP_CEF = "ipCef";
    private static final String OPT_NTPCLIENT = "NTPClient";
    private static final String OPT_SNTPCLIENT = "SNTPClient";
    static final String KEY_HOSTNAME = "hostname";
    static final String KEY_NAME = "name";
    static final String KEY_AAA = "aaa";
    static final String KEY_NEW_MODEL = "new-model";
    static final String KEY_DOMAIN = "domain";
    static final String KEY_DNAME = "dname";
    static final String KEY_IP = "ip";
    static final String KEY_LOOKUP = "lookup";
    static final String KEY_DEFAULT_GATEWAY = "default-gateway";
    static final String KEY_DEFGATEWAY = "defGwy";
    static final String KEY_ADDR = "addr";
    static final String KEY_ROUTING = "routing";
    static final String KEY_ENABLE = "enable";
    static final String KEY_ENCR = "encr";
    static final String KEY_PWD = "pwd";
    static final String KEY_SECRET = "secret";
    static final String KEY_PASSWORD = "password";
    static final String KEY_PASSWORDS = "passwords";
    static final String KEY_CEF = "cef";
    static final String KEY_NAME_SERVER = "name-server";
    static final String KEY_USERNAME = "username";
    static final String KEY_SNMP_SERVER = "snmp-server";
    static final String KEY_LOGGING = "logging";
    static final String KEY_LINE = "line";
    static final String KEY_VTY = "vty";
    static final String KEY_START = "start";
    static final String KEY_END = "end";
    static final String KEY_HOSTID = "hostID";
    static final String KEY_SECURE_SERVER = "secure-server";
    static final String KEY_SERVICE = "service";
    static final String KEY_FINGER = "finger";
    static final String KEY_PAD = "pad";
    static final String KEY_PASS_ENCR = "password-encryption";
    static final String KEY_TCP_SMALL_SERVERS = "tcp-small-servers";
    static final String KEY_UDP_SMALL_SERVERS = "udp-small-servers";
    static final String KEY_TCP_KEEPALIVE_OUT = "tcp-keepalives-out";
    static final String KEY_TCP_KEEPALIVE_IN = "tcp-keepalives-in";
    static final String KEY_BOOTP = "bootp";
    static final String KEY_SERVER = "server";
    static final String KEY_SOURCE_ROUTE = "source-route";
    static final String KEY_SEQUENCE_NUMBERS = "sequence-numbers";
    static final String KEY_IDENTIFICATION = "identd";
    static final String KEY_SCHEDULER = "scheduler";
    static final String KEY_INTERVAL = "interval";
    static final String KEY_ALLOCATE = "allocate";
    static final String KEY_INTERVAL_VAL = "INTERVAL";
    static final String KEY_INTERRUPT_TIME_VAL = "INTERRUPT-TIME";
    static final String KEY_PROCESS_TIME_VAL = "PROCESS-TIME";
    static final String KEY_HTTP = "http";
    static final String KEY_ACCESS_CLASS = "access-class";
    static final String KEY_LOCAL = "local";
    static final String KEY_POLICY = "policy";
    static final String KEY_RMAP = "route-map";
    static final String KEY_RMAP_NAME = "rmapName";
    static final String KEY_ACL_NUM_VAL = "ACL";
    static final String KEY_TCP = "tcp";
    static final String KEY_SYNWAIT_TIME = "synwait-time";
    static final String KEY_SYNWAIT_TIME_VAL = "SYNWAIT-TIME-VAL";
    static final String KEY_INTERCEPT = "intercept";
    static final String KEY_LIST = "list";
    static final String KEY_LIST_VAL = "ACL";
    static final String KEY_CONNECTION_TIMEOUT = "connection-timeout";
    static final String KEY_CONNECTION_TIMEOUT_VAL = "CONNECTION-TIMEOUT-VAL";
    static final String KEY_DROP_MODE = "drop-mode";
    static final String KEY_DROP_MODE_VAL = "DROP-MODE-VAL";
    static final String KEY_FINRST_TIMEOUT = "finrst-timeout";
    static final String KEY_FINRST_TIMEOUT_VAL = "FINRST-TIMEOUT-VAL";
    static final String KEY_MAX_INCOMPLETE = "max-incomplete";
    static final String KEY_HIGH = "high";
    static final String KEY_LOW = "low";
    static final String KEY_MAX_INCOMPLETE_HIGH_VAL = "MAX-INCOMPLETE-HIGH-VAL";
    static final String KEY_MAX_INCOMPLETE_LOW_VAL = "MAX-INCOMPLETE-LOW-VAL";
    static final String KEY_WATCH_TIMEOUT = "watch-timeout";
    static final String KEY_WATCH_TIMEOUT_VAL = "WATCH-TIMEOUT-VAL";
    static final String KEY_SECURITY = "security";
    static final String KEY_AUTHENTICATION = "authentication";
    static final String KEY_FAILURE = "failure";
    static final String KEY_RATE = "rate";
    static final String KEY_SEC_AUTH_FAIL_RATE_VAL = "FAILURE-RATE-VAL";
    static final String KEY_RUN = "run";
    static final String KEY_CDP = "cdp";
    static final String KEY_SSH = "ssh";
    static final String KEY_TIMEOUT = "time-out";
    static final String KEY_TIMEOUT_VAL = "TIME-OUT-VAL";
    static final String KEY_AUTH_RETRIES = "authentication-retries";
    static final String KEY_AUTH_RETRIES_VAL = "AUTH-RETRIES-VAL";
    static final String KEY_CRYPTO = "crypto";
    static final String KEY_KEY = "key";
    static final String KEY_RSA = "rsa";
    static final String KEY_GENERATE = "generate";
    static final String KEY_GENERAL_KEYS = "general-keys";
    static final String KEY_MODULUS = "modulus";
    static final String KEY_MODULUS_VAL = "MODULUS-VAL";
    static final String KEY_SPD = "spd";
    static final String KEY_HEADROOM = "headroom";
    static final String KEY_EXT_HEADROOM = "extended-headroom";
    static final String KEY_HEADROOM_VAL = "HEADROOM-VAL";
    static final String KEY_EXT_HEADROOM_VAL = "EXT-HEADROOM-VAL";
    static final String KEY_SPD_VAL = "SPD-VAL";
    static final String KEY_DISABLE = "disable";
    static final String KEY_MIN_LENGTH = "min-length";
    static final String KEY_SEC_PASS_MIN_LENGTH_VAL = "MIN-LENGTH-VAL";
    static final String KEY_CONSOLE = "con";
    static final String KEY_AUX = "aux";
    static final String KEY_GRAT_ARPS = "gratuitous-arps";
    static final String KEY_BANNER = "banner";
    static final String KEY_LOGIN = "login";
    static final String KEY_EXEC = "exec";
    static final String KEY_BANNER_VAL = "BANNER_VAL";
    static final String KEY_LOG = "log";
    static final String KEY_CLOCK = "clock";
    static final String KEY_TIMEZONE = "timezone";
    static final String KEY_HOUR = "hour";
    static final String KEY_MIN = "min";
    static final String KEY_SUBNET_ZERO = "subnet-zero";
    static final String KEY_DHCP = "dhcp";
    static final String KEY_CONFIG = "config";
    static final String KEY_BOOT = "boot";
    static final String KEY_HOST = "host";
    static final String KEY_NETWORK = "network";
    static final String KEY_FILENAME = "filename";
    static final String KEY_SYSTEM = "system";
    static final String KEY_METHOD = "METHOD";
    static final String KEY_PORT = "port";
    static final String KEY_SECURE_PORT = "secure-port";
    static final String KEY_PORT_NUM_VAL = "PORT";
    static final String KEY_SECURE_PORT_NUM_VAL = "SECURE-PORT";
    static final String KEY_MODEM = "modemcap";
    static final String KEY_ENTRY = "entry";
    static final String KEY_MODEMCAPNAME = "mcapname";
    static final String KEY_MODEMCAPVALUE = "mcapvalue";
    static final String KEY_SWITCHTYPE = "switch-type";
    static final String KEY_ISDN = "isdn";
    static final String KEY_PARSER = "parser";
    static final String KEY_VIEWNAME = "viewname";
    static final String KEY_NTP = "ntp";
    static final String KEY_PEER = "peer";
    static final String KEY_PEERNUMBER = "peerkeynumber";
    static final String KEY_PEERIPADDRESS = "ipNTPpeer";
    static final String KEY_AUTHENTICATIONKEY = "authentication-key";
    static final String KEY_AUTHENTICATE = "authenticate";
    static final String KEY_SNTP = "sntp";
    static final String KEY_MD5VAL = "keyStr";
    static final String KEY_NUMBER = "keyVal";
    static final String KEY_TRUSTED = "trusted-key";
    static final String KEY_TRUSTEDKEYVAL = "keytrusted";
    static final String KEY_SUMMERTIME = "summer-time";
    static final String KEY_UPDATECALENDAR = "update-calendar";

    public SystemProp(XDMObject parent) {
        super(parent);
        this._debugTimestamp = new Timestamp((XDMObject)this, true);
        this._logTimestamp = new Timestamp((XDMObject)this, false);
        this._logging = new Logging((XDMObject)this);
        this._localPoolCollection = new LocalPoolCollection((XDMObject)this, false);
        this._mgmtAccess = new MgmtAccess((DeviceBase)parent);
        this._pam = new PAM(this);
        this._flowTopTalkers = new FlowTopTalkers((XDMObject)this);
    }

    public boolean addLog(String host) {
        boolean ret = false;
        int check = HostIdentity.validateHostIdentity(host, (DeviceBase)this.getDevice());
        HostIdentity newHost = null;
        if (check == -1) {
            newHost = new HostIdentity(host);
        } else if (check == -2) {
            newHost = new HostIdentity(new IPAddress(host));
        }
        if (newHost != null) {
            boolean found = false;
            int i = 0;
            while (i < this._logs.size()) {
                if (newHost.equals(this._logs.elementAt(i))) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this._logs.addElement(newHost);
                this.setModified();
                ret = true;
            }
        }
        return ret;
    }

    public boolean addNameServer(String addr) {
        boolean ret = false;
        if (IPAddress.isLegalIPAddress(addr)) {
            boolean found = false;
            int i = 0;
            while (i < this._nameServers.size()) {
                if (addr.equalsIgnoreCase(this._nameServers.elementAt(i).toString())) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this._nameServers.addElement(new IPAddress(addr));
                this.setModified();
                ret = true;
            }
        }
        return ret;
    }

    public Object clone() {
        SystemProp newObj = (SystemProp)super.clone();
        if (this._ipDefaultGateway != null) {
            newObj._ipDefaultGateway = (IPAddress)this._ipDefaultGateway.clone();
        }
        newObj.bootSystem = (BootSystem)this.bootSystem.clone();
        newObj.bootSystem.setParent(newObj);
        newObj._secretPWDs = (SecretPasswords)this._secretPWDs.clone();
        newObj._secretPWDs.setParent(newObj);
        newObj._users = (Users)this._users.clone();
        newObj._users.setParent(newObj);
        newObj._urlfilter = (URLFilter)this._urlfilter.clone();
        newObj._urlfilter.setParent(newObj);
        newObj._users.setParent(newObj);
        newObj._sdm_ntpclients = (SDM_NTPClients)this._sdm_ntpclients.clone();
        newObj._sdm_sntpclients = (SDM_SNTPClients)this._sdm_sntpclients.clone();
        newObj._sdm_ntpclients.setParent(newObj);
        newObj._sdm_sntpclients.setParent(newObj);
        newObj._snmp = (SNMP)this._snmp.clone();
        newObj._snmp.setParent(newObj);
        newObj._vtyLines = (VtyLines)this._vtyLines.clone();
        newObj._vtyLines.setParent(newObj);
        newObj._ttyLines = (TtyLines)this._ttyLines.clone();
        newObj._ttyLines.setParent(newObj);
        newObj._cliviews = (CLIViews)this._cliviews.clone();
        newObj._cliviews.setParent(newObj);
        if (this._aaaMethods != null) {
            newObj._aaaMethods = (HttpAAAMethods)this._aaaMethods.clone();
            newObj._aaaMethods.setParent(newObj);
        }
        newObj._logs = new Vector();
        int i = 0;
        while (i < this._logs.size()) {
            HostIdentity item = (HostIdentity)((HostIdentity)this._logs.elementAt(i)).clone();
            newObj._logs.addElement(item);
            ++i;
        }
        newObj._nameServers = new Vector();
        int i2 = 0;
        while (i2 < this._nameServers.size()) {
            IPAddress item = (IPAddress)((IPAddress)this._nameServers.elementAt(i2)).clone();
            newObj._nameServers.addElement(item);
            ++i2;
        }
        newObj._localPoolCollection = (LocalPoolCollection)this._localPoolCollection.clone();
        newObj._localPoolCollection.setParent(newObj);
        newObj._pam = (PAM)this._pam.clone();
        newObj._pam.setParent(newObj);
        newObj._flowTopTalkers = (FlowTopTalkers)this._flowTopTalkers.clone();
        newObj._flowTopTalkers.setParent(newObj);
        newObj._mgmtAccess = (MgmtAccess)this._mgmtAccess.clone();
        newObj._logTimestamp = (Timestamp)this._logTimestamp.clone();
        newObj._logTimestamp.setParent(newObj);
        newObj._logging = (Logging)this._logging.clone();
        newObj._logging.setParent(newObj);
        newObj._debugTimestamp = (Timestamp)this._debugTimestamp.clone();
        newObj._debugTimestamp.setParent(newObj);
        if (this._console != null) {
            newObj._console = (Line)this._console.clone();
        }
        if (this._aux != null) {
            newObj._aux = (Line)this._aux.clone();
        }
        return newObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean configureRouterSummerTimeZone(String timeZone, boolean bDSTon) {
        boolean btimeZoneStatus = false;
        try {
            StringBuffer sb = new StringBuffer();
            if (timeZone != null && timeZone.length() > 0) {
                if (!bDSTon) {
                    sb.append("no clock summer-time ");
                    btimeZoneStatus = false;
                } else if (timeZone.equals(this.getTimezone())) {
                    if (bDSTon) return true;
                    sb.append("no clock summer-time ");
                    btimeZoneStatus = false;
                } else {
                    Vector vectTimeZone = this.objSyncPCDetails.getTimeZoneVector();
                    int index = vectTimeZone.indexOf(timeZone);
                    Log.getLog().debug("Index inside Configure Time DST index" + index);
                    if (vectTimeZone.indexOf("UTC") != -1 || vectTimeZone.indexOf("PCTime") != -1) {
                        --index;
                    } else if (vectTimeZone.size() > this.objSyncPCDetails.getDSTStartTimeVector().size()) {
                        Log.getLog().debug("User configured Time Zone is present");
                        --index;
                    }
                    if (index == -1) {
                        sb.append("no clock summer-time ");
                        btimeZoneStatus = false;
                    } else {
                        String startDSTtime;
                        if (this.vectDSTStartTime != null) {
                            this.vectDSTStartTime = this.objSyncPCDetails.getDSTStartTimeVector();
                        }
                        if ((startDSTtime = String.valueOf(String.valueOf(this.vectDSTStartTime.elementAt(index)))) == null || startDSTtime.trim().length() == 0) {
                            sb.append("no clock summer-time ");
                            btimeZoneStatus = false;
                        } else {
                            Vector vectDSTEndTime = this.objSyncPCDetails.getDSTEndTimeVector();
                            Vector vectPCTimeZone = this.objSyncPCDetails.getPCTimeZoneVector();
                            String configurableTimeZone = String.valueOf(String.valueOf(vectPCTimeZone.elementAt(index)));
                            String endDSTtime = String.valueOf(String.valueOf(vectDSTEndTime.elementAt(index)));
                            sb.append("clock summer-time ");
                            sb.append(configurableTimeZone);
                            sb.append(" ");
                            sb.append("date");
                            sb.append(" ");
                            sb.append(String.valueOf(startDSTtime) + " " + endDSTtime);
                            btimeZoneStatus = true;
                        }
                    }
                }
                String[] zonecmd = new String[]{sb.toString()};
                ((DeviceBase)this.getDevice()).getDevInfoBase().getComm().config(zonecmd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._timeZoneDST = btimeZoneStatus;
        return true;
    }

    private boolean configureRouterTime(String time) {
        try {
            IOSCmdService comm = ((DeviceBase)this.getDevice()).getDevInfoBase().getComm();
            String[] commands = new String[]{"clock set " + time};
            IOSCmdResponse[] responses = comm.exec(commands);
            if (responses == null || responses.length < 1) {
                return false;
            }
            String buf = null;
            String[] strHardWareClockcmd = new String[]{"clock update-calendar"};
            if (this.isHardwareClockSupported()) {
                Log.getLog().debug("Hardware Clock supported");
                try {
                    IOSCmdResponse[] HardwareClockresponse = comm.exec(strHardWareClockcmd);
                    if (HardwareClockresponse == null || HardwareClockresponse.length < 1) {
                        return false;
                    }
                    buf = HardwareClockresponse[0].getOutput();
                    Log.getLog().debug("Clock update-calendar output" + buf);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean configureRouterTimeZone(String timeZone, String hrOffset, String minOffset) {
        try {
            StringBuffer sb = new StringBuffer();
            if (timeZone != null && timeZone.length() > 0) {
                sb.append("clock timezone ");
                sb.append(timeZone);
                sb.append(" ");
                sb.append(String.valueOf(hrOffset) + " " + minOffset);
                String[] zonecmd = new String[]{sb.toString()};
                ((DeviceBase)this.getDevice()).getDevInfoBase().getComm().config(zonecmd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTimezone(timeZone, Integer.parseInt(hrOffset.trim()), Integer.parseInt(minOffset.trim()));
        return true;
    }

    private boolean configureRouterTimeZoneDST(String timeZone, String DSTVal) {
        try {
            StringBuffer sb = new StringBuffer();
            if (timeZone != null && timeZone.length() > 0) {
                sb.append("clock summer-time ");
                sb.append(timeZone);
                sb.append(" ");
                sb.append("date");
                sb.append(" ");
                sb.append(DSTVal);
                String[] zonecmd = new String[]{sb.toString()};
                ((DeviceBase)this.getDevice()).getDevInfoBase().getComm().config(zonecmd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._timeZoneDST = true;
        return true;
    }

    public Line createNewAux() {
        this._aux = new Line(0, 0, 1);
        return this._aux;
    }

    public Line createNewConsole() {
        this._console = new Line(0, 0, 2);
        return this._console;
    }

    public void deleteAux() {
        this._aux = null;
    }

    public void deleteConsole() {
        this._console = null;
    }

    private boolean discoverFeature(String key) {
        boolean discovered = false;
        IOSCmdService comm = ((DeviceBase)this.getDevice()).getDevInfoBase().getComm();
        IOSCmdResponse[] replies = null;
        if (key == null) {
            return false;
        }
        try {
            if (key.equals(OPT_IP_IDENT)) {
                String[] cli = new String[]{"ip identd ?"};
                replies = comm.config(cli);
                _features.put(OPT_IP_IDENT, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (key.equals(OPT_IP_INTERCEPT)) {
                String[] cli = new String[]{"ip tcp intercept ?"};
                replies = comm.config(cli);
                _features.put(OPT_IP_INTERCEPT, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (key.equals(OPT_SCHEDULER_INTERVAL) || key.equals(OPT_SCHEDULER_ALLOC)) {
                String[] cli = new String[]{"scheduler ?"};
                replies = comm.config(cli);
                _features.put(OPT_SCHEDULER_ALLOC, new Boolean(XDMDiscovery.getOptionSupportedOnCmd(replies[0], KEY_ALLOCATE)));
                _features.put(OPT_SCHEDULER_INTERVAL, new Boolean(XDMDiscovery.getOptionSupportedOnCmd(replies[0], KEY_INTERVAL)));
                discovered = true;
            } else if (key.equals(OPT_SEC_AUTH_FAIL_RATE)) {
                String[] cli = new String[]{"security authentication failure ?"};
                replies = comm.config(cli);
                _features.put(OPT_SEC_AUTH_FAIL_RATE, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (key.equals("ssh")) {
                String[] cli = new String[]{"ip ssh ?"};
                replies = comm.config(cli);
                _features.put("ssh", new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (key.equals("spd")) {
                String[] cli = new String[]{"spd ?"};
                replies = comm.config(cli);
                _features.put("spd", new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (key.equals(OPT_SEC_PASS_MIN_LEN)) {
                String[] cli = new String[]{"security passwords min-length ?"};
                replies = comm.config(cli);
                _features.put(OPT_SEC_PASS_MIN_LEN, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (key.equals(OPT_ROUTE_TRACKING)) {
                String[] cli = new String[]{"ip route 0.0.0.0 0.0.0.0 10.10.10.1 track ?"};
                replies = comm.config(cli);
                _features.put(OPT_ROUTE_TRACKING, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (key.equals(OPT_TRACKING_RTR)) {
                String[] cli = new String[]{"track 1 rtr ?"};
                replies = comm.config(cli);
                _features.put(OPT_TRACKING_RTR, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (key.equals(OPT_HARDWARE_CLOCK)) {
                String[] cli = new String[]{"show calendar ?"};
                replies = comm.exec(cli);
                _features.put(OPT_HARDWARE_CLOCK, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (key.equals(OPT_IP_CEF)) {
                String[] cli = new String[]{"show ip cef ?"};
                replies = comm.exec(cli);
                _features.put(OPT_IP_CEF, new Boolean(XDMDiscovery.isOKResponse(replies[0])));
                discovered = true;
            } else if (key.equals(OPT_NTPCLIENT) || key.equals(OPT_SNTPCLIENT)) {
                boolean[] bNTP = XDMDiscovery.isNTPandSNTPSupported(comm);
                _features.put(OPT_NTPCLIENT, new Boolean(bNTP[0]));
                _features.put(OPT_SNTPCLIENT, new Boolean(bNTP[1]));
                discovered = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return discovered;
    }

    public void enableLogging(boolean enable) {
        this._logging.enableLogging(enable);
    }

    public boolean equals(Object obj) {
        return false;
    }

    public int generateCmdForCrypto(CredentialRepository cred) {
        SystemProp sys;
        if (!_cryptoKeyModulusSupported) {
            return -1;
        }
        if (this._cryptoKeyModulus < 360 || this._cryptoKeyModulus > 2048) {
            return -1;
        }
        DeviceBase backupDev = ((DeviceBase)this.getDevice()).getBackup();
        if (backupDev != null && (sys = backupDev.getSystemProp()) != null && sys.getIpDomainName().length() == 0) {
            return -2;
        }
        try {
            Log.getLog().debug("in generate crypto cmd");
            IOSCmdService comm = ((DeviceBase)this.getDevice()).getDevInfoBase().getInteractiveComm(cred);
            if (comm == null) {
                return -1;
            }
            int oldtimeout = comm.getTimeout();
            comm.setTimeout(900000);
            String[] commands = new String[]{"crypto key generate rsa general-keys"};
            IOSCmdResponse[] responses = comm.config(commands, this);
            comm.setTimeout(oldtimeout);
            Log.getLog().debug("Got response from the config command. ");
            if (responses == null || responses.length < 1) {
                comm.close();
                return -1;
            }
            comm.close();
            this._rsaCryptoKeyConfigured = true;
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        CmdValues cmd;
        CmdValues cmd2;
        CmdValues cmd3;
        if (backup == null || !(backup instanceof SystemProp)) {
            throw new XDMException(4);
        }
        Log log = Log.getLog();
        log.debug("Enter SystempProp.generateDelta");
        SystemProp bObj = (SystemProp)backup;
        if (!this._hostName.equals(bObj._hostName)) {
            cmd3 = new CmdValues(KEY_HOSTNAME);
            if (this._hostName.length() == 0) {
                cmd3.setAction(2);
            } else {
                cmd3.addValue(KEY_NAME, this._hostName);
            }
            values.addCmdValues(cmd3);
        }
        if (!this.bootSystem.equals((Object)bObj.bootSystem)) {
            this.bootSystem.generateDelta((XDMObject)bObj.bootSystem, values);
        }
        if (!this._ipDomainName.equals(bObj._ipDomainName)) {
            cmd3 = new CmdValues(KEY_IP);
            cmd3.addValue(KEY_DOMAIN, KEY_DOMAIN);
            cmd3.addValue(KEY_NAME, KEY_NAME);
            if (this._ipDomainName.length() == 0) {
                cmd3.setAction(2);
            } else {
                cmd3.addValue(KEY_DNAME, this._ipDomainName);
            }
            values.addCmdValues(cmd3);
        }
        if (this._isDomainLookup != bObj._isDomainLookup) {
            cmd3 = new CmdValues(KEY_IP);
            cmd3.addValue(KEY_DOMAIN, KEY_DOMAIN);
            cmd3.addValue(KEY_LOOKUP, KEY_LOOKUP);
            if (!this._isDomainLookup) {
                cmd3.setAction(2);
            }
            values.addCmdValues(cmd3);
        }
        if (this._isIpSubnetZero != bObj._isIpSubnetZero) {
            cmd3 = new CmdValues(KEY_IP);
            cmd3.addValue(KEY_SUBNET_ZERO, KEY_SUBNET_ZERO);
            if (!this._isIpSubnetZero) {
                cmd3.setAction(2);
            }
            values.addCmdValues(cmd3);
        }
        String oldDefGateway = "";
        String curDefGateway = "";
        if (this._ipDefaultGateway != null) {
            curDefGateway = this._ipDefaultGateway.toString();
        }
        if (bObj._ipDefaultGateway != null) {
            oldDefGateway = bObj._ipDefaultGateway.toString();
        }
        if (!curDefGateway.equals(oldDefGateway)) {
            cmd2 = new CmdValues(KEY_IP);
            cmd2.addValue(KEY_DEFAULT_GATEWAY, KEY_DEFAULT_GATEWAY);
            if (curDefGateway.length() == 0) {
                cmd2.setAction(2);
            } else {
                cmd2.addValue(KEY_DEFGATEWAY, curDefGateway);
            }
            values.addCmdValues(cmd2);
        }
        if (this._aaaMethods == null && bObj._aaaMethods != null) {
            bObj._aaaMethods.generateDelta(null, values);
        }
        if (this._isIpRouting != bObj._isIpRouting) {
            cmd2 = new CmdValues(KEY_IP);
            cmd2.addValue(KEY_ROUTING, KEY_ROUTING);
            if (!this._isIpRouting) {
                cmd2.setAction(2);
            }
            values.addCmdValues(cmd2);
        }
        if (this.isSupported(OPT_IP_CEF) && this._isIpCEF != bObj._isIpCEF) {
            cmd2 = new CmdValues(KEY_IP);
            cmd2.addValue(KEY_CEF, KEY_CEF);
            if (!this._isIpCEF) {
                cmd2.setAction(2);
                values.addCmdValues(cmd2);
            } else {
                int pos = ((DeviceBase)this.getDevice()).getFirstCmdPosition("ifs", values, false);
                if (pos >= 0) {
                    values.insertCmdValues(cmd2, pos);
                } else {
                    values.addCmdValues(cmd2);
                }
            }
        }
        if (!this._enablePWD.equals(bObj._enablePWD)) {
            cmd2 = new CmdValues(KEY_ENABLE);
            cmd2.addValue(KEY_PASSWORD, KEY_PASSWORD);
            if (this._enablePWD.length() == 0) {
                cmd2.setAction(2);
            } else {
                cmd2.addValue(KEY_ENCR, String.valueOf(this._enablePWDEncr));
                cmd2.addValue(KEY_PWD, this._enablePWD);
            }
            values.addCmdValues(cmd2);
        }
        if (this._secretPWDs.isModified()) {
            this._secretPWDs.generateDelta((XDMObject)bObj._secretPWDs, values);
        }
        if (this._users.isModified()) {
            this._users.generateDelta((XDMObject)bObj._users, values);
        }
        if (this._cliviews.isModified()) {
            this._cliviews.generateDelta((XDMObject)bObj._cliviews, values);
        }
        if (this._sdm_ntpclients.isModified()) {
            this._sdm_ntpclients.generateDelta(bObj._sdm_ntpclients, values);
        }
        if (this._sdm_sntpclients.isModified()) {
            this._sdm_sntpclients.generateDelta((XDMObject)bObj._sdm_sntpclients, values);
        }
        if (this._snmp.isModified()) {
            this._snmp.generateDelta((XDMObject)bObj._snmp, values);
        }
        if (this._urlfilter.isModified()) {
            this._urlfilter.generateDelta((XDMObject)bObj._urlfilter, values);
        }
        if (this._vtyLines.isModified()) {
            this._vtyLines.generateDelta(bObj._vtyLines, values);
        }
        if (this._ttyLines.isModified()) {
            this._ttyLines.generateDelta((XDMObject)bObj._ttyLines, values);
        }
        if (this._console != null) {
            if (this._console.isModified()) {
                this._console.generateDelta(bObj._console, values);
            }
        } else if (bObj._console != null) {
            this._console.generateDelta(null, values);
        }
        if (this._aux != null) {
            if (this._aux.isModified()) {
                this._aux.generateDelta(bObj._aux, values);
            }
        } else if (bObj._aux != null) {
            this._aux.generateDelta(null, values);
        }
        int index = 0;
        while (index < bObj._logs.size()) {
            if (!this._logs.contains(bObj._logs.elementAt(index))) {
                CmdValues cmd4 = this.generateLog(bObj._logs.elementAt(index), true);
                values.addCmdValues(cmd4);
            }
            ++index;
        }
        int index2 = 0;
        while (index2 < this._logs.size()) {
            if (!bObj._logs.contains(this._logs.elementAt(index2))) {
                CmdValues cmd5 = this.generateLog(this._logs.elementAt(index2), false);
                values.addCmdValues(cmd5);
            }
            ++index2;
        }
        int index3 = 0;
        while (index3 < bObj._nameServers.size()) {
            if (!this._nameServers.contains(bObj._nameServers.elementAt(index3))) {
                CmdValues cmd6 = this.generateNS(bObj._nameServers.elementAt(index3), true);
                values.addCmdValues(cmd6);
            }
            ++index3;
        }
        int index4 = 0;
        while (index4 < this._nameServers.size()) {
            if (!bObj._nameServers.contains(this._nameServers.elementAt(index4))) {
                cmd = this.generateNS(this._nameServers.elementAt(index4), false);
                values.addCmdValues(cmd);
            }
            ++index4;
        }
        if (this._fingerService != bObj._fingerService) {
            CmdValues fingerCmd = new CmdValues(KEY_IP);
            fingerCmd.addValue(KEY_FINGER, KEY_FINGER);
            if (!this._fingerService) {
                fingerCmd.setAction(2);
            }
            values.addCmdValues(fingerCmd);
        }
        if (this._padService != bObj._padService) {
            CmdValues padCmd = new CmdValues(KEY_SERVICE);
            padCmd.addValue(KEY_PAD, KEY_PAD);
            if (!this._padService) {
                padCmd.setAction(2);
            }
            values.addCmdValues(padCmd);
        }
        if (this._servicePassEncr != bObj._servicePassEncr) {
            cmd = new CmdValues(KEY_SERVICE);
            cmd.addValue(KEY_PASS_ENCR, KEY_PASS_ENCR);
            if (!this._servicePassEncr) {
                cmd.setAction(2);
            }
            values.addCmdValues(cmd);
        }
        if (this._tcpSmallServer != bObj._tcpSmallServer) {
            CmdValues tcpSmallServerCmd = new CmdValues(KEY_SERVICE);
            tcpSmallServerCmd.addValue(KEY_TCP_SMALL_SERVERS, KEY_TCP_SMALL_SERVERS);
            if (!this._tcpSmallServer) {
                tcpSmallServerCmd.setAction(2);
            }
            values.addCmdValues(tcpSmallServerCmd);
        }
        if (this._udpSmallServer != bObj._udpSmallServer) {
            CmdValues udpSmallServerCmd = new CmdValues(KEY_SERVICE);
            udpSmallServerCmd.addValue(KEY_UDP_SMALL_SERVERS, KEY_UDP_SMALL_SERVERS);
            if (!this._udpSmallServer) {
                udpSmallServerCmd.setAction(2);
            }
            values.addCmdValues(udpSmallServerCmd);
        }
        if (this._dhcpService != bObj._dhcpService) {
            cmd = new CmdValues(KEY_SERVICE);
            cmd.addValue(KEY_DHCP, KEY_DHCP);
            if (!this._dhcpService) {
                cmd.setAction(2);
            }
            values.addCmdValues(cmd);
        }
        if (this._tcpKeepAliveIn != bObj._tcpKeepAliveIn) {
            CmdValues tcpKeepAliveInCmd = new CmdValues(KEY_SERVICE);
            tcpKeepAliveInCmd.addValue(KEY_TCP_KEEPALIVE_IN, KEY_TCP_KEEPALIVE_IN);
            if (!this._tcpKeepAliveIn) {
                tcpKeepAliveInCmd.setAction(2);
            }
            values.addCmdValues(tcpKeepAliveInCmd);
        }
        if (this._tcpKeepAliveOut != bObj._tcpKeepAliveOut) {
            CmdValues tcpKeepAliveOutCmd = new CmdValues(KEY_SERVICE);
            tcpKeepAliveOutCmd.addValue(KEY_TCP_KEEPALIVE_OUT, KEY_TCP_KEEPALIVE_OUT);
            if (!this._tcpKeepAliveOut) {
                tcpKeepAliveOutCmd.setAction(2);
            }
            values.addCmdValues(tcpKeepAliveOutCmd);
        }
        if (this._bootpServer != bObj._bootpServer) {
            CmdValues bootpServerCmd = new CmdValues(KEY_IP);
            bootpServerCmd.addValue(KEY_BOOTP, KEY_BOOTP);
            bootpServerCmd.addValue(KEY_SERVER, KEY_SERVER);
            if (!this._bootpServer) {
                bootpServerCmd.setAction(2);
            }
            values.addCmdValues(bootpServerCmd);
        }
        if (this._ipSourceRoute != bObj._ipSourceRoute) {
            CmdValues sourceRouteCmd = new CmdValues(KEY_IP);
            sourceRouteCmd.addValue(KEY_SOURCE_ROUTE, KEY_SOURCE_ROUTE);
            if (!this._ipSourceRoute) {
                sourceRouteCmd.setAction(2);
            }
            values.addCmdValues(sourceRouteCmd);
        }
        if (this._ipGratuitousArps != bObj._ipGratuitousArps) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_GRAT_ARPS, KEY_GRAT_ARPS);
            if (!this._ipGratuitousArps) {
                cmd.setAction(2);
            }
            values.addCmdValues(cmd);
        }
        if (this.isSupported(OPT_IP_IDENT) && this._ipIdentificationService != bObj._ipIdentificationService) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_IDENTIFICATION, KEY_IDENTIFICATION);
            if (!this._ipIdentificationService) {
                cmd.setAction(2);
            }
            values.addCmdValues(cmd);
        }
        if (this._sequenceNumbers != bObj._sequenceNumbers) {
            CmdValues sequenceNumberCmd = new CmdValues(KEY_SERVICE);
            sequenceNumberCmd.addValue(KEY_SEQUENCE_NUMBERS, KEY_SEQUENCE_NUMBERS);
            if (!this._sequenceNumbers) {
                sequenceNumberCmd.setAction(2);
            }
            values.addCmdValues(sequenceNumberCmd);
        }
        if (!this._debugTimestamp.equals((Object)bObj._debugTimestamp)) {
            this._debugTimestamp.generateDelta(null, values);
        }
        if (!this._logTimestamp.equals((Object)bObj._logTimestamp)) {
            this._logTimestamp.generateDelta(null, values);
        }
        if (this.isSupported(OPT_SCHEDULER_INTERVAL) && this._schedulerInterval != bObj._schedulerInterval) {
            cmd = new CmdValues(KEY_SCHEDULER);
            cmd.addValue(KEY_INTERVAL, KEY_INTERVAL);
            if (this._schedulerInterval == -1) {
                cmd.setAction(2);
            } else {
                cmd.addValue(KEY_INTERVAL_VAL, String.valueOf(this._schedulerInterval));
            }
            values.addCmdValues(cmd);
        }
        if (this.isSupported(OPT_SCHEDULER_ALLOC) && (this._schedulerInterruptTime != bObj._schedulerInterruptTime || this._schedulerProcessTime != bObj._schedulerProcessTime)) {
            cmd = new CmdValues(KEY_SCHEDULER);
            cmd.addValue(KEY_ALLOCATE, KEY_ALLOCATE);
            if (this._schedulerInterruptTime == -1 && this._schedulerProcessTime == -1) {
                cmd.setAction(2);
                values.addCmdValues(cmd);
            } else if (this._schedulerInterruptTime != -1 && this._schedulerProcessTime != -1) {
                cmd.addValue(KEY_INTERRUPT_TIME_VAL, String.valueOf(this._schedulerInterruptTime));
                cmd.addValue(KEY_PROCESS_TIME_VAL, String.valueOf(this._schedulerProcessTime));
                values.addCmdValues(cmd);
            }
        }
        if (this._httpServer != bObj._httpServer) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_HTTP, KEY_HTTP);
            cmd.addValue(KEY_SERVER, KEY_SERVER);
            values.addCmdValues(cmd);
        }
        if (this._httpServerACL != bObj._httpServerACL || this._deleteHttpACL != bObj._deleteHttpACL) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_HTTP, KEY_HTTP);
            cmd.addValue(KEY_ACCESS_CLASS, KEY_ACCESS_CLASS);
            cmd.addValue("ACL", this._httpServerACL);
            if (this._deleteHttpACL) {
                cmd.setAction(2);
            }
            values.addCmdValues(cmd);
        }
        if (this._httpAuthentication != bObj._httpAuthentication) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_HTTP, KEY_HTTP);
            cmd.addValue(KEY_AUTHENTICATION, KEY_AUTHENTICATION);
            if (this._httpAuthentication == 0) {
                cmd.setAction(2);
            } else if (this._httpAuthentication == 1) {
                cmd.addValue(KEY_METHOD, KEY_AAA);
            } else if (this._httpAuthentication == 2) {
                cmd.addValue(KEY_METHOD, KEY_ENABLE);
            } else if (this._httpAuthentication == 3) {
                cmd.addValue(KEY_METHOD, KEY_LOCAL);
            } else if (this._httpAuthentication == 4) {
                cmd.addValue(KEY_METHOD, "tacacs");
            }
            values.addCmdValues(cmd);
        }
        if (!this._localPolicyRMapName.equals(bObj._localPolicyRMapName) || this._deleteLocalRMapPolicy != bObj._deleteLocalRMapPolicy) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_LOCAL, KEY_LOCAL);
            cmd.addValue(KEY_POLICY, KEY_POLICY);
            cmd.addValue(KEY_RMAP, KEY_RMAP);
            cmd.addValue(KEY_RMAP_NAME, this._localPolicyRMapName);
            if (this._deleteLocalRMapPolicy) {
                cmd.setAction(2);
                int index5 = ((DeviceBase)this.getDevice()).getFirstCmdPosition("acls", values, true);
                if (index5 != -1) {
                    values.insertCmdValues(cmd, index5);
                } else {
                    values.addCmdValues(cmd);
                }
            } else {
                values.addCmdValues(cmd);
            }
        }
        if (this._httpSecureServer != bObj._httpSecureServer) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_HTTP, KEY_HTTP);
            cmd.addValue(KEY_SECURE_SERVER, KEY_SECURE_SERVER);
            if (!this._httpSecureServer) {
                cmd.setAction(2);
            }
            values.addCmdValues(cmd);
        }
        if (this._tcpSynwaitTime != bObj._tcpSynwaitTime) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_TCP, KEY_TCP);
            cmd.addValue(KEY_SYNWAIT_TIME, KEY_SYNWAIT_TIME);
            if (this._tcpSynwaitTime == -1) {
                cmd.setAction(2);
            } else {
                cmd.addValue(KEY_SYNWAIT_TIME_VAL, String.valueOf(this._tcpSynwaitTime));
            }
            values.addCmdValues(cmd);
        }
        if (this.isSupported(OPT_IP_INTERCEPT)) {
            if (!this._interceptList.equalsIgnoreCase(bObj._interceptList)) {
                cmd = new CmdValues(KEY_IP);
                cmd.addValue(KEY_TCP, KEY_TCP);
                cmd.addValue(KEY_INTERCEPT, KEY_INTERCEPT);
                cmd.addValue(KEY_LIST, KEY_LIST);
                if (this._interceptList.length() == 0) {
                    cmd.setAction(2);
                } else {
                    cmd.addValue("ACL", this._interceptList);
                }
                values.addCmdValues(cmd);
            }
            if (this._interceptConnectionTimeout != bObj._interceptConnectionTimeout) {
                cmd = new CmdValues(KEY_IP);
                cmd.addValue(KEY_TCP, KEY_TCP);
                cmd.addValue(KEY_INTERCEPT, KEY_INTERCEPT);
                cmd.addValue(KEY_CONNECTION_TIMEOUT, KEY_CONNECTION_TIMEOUT);
                cmd.addValue(KEY_CONNECTION_TIMEOUT_VAL, String.valueOf(this._interceptConnectionTimeout));
                values.addCmdValues(cmd);
            }
            if (!this._interceptDropMode.equalsIgnoreCase(bObj._interceptDropMode)) {
                cmd = new CmdValues(KEY_IP);
                cmd.addValue(KEY_TCP, KEY_TCP);
                cmd.addValue(KEY_INTERCEPT, KEY_INTERCEPT);
                cmd.addValue(KEY_DROP_MODE, KEY_DROP_MODE);
                cmd.addValue(KEY_DROP_MODE_VAL, String.valueOf(this._interceptDropMode));
                values.addCmdValues(cmd);
            }
            if (this._interceptFinrstTimeout != bObj._interceptFinrstTimeout) {
                cmd = new CmdValues(KEY_IP);
                cmd.addValue(KEY_TCP, KEY_TCP);
                cmd.addValue(KEY_INTERCEPT, KEY_INTERCEPT);
                cmd.addValue(KEY_FINRST_TIMEOUT, KEY_FINRST_TIMEOUT);
                cmd.addValue(KEY_FINRST_TIMEOUT_VAL, String.valueOf(this._interceptFinrstTimeout));
                values.addCmdValues(cmd);
            }
            if (this._interceptMaxIncompleteHigh != bObj._interceptMaxIncompleteHigh) {
                cmd = new CmdValues(KEY_IP);
                cmd.addValue(KEY_TCP, KEY_TCP);
                cmd.addValue(KEY_INTERCEPT, KEY_INTERCEPT);
                cmd.addValue(KEY_MAX_INCOMPLETE, KEY_MAX_INCOMPLETE);
                cmd.addValue(KEY_HIGH, KEY_HIGH);
                cmd.addValue(KEY_MAX_INCOMPLETE_HIGH_VAL, String.valueOf(this._interceptMaxIncompleteHigh));
                values.addCmdValues(cmd);
            }
            if (this._interceptMaxIncompleteLow != bObj._interceptMaxIncompleteLow) {
                cmd = new CmdValues(KEY_IP);
                cmd.addValue(KEY_TCP, KEY_TCP);
                cmd.addValue(KEY_INTERCEPT, KEY_INTERCEPT);
                cmd.addValue(KEY_MAX_INCOMPLETE, KEY_MAX_INCOMPLETE);
                cmd.addValue(KEY_LOW, KEY_LOW);
                cmd.addValue(KEY_MAX_INCOMPLETE_LOW_VAL, String.valueOf(this._interceptMaxIncompleteLow));
                values.addCmdValues(cmd);
            }
            if (this._interceptWatchTimeOut != bObj._interceptWatchTimeOut) {
                cmd = new CmdValues(KEY_IP);
                cmd.addValue(KEY_TCP, KEY_TCP);
                cmd.addValue(KEY_INTERCEPT, KEY_INTERCEPT);
                cmd.addValue(KEY_WATCH_TIMEOUT, KEY_WATCH_TIMEOUT);
                cmd.addValue(KEY_WATCH_TIMEOUT_VAL, String.valueOf(this._interceptWatchTimeOut));
                values.addCmdValues(cmd);
            }
        }
        if (this._cdpEnabled != bObj._cdpEnabled) {
            cmd = new CmdValues(KEY_CDP);
            cmd.addValue(KEY_RUN, KEY_RUN);
            if (!this._cdpEnabled) {
                cmd.setAction(2);
            }
            values.addCmdValues(cmd);
        }
        if (this.isSupported(OPT_SEC_AUTH_FAIL_RATE) && this._secAuthFailureRate != bObj._secAuthFailureRate) {
            cmd = new CmdValues(KEY_SECURITY);
            cmd.addValue(KEY_AUTHENTICATION, KEY_AUTHENTICATION);
            cmd.addValue(KEY_FAILURE, KEY_FAILURE);
            cmd.addValue(KEY_RATE, KEY_RATE);
            cmd.addValue(KEY_SEC_AUTH_FAIL_RATE_VAL, String.valueOf(this._secAuthFailureRate));
            cmd.addValue(KEY_LOG, KEY_LOG);
            values.addCmdValues(cmd);
        }
        if (this.isSupported(OPT_SEC_PASS_MIN_LEN) && this._secPassMinLength != bObj._secPassMinLength) {
            cmd = new CmdValues(KEY_SECURITY);
            cmd.addValue(KEY_PASSWORDS, KEY_PASSWORDS);
            cmd.addValue(KEY_MIN_LENGTH, KEY_MIN_LENGTH);
            cmd.addValue(KEY_SEC_PASS_MIN_LENGTH_VAL, String.valueOf(this._secPassMinLength));
            values.addCmdValues(cmd);
        }
        if (this.isSupported("ssh") && this._sshTimeout != bObj._sshTimeout) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue("ssh", "ssh");
            cmd.addValue(KEY_TIMEOUT, KEY_TIMEOUT);
            cmd.addValue(KEY_TIMEOUT_VAL, String.valueOf(this._sshTimeout));
            values.addCmdValues(cmd);
        }
        if (this.isSupported("ssh") && this._sshAuthRetries != bObj._sshAuthRetries) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue("ssh", "ssh");
            cmd.addValue(KEY_AUTH_RETRIES, KEY_AUTH_RETRIES);
            cmd.addValue(KEY_AUTH_RETRIES_VAL, String.valueOf(this._sshAuthRetries));
            values.addCmdValues(cmd);
        }
        if (this.isSupported("spd")) {
            if (this._spd != bObj._spd) {
                cmd = new CmdValues("spd");
                cmd.addValue(KEY_SPD_VAL, this._spd ? KEY_ENABLE : KEY_DISABLE);
                values.addCmdValues(cmd);
            }
            if (this._spdHeadroom != bObj._spdHeadroom) {
                cmd = new CmdValues("spd");
                cmd.addValue(KEY_HEADROOM, KEY_HEADROOM);
                cmd.addValue(KEY_HEADROOM_VAL, String.valueOf(this._spdHeadroom));
                values.addCmdValues(cmd);
            }
            if (this._spdExtHeadroom != bObj._spdExtHeadroom) {
                cmd = new CmdValues("spd");
                cmd.addValue(KEY_EXT_HEADROOM, KEY_EXT_HEADROOM);
                cmd.addValue(KEY_EXT_HEADROOM_VAL, String.valueOf(this._spdExtHeadroom));
                values.addCmdValues(cmd);
            }
        }
        if (!this._banner.equals(bObj._banner)) {
            cmd = new CmdValues(KEY_BANNER);
            cmd.addValue(KEY_LOGIN, KEY_LOGIN);
            if (this._banner.length() == 0) {
                cmd.setAction(2);
            } else {
                cmd.addValue(KEY_BANNER_VAL, "~" + this._banner + "~");
            }
            values.addCmdValues(cmd);
        }
        if (!this._execBanner.equals(bObj._execBanner)) {
            cmd = new CmdValues(KEY_BANNER);
            cmd.addValue(KEY_EXEC, KEY_EXEC);
            if (this._execBanner.length() == 0) {
                cmd.setAction(2);
            } else {
                cmd.addValue(KEY_BANNER_VAL, "~" + this._execBanner + "~");
            }
            values.addCmdValues(cmd);
        }
        if (this.switchType.length() > 0 && !isISDNSwt) {
            cmd = new CmdValues(KEY_ISDN);
            cmd.addValue(KEY_SWITCHTYPE, KEY_SWITCHTYPE);
            cmd.addValue("switchName", this.switchType);
            values.addCmdValues(cmd);
            isISDNSwt = true;
        }
        this._logging.generateDelta((XDMObject)bObj._logging, values);
        this._localPoolCollection.generateDelta((XDMObject)bObj._localPoolCollection, values);
        this._pam.generateDelta(bObj._pam, values);
        if (this._flowTopTalkers.isModified()) {
            this._flowTopTalkers.generateDelta((XDMObject)bObj._flowTopTalkers, values);
        }
        log.debug("Leave SystempProp.generateDelta");
    }

    private CmdValues generateLog(Object log, boolean noCmd) {
        CmdValues cmd = new CmdValues(KEY_LOGGING);
        cmd.addValue(KEY_HOSTID, log.toString());
        if (noCmd) {
            cmd.setAction(2);
        }
        return cmd;
    }

    private CmdValues generateNS(Object ns, boolean noCmd) {
        CmdValues cmd = new CmdValues(KEY_IP);
        cmd.addValue(KEY_NAME_SERVER, KEY_NAME_SERVER);
        cmd.addValue(KEY_ADDR, ns.toString());
        if (noCmd) {
            cmd.setAction(2);
        }
        return cmd;
    }

    public Line getAux() {
        return this._aux;
    }

    public String getBanner() {
        return this._banner;
    }

    public BootSystem getBootSystem() {
        return this.bootSystem;
    }

    public boolean getBootpServer() {
        return this._bootpServer;
    }

    public boolean getCDPEnabled() {
        return this._cdpEnabled;
    }

    public String getCLIViewDetails(String strViewName) {
        CLIView view = (CLIView)this.getCLIViews().get(strViewName);
        if (view != null && view.getViewDefinition() != null) {
            return view.getViewDefinition();
        }
        return "";
    }

    public CLIViews getCLIViews() {
        return this._cliviews;
    }

    public int getConfigurableStartGMTHourOffset(String strTimeZone) {
        Log.getLog().debug("inside getConfigurableStartGMTOffset strTimeZone" + strTimeZone);
        if (strTimeZone != null && strTimeZone.equals(this.getTimezone())) {
            return this._tzOffsetHour;
        }
        strTimeZone = strTimeZone.trim();
        Vector vectGUITimeZone = this.objSyncPCDetails.getTimeZoneVector();
        int index = vectGUITimeZone.indexOf(strTimeZone);
        if (this.vectTimeZone.indexOf("UTC") != -1 || this.vectTimeZone.indexOf("PCTime") != -1) {
            --index;
        } else if (this.vectTimeZone.size() > this.objSyncPCDetails.getDSTStartTimeVector().size()) {
            --index;
        }
        if (index == -1) {
            return this._tzOffsetHour;
        }
        Vector vectGMTOffset = this.objSyncPCDetails.getGMTOffsetVector();
        String strGMTOffset = String.valueOf(String.valueOf(vectGMTOffset.elementAt(index))).trim();
        int strGMTHrOffset = Integer.parseInt(strGMTOffset.substring(0, strGMTOffset.indexOf(" ")).trim());
        Log.getLog().debug("inside getConfigurableStartGMTOffset strGMTHrOffset" + strGMTHrOffset);
        return strGMTHrOffset;
    }

    public int getConfigurableStartGMTMinOffset(String strTimeZone) {
        Log.getLog().debug("inside getConfigurableStartGMTMinOffset strTimeZone" + strTimeZone);
        if (strTimeZone != null && strTimeZone.equals(this.getTimezone())) {
            return this._tzOffsetMin;
        }
        strTimeZone = strTimeZone.trim();
        Vector vectGUITimeZone = this.objSyncPCDetails.getTimeZoneVector();
        int index = vectGUITimeZone.indexOf(strTimeZone);
        if (this.vectTimeZone.indexOf("UTC") != -1 || this.vectTimeZone.indexOf("PCTime") != -1) {
            --index;
        } else if (this.vectTimeZone.size() > this.objSyncPCDetails.getDSTStartTimeVector().size()) {
            --index;
        }
        if (index == -1) {
            return this._tzOffsetMin;
        }
        Vector vectGMTOffset = this.objSyncPCDetails.getGMTOffsetVector();
        String strGMTOffset = String.valueOf(String.valueOf(vectGMTOffset.elementAt(index))).trim();
        int strGMTMinOffset = Integer.parseInt(strGMTOffset.substring(strGMTOffset.indexOf(" ") + 1, strGMTOffset.length()));
        Log.getLog().debug("inside getConfigurableStartGMTMinOffset strGMTMinOffset" + strGMTMinOffset);
        return strGMTMinOffset;
    }

    public String getConfigurableTimeZone(String strTimeZone) {
        Log.getLog().debug("inside getConfigurableTimeZone strTimeZone" + strTimeZone);
        if (strTimeZone != null && strTimeZone.equals(this.getTimezone())) {
            String tempStr = strTimeZone.substring(this._timezone.indexOf(")") + 2, this._timezone.length());
            Log.getLog().debug("inside getConfigurableTimeZone tempStr" + tempStr);
            return tempStr;
        }
        strTimeZone = strTimeZone.trim();
        Vector vectGUITimeZone = this.objSyncPCDetails.getTimeZoneVector();
        int index = vectGUITimeZone.indexOf(strTimeZone);
        if (this.vectTimeZone.indexOf("UTC") != -1 || this.vectTimeZone.indexOf("PCTime") != -1) {
            --index;
        } else if (this.vectTimeZone.size() > this.objSyncPCDetails.getDSTStartTimeVector().size()) {
            --index;
        }
        Log.getLog().debug("inside getConfigurableTimeZone index" + index + "size" + vectGUITimeZone.size());
        if (index == -1) {
            return strTimeZone;
        }
        Vector vectPCTimeZone = this.objSyncPCDetails.getPCTimeZoneVector();
        String configurableTimeZone = String.valueOf(String.valueOf(vectPCTimeZone.elementAt(index))).trim();
        Log.getLog().debug("inside getConfigurableTimeZone configurableTimeZone" + configurableTimeZone + "vectPCTimeZone.size()" + vectPCTimeZone.size());
        if (configurableTimeZone != null && configurableTimeZone.trim().length() != 0) {
            return configurableTimeZone;
        }
        return strTimeZone;
    }

    public Line getConsole() {
        return this._console;
    }

    public int getCryptoKeyModulus() {
        return this._cryptoKeyModulus;
    }

    public boolean getDHCPService() {
        return this._dhcpService;
    }

    public Vector getDNSServers() {
        return this._nameServers;
    }

    public String getDSTZoneName() {
        return this._DSTZoneName;
    }

    public Timestamp getDebugTimestamp() {
        return this._debugTimestamp;
    }

    public boolean getDefaultCDP() {
        return true;
    }

    public String getDefaultDropMode() {
        return "oldest";
    }

    public int getDefaultInterceptConnectionTimeout() {
        return this.getDefaultValue(KEY_IP, KEY_CONNECTION_TIMEOUT_VAL);
    }

    public int getDefaultInterceptFinrstTimeout() {
        return this.getDefaultValue(KEY_IP, KEY_FINRST_TIMEOUT_VAL);
    }

    public int getDefaultInterceptMaxIncompleteHigh() {
        return this.getDefaultValue(KEY_IP, KEY_MAX_INCOMPLETE_HIGH_VAL);
    }

    public int getDefaultInterceptMaxIncompleteLow() {
        return this.getDefaultValue(KEY_IP, KEY_MAX_INCOMPLETE_LOW_VAL);
    }

    public int getDefaultInterceptWatchTimeout() {
        return this.getDefaultValue(KEY_IP, KEY_WATCH_TIMEOUT_VAL);
    }

    public int getDefaultSchedulerInterruptTime() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        if (dev.getDevInfoBase().getModel().indexOf("28") == 0 || dev.getDevInfoBase().getModel().startsWith("38")) {
            return 20000;
        }
        return 4000;
    }

    public int getDefaultSchedulerInterval() {
        return this.getDefaultValue(KEY_SCHEDULER, KEY_INTERVAL_VAL);
    }

    public int getDefaultSchedulerProcessTime() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        if (dev.getDevInfoBase().getModel().indexOf("7") == 0) {
            return 200;
        }
        return 1000;
    }

    public int getDefaultSshAuthRetries() {
        return this.getDefaultValue(KEY_IP, KEY_AUTH_RETRIES_VAL);
    }

    public int getDefaultSshTimeout() {
        return this.getDefaultValue(KEY_IP, KEY_TIMEOUT_VAL);
    }

    public int getDefaultSynwaitTime() {
        return this.getDefaultValue(KEY_IP, KEY_SYNWAIT_TIME_VAL);
    }

    public int getDefaultValue(String cmd, String param) {
        KeywordParamNode node;
        if (this.getDevice() != null && (node = ((DeviceBase)this.getDevice()).getDevInfoBase().getCmdSet().getParamNode(cmd, param, true)) != null && node.getDefaultValue() != null && node.getDefaultValue().length() != 0) {
            return Integer.valueOf(node.getDefaultValue());
        }
        return -1;
    }

    public String getEnablePWD() {
        return this._enablePWD;
    }

    public int getEnablePWDEncr() {
        return this._enablePWDEncr;
    }

    public String getExecBanner() {
        return this._execBanner;
    }

    public static Hashtable getFeatures() {
        return _features;
    }

    public boolean getFingerService() {
        return this._fingerService;
    }

    public FlowTopTalkers getFlowTopTalkers() {
        return this._flowTopTalkers;
    }

    public String getHostConfig() {
        return this._hostConfig;
    }

    public String getHostName() {
        return this._hostName;
    }

    public HttpAAAMethods getHttpAAAMethods() {
        return this._aaaMethods;
    }

    public int getHttpAuthen() {
        return this._httpAuthentication;
    }

    public int getHttpSecureServerPort() {
        return this._httpSecurePort;
    }

    public String getHttpServerACL() {
        return this._httpServerACL;
    }

    public int getHttpServerPort() {
        return this._httpPort;
    }

    public boolean getIdentificationService() {
        return this._ipIdentificationService;
    }

    public int getInterceptConnectionTimeout() {
        return this._interceptConnectionTimeout;
    }

    public String getInterceptDropMode() {
        return this._interceptDropMode;
    }

    public int getInterceptFinrstTimeout() {
        return this._interceptFinrstTimeout;
    }

    public String getInterceptListName() {
        return this._interceptList;
    }

    public int getInterceptMaxIncompleteHigh() {
        return this._interceptMaxIncompleteHigh;
    }

    public int getInterceptMaxIncompleteLow() {
        return this._interceptMaxIncompleteLow;
    }

    public int getInterceptWatchTimeout() {
        return this._interceptWatchTimeOut;
    }

    public String getIpDomainName() {
        return this._ipDomainName;
    }

    public boolean getIpGratuitousArps() {
        return this._ipGratuitousArps;
    }

    public boolean getIpSourceRoute() {
        return this._ipSourceRoute;
    }

    public IPAddress getIptDefaultGateway() {
        return this._ipDefaultGateway;
    }

    public String getLocalPolicyRMap() {
        return this._localPolicyRMapName;
    }

    public LocalPoolCollection getLocalPoolCollection() {
        return this._localPoolCollection;
    }

    public int getLogBufferLevel() {
        return this._logging.getBufferLevel();
    }

    public long getLogBufferSize() {
        return this._logging.getBufferSize();
    }

    public int getLogConsoleLevel() {
        return this._logging.getConsoleLevel();
    }

    public Timestamp getLogTimestamp() {
        return this._logTimestamp;
    }

    public int getLogTrapLevel() {
        return this._logging.getTrapLevel();
    }

    public Enumeration getLogs() {
        return this._logs.elements();
    }

    public int getMaxCryptoKeyModulus() {
        return this.getMaxValue(KEY_CRYPTO, KEY_MODULUS_VAL);
    }

    public int getMaxInterceptConnectionTimeout() {
        return this.getMaxValue(KEY_IP, KEY_CONNECTION_TIMEOUT_VAL);
    }

    public int getMaxInterceptFinrstTimeout() {
        return this.getMaxValue(KEY_IP, KEY_FINRST_TIMEOUT_VAL);
    }

    public int getMaxInterceptMaxIncompleteHigh() {
        return this.getMaxValue(KEY_IP, KEY_MAX_INCOMPLETE_HIGH_VAL);
    }

    public int getMaxInterceptMaxIncompleteLow() {
        return this.getMaxValue(KEY_IP, KEY_MAX_INCOMPLETE_LOW_VAL);
    }

    public int getMaxInterceptWatchTimeout() {
        return this.getMaxValue(KEY_IP, KEY_WATCH_TIMEOUT_VAL);
    }

    public long getMaxLoggingBufferSize() {
        return this._logging.getMaxLoggingBufferSize();
    }

    public int getMaxSPDExtHeadroom() {
        return this.getMaxValue("spd", KEY_EXT_HEADROOM_VAL);
    }

    public int getMaxSPDHeadroom() {
        return this.getMaxValue("spd", KEY_HEADROOM_VAL);
    }

    public int getMaxSchedulerInterruptTime() {
        return 60000;
    }

    public int getMaxSchedulerInterval() {
        return this.getMaxValue(KEY_SCHEDULER, KEY_INTERVAL_VAL);
    }

    public int getMaxSchedulerProcessTime() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        if (dev.getDevInfoBase().getModel().indexOf("7") == 0) {
            return 4000;
        }
        return 8000;
    }

    public int getMaxSshAuthRetries() {
        return this.getMaxValue(KEY_IP, KEY_AUTH_RETRIES_VAL);
    }

    public int getMaxSshTimeout() {
        return this.getMaxValue(KEY_IP, KEY_TIMEOUT_VAL);
    }

    public int getMaxSynwaitTime() {
        return this.getMaxValue(KEY_IP, KEY_SYNWAIT_TIME_VAL);
    }

    public int getMaxValue(String cmd, String param) {
        KeywordParamNode node;
        if (this.getDevice() != null && (node = ((DeviceBase)this.getDevice()).getDevInfoBase().getCmdSet().getParamNode(cmd, param, true)) != null) {
            return (int)node.getMaxRange();
        }
        return -1;
    }

    public MgmtAccess getMgmtAccess() {
        return this._mgmtAccess;
    }

    public int getMinCryptoKeyModulus() {
        int min = this.getMinValue(KEY_CRYPTO, KEY_MODULUS_VAL);
        if (min < 512) {
            min = 512;
        }
        return min;
    }

    public int getMinInterceptConnectionTimeout() {
        return this.getMinValue(KEY_IP, KEY_CONNECTION_TIMEOUT_VAL);
    }

    public int getMinInterceptFinrstTimeout() {
        return this.getMinValue(KEY_IP, KEY_FINRST_TIMEOUT_VAL);
    }

    public int getMinInterceptMaxIncompleteHigh() {
        return this.getMinValue(KEY_IP, KEY_MAX_INCOMPLETE_HIGH_VAL);
    }

    public int getMinInterceptMaxIncompleteLow() {
        return this.getMinValue(KEY_IP, KEY_MAX_INCOMPLETE_LOW_VAL);
    }

    public int getMinInterceptWatchTimeout() {
        return this.getMinValue(KEY_IP, KEY_WATCH_TIMEOUT_VAL);
    }

    public long getMinLoggingBufferSize() {
        return this._logging.getMinLoggingBufferSize();
    }

    public int getMinSPDExtHeadroom() {
        return this.getMinValue("spd", KEY_EXT_HEADROOM_VAL);
    }

    public int getMinSPDHeadroom() {
        return this.getMinValue("spd", KEY_HEADROOM_VAL);
    }

    public int getMinSchedulerInterruptTime() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        if (dev.getDevInfoBase().getModel().indexOf("7") == 0) {
            return 400;
        }
        if (dev.getDevInfoBase().getModel().indexOf("28") == 0 || dev.getDevInfoBase().getModel().startsWith("38")) {
            return 20000;
        }
        return 3000;
    }

    public int getMinSchedulerInterval() {
        return this.getMinValue(KEY_SCHEDULER, KEY_INTERVAL_VAL);
    }

    public int getMinSchedulerProcessTime() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        if (dev.getDevInfoBase().getModel().indexOf("7") == 0) {
            return 100;
        }
        return 1000;
    }

    public int getMinSshAuthRetries() {
        return this.getMinValue(KEY_IP, KEY_AUTH_RETRIES_VAL);
    }

    public int getMinSshTimeout() {
        return this.getMinValue(KEY_IP, KEY_TIMEOUT_VAL);
    }

    public int getMinSynwaitTime() {
        return this.getMinValue(KEY_IP, KEY_SYNWAIT_TIME_VAL);
    }

    public int getMinValue(String cmd, String param) {
        KeywordParamNode node;
        if (this.getDevice() != null && (node = ((DeviceBase)this.getDevice()).getDevInfoBase().getCmdSet().getParamNode(cmd, param, true)) != null) {
            return (int)node.getMinRange();
        }
        return -1;
    }

    public String getModemCapValue() {
        return this._modemCapValue;
    }

    public SDM_NTPClients getNTPClients() {
        return this._sdm_ntpclients;
    }

    public Enumeration getNameServers() {
        return this._nameServers.elements();
    }

    public String getNetworkConfig() {
        return this._networkConfig;
    }

    public boolean getPADService() {
        return this._padService;
    }

    public PAM getPAM() {
        return this._pam;
    }

    public Calendar getPCTimeAsCalObject() {
        Calendar cal = Calendar.getInstance();
        return cal;
    }

    public SNMP getSNMP() {
        try {
            if (this._snmp._needRefresh) {
                this.refreshSNMP();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this._snmp;
    }

    public SDM_SNTPClients getSNTPClients() {
        return this._sdm_sntpclients;
    }

    public boolean getSPD() {
        return this._spd;
    }

    public int getSPDExtHeadroom() {
        return this._spdExtHeadroom;
    }

    public int getSPDHeadroom() {
        return this._spdHeadroom;
    }

    public int getSchedulerInterruptTime() {
        return this._schedulerInterruptTime;
    }

    public int getSchedulerInterval() {
        return this._schedulerInterval;
    }

    public int getSchedulerProcessTime() {
        return this._schedulerProcessTime;
    }

    public int getSecAuthFailureRate() {
        return this._secAuthFailureRate;
    }

    public int getSecPassMinLength() {
        return this._secPassMinLength;
    }

    public SecretPasswords getSecretPWDs() {
        return this._secretPWDs;
    }

    public int getSelectedTimeZoneDBIndex() {
        return this._selectedTimeZoneDBindex;
    }

    public boolean getSequenceNumbers() {
        return this._sequenceNumbers;
    }

    public boolean getServicePassEncr() {
        return this._servicePassEncr;
    }

    public int getSshAuthRetries() {
        return this._sshAuthRetries;
    }

    public int getSshTimout() {
        return this._sshTimeout;
    }

    public boolean getTcpKeepAliveIn() {
        return this._tcpKeepAliveIn;
    }

    public boolean getTcpKeepAliveOut() {
        return this._tcpKeepAliveOut;
    }

    public boolean getTcpSmallServer() {
        return this._tcpSmallServer;
    }

    public int getTcpSynwaitTime() {
        return this._tcpSynwaitTime;
    }

    public String getTimeSource() {
        return this._timeSource;
    }

    public boolean getTimeZoneDST() {
        return this._timeZoneDST;
    }

    public String getTimezone() {
        return this._timezone;
    }

    public String getTimezoneNoGMT() {
        return this._timezoneNoGMT;
    }

    public int getTimezoneOffsetHour() {
        return this._tzOffsetHour;
    }

    public int getTimezoneOffsetMin() {
        return this._tzOffsetMin;
    }

    public TtyLines getTtyLines() {
        return this._ttyLines;
    }

    public URLFilter getURLFilter() {
        try {
            if (this._urlfilter == null) {
                this._urlfilter = new URLFilter((XDMObject)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this._urlfilter;
    }

    public boolean getUdpSmallServer() {
        return this._udpSmallServer;
    }

    public Users getUsers() {
        return this._users;
    }

    private String getViewDefinition(String strViewName, String showRunn) {
        String strStartSring = "parser view " + strViewName;
        String strEndSring = "!";
        String retString = "";
        int indexStart = showRunn.indexOf(strStartSring);
        if (indexStart == -1) {
            return retString;
        }
        int indexEnd = showRunn.indexOf(strEndSring, indexStart);
        if (indexEnd == -1) {
            return retString;
        }
        retString = showRunn.substring(indexStart, indexEnd);
        return retString;
    }

    public VtyLines getVtyLines() {
        return this._vtyLines;
    }

    public String handle(String[] devOutput) {
        Log.getLog().debug("In Handle method ");
        Log.getLog().debug("Number of Strings received : " + devOutput.length);
        Log.getLog().debug(devOutput[devOutput.length - 1]);
        String prompt = devOutput[devOutput.length - 1].trim();
        if (prompt.endsWith("% Do you really want to replace them? [yes/no]:")) {
            Log.getLog().debug("Got % Do you really want to replace them? [yes/no]: ");
            return "yes\r\n";
        }
        if (prompt.endsWith("How many bits in the modulus [512]:")) {
            Log.getLog().debug("Got How many bits in the modulus [512]: ");
            return String.valueOf(this._cryptoKeyModulus) + "\r\n";
        }
        return null;
    }

    public boolean isAuthFailureRateSupported() {
        return this.isSupported(OPT_SEC_AUTH_FAIL_RATE);
    }

    public boolean isBackupCmdsSupported() {
        Log.getLog().debug("isBackupCmdsSupported():: _routeTrackingSupported: " + this.isSupported(OPT_ROUTE_TRACKING) + " _trackingRTRObjectSupported: " + this.isSupported(OPT_TRACKING_RTR));
        return this.isSupported(OPT_ROUTE_TRACKING) && this.isSupported(OPT_TRACKING_RTR) && (((DeviceBase)this.getDevice()).getDevInfoBase().isRTRSupported() || ((DeviceBase)this.getDevice()).getDevInfoBase().isIPSLASupported() || ((DeviceBase)this.getDevice()).getDevInfoBase().isIPSLAOnlySupported());
    }

    public boolean isCryptoKeyModulusSupported() {
        return _cryptoKeyModulusSupported;
    }

    public boolean isDSTSettingsON(String strTimeZone) {
        String startDSTtime;
        Log.getLog().debug("inside isDSTSettingsON strTimeZone" + strTimeZone);
        if (strTimeZone != null && strTimeZone.equals(this.getTimezone())) {
            return this.getTimeZoneDST();
        }
        Vector vectGUITimeZone = this.objSyncPCDetails.getTimeZoneVector();
        int index = vectGUITimeZone.indexOf(strTimeZone);
        if (this.vectTimeZone.indexOf("UTC") != -1 || this.vectTimeZone.indexOf("PCTime") != -1) {
            --index;
        } else if (this.vectTimeZone.size() > this.objSyncPCDetails.getDSTStartTimeVector().size()) {
            --index;
        }
        if (index == -1) {
            return false;
        }
        Vector vectPCTimeZone = this.objSyncPCDetails.getPCTimeZoneVector();
        if (this.getTimezone().equals(vectPCTimeZone.elementAt(index))) {
            return this.getTimeZoneDST();
        }
        if (this.vectDSTStartTime != null) {
            this.vectDSTStartTime = this.objSyncPCDetails.getDSTStartTimeVector();
        }
        return (startDSTtime = String.valueOf(String.valueOf(this.vectDSTStartTime.elementAt(index)))) != null && startDSTtime.trim().length() != 0;
    }

    public boolean isDSTSettingsSupported(String strTimeZone) {
        String startDSTtime;
        Log.getLog().debug("inside isDSTSettingsON strTimeZone" + strTimeZone);
        if (strTimeZone != null && strTimeZone.equals(this.getTimezone())) {
            return this.getTimeZoneDST();
        }
        Vector vectGUITimeZone = this.objSyncPCDetails.getTimeZoneVector();
        int index = vectGUITimeZone.indexOf(strTimeZone);
        if (this.vectTimeZone.indexOf("UTC") != -1 || this.vectTimeZone.indexOf("PCTime") != -1) {
            --index;
        } else if (this.vectTimeZone.size() > this.objSyncPCDetails.getDSTStartTimeVector().size()) {
            --index;
        }
        if (index == -1) {
            return false;
        }
        if (this.vectDSTStartTime != null) {
            this.vectDSTStartTime = this.objSyncPCDetails.getDSTStartTimeVector();
        }
        return (startDSTtime = String.valueOf(String.valueOf(this.vectDSTStartTime.elementAt(index)))) != null && startDSTtime.trim().length() != 0;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public boolean isDefaultExecBannerPresent() {
        String defaultBannerStart = "\n% Password expiration warning.";
        String defaultBannerChk1 = "Cisco Router and Security Device Manager (SDM) is installed on this device";
        String defaultBannerChk2 = "your IOS image supports the \n\"one-time\" user option, then this username has already expired";
        return this._execBanner.startsWith(defaultBannerStart) && this._execBanner.indexOf(defaultBannerChk1) != -1 && this._execBanner.indexOf(defaultBannerChk2) != -1;
    }

    public boolean isDomainLookup() {
        return this._isDomainLookup;
    }

    public boolean isHTTPSServerSupported() {
        return true;
    }

    public boolean isHTTPServerSupported() {
        return this._httpServer;
    }

    public boolean isHardwareClockSupported() {
        Log.getLog().debug("isHardwareClockSupported" + this.isSupported(OPT_HARDWARE_CLOCK));
        return this.isSupported(OPT_HARDWARE_CLOCK);
    }

    public boolean isHttpsEnable() {
        return this._httpSecureServer;
    }

    public boolean isIPInterceptSupported() {
        return this.isSupported(OPT_IP_INTERCEPT);
    }

    public boolean isIndentSupported() {
        return this.isSupported(OPT_IP_IDENT);
    }

    public boolean isIpCEF() {
        return this._isIpCEF;
    }

    public boolean isIpCefSupported() {
        return this.isSupported(OPT_IP_CEF);
    }

    public boolean isIpRouting() {
        return this._isIpRouting;
    }

    public boolean isIpSubnetZero() {
        return this._isIpSubnetZero;
    }

    private boolean isKeysAvailable() {
        boolean bKeyAvailable = false;
        try {
            IOSCmdService comm = ((DeviceBase)this.getDevice()).getDevInfoBase().getComm();
            if (comm != null) {
                String[] cmd = new String[]{"show crypto key mypubkey rsa"};
                IOSCmdResponse[] execReply = comm.exec(cmd);
                if (XDMDiscovery.isOKResponse(execReply[0])) {
                    bKeyAvailable = XDMDiscovery.getOptionSupportedOnCmd(execReply[0], "Key name:");
                }
            }
        }
        catch (Exception exception) {}
        return bKeyAvailable;
    }

    public boolean isLocalPolicyDelete() {
        return this._deleteLocalRMapPolicy;
    }

    public boolean isLoggingEnabled() {
        return this._logging.isLoggingEnabled();
    }

    public boolean isNTPClientSupported() {
        return this.isSupported(OPT_NTPCLIENT);
    }

    public boolean isNTPSynchronized() {
        try {
            IOSCmdService comm = ((DeviceBase)this.getDevice()).getDevInfoBase().getComm();
            String[] commands = new String[]{"show ntp status"};
            IOSCmdResponse[] responses = comm.exec(commands);
            if (responses == null || responses.length < 1) {
                return false;
            }
            String buf = null;
            buf = responses[0].getOutput();
            Log.getLog().debug("show ntp status" + buf);
            if ((responses[0].getStatus() != 2 || buf != null || buf.indexOf("% Unrecognized command") < 0 || buf.indexOf("% Invalid input detected at '^' marker") < 0) && buf.indexOf("Clock is synchronized") != -1) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isRsaCryptoKeyConfigured() {
        return this.isKeysAvailable();
    }

    public boolean isRtrTrackSupported() {
        Log.getLog().debug("isBackupCmdsSupported():: _routeTrackingSupported: " + this.isSupported(OPT_ROUTE_TRACKING) + " _trackingRTRObjectSupported: " + this.isSupported(OPT_TRACKING_RTR));
        return this.isSupported(OPT_ROUTE_TRACKING) && this.isSupported(OPT_TRACKING_RTR);
    }

    public boolean isSNTPClientSupported() {
        return this.isSupported(OPT_SNTPCLIENT);
    }

    public boolean isSNTPSynchronized() {
        try {
            IOSCmdService comm = ((DeviceBase)this.getDevice()).getDevInfoBase().getComm();
            String[] command = new String[]{"show sntp"};
            IOSCmdResponse[] response = comm.exec(command);
            if (response == null || response.length < 1) {
                return false;
            }
            String buf = null;
            buf = response[0].getOutput();
            Log.getLog().debug("show sntp" + buf);
            if ((response[0].getStatus() != 2 || buf != null || buf.indexOf("% Unrecognized command") < 0 || buf.indexOf("% Invalid input detected at '^' marker") < 0) && buf.indexOf("Synced") != -1) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isSPDSupported() {
        return this.isSupported("spd");
    }

    public boolean isSchedulerAllocateSupported() {
        return this.isSupported(OPT_SCHEDULER_ALLOC);
    }

    public boolean isSchedulerIntervalSupported() {
        return this.isSupported(OPT_SCHEDULER_INTERVAL);
    }

    public boolean isSecPassMinLengthSupported() {
        return this.isSupported(OPT_SEC_PASS_MIN_LEN);
    }

    public boolean isServiceConfig() {
        return this._serviceConfig;
    }

    public boolean isSshSupported() {
        return this.isSupported("ssh");
    }

    public boolean isStartupConfigOnTFTP() {
        return this._serviceConfig && (this._hostConfig != null && this._hostConfig.length() > 0 || this._networkConfig != null && this._networkConfig.length() > 0);
    }

    public boolean isSupported(String tag) {
        if (!_features.containsKey(tag) && !this.discoverFeature(tag)) {
            return false;
        }
        return (Boolean)_features.get(tag);
    }

    public boolean isUsingACL(String acl) {
        if (acl == null || acl.length() == 0) {
            return false;
        }
        Enumeration e = this._vtyLines.elements();
        while (e.hasMoreElements()) {
            Line item = (Line)e.nextElement();
            if (!acl.equals(item.getAccessClassIn()) && !acl.equals(item.getAccessClassOut())) continue;
            return true;
        }
        Enumeration e2 = this._ttyLines.elements();
        while (e2.hasMoreElements()) {
            Line item = (Line)e2.nextElement();
            if (!acl.equals(item.getAccessClassIn()) && !acl.equals(item.getAccessClassOut())) continue;
            return true;
        }
        if (this._console != null && (acl.equals(this._console.getAccessClassIn()) || acl.equals(this._console.getAccessClassOut()))) {
            return true;
        }
        return this._aux != null && (acl.equals(this._aux.getAccessClassIn()) || acl.equals(this._aux.getAccessClassOut()));
    }

    public boolean isValidHostName(String name) {
        if (name == null || name.length() == 0 || name.length() > 63) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            boolean isNum;
            char ch = name.charAt(i);
            boolean isChar = ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
            boolean bl = isNum = ch >= '0' && ch <= '9';
            if (i == 0 ? !isChar : (i == name.length() - 1 ? !isChar && !isNum : !isChar && ch != '-' && !isNum)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void negateHttpAAAMethods() {
        this._aaaMethods = null;
        this.setModified();
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        if (config == null) {
            return;
        }
        DeviceBase dev = (DeviceBase)this.getDevice();
        try {
            this._snmp.enable(XDMDiscovery.getIsSNMPEnabled(dev.getDevInfoBase().getComm()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._snmp.populate(config, cmdVal);
        String aaaLogin = null;
        String aaaExec = null;
        Vector<String> aaaCmds = new Vector<String>();
        int i = 0;
        while (i <= 15) {
            aaaCmds.addElement("");
            ++i;
        }
        this._fingerService = false;
        this._padService = true;
        this._servicePassEncr = false;
        this._tcpSmallServer = false;
        this._udpSmallServer = false;
        this._bootpServer = true;
        this._cdpEnabled = true;
        this._ipSourceRoute = true;
        this._ipGratuitousArps = false;
        this._ipIdentificationService = false;
        this._tcpKeepAliveIn = false;
        this._tcpKeepAliveOut = false;
        this._sequenceNumbers = false;
        this._schedulerInterval = -1;
        this._schedulerInterruptTime = -1;
        this._schedulerProcessTime = -1;
        this._httpServerACL = "";
        this._deleteHttpACL = false;
        this._deleteLocalRMapPolicy = false;
        this._tcpSynwaitTime = this.getDefaultSynwaitTime();
        this._secAuthFailureRate = -1;
        this._secPassMinLength = 0;
        this._sshTimeout = 120;
        this._sshAuthRetries = 3;
        this._console = null;
        this._aux = null;
        this._spd = false;
        this._spdHeadroom = -1;
        this._spdExtHeadroom = -1;
        this._banner = "";
        this._execBanner = "";
        SDM_NTPClient.setAuthenticateCommand(false);
        SDM_NTPClient.emptyAllKeyVectors();
        int i2 = 0;
        while (i2 < config.numCmds()) {
            String temp;
            CmdValues cmd = config.getCmdValues(i2);
            String cmdName = cmd.getCmdName();
            if (cmdName.equalsIgnoreCase(KEY_NTP)) {
                if (cmd.containsKey(KEY_SERVER)) {
                    SDM_NTPClient sdm_ntpclient = new SDM_NTPClient();
                    sdm_ntpclient.populate(config, cmd);
                    this._sdm_ntpclients.put(sdm_ntpclient);
                } else if (cmd.containsKey(KEY_PEER)) {
                    Log.getLog().debug("Inside NTP PEER");
                    if (cmd.containsKey(KEY_PEERNUMBER)) {
                        String strKeyNumber = cmd.getValue(KEY_PEERNUMBER);
                        Log.getLog().debug("Got the Peer is associated with a key number strKeyNumber" + strKeyNumber);
                        if (strKeyNumber != null) {
                            SDM_NTPClient.addNTPPeerAuthKeyToVector(strKeyNumber);
                        }
                    }
                    if (cmd.containsKey(KEY_PEERIPADDRESS)) {
                        String strPeerAddress = cmd.getValue(KEY_PEERIPADDRESS);
                        Log.getLog().debug("Got the Peer Address strPeerAddress" + strPeerAddress);
                        if (strPeerAddress != null) {
                            SDM_NTPClient.addNTPPeerServerToVector(strPeerAddress);
                        }
                    }
                } else if (cmd.containsKey("broadcast")) {
                    Log.getLog().debug("Inside broadcast");
                    if (cmd.containsKey("peerBroadCastnumber")) {
                        String strKeyNumber = cmd.getValue("peerBroadCastnumber");
                        Log.getLog().debug("Got the broadcast is associated with a key number strKeyNumber" + strKeyNumber);
                        if (strKeyNumber != null) {
                            SDM_NTPClient.addNTPPeerAuthKeyToVector(strKeyNumber);
                        }
                    }
                    if (cmd.containsKey("ipBroadCastdestination")) {
                        String strPeerAddress = cmd.getValue("ipBroadCastdestination");
                        Log.getLog().debug("Got the broadcast Address strPeerAddress" + strPeerAddress);
                        if (strPeerAddress != null) {
                            SDM_NTPClient.addNTPPeerServerToVector(strPeerAddress);
                        }
                    }
                } else if (cmd.containsKey("multicast")) {
                    Log.getLog().debug("Inside NTP multicast");
                    if (cmd.containsKey("peerMultiCastnumber")) {
                        String strKeyNumber = cmd.getValue("peerMultiCastnumber");
                        Log.getLog().debug("Got the multicast is associated with a key number strKeyNumber" + strKeyNumber);
                        if (strKeyNumber != null) {
                            SDM_NTPClient.addNTPPeerAuthKeyToVector(strKeyNumber);
                        }
                    }
                    if (cmd.containsKey("ipMultiCastdestination")) {
                        String strPeerAddress = cmd.getValue("ipMultiCastdestination");
                        Log.getLog().debug("Got the multicast Address strPeerAddress" + strPeerAddress);
                        if (strPeerAddress != null) {
                            SDM_NTPClient.addNTPPeerServerToVector(strPeerAddress);
                        }
                    }
                } else if (cmd.containsKey(KEY_AUTHENTICATIONKEY)) {
                    Log.getLog().debug("################################");
                    Log.getLog().debug("Got the NTP authentication-key Command ");
                    String strkeyVal = cmd.getValue(KEY_NUMBER);
                    Log.getLog().debug("###### The keyVal Value is " + strkeyVal);
                    String md5Val = cmd.getValue(KEY_MD5VAL);
                    Log.getLog().debug(" md5Val Val is " + md5Val);
                    if (strkeyVal != null) {
                        SDM_NTPClient.addNTPAuthKeyToVector(strkeyVal);
                    }
                } else if (cmd.containsKey(KEY_AUTHENTICATE)) {
                    Log.getLog().debug("################################");
                    Log.getLog().debug("Got the NTP authenticate Command ");
                    SDM_NTPClient.setAuthenticateCommand(true);
                    this._sdm_ntpclients.setNTPAuthCommand(true);
                } else if (cmd.containsKey(KEY_TRUSTED)) {
                    Log.getLog().debug("################################");
                    Log.getLog().debug("Got the NTP TRUSTED Key");
                    String strTrustedkey = cmd.getValue(KEY_TRUSTEDKEYVAL);
                    Log.getLog().debug("###### The strTrustedkey Value is " + strTrustedkey);
                    SDM_NTPClient.addNTPTrustedKeyToVector(strTrustedkey);
                } else if (cmd.containsKey(KEY_UPDATECALENDAR)) {
                    Log.getLog().debug("################################");
                    Log.getLog().debug("Got the NTP Calendar Command ");
                    SDM_NTPClient.setNTPCalendarCommand(true);
                }
            }
            if (cmdName.equalsIgnoreCase(KEY_SNTP) && cmd.containsKey(KEY_SERVER)) {
                SDM_SNTPClient sdm_sntpclient = new SDM_SNTPClient();
                sdm_sntpclient.populate(config, cmd);
                this._sdm_sntpclients.put(sdm_sntpclient);
            }
            if (cmdName.equalsIgnoreCase(KEY_HOSTNAME)) {
                String str = cmd.getValue(KEY_NAME);
                this._hostName = str.startsWith("\"") && str.endsWith("\"") ? str.substring(1, str.length() - 1) : str;
            } else if (cmdName.equalsIgnoreCase(KEY_CLOCK) && cmd.containsKey(KEY_TIMEZONE)) {
                this._timezoneNoGMT = this._timezone = cmd.getValue(KEY_NAME);
                this._tzOffsetHour = Integer.valueOf(cmd.getValue(KEY_HOUR));
                if (cmd.containsKey(KEY_MIN)) {
                    this._tzOffsetMin = Integer.valueOf(cmd.getValue(KEY_MIN));
                }
                Log.getLog().debug("_timezone" + this._timezone + "_tzOffsetHour " + this._tzOffsetHour + "_tzOffsetMin" + this._tzOffsetMin);
                this.bDBPopulatedforGUI = false;
            } else if (cmdName.equalsIgnoreCase(KEY_CLOCK) && cmd.containsKey(KEY_SUMMERTIME)) {
                Log.getLog().debug("Summer time is on");
                this._timeZoneDST = true;
                this._DSTZoneName = cmd.getValue("summertimezone");
            } else if (cmdName.equalsIgnoreCase(KEY_IP)) {
                if (cmd.containsKey(KEY_DOMAIN)) {
                    if (cmd.containsKey(KEY_NAME)) {
                        this._ipDomainName = cmd.isNoCmd() ? "" : cmd.getValue(KEY_DNAME);
                    } else if (cmd.containsKey(KEY_LOOKUP)) {
                        this._isDomainLookup = cmd.isNoCmd() ^ true;
                    }
                }
                if (cmd.containsKey(KEY_SUBNET_ZERO)) {
                    this._isIpSubnetZero = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_DEFAULT_GATEWAY)) {
                    this._ipDefaultGateway = cmd.isNoCmd() ? null : new IPAddress(cmd.getValue(KEY_DEFGATEWAY));
                } else if (cmd.containsKey(KEY_ROUTING)) {
                    this._isIpRouting = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_CEF)) {
                    this._isIpCEF = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_NAME_SERVER)) {
                    this.addNameServer(cmd.getValue(KEY_ADDR));
                } else if (cmd.containsKey(KEY_BOOTP) && cmd.containsKey(KEY_SERVER)) {
                    this._bootpServer = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_SOURCE_ROUTE)) {
                    this._ipSourceRoute = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_GRAT_ARPS)) {
                    this._ipGratuitousArps = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_IDENTIFICATION)) {
                    this._ipIdentificationService = cmd.isNoCmd() ^ true;
                    _features.put(OPT_IP_IDENT, new Boolean(true));
                } else if (cmd.containsKey(KEY_FINGER)) {
                    this._fingerService = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_HTTP)) {
                    if (cmd.containsKey(KEY_SERVER)) {
                        this._httpServer = cmd.isNoCmd() ^ true;
                    } else if (cmd.containsKey(KEY_SECURE_SERVER)) {
                        this._httpSecureServer = cmd.isNoCmd() ^ true;
                    } else if (cmd.containsKey(KEY_PORT)) {
                        temp = cmd.getValue(KEY_PORT_NUM_VAL);
                        if (temp != null && temp.length() != 0) {
                            this._httpPort = Integer.valueOf(temp);
                        }
                    } else if (cmd.containsKey(KEY_SECURE_PORT)) {
                        temp = cmd.getValue(KEY_SECURE_PORT_NUM_VAL);
                        if (temp != null && temp.length() != 0) {
                            this._httpSecurePort = Integer.valueOf(temp);
                        }
                    } else if (cmd.containsKey(KEY_ACCESS_CLASS)) {
                        this._httpServerACL = cmd.getValue("ACL");
                        ACLBase acl = ((DeviceBase)this.getDevice()).getAcls().getACL(this._httpServerACL);
                        if (acl != null) {
                            acl.addToCategory(1);
                        }
                    } else if (cmd.containsKey(KEY_AUTHENTICATION)) {
                        if (cmd.containsKey(KEY_METHOD)) {
                            String method = cmd.getValue(KEY_METHOD);
                            if (method.equals(KEY_ENABLE)) {
                                this._httpAuthentication = 2;
                            } else if (method.equals(KEY_LOCAL)) {
                                this._httpAuthentication = 3;
                            } else if (method.equals("tacacs")) {
                                this._httpAuthentication = 4;
                            } else if (method.equals(KEY_AAA)) {
                                this._httpAuthentication = 1;
                                aaaLogin = "default";
                            }
                        } else if (cmd.containsKey(KEY_AAA)) {
                            if (cmd.containsKey("login-authentication")) {
                                this._httpAuthentication = 1;
                                aaaLogin = cmd.getValue("LIST_NAME");
                            } else if (cmd.containsKey("exec-authorization")) {
                                aaaExec = cmd.getValue("LIST_NAME");
                            } else if (cmd.containsKey("command-authorization")) {
                                int level = new Integer(cmd.getValue("LEVEL"));
                                aaaCmds.setElementAt(cmd.getValue("LIST_NAME"), level);
                            }
                        }
                    }
                } else if (cmd.containsKey(KEY_LOCAL) && cmd.containsKey(KEY_POLICY) && cmd.containsKey(KEY_RMAP)) {
                    this._localPolicyRMapName = cmd.getValue(KEY_RMAP_NAME);
                    Log.getLog().info("Local Routing Policy Configured, _localPolicyRMapName: " + this._localPolicyRMapName);
                } else if (cmd.containsKey(KEY_TCP) && cmd.containsKey(KEY_SYNWAIT_TIME)) {
                    temp = cmd.getValue(KEY_SYNWAIT_TIME_VAL);
                    if (temp != null && temp.length() != 0) {
                        this._tcpSynwaitTime = Integer.valueOf(temp);
                    }
                } else if (cmd.containsKey("ssh") && cmd.containsKey(KEY_TIMEOUT)) {
                    temp = cmd.getValue(KEY_TIMEOUT_VAL);
                    if (temp != null && temp.length() != 0) {
                        this._sshTimeout = Integer.valueOf(temp);
                    }
                    _features.put("ssh", new Boolean(true));
                } else if (cmd.containsKey("ssh") && cmd.containsKey(KEY_AUTH_RETRIES)) {
                    temp = cmd.getValue(KEY_AUTH_RETRIES_VAL);
                    if (temp != null && temp.length() != 0) {
                        this._sshAuthRetries = Integer.valueOf(temp);
                    }
                    _features.put("ssh", new Boolean(true));
                } else if (cmd.containsKey(KEY_TCP) && cmd.containsKey(KEY_INTERCEPT)) {
                    _features.put(OPT_IP_INTERCEPT, new Boolean(true));
                    if (cmd.containsKey(KEY_LIST)) {
                        this._interceptList = cmd.getValue("ACL");
                    }
                    if (cmd.containsKey(KEY_CONNECTION_TIMEOUT) && (temp = cmd.getValue(KEY_CONNECTION_TIMEOUT_VAL)) != null && temp.length() != 0) {
                        this._interceptConnectionTimeout = Integer.valueOf(temp);
                    }
                    if (cmd.containsKey(KEY_DROP_MODE) && (temp = cmd.getValue(KEY_DROP_MODE_VAL)) != null) {
                        this._interceptDropMode = temp;
                    }
                    if (cmd.containsKey(KEY_FINRST_TIMEOUT) && (temp = cmd.getValue(KEY_FINRST_TIMEOUT_VAL)) != null && temp.length() != 0) {
                        this._interceptFinrstTimeout = Integer.valueOf(temp);
                    }
                    if (cmd.containsKey(KEY_MAX_INCOMPLETE) && cmd.containsKey(KEY_HIGH) && (temp = cmd.getValue(KEY_MAX_INCOMPLETE_HIGH_VAL)) != null && temp.length() != 0) {
                        this._interceptMaxIncompleteHigh = Integer.valueOf(temp);
                    }
                    if (cmd.containsKey(KEY_MAX_INCOMPLETE) && cmd.containsKey(KEY_LOW) && (temp = cmd.getValue(KEY_MAX_INCOMPLETE_LOW_VAL)) != null && temp.length() != 0) {
                        this._interceptMaxIncompleteLow = Integer.valueOf(temp);
                    }
                    if (cmd.containsKey(KEY_WATCH_TIMEOUT) && (temp = cmd.getValue(KEY_WATCH_TIMEOUT_VAL)) != null && temp.length() != 0) {
                        this._interceptWatchTimeOut = Integer.valueOf(temp);
                    }
                } else if (cmd.containsKey("flow-top-talkers")) {
                    this._flowTopTalkers.populate(config, cmd);
                }
            } else if (cmdName.equalsIgnoreCase(KEY_ENABLE)) {
                if (cmd.containsKey(KEY_PASSWORD)) {
                    if (cmd.containsKey(KEY_ENCR)) {
                        this._enablePWDEncr = Integer.valueOf(cmd.getValue(KEY_ENCR));
                    }
                    this._enablePWD = cmd.getValue(KEY_PWD);
                } else {
                    SecretPassword sp = new SecretPassword();
                    sp.populate(config, cmd);
                    this._secretPWDs.put(sp);
                }
            } else if (cmdName.equalsIgnoreCase(KEY_USERNAME)) {
                User user = new User();
                user.populate(config, cmd);
                this._users.put(user);
            } else if (cmdName.equalsIgnoreCase(KEY_PARSER)) {
                CLIView cliview = new CLIView();
                cliview.populate(config, cmd);
                this._cliviews.put(cliview);
            } else if (cmdName.equalsIgnoreCase(KEY_LOGGING) && cmd.containsKey(KEY_HOSTID) && !cmd.isNoCmd()) {
                this.addLog(cmd.getValue(KEY_HOSTID));
            } else if (cmdName.equalsIgnoreCase(KEY_MODEM)) {
                if (cmd.containsKey(KEY_ENTRY)) {
                    String mcapName = cmd.getValue(KEY_MODEMCAPNAME);
                    String mcapValue = cmd.getValue(KEY_MODEMCAPVALUE);
                    Log.getLog().debug("Modem Cap entry name " + mcapName + " Value : " + mcapValue);
                }
            } else if (cmdName.equalsIgnoreCase(KEY_LINE)) {
                Log.getLog().debug("LINE NUmber is : " + cmd.getValue(KEY_START));
                Log.getLog().debug("***** LINE contains KEY *** : " + cmd.containsKey("1"));
                boolean isLineTTY = (cmd.containsKey(KEY_VTY) || cmd.containsKey(KEY_CONSOLE) || cmd.containsKey(KEY_AUX)) ^ true;
                if (isLineTTY) {
                    int iend;
                    int istart;
                    String start;
                    String end = start = cmd.getValue(KEY_START);
                    if (cmd.containsKey(KEY_END)) {
                        end = cmd.getValue(KEY_END);
                    }
                    int lastS = start.lastIndexOf("/");
                    String lineLoc = "";
                    if (lastS >= 0) {
                        lineLoc = start.substring(0, lastS);
                        istart = Integer.valueOf(start.substring(lastS + 1));
                        iend = Integer.valueOf(end.substring(lastS + 1));
                    } else {
                        istart = Integer.valueOf(start);
                        iend = Integer.valueOf(end);
                    }
                    Log.getLog().debug("LINE TTY Start : " + start + " End : " + end);
                    int j = istart;
                    while (j <= iend) {
                        Line line = new Line(lineLoc, j, j, 3);
                        this._ttyLines.put(line);
                        line.populate(config, cmd);
                        ++j;
                    }
                }
                if (cmd.containsKey(KEY_VTY)) {
                    int start;
                    int end = start = Integer.valueOf(cmd.getValue(KEY_START)).intValue();
                    if (cmd.containsKey(KEY_END)) {
                        end = Integer.valueOf(cmd.getValue(KEY_END));
                    }
                    Line line = new Line(start, end, 4);
                    this._vtyLines.put(line);
                    line.populate(config, cmd);
                }
                if (cmd.containsKey(KEY_CONSOLE)) {
                    this._console = new Line(0, 0, 2);
                    this._console.setParent(this);
                    this._console.populate(config, cmd);
                }
                if (cmd.containsKey(KEY_AUX)) {
                    this._aux = new Line(0, 0, 1);
                    this._aux.setParent(this);
                    this._aux.populate(config, cmd);
                }
            } else if (cmdName.equalsIgnoreCase(KEY_SERVICE)) {
                if (cmd.containsKey(KEY_PAD)) {
                    this._padService = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_PASS_ENCR)) {
                    this._servicePassEncr = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_TCP_SMALL_SERVERS)) {
                    this._tcpSmallServer = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_UDP_SMALL_SERVERS)) {
                    this._udpSmallServer = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_TCP_KEEPALIVE_IN)) {
                    this._tcpKeepAliveIn = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_TCP_KEEPALIVE_OUT)) {
                    this._tcpKeepAliveOut = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey("timestamps")) {
                    if (cmd.containsKey("debug")) {
                        this._debugTimestamp.populate(null, cmd);
                    } else if (cmd.containsKey(KEY_LOG)) {
                        this._logTimestamp.populate(null, cmd);
                    }
                } else if (cmd.containsKey(KEY_SEQUENCE_NUMBERS)) {
                    this._sequenceNumbers = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_DHCP)) {
                    this._dhcpService = cmd.isNoCmd() ^ true;
                } else if (cmd.containsKey(KEY_CONFIG)) {
                    this._serviceConfig = cmd.isNoCmd() ^ true;
                }
            } else if (cmdName.equalsIgnoreCase(KEY_SCHEDULER)) {
                if (cmd.containsKey(KEY_INTERVAL)) {
                    _features.put(OPT_SCHEDULER_INTERVAL, new Boolean(true));
                    temp = cmd.getValue(KEY_INTERVAL_VAL);
                    if (temp != null && temp.length() != 0) {
                        this._schedulerInterval = Integer.valueOf(temp);
                    }
                }
                if (cmd.containsKey(KEY_ALLOCATE)) {
                    _features.put(OPT_SCHEDULER_ALLOC, new Boolean(true));
                    temp = cmd.getValue(KEY_INTERRUPT_TIME_VAL);
                    if (temp != null && temp.length() != 0) {
                        this._schedulerInterruptTime = Integer.valueOf(temp);
                    }
                    if ((temp = cmd.getValue(KEY_PROCESS_TIME_VAL)) != null && temp.length() != 0) {
                        this._schedulerProcessTime = Integer.valueOf(temp);
                    }
                }
            } else if (cmdName.equalsIgnoreCase(KEY_CDP) && cmd.containsKey(KEY_RUN)) {
                this._cdpEnabled = cmd.isNoCmd() ^ true;
            } else if (cmdName.equalsIgnoreCase(KEY_SECURITY) && cmd.containsKey(KEY_AUTHENTICATION) && cmd.containsKey(KEY_FAILURE) && cmd.containsKey(KEY_RATE)) {
                temp = cmd.getValue(KEY_SEC_AUTH_FAIL_RATE_VAL);
                if (temp != null && temp.length() != 0) {
                    _features.put(OPT_SEC_AUTH_FAIL_RATE, new Boolean(true));
                    this._secAuthFailureRate = Integer.valueOf(temp);
                }
            } else if (cmdName.equalsIgnoreCase(KEY_SECURITY) && cmd.containsKey(KEY_PASSWORDS) && cmd.containsKey(KEY_MIN_LENGTH)) {
                temp = cmd.getValue(KEY_SEC_PASS_MIN_LENGTH_VAL);
                if (temp != null && temp.length() != 0) {
                    _features.put(OPT_SEC_PASS_MIN_LEN, new Boolean(true));
                    this._secPassMinLength = Integer.valueOf(temp);
                }
            } else if (cmdName.equalsIgnoreCase(Logging.KEY_LOGGING)) {
                this._logging.populate(null, cmd);
            } else if (cmdName.equalsIgnoreCase(KEY_CRYPTO) && cmd.containsKey(KEY_KEY) && cmd.containsKey(KEY_GENERATE) && cmd.containsKey(KEY_RSA) && cmd.containsKey(KEY_GENERAL_KEYS) && cmd.containsKey(KEY_MODULUS)) {
                temp = cmd.getValue(KEY_MODULUS_VAL);
                if (temp != null && temp.length() != 0) {
                    _cryptoKeyModulusSupported = true;
                    this._cryptoKeyModulus = Integer.valueOf(temp);
                }
            } else if (cmdName.equalsIgnoreCase("spd")) {
                if (cmd.containsKey(KEY_SPD_VAL) && (temp = cmd.getValue(KEY_SPD_VAL)) != null && temp.equalsIgnoreCase(KEY_ENABLE)) {
                    _features.put("spd", new Boolean(true));
                    this._spd = true;
                }
                if (cmd.containsKey(KEY_HEADROOM) && (temp = cmd.getValue(KEY_HEADROOM_VAL)) != null && temp.length() != 0) {
                    _features.put("spd", new Boolean(true));
                    this._spdHeadroom = Integer.valueOf(temp);
                }
                if (cmd.containsKey(KEY_EXT_HEADROOM) && (temp = cmd.getValue(KEY_EXT_HEADROOM_VAL)) != null && temp.length() != 0) {
                    _features.put("spd", new Boolean(true));
                    this._spdExtHeadroom = Integer.valueOf(temp);
                }
            } else if (cmdName.equalsIgnoreCase(KEY_BANNER)) {
                if (cmd.containsKey(KEY_LOGIN)) {
                    temp = cmd.getValue(KEY_BANNER_VAL);
                    if (temp != null) {
                        this._banner = temp;
                    }
                } else if (cmd.containsKey(KEY_EXEC) && (temp = cmd.getValue(KEY_BANNER_VAL)) != null) {
                    this._execBanner = temp;
                }
            } else if (cmdName.equalsIgnoreCase(KEY_BOOT)) {
                if (cmd.containsKey(KEY_HOST)) {
                    this._hostConfig = cmd.getValue(KEY_FILENAME);
                } else if (cmd.containsKey(KEY_NETWORK)) {
                    this._networkConfig = cmd.getValue(KEY_FILENAME);
                } else if (cmd.containsKey(KEY_SYSTEM)) {
                    this.bootSystem.addFileName(cmd.getValue(KEY_FILENAME));
                }
            }
            ++i2;
        }
        if (this._httpAuthentication == 1) {
            this._aaaMethods = new HttpAAAMethods((XDMObject)this, aaaLogin, aaaExec, aaaCmds);
        }
        ConfigValues cv = config.getCmds(KEY_ISDN, KEY_SWITCHTYPE, ".*", false);
        isISDNSwt = true;
        if (cv == null) {
            Log.getLog().debug("######## No Global ISDN swtich type set From System Prop ");
            isISDNSwt = false;
        }
        if (this._logging.isLoggingEnabled() && this._logging.getBufferSize() == 0L) {
            this._logging.setDefaultBufSize();
        }
        this.populateCryptoKeyGenerate();
        Log.getLog().debug("PAM population");
        if (((DeviceBase)this.getDevice()).getDevInfoBase().isPAMSupported()) {
            this._pam.populate(config, cmdVal);
        }
        this.populateDBTimeZones();
        this._localPoolCollection.populate(config, cmdVal);
        this._urlfilter.populate(config, cmdVal);
    }

    void populateCryptoKeyGenerate() {
        this._rsaCryptoKeyConfigured = false;
        _cryptoKeyModulusSupported = false;
        try {
            IOSCmdService comm = ((DeviceBase)this.getDevice()).getDevInfoBase().getComm();
            String[] commands = new String[]{"show crypto key mypubkey rsa"};
            IOSCmdResponse[] responses = comm.exec(commands);
            if (responses == null || responses.length < 1) {
                return;
            }
            String buf = null;
            buf = responses[0].getOutput();
            if (responses[0].getStatus() != 2 && buf != null && buf.indexOf("% Unrecognized command") < 0 && buf.indexOf("% Invalid input detected at '^' marker") < 0) {
                _cryptoKeyModulusSupported = true;
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public Vector populateDBTimeZones() {
        Log.getLog().debug("Inside populateDBTimeZones");
        if (this.vectTimeZone.indexOf("UTC") != -1) {
            this.vectTimeZone.removeElement("UTC");
        }
        if (this.vectTimeZone.indexOf("PCTime") != -1) {
            this.vectTimeZone.removeElement("PCTime");
        }
        this.objSyncPCDetails.parseXMLfile();
        if (this.vectTimeZone.size() > this.objSyncPCDetails.getDSTStartTimeVector().size()) {
            Log.getLog().debug("User configured time zone is present in the top ..so removing that element");
            this.vectTimeZone.removeElementAt(0);
        }
        this.vectTimeZone = this.objSyncPCDetails.getTimeZoneVector();
        String strConfiguredTimeZone = this.getTimezone();
        Log.getLog().debug("strConfiguredTimeZone" + strConfiguredTimeZone);
        if (strConfiguredTimeZone != null || strConfiguredTimeZone.trim().length() != 0) {
            Vector vectPCTimeZone = this.objSyncPCDetails.getPCTimeZoneVector();
            int index = vectPCTimeZone.indexOf(strConfiguredTimeZone);
            if (index != -1) {
                this._selectedTimeZoneDBindex = index;
            } else {
                this._selectedTimeZoneDBindex = 0;
                if (this.vectTimeZone.indexOf(strConfiguredTimeZone) == -1) {
                    if (this._timezone != null && this._timezone.indexOf("(GMT") == -1) {
                        String StrTimeHrOffset = "";
                        if (this._tzOffsetHour == 0 && this._tzOffsetMin == 0) {
                            this._timezone = "(GMT) " + this._timezone;
                        } else {
                            StrTimeHrOffset = this._tzOffsetHour > 0 ? "(GMT+" + this._tzOffsetHour + ":" : "(GMT" + this._tzOffsetHour + ":";
                            this._timezone = this._tzOffsetMin < 10 ? String.valueOf(StrTimeHrOffset) + "0" + this._tzOffsetMin + ") " + this._timezone : String.valueOf(StrTimeHrOffset) + this._tzOffsetMin + ") " + this._timezone;
                        }
                    }
                    this.vectTimeZone.insertElementAt(this._timezone, 0);
                }
            }
        }
        return this.vectTimeZone;
    }

    public void populateURLFilter() throws IOException, XDMException, CliGPBException {
        DeviceBase dev = (DeviceBase)this.getDevice();
        ConfigValues values = dev.getFilteredConfig("urlfilter");
        this._urlfilter.populate(values, null);
        dev.getBackup().getSystemProp()._urlfilter = (URLFilter)this._urlfilter.clone();
        dev.getBackup().getSystemProp()._urlfilter.setParent(dev.getBackup().getSystemProp());
        this._urlfilter.resetModifiedFlag();
    }

    private void refreshSNMP() throws IOException, XDMException, CliGPBException {
        this._snmp = new SNMP((XDMObject)this);
        DeviceBase dev = (DeviceBase)this.getDevice();
        this._snmp.enable(XDMDiscovery.getIsSNMPEnabled(dev.getDevInfoBase().getComm()));
        ConfigValues values = dev.getFilteredConfig(KEY_SNMP_SERVER);
        this._snmp.populate(values, null);
        this._snmp._needRefresh = false;
        dev.getBackup().getSystemProp()._snmp = (SNMP)this._snmp.clone();
        dev.getBackup().getSystemProp()._snmp.setParent(dev.getBackup().getSystemProp());
        this._snmp.resetModifiedFlag();
    }

    public void refreshURLFilter() throws IOException, XDMException, CliGPBException {
        this._urlfilter = new URLFilter((XDMObject)this);
        DeviceBase dev = (DeviceBase)this.getDevice();
        ConfigValues values = dev.getFilteredConfig("urlfilter");
        this._urlfilter.populate(values, null);
        dev.getBackup().getSystemProp()._urlfilter = (URLFilter)this._urlfilter.clone();
        dev.getBackup().getSystemProp()._urlfilter.setParent(dev.getBackup().getSystemProp());
        this._urlfilter.resetModifiedFlag();
    }

    public void removeAllNameServer() {
        if (this._nameServers.size() > 0) {
            this._nameServers.removeAllElements();
            this.setModified();
        }
    }

    public boolean removeLog(String host) {
        boolean ret = false;
        if (host != null && host.length() > 0) {
            int i = 0;
            while (i < this._logs.size()) {
                if (host.equals(this._logs.elementAt(i).toString())) {
                    ret = true;
                    this._logs.removeElementAt(i);
                    this.setModified();
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    public boolean removeNameServer(String addr) {
        if (addr == null || addr.length() == 0) {
            return false;
        }
        boolean ret = false;
        int i = 0;
        while (i < this._nameServers.size()) {
            if (addr.equalsIgnoreCase(this._nameServers.elementAt(i).toString())) {
                this._nameServers.removeElementAt(i);
                this.setModified();
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    public void resetModifiedFlag() {
        super.resetModifiedFlag();
        this._secretPWDs.resetModifiedFlag();
        this._cliviews.resetModifiedFlag();
        this._users.resetModifiedFlag();
        this._sdm_ntpclients.resetModifiedFlag();
        this._sdm_sntpclients.resetModifiedFlag();
        this._snmp.resetModifiedFlag();
        this._urlfilter.resetModifiedFlag();
        this._vtyLines.resetModifiedFlag();
        this._ttyLines.resetModifiedFlag();
        this.bootSystem.resetModifiedFlag();
        if (this._console != null) {
            this._console.resetModifiedFlag();
        }
        if (this._aux != null) {
            this._aux.resetModifiedFlag();
        }
        this._flowTopTalkers.resetModifiedFlag();
    }

    public void setBanner(String banner) {
        String newBanner = banner == null ? "" : banner;
        if (!newBanner.equals(this._banner)) {
            this._banner = newBanner;
            this.setModified();
        }
    }

    private void setBootSystem(BootSystem bootSystem) {
        this.bootSystem = bootSystem;
        this.setModified();
    }

    public void setBootpServer(boolean bootpServer) {
        this._bootpServer = bootpServer;
        this.setModified();
    }

    public void setCDPEnabled(boolean cdpEnabled) {
        this._cdpEnabled = cdpEnabled;
        this.setModified();
    }

    public boolean setCryptoKeyModulus(int cryptoKeyModulus) {
        if (cryptoKeyModulus < this.getMinCryptoKeyModulus() || cryptoKeyModulus > this.getMaxCryptoKeyModulus()) {
            return false;
        }
        this._cryptoKeyModulus = cryptoKeyModulus;
        this.setModified();
        return true;
    }

    public void setDHCPService(boolean enable) {
        if (this._dhcpService != enable) {
            this._dhcpService = enable;
            this.setModified();
        }
    }

    public void setDomainLookup(boolean enable) {
        if (enable != this._isDomainLookup) {
            this._isDomainLookup = enable;
            this.setModified();
        }
    }

    public void setEnablePWD(String pwd, int encr) {
        if (!this._enablePWD.equals(pwd) || encr != this._enablePWDEncr) {
            this._enablePWD = pwd == null ? "" : pwd;
            this._enablePWDEncr = encr;
            this.setModified();
        }
    }

    public void setExecBanner(String banner) {
        String newBanner = banner == null ? "" : banner;
        if (!newBanner.equals(this._execBanner)) {
            this._execBanner = newBanner;
            this.setModified();
        }
    }

    public static void setFeatures(Hashtable features) {
        _features = features;
    }

    public void setFingerService(boolean fingerService) {
        this._fingerService = fingerService;
        this.setModified();
    }

    public void setHostName(String newName) {
        if (!this._hostName.equals(newName)) {
            this._hostName = newName == null ? "" : newName;
            this.setModified();
        }
    }

    public void setHttpAuthen(int val) {
        this._httpAuthentication = val;
        this.setModified();
    }

    public void setHttpServerACL(String acl, boolean delete) {
        if (acl == null) {
            return;
        }
        this._deleteHttpACL = delete;
        this._httpServerACL = acl;
        this.setModified();
        if (delete) {
            this._httpServerACL = acl;
            this.setModified();
            return;
        }
        ACLBase httpAcl = ((DeviceBase)this.getDevice()).getAcls().getACL(acl);
        if (httpAcl != null && httpAcl.getACLType() == 0) {
            this._httpServerACL = acl;
            httpAcl.addToCategory(1);
            httpAcl.deleteFromCategory(5);
            this.setModified();
            return;
        }
    }

    public void setHttpsEnable(boolean enable) {
        if (this._httpSecureServer != enable) {
            this._httpSecureServer = enable;
            this.setModified();
        }
    }

    public void setIdentificationService(boolean ipIdentificationService) {
        this._ipIdentificationService = ipIdentificationService;
        this.setModified();
    }

    public boolean setInterceptConnectionTimeout(int interceptConnectionTimeout) {
        if (interceptConnectionTimeout < this.getMinInterceptConnectionTimeout() || interceptConnectionTimeout > this.getMaxInterceptConnectionTimeout()) {
            return false;
        }
        this._interceptConnectionTimeout = interceptConnectionTimeout;
        this.setModified();
        return true;
    }

    public boolean setInterceptDropMode(String dropMode) {
        if (dropMode.compareTo("oldest") == 0 || dropMode.compareTo("random") == 0) {
            this._interceptDropMode = dropMode;
            this.setModified();
            return false;
        }
        return true;
    }

    public boolean setInterceptFinrstTimeout(int finrstTimeout) {
        if (finrstTimeout < this.getMinInterceptFinrstTimeout() || finrstTimeout > this.getMaxInterceptFinrstTimeout()) {
            return false;
        }
        this._interceptFinrstTimeout = finrstTimeout;
        this.setModified();
        return true;
    }

    public void setInterceptList(String interceptList) {
        ACLBase acl = ((DeviceBase)this.getDevice()).getAcls().getACL(interceptList);
        if (acl == null) {
            if (interceptList.length() == 0) {
                ACLBase oldAcl = ((DeviceBase)this.getDevice()).getAcls().getACL(this._interceptList);
                if (oldAcl != null) {
                    oldAcl.deleteFromCategory(1);
                }
                this._interceptList = interceptList;
                return;
            }
            return;
        }
        if (acl.getACLType() == 1) {
            ACLBase oldAcl = ((DeviceBase)this.getDevice()).getAcls().getACL(this._interceptList);
            if (oldAcl != null) {
                oldAcl.deleteFromCategory(1);
            }
            this._interceptList = interceptList;
            acl.addToCategory(1);
            acl.deleteFromCategory(5);
            this.setModified();
            return;
        }
    }

    public boolean setInterceptMaxIncompleteHigh(int maxIncompleteHigh) {
        if (maxIncompleteHigh < this.getMinInterceptMaxIncompleteHigh() || maxIncompleteHigh > this.getMaxInterceptMaxIncompleteHigh()) {
            return false;
        }
        this._interceptMaxIncompleteHigh = maxIncompleteHigh;
        this.setModified();
        return true;
    }

    public boolean setInterceptMaxIncompleteLow(int maxIncompleteLow) {
        if (maxIncompleteLow < this.getMinInterceptMaxIncompleteLow() || maxIncompleteLow > this.getMaxInterceptMaxIncompleteLow()) {
            return false;
        }
        this._interceptMaxIncompleteLow = maxIncompleteLow;
        this.setModified();
        return true;
    }

    public boolean setInterceptWatchTimeout(int watchTimeout) {
        if (watchTimeout < this.getMinInterceptWatchTimeout() || watchTimeout > this.getMaxInterceptWatchTimeout()) {
            return false;
        }
        this._interceptWatchTimeOut = watchTimeout;
        this.setModified();
        return true;
    }

    public void setIpCEF(boolean enable) {
        if (this._isIpCEF != enable) {
            this._isIpCEF = enable;
            this.setModified();
        }
    }

    public void setIpDefaultGateway(IPAddress gateway) {
        this._ipDefaultGateway = gateway;
        this.setModified();
    }

    public void setIpDomainName(String name) {
        if (!this._ipDomainName.equals(name)) {
            this._ipDomainName = name == null ? "" : name;
            this.setModified();
        }
    }

    public void setIpGratuitousArps(boolean ipGratuitousArps) {
        this._ipGratuitousArps = ipGratuitousArps;
        this.setModified();
    }

    public void setIpRouting(boolean enable) {
        if (enable != this._isIpRouting) {
            this._isIpRouting = enable;
            this.setModified();
        }
    }

    public void setIpSourceRoute(boolean ipSourceRoute) {
        this._ipSourceRoute = ipSourceRoute;
        this.setModified();
    }

    public void setIpSubnetZero(boolean enable) {
        if (this._isIpSubnetZero != enable) {
            this._isIpSubnetZero = enable;
            this.setModified();
        }
    }

    public void setLocalPolicyRMap(String rmapName, boolean delete) {
        if (!this._localPolicyRMapName.equals(rmapName) || this._deleteLocalRMapPolicy != delete) {
            this._localPolicyRMapName = rmapName == null ? "" : rmapName;
            this._deleteLocalRMapPolicy = delete;
            this.setModified();
        }
    }

    public boolean setLogBufferLevel(int level) {
        return this._logging.setBufferLevel(level);
    }

    public void setLogBufferSize(long size) {
        this._logging.setBufferSize(size);
        this.setModified();
    }

    public boolean setLogConsoleLevel(int level) {
        return this._logging.setConsoleLevel(level);
    }

    public boolean setLogTrapLevel(int level) {
        return this._logging.setTrapLevel(level);
    }

    public void setPADService(boolean padService) {
        this._padService = padService;
        this.setModified();
    }

    public void setSPD(boolean spd) {
        this._spd = spd;
        this.setModified();
    }

    public boolean setSPDExtHeadroom(int spdExtHeadroom) {
        if (spdExtHeadroom < this.getMinSPDExtHeadroom() || spdExtHeadroom > this.getMaxSPDExtHeadroom()) {
            return false;
        }
        this._spdExtHeadroom = spdExtHeadroom;
        this.setModified();
        return true;
    }

    public boolean setSPDHeadroom(int spdHeadroom) {
        if (spdHeadroom < this.getMinSPDHeadroom() || spdHeadroom > this.getMaxSPDHeadroom()) {
            return false;
        }
        this._spdHeadroom = spdHeadroom;
        this.setModified();
        return true;
    }

    public boolean setSchedulerInterruptTime(int schedulerInterruptTime) {
        if (schedulerInterruptTime != -1 && (schedulerInterruptTime < this.getMinSchedulerInterruptTime() || schedulerInterruptTime > this.getMaxSchedulerInterruptTime())) {
            return false;
        }
        this._schedulerInterruptTime = schedulerInterruptTime;
        this.setModified();
        return true;
    }

    public boolean setSchedulerInterval(int schedulerInterval) {
        if (schedulerInterval != -1 && (schedulerInterval < this.getMinSchedulerInterval() || schedulerInterval > this.getMaxSchedulerInterval())) {
            return false;
        }
        this._schedulerInterval = schedulerInterval;
        this.setModified();
        return true;
    }

    public boolean setSchedulerProcessTime(int schedulerProcessTime) {
        if (schedulerProcessTime != -1 && (schedulerProcessTime < this.getMinSchedulerProcessTime() || schedulerProcessTime > this.getMaxSchedulerProcessTime())) {
            return false;
        }
        this._schedulerProcessTime = schedulerProcessTime;
        this.setModified();
        return true;
    }

    public void setSecAuthFailureRate(int secAuthFailureRate) {
        this._secAuthFailureRate = secAuthFailureRate;
        this.setModified();
    }

    public boolean setSecPassMinLength(int secPassMinLength) {
        this._secPassMinLength = secPassMinLength;
        this.setModified();
        return true;
    }

    public void setSequenceNumbers(boolean sequenceNumbers) {
        this._sequenceNumbers = sequenceNumbers;
        this.setModified();
    }

    public void setServicePassEncr(boolean servicePassEncr) {
        this._servicePassEncr = servicePassEncr;
        this.setModified();
    }

    public boolean setSsshAuthRetries(int sshAuthRetries) {
        if (sshAuthRetries < this.getMinSshAuthRetries() || sshAuthRetries > this.getMaxSshAuthRetries()) {
            return false;
        }
        this._sshAuthRetries = sshAuthRetries;
        this.setModified();
        return true;
    }

    public boolean setSsshTimeout(int sshTimeout) {
        if (sshTimeout < this.getMinSshTimeout() || sshTimeout > this.getMaxSshTimeout()) {
            return false;
        }
        this._sshTimeout = sshTimeout;
        this.setModified();
        return true;
    }

    public void setSwitchType(String strSwitch) {
        this.switchType = strSwitch;
        this.setModified();
    }

    public void setTcpKeepAliveIn(boolean tcpKeepAliveIn) {
        this._tcpKeepAliveIn = tcpKeepAliveIn;
        this.setModified();
    }

    public void setTcpKeepAliveOut(boolean tcpKeepAliveOut) {
        this._tcpKeepAliveOut = tcpKeepAliveOut;
        this.setModified();
    }

    public void setTcpSmallServer(boolean tcpSmallServer) {
        this._tcpSmallServer = tcpSmallServer;
        this.setModified();
    }

    public boolean setTcpSynwaitTime(int tcpSynwaitTime) {
        if (tcpSynwaitTime != -1 && (tcpSynwaitTime < this.getMinSynwaitTime() || tcpSynwaitTime > this.getMaxSynwaitTime())) {
            return false;
        }
        this._tcpSynwaitTime = tcpSynwaitTime;
        this.setModified();
        return true;
    }

    public void setTimeSource(String strTimeSource) {
        Log.getLog().debug("inside Sysprop setTimeSource() - strTimeSource" + strTimeSource);
        this._timeSource = strTimeSource == null || strTimeSource.trim().length() == 0 ? "No Time Source" : (strTimeSource.indexOf("Time source is user configuration") != -1 ? "User Configuration" : (strTimeSource.indexOf("Time source is NTP") != -1 ? "NTP" : (strTimeSource.indexOf("Time source is SNTP") != -1 ? "SNTP" : (strTimeSource.indexOf("No time source") != -1 ? "No time source" : (strTimeSource.indexOf("Time source is hardware calendar") != -1 ? "Hardware Calendar" : strTimeSource)))));
    }

    public void setTimezone(String zone, int offsetHour, int offsetMin) {
        this._timezoneNoGMT = this._timezone = zone;
        this._tzOffsetHour = offsetHour;
        this._tzOffsetMin = offsetMin;
    }

    public void setUdpSmallServer(boolean udpSmallServer) {
        this._udpSmallServer = udpSmallServer;
        this.setModified();
    }

    public void synchronizewithPCtime() {
        if (this.objSyncPCDetails == null) {
            return;
        }
        this.objSyncPCDetails.populatePCClock();
        String strConfigurableTimezoneVal = this.objSyncPCDetails.getConfigurableTimezoneVal();
        String strConfigurableTime = this.objSyncPCDetails.getConfigurableTimeVal();
        String strDSTTime = "";
        String strGMTOffset = this.objSyncPCDetails.getConfigurableGMTOffsetVal();
        boolean bDSTon = this.objSyncPCDetails.isDSTSettingsOn();
        Log.getLog().debug("strGMTOffset" + strGMTOffset);
        strGMTOffset = strGMTOffset.trim();
        String strGMTHrOffset = strGMTOffset.substring(0, strGMTOffset.indexOf(" "));
        String strGMTMinOffset = strGMTOffset.substring(strGMTOffset.indexOf(" "), strGMTOffset.length());
        Log.getLog().debug("strGMTHrOffset" + strGMTHrOffset + "strGMTMinOffset" + strGMTMinOffset);
        this.configureRouterTimeZone(strConfigurableTimezoneVal, strGMTHrOffset, strGMTMinOffset);
        Log.getLog().debug("strConfigurableTimezoneVal" + strConfigurableTimezoneVal);
        if (bDSTon) {
            strDSTTime = this.objSyncPCDetails.getConfigurableDSTVal();
            Log.getLog().debug("strDSTTime" + strDSTTime);
            this.configureRouterTimeZoneDST(strConfigurableTimezoneVal, strDSTTime);
        } else {
            this.configureRouterSummerTimeZone(strConfigurableTimezoneVal, false);
        }
        Log.getLog().debug("strConfigurableTime" + strConfigurableTime);
        this.configureRouterTime(strConfigurableTime);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t_hostName = " + this._hostName);
        sb.append("\t_ipDomainName = " + this._ipDomainName);
        sb.append("\t_isDomainLookup = " + this._isDomainLookup);
        if (this._ipDefaultGateway != null) {
            sb.append("\t_ipDefaultGateway = " + this._ipDefaultGateway.toString());
        }
        sb.append("\t_isIpRouting = " + this._isIpRouting);
        sb.append("\t_isIpCEF = " + this._isIpCEF);
        sb.append("\t_enablePWD = " + this._enablePWD);
        sb.append("\t_enablePWDEncr = " + this._enablePWDEncr);
        sb.append("\t_secretPWDs = " + this._secretPWDs.toString());
        sb.append("\t_sdm_ntpclients = " + this._sdm_ntpclients.toString());
        sb.append("\t_sdm_sntpclients = " + this._sdm_sntpclients.toString());
        sb.append("\t_users = " + this._users.toString());
        sb.append("\t_cliviews = " + this._cliviews.toString());
        sb.append("\t_snmp = " + this._snmp.toString());
        sb.append("\t_vtyLines = " + this._vtyLines.toString());
        sb.append("\t_ttyLines = " + this._ttyLines.toString());
        sb.append("\t_logs = " + this._logs.toString());
        sb.append("\t_nameServers = " + this._nameServers.toString());
        sb.append("\n_fingerService = " + this._fingerService);
        sb.append("\n_padService = " + this._padService);
        sb.append("\n_servicePassEncr = " + this._servicePassEncr);
        sb.append("\n_tcpSmallServer = " + this._tcpSmallServer);
        sb.append("\n_udpSmallServer = " + this._udpSmallServer);
        sb.append("\n_bootpServer = " + this._bootpServer);
        sb.append("\n_ipIdentificationService = " + this._ipIdentificationService);
        sb.append("\n_cdpEnabled = " + this._cdpEnabled);
        sb.append("\n_ipSourceRoute = " + this._ipSourceRoute);
        sb.append("\n_ipGratuitousArps = " + this._ipGratuitousArps);
        sb.append("\n_tcpKeepAliveIn = " + this._tcpKeepAliveIn);
        sb.append("\n_tcpKeepAliveOut = " + this._tcpKeepAliveOut);
        sb.append("\n_debugTimestamp = " + this._debugTimestamp);
        sb.append("\n_logTimestamp = " + this._logTimestamp);
        sb.append("\n_sequenceNumbers = " + this._sequenceNumbers);
        sb.append("\n_schedulerInterval = " + this._schedulerInterval);
        sb.append("\n_schedulerInterruptTime = " + this._schedulerInterruptTime);
        sb.append("\n_schedulerProcessTime = " + this._schedulerProcessTime);
        sb.append("\n_httpServer = " + this._httpServer);
        sb.append("\n_httpServerACL = " + this._httpServerACL);
        sb.append("\n_deleteHttpACL = " + this._deleteHttpACL);
        sb.append("\n _deleteLocalRMapPolicy = " + this._deleteLocalRMapPolicy);
        sb.append("\n _localPolicyRMapName = " + this._localPolicyRMapName);
        sb.append("\n_tcpSynwaitTime = " + this._tcpSynwaitTime);
        sb.append("\n_interceptList = " + this._interceptList);
        sb.append("\n_interceptConnectionTimeout = " + this._interceptConnectionTimeout);
        sb.append("\n_interceptDropMode = " + this._interceptDropMode);
        sb.append("\n_interceptFinrstTimeout = " + this._interceptFinrstTimeout);
        sb.append("\n_interceptMaxIncompleteHigh = " + this._interceptMaxIncompleteHigh);
        sb.append("\n_interceptMaxIncompleteLow = " + this._interceptMaxIncompleteLow);
        sb.append("\n_interceptWatchTimeOut = " + this._interceptWatchTimeOut);
        sb.append("\n_logging = " + this._logging);
        sb.append("\n_secAuthFailureRate = " + this._secAuthFailureRate);
        sb.append("\n_secPassMinLength = " + this._secPassMinLength);
        sb.append("\n_cryptoKeyModulus = " + this._cryptoKeyModulus);
        sb.append("\n_cryptoKeyModulusSupported = " + _cryptoKeyModulusSupported);
        sb.append("\n_sshTimeout = " + this._sshTimeout);
        sb.append("\n_sshAuthRetries = " + this._sshAuthRetries);
        sb.append("\n_spd = " + this._spd);
        sb.append("\n_spdHeadroom = " + this._spdHeadroom);
        sb.append("\n_spdExtHeadroom = " + this._spdExtHeadroom);
        sb.append("\n_console = " + this._console);
        sb.append("\n_aux = " + this._aux);
        sb.append("\n_banner = " + this._banner);
        sb.append("\n_execBanner = " + this._execBanner);
        sb.append("\n_rsaCrypotoKeyConfigured = " + this._rsaCryptoKeyConfigured);
        return sb.toString();
    }
}

