/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.vpdn;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import com.cisco.xdm.data.interfaces.XDMUnsupportedIf;
import com.cisco.xdm.data.vpdn.VPDNGroupCollection;
import java.util.Enumeration;

public class VPDN
extends XDMObject
implements Cloneable {
    private boolean _vpdnEnabled = false;
    private boolean _vpdnLogging = false;
    private boolean _vpdnNoLogging = false;
    private VPDNGroupCollection _vpdnGroupCollection = new VPDNGroupCollection(this);
    private boolean _canDeleteVPDN = true;
    private boolean _vpdnRequired = false;

    public VPDN() {
    }

    public VPDN(XDMObject parent) {
        super(parent);
    }

    public Object clone() {
        VPDN newObj = (VPDN)super.clone();
        newObj._vpdnGroupCollection = (VPDNGroupCollection)this._vpdnGroupCollection.clone();
        newObj._vpdnGroupCollection.setParent(newObj);
        return newObj;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        VPDN _backup = (VPDN)backup;
        int cmdPos = -1;
        Log.getLog().info(" In VPDN generate Delta of ========" + this);
        if (this._vpdnGroupCollection.isModified() && _backup != null) {
            CmdValues subcmdval;
            if (_backup.isVpdnEnabledSet() != this.isVpdnEnabledSet()) {
                subcmdval = new CmdValues("vpdn");
                subcmdval.addValue("enable", "enable");
                Log.getLog().info("vpdn enabled ========" + this.isVpdnEnabledSet());
                if (this.isVpdnEnabledSet()) {
                    subcmdval.setAction(1);
                    DeviceBase dev = (DeviceBase)this.getDevice();
                    cmdPos = dev.getFirstCmdPosition("ifs", values, false);
                } else {
                    subcmdval.setAction(2);
                }
                if (cmdPos >= 0) {
                    values.insertCmdValues(subcmdval, cmdPos);
                } else {
                    values.addCmdValues(subcmdval);
                }
            }
            if (_backup._vpdnNoLogging != this._vpdnNoLogging && this._vpdnNoLogging) {
                subcmdval = new CmdValues("vpdn");
                subcmdval.addValue("logging", "logging");
                subcmdval.setAction(2);
                values.addCmdValues(subcmdval);
            }
            this._vpdnGroupCollection.generateDelta(_backup.getVPDNGroupCollection(), values);
        }
    }

    public boolean getDeleteVPDN() {
        return this._canDeleteVPDN;
    }

    public String getNextGroupName() {
        return null;
    }

    public VPDNGroupCollection getVPDNGroupCollection() {
        return this._vpdnGroupCollection;
    }

    public boolean isVpdnEnabledSet() {
        return this._vpdnEnabled;
    }

    public boolean isVpdnLoggingSet() {
        return this._vpdnLogging;
    }

    public boolean isVpdnRequired() {
        return this._vpdnRequired;
    }

    public void populate(ConfigValues config, CmdValues cmdvals) throws XDMException, CliGPBException {
        ConfigValues vpdnCmds = config.getCmds("vpdn", ".*", ".*", false);
        if (vpdnCmds != null) {
            String log;
            CmdValues cmd = vpdnCmds.getCmdValues(0);
            String enable = cmd.getValue("enable");
            if (enable != null) {
                this._vpdnEnabled = true;
            }
            if ((log = cmd.getValue("vpdnLog")) != null) {
                this._vpdnLogging = true;
            }
            this.setDeleteVPDN();
        }
        this._vpdnGroupCollection.populate(config, null);
    }

    public void setDeleteVPDN() {
        XDMInterfaces xifs = ((DeviceBase)this.getDevice()).getIfs();
        Enumeration enum_if = xifs.getSortedIfs().elements();
        while (enum_if.hasMoreElements()) {
            XDMInterfaceBase xif = (XDMInterfaceBase)enum_if.nextElement();
            if (!(xif instanceof XDMUnsupportedIf)) continue;
            this._canDeleteVPDN = false;
            break;
        }
    }

    public void setNoVpdnLogging(boolean enable) {
        this._vpdnNoLogging = enable;
        this.setModified();
    }

    public void setVpdnEnabled(boolean enable) {
        this._vpdnEnabled = enable;
        this.setModified();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("VPDN \n");
        sb.append(" Enabled = " + this._vpdnEnabled + "\n");
        sb.append(" Logging = " + this._vpdnLogging + "\n");
        sb.append(this._vpdnGroupCollection);
        return sb.toString();
    }
}

