/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.vpdn;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;

public class VPDNGroup
extends XDMObject {
    private String _groupName;
    private String _protocol;
    private String _description;
    private int _groupNo = 0;
    private static final String GROUP_NAME = "SDM-VPDN-";
    private static final String DESCRIPTION = "SDM created VPDN Group";

    public VPDNGroup() {
    }

    public VPDNGroup(int group) {
        this._protocol = "pppoe";
        this._groupNo = group;
        this._groupName = GROUP_NAME + group;
        this._description = DESCRIPTION;
    }

    public VPDNGroup(XDMObject parent) {
        super(parent);
    }

    public boolean equals(Object obj) {
        return false;
    }

    private void generateAddCmd(ConfigValues cv) {
        CmdValues cmd = this.generateVPDNGroupCmd(1);
        ConfigValues subcfgval = new ConfigValues();
        CmdValues descrCmdValue = this.generateDescriptionCmd(1, null);
        subcfgval.addCmdValues(descrCmdValue);
        CmdValues reqCmdVal = new CmdValues("request-dialin");
        subcfgval.addCmdValues(reqCmdVal);
        ConfigValues sub2cfgval = new ConfigValues();
        CmdValues protocolCmdValue = this.generateProtocolCmd(1, null);
        sub2cfgval.addCmdValues(protocolCmdValue);
        if (sub2cfgval.numCmds() > 0) {
            reqCmdVal.setModeCmdsValues(sub2cfgval);
        }
        if (subcfgval.numCmds() > 0) {
            cmd.setModeCmdsValues(subcfgval);
        }
        int cmdPos = -1;
        DeviceBase dev = (DeviceBase)this.getDevice();
        cmdPos = dev.getFirstCmdPosition("ifs", cv, false);
        if (cmdPos >= 0) {
            cv.insertCmdValues(cmd, cmdPos);
        } else {
            cv.addCmdValues(cmd);
        }
    }

    public void generateDelta(XDMObject backup, ConfigValues cfgval) {
        VPDNGroup backupVPDNGroup = null;
        if (!this.isReadOnly() && this.isModified()) {
            if (this.isBackup()) {
                CmdValues cmdval = this.generateVPDNGroupCmd(2);
                cfgval.addCmdValues(cmdval);
            } else if (backup == null) {
                this.generateAddCmd(cfgval);
            } else {
                backupVPDNGroup = (VPDNGroup)backup;
            }
        }
    }

    private CmdValues generateDescriptionCmd(int action, VPDNGroup backupObj) {
        CmdValues subcmdval = new CmdValues("description");
        switch (action) {
            case 1: {
                subcmdval.addValue("description", this._description);
                subcmdval.setAction(action);
                return subcmdval;
            }
            case 2: {
                subcmdval.addValue("description", backupObj._description);
                subcmdval.setAction(action);
                return subcmdval;
            }
        }
        return null;
    }

    private CmdValues generateProtocolCmd(int action, VPDNGroup backupObj) {
        CmdValues subcmdval = new CmdValues("protocol");
        switch (action) {
            case 1: {
                subcmdval.addValue("protocol", this._protocol);
                subcmdval.setAction(action);
                return subcmdval;
            }
            case 2: {
                subcmdval.addValue("protocol", backupObj._protocol);
                subcmdval.setAction(action);
                return subcmdval;
            }
        }
        return null;
    }

    private CmdValues generateVPDNGroupCmd(int action) {
        CmdValues cmdval = new CmdValues("vpdn-group");
        cmdval.addValue("groupName", this._groupName);
        switch (action) {
            case 1: {
                cmdval.setAction(1);
                return cmdval;
            }
            case 2: {
                cmdval.setAction(2);
                return cmdval;
            }
        }
        return null;
    }

    public String getDescription() {
        return this._description;
    }

    public int getGroupNo() {
        return this._groupNo;
    }

    public String getName() {
        return this._groupName;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public void populate(ConfigValues config, CmdValues cmdVals) throws XDMException, CliGPBException {
        ConfigValues subcmds;
        this._groupName = cmdVals.getValue("groupName");
        if (this._groupName.indexOf(GROUP_NAME) != -1) {
            String grpNo = this._groupName.substring(GROUP_NAME.length());
            try {
                this._groupNo = Integer.parseInt(grpNo);
            }
            catch (NumberFormatException numberFormatException) {
                this._groupNo = 0;
            }
        }
        if ((subcmds = cmdVals.getModeCmdsValues()) == null) {
            return;
        }
        CmdValues grpCmd = null;
        if (subcmds.numCmds() > 0) {
            grpCmd = subcmds.getCmdValues(0);
        }
        if (grpCmd == null) {
            return;
        }
        this._description = grpCmd.getValue("description");
        this.populateRequestDialin(subcmds);
        this.populateAcceptDialin(subcmds);
    }

    private void populateAcceptDialin(ConfigValues cmds) throws XDMException, CliGPBException {
        ConfigValues reqCmds = cmds.getCmds("accept-dialin", ".*", ".*", false);
        if (reqCmds == null) {
            return;
        }
        CmdValues reqCmd = reqCmds.getCmdValues(0);
        ConfigValues subcmds = reqCmd.getModeCmdsValues();
        if (subcmds == null) {
            return;
        }
        this.populateProtocol(subcmds);
    }

    private void populateProtocol(ConfigValues cmds) throws XDMException, CliGPBException {
        ConfigValues protocolCmds = cmds.getCmds("protocol", ".*", ".*", false);
        if (protocolCmds == null) {
            this.setReadOnly(true);
            return;
        }
        CmdValues protocolCmd = protocolCmds.getCmdValues(0);
        this._protocol = protocolCmd.getValue("protocol");
        if (!this._protocol.equals("pppoe")) {
            this.setReadOnly(true);
        }
    }

    private void populateRequestDialin(ConfigValues cmds) throws XDMException, CliGPBException {
        ConfigValues reqCmds = cmds.getCmds("request-dialin", ".*", ".*", false);
        if (reqCmds == null) {
            this.setReadOnly(true);
            return;
        }
        CmdValues reqCmd = reqCmds.getCmdValues(0);
        ConfigValues subcmds = reqCmd.getModeCmdsValues();
        if (subcmds == null) {
            return;
        }
        this.populateProtocol(subcmds);
    }

    public String toString() {
        return "vpdn-group :" + this._groupName + " ,protocol :" + this._protocol + " ,readOnly :" + this.isReadOnly() + " ,description :" + this._description;
    }
}

