/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.io;

public class Base64 {
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static byte[] codes = new byte[256];

    static {
        int i = 0;
        while (i < 256) {
            Base64.codes[i] = -1;
            ++i;
        }
        int i2 = 65;
        while (i2 <= 90) {
            Base64.codes[i2] = (byte)(i2 - 65);
            ++i2;
        }
        int i3 = 97;
        while (i3 <= 122) {
            Base64.codes[i3] = (byte)(26 + i3 - 97);
            ++i3;
        }
        int i4 = 48;
        while (i4 <= 57) {
            Base64.codes[i4] = (byte)(52 + i4 - 48);
            ++i4;
        }
        Base64.codes[43] = 62;
        Base64.codes[47] = 63;
    }

    public static String decode(String str) {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        return new String(Base64.decode(str.toCharArray()));
    }

    public static byte[] decode(char[] encoded) {
        int len = (encoded.length + 3) / 4 * 3;
        if (encoded.length > 0 && encoded[encoded.length - 1] == '=') {
            --len;
        }
        if (encoded.length > 1 && encoded[encoded.length - 2] == '=') {
            --len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        int ix = 0;
        while (ix < encoded.length) {
            byte value = codes[encoded[ix] & 0xFF];
            if (value >= 0) {
                accum <<= 6;
                accum |= value;
                if ((shift += 6) >= 8) {
                    out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
                }
            }
            ++ix;
        }
        if (index != out.length) {
            throw new Error("miscalculated encoded length!");
        }
        return out;
    }

    public static String encode(String str) {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        return new String(Base64.encode(str.getBytes()));
    }

    public static char[] encode(byte[] bytes) {
        char[] out = new char[(bytes.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < bytes.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & bytes[i];
            val <<= 8;
            if (i + 1 < bytes.length) {
                val |= 0xFF & bytes[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < bytes.length) {
                val |= 0xFF & bytes[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }
}

