/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.io;

import com.cisco.nm.util.sgz.SgzApplet;
import com.cisco.xdm.io.Base64;
import com.cisco.xdm.net.URLI;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Hashtable;

public class HTTPInputStream
extends InputStream {
    InputStream in;
    URLConnection conn;
    Hashtable headers;

    public HTTPInputStream(com.cisco.xdm.net.URL url) throws IOException, MalformedURLException {
        if (!url.getScheme().toLowerCase().equals("http") && !url.getScheme().toLowerCase().equals("https")) {
            throw new MalformedURLException("unknown protocol");
        }
        this.conn = url.toURL().openConnection();
        if (url.getUsername() != null && url.getPassword() != null) {
            String enc = Base64.encode(String.valueOf(url.getUsername()) + ":" + url.getPassword());
            this.conn.setRequestProperty("Authorization", "Basic " + enc);
        }
        try {
            this.in = SgzApplet.getInputStreamFromURLConnection(this.conn);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("Authentication required or invalid");
        }
        if (this.conn != null) {
            String key = null;
            String value = null;
            this.headers = new Hashtable();
            int ii = 1;
            while ((key = this.conn.getHeaderFieldKey(ii)) != null) {
                value = this.conn.getHeaderField(key);
                this.headers.put(key.toLowerCase(), value);
                ++ii;
            }
        }
    }

    public HTTPInputStream(String spec) throws IOException, MalformedURLException {
        this(new URLI(spec));
    }

    public HTTPInputStream(String username, String password, String host, int port, String path) throws IOException, UnknownHostException {
        this(new URLI("http", username, password, host, port, path));
    }

    public HTTPInputStream(String protocol, String username, String password, String host, int port, String path) throws IOException, UnknownHostException {
        this(new URLI(protocol, username, password, host, port, path));
    }

    public HTTPInputStream(URL url) throws IOException, MalformedURLException {
        this(new URLI(url.toString()));
    }

    public void close() throws IOException {
        this.in.close();
    }

    public String getContentEncoding() {
        return this.conn.getHeaderField("content-encoding");
    }

    public int getContentLength() {
        return this.conn.getHeaderFieldInt("content-length", -1);
    }

    public String getContentType() {
        return this.conn.getHeaderField("content-type");
    }

    public long getDate() {
        return this.conn.getHeaderFieldDate("date", 0L);
    }

    public long getExpiration() {
        return this.conn.getHeaderFieldDate("expires", 0L);
    }

    public String getHeaderField(String name) {
        if (this.conn != null) {
            return this.conn.getHeaderField(name);
        }
        return null;
    }

    public Hashtable getHeaders() {
        return this.headers;
    }

    public long getLastModified() {
        return this.conn.getHeaderFieldDate("last-modified", 0L);
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] b) throws IOException {
        return this.in.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }
}

