/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.net;

import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.io.HTTPInputStream;
import com.cisco.xdm.io.IOSCLIHTMLInputStreamFilter;
import com.cisco.xdm.net.URL;
import com.cisco.xdm.net.URLI;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class HTTPService {
    private static final char SP = ' ';
    private static final char TAB = '\t';
    private static final char LF = '\n';
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static HTTPService _instance;
    protected static URL _base_url;
    protected static Log _log;

    private HTTPService(URL url) {
        _log = Log.getLog();
        if (url != null) {
            HTTPService.setBaseURL(url);
        }
    }

    public static URL getBaseURL() {
        return _base_url;
    }

    public synchronized String getContentAsString(URL url) throws IOException {
        if (url.getHost().equals("127.0.0.1")) {
            return " ";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            _log.debug("HTTPService GET " + url.toString());
            BufferedInputStream bis = new BufferedInputStream(this.getInputStream(url));
            int count = 0;
            byte[] buffer = new byte[4096];
            while ((count = bis.read(buffer, 0, buffer.length)) >= 0) {
                baos.write(buffer, 0, count);
            }
            bis.close();
        }
        catch (Exception x) {
            throw new IOException(x.getMessage());
        }
        return baos.toString();
    }

    public synchronized String getContentAsString(String urlstr) throws MalformedURLException, UnknownHostException, IOException {
        String content = null;
        if (urlstr.startsWith("/")) {
            if (_base_url == null || _base_url.equals("")) {
                throw new UnknownHostException("Base URL not specified");
            }
            content = this.getContentAsString(new URLI(_base_url, urlstr));
        } else {
            content = this.getContentAsString(new URLI(urlstr));
        }
        return content;
    }

    public synchronized InputStream getInputStream(URL url) throws IOException {
        _log.debug("HTTPService GET " + url.toString());
        return new HTTPInputStream(url);
    }

    public synchronized InputStream getInputStream(String urlstr) throws MalformedURLException, UnknownHostException, IOException {
        InputStream is = null;
        if (urlstr.startsWith("/")) {
            if (_base_url == null || _base_url.equals("")) {
                throw new UnknownHostException("Base URL not specified");
            }
            is = this.getInputStream(new URLI(_base_url, urlstr));
        } else {
            is = this.getInputStream(new URLI(urlstr));
        }
        return is;
    }

    public synchronized InputStream getInputStreamWithoutHTML(URL url) throws IOException {
        return new IOSCLIHTMLInputStreamFilter(this.getInputStream(url));
    }

    public synchronized InputStream getInputStreamWithoutHTML(String url) throws IOException {
        return new IOSCLIHTMLInputStreamFilter(this.getInputStream(url));
    }

    public static synchronized HTTPService getInstance() {
        if (_instance == null) {
            _instance = new HTTPService(null);
        }
        return _instance;
    }

    public static synchronized HTTPService getInstance(URL url) {
        if (_instance == null) {
            _instance = new HTTPService(url);
        } else {
            HTTPService.setBaseURL(url);
        }
        return _instance;
    }

    public static synchronized HTTPService getInstance(String url) throws MalformedURLException, UnknownHostException {
        return HTTPService.getInstance(new URLI(url));
    }

    protected static String getUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("NAME\n  HTTPService\n");
        sb.append("\n");
        sb.append("SYNOPSIS\n  java com.cisco.xdm.net.HTTPService <URL> [ <URL> ]\n");
        sb.append("\n");
        sb.append("DESCRIPTION\n  Retrieves one or more URLs from the command line.\n");
        sb.append("\n");
        return sb.toString();
    }

    protected static final int indexOfNonWhitespace(String s, int index) {
        int length = s.length();
        while (index < length) {
            char c = s.charAt(index);
            if (c != ' ' && c != '\t' && c != '\n') {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static void main(String[] args) {
        Vector<URLI> urls = new Vector<URLI>();
        if (args.length <= 0) {
            System.out.println(HTTPService.getUsage());
            System.exit(0);
        }
        int ii = 0;
        while (ii < args.length) {
            try {
                urls.addElement(new URLI(args[ii]));
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Invalid URL: " + args[ii]);
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("Unknown host: " + args[ii]);
            }
            ++ii;
        }
        if (urls.size() <= 0) {
            System.out.println(HTTPService.getUsage());
            System.exit(0);
        }
        URL url = null;
        Enumeration e = urls.elements();
        while (e != null && e.hasMoreElements()) {
            url = (URL)e.nextElement();
            try {
                System.out.println(HTTPService.getInstance().getContentAsString(url));
                System.out.println("--------------------------------------------------------------------------------");
            }
            catch (IOException x) {
                System.out.println(x.getMessage());
            }
        }
    }

    public static String removeIOSCLIHTML(String html) {
        String line = null;
        String line_lc = null;
        boolean is_form = false;
        StringBuffer response = new StringBuffer();
        StringTokenizer lines = new StringTokenizer(html, "\n");
        while (lines.hasMoreTokens()) {
            line = lines.nextToken();
            line_lc = line.toLowerCase();
            if (line_lc.startsWith("<form")) {
                is_form = true;
                continue;
            }
            if (line_lc.startsWith("</form")) {
                is_form = false;
                continue;
            }
            if (!is_form || line_lc.startsWith("complete") || line_lc.startsWith("command")) continue;
            response.append(String.valueOf(line) + "\n");
        }
        return response.toString();
    }

    public static synchronized void setBaseURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        _base_url = url;
        _log.debug("HTTPService Base: " + _base_url.toString());
    }
}

