/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.net;

import com.cisco.xdm.net.URL;
import com.cisco.xdm.net.URLFactory;
import com.cisco.xdm.net.URLI;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class URLFactoryDefault
implements URLFactory {
    private static final String DEFAULT_SCHEME = "http";
    private static final String AT = "@";
    private static final String CLN = ":";
    private static final String FSL = "/";
    private static final String NULL = "";
    private static final String SLASH_SLASH = "//";
    private static URLFactory instance = new URLFactoryDefault();
    private Hashtable factories = new Hashtable();

    private URLFactoryDefault() {
    }

    public void addURLFactory(String scheme, URLFactory factory) {
        if (scheme == null) {
            throw new NullPointerException("scheme");
        }
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factories.put(scheme, factory);
    }

    public URL createURL(String spec) throws MalformedURLException {
        URL url = null;
        try {
            String CLN = CLN;
            String scheme = null;
            StringTokenizer st = null;
            if (spec.indexOf(CLN) < 0) {
                scheme = DEFAULT_SCHEME;
            } else {
                st = new StringTokenizer(spec, CLN, true);
                scheme = st.nextToken();
                int ii = 0;
                while (ii < URL.RESERVED_CHARS.length) {
                    if (scheme.indexOf(URL.RESERVED_CHARS[ii]) >= 0) {
                        throw new MalformedURLException(scheme);
                    }
                    ++ii;
                }
            }
            URLFactory factory = (URLFactory)this.factories.get(scheme);
            url = factory == null ? this.parseURL(scheme, st.nextToken(NULL)) : factory.createURL(spec);
        }
        catch (Exception exception) {
            throw new MalformedURLException(spec);
        }
        return url;
    }

    public static URLFactory getInstance() {
        return instance;
    }

    public int getSchemePort(String scheme) {
        int port = -1;
        String s = scheme.toLowerCase();
        if (s.equals("ftp")) {
            port = 21;
        } else if (s.equals(DEFAULT_SCHEME)) {
            port = 80;
        } else if (s.equals("mailto")) {
            port = 23;
        } else if (s.equals("telnet")) {
            port = 19;
        }
        return port;
    }

    private URL parseURL(String scheme, String spec) throws MalformedURLException, UnknownHostException {
        int index;
        StringTokenizer st = null;
        String username = null;
        String password = null;
        String host = null;
        int port = -1;
        String path = null;
        if (spec.startsWith(CLN)) {
            spec = spec.substring(1, spec.length());
        }
        if (spec.startsWith(SLASH_SLASH)) {
            spec = spec.substring(2, spec.length());
        }
        if (spec.indexOf(AT) < 0) {
            username = null;
            password = null;
        } else if (spec.indexOf(AT) == 0) {
            username = NULL;
            password = null;
        } else if (spec.indexOf(AT) > 0) {
            st = new StringTokenizer(spec, AT, true);
            String user_pass = st.nextToken();
            st.nextToken();
            spec = st.nextToken(NULL);
            if (user_pass.indexOf(CLN) == 0) {
                username = NULL;
            } else {
                index = user_pass.indexOf(CLN);
                username = user_pass.substring(0, index);
                password = user_pass.substring(index + 1, user_pass.length());
            }
        }
        st = new StringTokenizer(spec, FSL);
        String host_port = st.nextToken();
        if (st.hasMoreTokens()) {
            path = st.nextToken(NULL);
            if (path.startsWith(FSL)) {
                path = path.substring(1, path.length());
            }
        } else {
            path = NULL;
        }
        if ((index = host_port.indexOf(CLN)) < 0) {
            host = host_port;
        } else {
            if (index == 0) {
                throw new MalformedURLException("no host");
            }
            host = host_port.substring(0, index);
            String port_str = host_port.substring(index + 1, host_port.length());
            try {
                port = Integer.parseInt(port_str);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedURLException("port");
            }
        }
        return new URLI(scheme, username, password, host, port, path);
    }
}

