/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.net.cmdsvc;

import com.cisco.nm.util.sgz.SgzApplet;
import com.cisco.xdm.data.Constant;
import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.net.cmdsvc.CredentialRepository;
import com.cisco.xdm.net.cmdsvc.HandleCreator;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceBase;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import com.cisco.xdm.net.cmdsvc.InteractiveItemContext;
import com.cisco.xdm.net.cmdsvc.PromptHandlerIf;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileIOSCmdService
extends IOSCmdServiceBase {
    private String _dir;
    private String SEP = "//?//?//?//";
    private Hashtable handler = new Hashtable();
    public static final String DEMO_FILES_PATH = "C:\\routerlessdemo";

    public void close() {
    }

    public synchronized IOSCmdResponse[] config(String[] cmds) throws IOSCmdServiceException {
        IOSCmdResponse[] replies = this.sendCmds(cmds);
        if (replies == null) {
            throw this.processIOSCmdServiceException("PAI communication protocol error");
        }
        return replies;
    }

    public synchronized IOSCmdResponse[] config(String[] cmds, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        return this.handleInteractiveSession(cmds, promptHandler);
    }

    public synchronized void connect(String protocol, String ipAddress, int port, CredentialRepository credRep) {
        this._dir = DEMO_FILES_PATH;
    }

    public synchronized IOSCmdResponse[] exec(String[] cmds) throws IOSCmdServiceException {
        IOSCmdResponse[] replies = this.sendCmds(cmds);
        if (replies == null) {
            throw this.processIOSCmdServiceException("PAI communication protocol error");
        }
        return replies;
    }

    public synchronized IOSCmdResponse[] exec(String[] cmds, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        return this.handleInteractiveSession(cmds, promptHandler);
    }

    private String getFileName(String[] cmds, int start, int end) {
        StringBuffer sb = new StringBuffer();
        int i = start;
        while (i <= end) {
            if (cmds[i].startsWith("interface")) {
                sb.append("interface");
            } else {
                sb.append(cmds[i]);
            }
            if (i < end) {
                sb.append("&");
            }
            ++i;
        }
        String fileName = sb.toString();
        fileName = fileName.replace('\\', '$');
        fileName = fileName.replace('/', '$');
        fileName = fileName.replace(':', '$');
        fileName = fileName.replace('*', '$');
        fileName = fileName.replace('?', '$');
        fileName = fileName.replace('\"', '$');
        fileName = fileName.replace('<', '$');
        fileName = fileName.replace('>', '$');
        fileName = fileName.replace('|', '$');
        fileName = this.getFileNameForDynamicHost(fileName);
        return String.valueOf(this._dir) + "\\demo_" + fileName;
    }

    private String getFileNameForDynamicHost(String fileName) {
        StringTokenizer tokenizer;
        if (fileName.startsWith("ping")) {
            return "ping";
        }
        if (fileName.startsWith("show ip route")) {
            StringTokenizer tokenizer2 = new StringTokenizer(fileName, " ", false);
            if (tokenizer2.countTokens() == 4) {
                tokenizer2.nextToken();
                tokenizer2.nextToken();
                tokenizer2.nextToken();
                if (IPAddress.isLegalIPAddress(tokenizer2.nextToken())) {
                    return "show ip route 127.0.0.1";
                }
                return "show ip route";
            }
            return "show ip route";
        }
        if (fileName.startsWith("show ip flow top ")) {
            tokenizer = new StringTokenizer(fileName, " ", false);
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            String token = tokenizer.nextToken();
            if (token.equalsIgnoreCase("source-address")) {
                return "show ip flow top 10 aggregate source-address";
            }
            if (token.equalsIgnoreCase("source-interface")) {
                return "show ip flow top 10 aggregate source-interface";
            }
        }
        if (fileName.startsWith("crypto ipsec server auto-update")) {
            return "crypto ipsec server auto-update sdmsdm";
        }
        if (fileName.startsWith("ip inspect name test")) {
            tokenizer = new StringTokenizer(fileName, " ", false);
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            if (tokenizer.nextToken().equalsIgnoreCase("$")) {
                return "ip inspect name test $";
            }
            return "ip inspect name test pop3 $";
        }
        return fileName;
    }

    private String getOutputFromFile(String fileName) throws Exception {
        StringBuffer buf = new StringBuffer();
        int size = 10240;
        char[] tmp = new char[size];
        try {
            if (Class.forName("com.ms.security.PolicyEngine") != null) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
            }
        }
        catch (Throwable throwable) {}
        FileInputStream fis = SgzApplet.createFileInputStream(new File(fileName));
        BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
        int bytes = 0;
        while (bytes != -1) {
            bytes = reader.read(tmp, 0, size);
            if (bytes <= 0) continue;
            buf.append(tmp, 0, bytes);
        }
        reader.close();
        return buf.toString();
    }

    private InputStream getStreamFromFile(String fileName) throws Exception {
        try {
            if (Class.forName("com.ms.security.PolicyEngine") != null) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
            }
        }
        catch (Throwable throwable) {}
        return SgzApplet.createFileInputStream(new File(fileName));
    }

    public synchronized int getTimeout() {
        return 5000;
    }

    private IOSCmdResponse[] handleInteractiveSession(String[] cmds, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        InteractiveItemContext ctx;
        this.logCmds(cmds);
        IOSCmdResponse[] responses = new IOSCmdResponse[cmds.length];
        if (cmds[0].startsWith("no")) {
            cmds[0] = cmds[0].substring(2, cmds[0].length()).trim();
            this.handler.containsKey(cmds[0]);
        }
        cmds[0] = this.stripDynamicPart(cmds[0]);
        if (!this.handler.containsKey(cmds[0])) {
            String fileName = "C:\\routerlessdemo\\xml_" + cmds[0];
            try {
                InteractiveItemContext ctx2 = HandleCreator.getInteractiveHandler(this.getStreamFromFile(fileName));
                this.handler.put(ctx2.getKey(), ctx2);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        if ((ctx = (InteractiveItemContext)this.handler.get(cmds[0])) != null) {
            String retVal = null;
            String response = "";
            for (int index = 0; index < cmds.length; ++index) {
                response = ctx.getOutput(retVal);
                retVal = promptHandler.handle(new String[]{cmds[0], response});
                if (retVal == null || retVal.length() == 0 || retVal.equals("\r\n")) {
                    responses[index] = new IOSCmdResponse(cmds[index], response, 0);
                    break;
                }
                responses[index] = new IOSCmdResponse(cmds[index], response, 0);
            }
        }
        return responses;
    }

    public boolean isSecure() {
        return false;
    }

    private boolean isVLANIdCLI(String strCmd) {
        StringTokenizer strTokenlist = new StringTokenizer(strCmd);
        if (strTokenlist.countTokens() == 2 && strTokenlist.nextToken().equalsIgnoreCase("vlan")) {
            String strToken = strTokenlist.nextToken();
            try {
                if (Integer.parseInt(strToken) >= 0) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    private void logCmds(String[] cmds) {
        int i = 0;
        while (i < cmds.length) {
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private IOSCmdResponse[] sendCmds(String[] cmds) throws IOSCmdServiceException {
        if (cmds == null || cmds.length == 0) {
            return null;
        }
        replies = new Vector<IOSCmdResponse>();
        reply = null;
        i = 0;
        while (i < cmds.length) {
            block50: {
                block51: {
                    start = i;
                    end = i + 1;
                    while (end < cmds.length) {
                        if (!cmds[end].startsWith(" ")) break;
                        ++end;
                    }
                    fileName = this.getFileName(cmds, start, --end);
                    CLIOutput = null;
                    try {
                        CLIOutput = this.getOutputFromFile(fileName);
                        break block50;
                    }
                    catch (Exception e) {
                        if (!cmds[start].startsWith("interface")) break block51;
                        sb = new StringBuffer();
                        k = start;
                        ** while (k <= end)
                    }
lbl-1000:
                    // 1 sources

                    {
                        sb.append("\n\r");
                        if (k < end) {
                            sb.append(this.SEP);
                        }
                        ++k;
                        continue;
                    }
lbl30:
                    // 1 sources

                    CLIOutput = sb.toString();
                    break block50;
                }
                if (cmds[start].startsWith("vlan")) {
                    sb = new StringBuffer();
                    k = start;
                    while (k <= end) {
                        sb.append("\n\r");
                        if (k < end) {
                            sb.append(this.SEP);
                        }
                        ++k;
                    }
                    CLIOutput = sb.toString();
                } else if (cmds[start].startsWith("ip nbar port-map custom-") || cmds[start].startsWith("no ip nbar port-map custom-")) {
                    sb = new StringBuffer();
                    k = start;
                    while (k <= end) {
                        sb.append("\n\r");
                        if (k < end) {
                            sb.append(this.SEP);
                        }
                        ++k;
                    }
                    CLIOutput = sb.toString();
                } else if (cmds[start].startsWith("ip access-list standard") || cmds[start].startsWith("no ip access-list standard")) {
                    sb = new StringBuffer();
                    k = start;
                    while (k <= end) {
                        sb.append("\n\r");
                        if (k < end) {
                            sb.append(this.SEP);
                        }
                        ++k;
                    }
                    CLIOutput = sb.toString();
                } else if (cmds[start].startsWith("clock timezone") || cmds[start].startsWith("no clock timezone") || cmds[start].startsWith("clock set") || cmds[start].startsWith("clock summer-time") || cmds[start].startsWith("no clock summer-time")) {
                    sb = new StringBuffer();
                    k = start;
                    while (k <= end) {
                        sb.append("\n\r");
                        if (k < end) {
                            sb.append(this.SEP);
                        }
                        ++k;
                    }
                    CLIOutput = sb.toString();
                } else if (cmds[start].startsWith("crypto isakmp key") || cmds[start].startsWith("no crypto isakmp key")) {
                    sb = new StringBuffer();
                    k = start;
                    while (k <= end) {
                        sb.append("\n\r");
                        if (k < end) {
                            sb.append(this.SEP);
                        }
                        ++k;
                    }
                    CLIOutput = sb.toString();
                } else if (cmds[start].startsWith("aaa authentication login") || cmds[start].startsWith("no aaa authentication login")) {
                    sb = new StringBuffer();
                    k = start;
                    while (k <= end) {
                        sb.append("\n\r");
                        if (k < end) {
                            sb.append(this.SEP);
                        }
                        ++k;
                    }
                    CLIOutput = sb.toString();
                } else if (cmds[start].startsWith("aaa authentication eou") || cmds[start].startsWith("no aaa authentication eou")) {
                    sb = new StringBuffer();
                    k = start;
                    while (k <= end) {
                        sb.append("\n\r");
                        if (k < end) {
                            sb.append(this.SEP);
                        }
                        ++k;
                    }
                    CLIOutput = sb.toString();
                } else if (cmds[start].startsWith("aaa authorization exec") || cmds[start].startsWith("no aaa authorization exec")) {
                    sb = new StringBuffer();
                    k = start;
                    while (k <= end) {
                        sb.append("\n\r");
                        if (k < end) {
                            sb.append(this.SEP);
                        }
                        ++k;
                    }
                    CLIOutput = sb.toString();
                } else if (cmds[start].startsWith("aaa authorization network") || cmds[start].startsWith("no aaa authorization network")) {
                    sb = new StringBuffer();
                    k = start;
                    while (k <= end) {
                        sb.append("\n\r");
                        if (k < end) {
                            sb.append(this.SEP);
                        }
                        ++k;
                    }
                    CLIOutput = sb.toString();
                } else if (cmds[start].startsWith("show ip route")) {
                    sb = new StringBuffer();
                    strTokens = new StringTokenizer(fileName);
                    if (strTokens.countTokens() == 4 && IPAddress.isLegalIPAddress(strLastToken = strTokens.nextToken("show ip route"))) {
                        sb.append("% Network not in table");
                    }
                    k = start;
                    while (k <= end) {
                        sb.append("\n\r");
                        if (k < end) {
                            sb.append(this.SEP);
                        }
                        ++k;
                    }
                    CLIOutput = sb.toString();
                } else {
                    e.printStackTrace();
                }
            }
            length = CLIOutput.length();
            indexBegin = 0;
            indexEnd = CLIOutput.indexOf(this.SEP);
            while (indexBegin < length) {
                token = indexEnd == -1 ? CLIOutput.substring(indexBegin) : CLIOutput.substring(indexBegin, indexEnd);
                reply = new IOSCmdResponse(cmds[start], token, 0);
                if (cmds.length > 0 && (cmds[0].equalsIgnoreCase(Constant.SHOW_CMDS_COMMANDS_ARRAY[5]) || cmds[0].equalsIgnoreCase(Constant.SHOW_CMDS_COMMANDS_ARRAY[7]) || cmds[0].equalsIgnoreCase(Constant.SHOW_CMDS_COMMANDS_ARRAY[8]))) {
                    reply = new IOSCmdResponse(cmds[start], token, 1);
                }
                replies.addElement(reply);
                if (indexEnd == -1) break;
                indexBegin = indexEnd + this.SEP.length();
                indexEnd = CLIOutput.indexOf(this.SEP, indexBegin);
                ++start;
            }
            i = end + 1;
        }
        replyArray = new IOSCmdResponse[replies.size()];
        replies.copyInto(replyArray);
        return replyArray;
    }

    public synchronized void setTimeout(int msecs) {
    }

    private String stripDynamicPart(String cmd) {
        if (cmd.indexOf("crypto key generate rsa general-keys label SDM-RSAKey-") != -1) {
            cmd = "crypto key generate rsa general-keys label SDM-RSAKey-";
        }
        if (cmd.indexOf("crypto key generate rsa usage-keys label SDM-RSAKey-") != -1) {
            cmd = "crypto key generate rsa usage-keys label SDM-RSAKey-";
        }
        if (cmd.indexOf("crypto ca authenticate") != -1) {
            cmd = "crypto ca authenticate";
        }
        if (cmd.indexOf("crypto ca enroll") != -1) {
            cmd = "crypto ca enroll";
        }
        if (cmd.indexOf("crypto ca trustpoint") != -1) {
            cmd = "crypto ca trustpoint";
        }
        if (cmd.indexOf("crypto key zeroize rsa") != -1) {
            cmd = "crypto key zeroize rsa";
        }
        if (cmd.indexOf("crypto pki enroll") != -1) {
            cmd = "crypto pki enroll";
        }
        return cmd;
    }
}

