/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.net.cmdsvc;

import com.cisco.nm.util.sgz.SgzApplet;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.io.Base64;
import com.cisco.xdm.net.cmdsvc.CredentialRepository;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceBase;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceFactory;
import com.cisco.xdm.net.cmdsvc.PromptHandlerIf;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class PAIIOSCmdService
extends IOSCmdServiceBase
implements Runnable {
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final int DEFAULT_TIMEOUT = 120000;
    private static final String CMDSET_URL = "/ios_web_exec/commandset";
    private static final String CMDSET_TEXT_HEADER = "! COMMANDSET VERSION=\"1.0\"\r\n";
    private static final String CMDSET_TEXT_TRAILER = "! COMMANDSET END\r\n\r\n";
    private static final String CMD_TEXT_OPTIONS_HEADER = "! OPTIONS BEGIN\r\n";
    private static final String CMD_TEXT_OPTIONS_TRAILER = "! OPTIONS END\r\n";
    private static final String CMD_TEXT_TRAILER = "! END\r\n";
    public static final int CONTINUE = 0;
    public static final int STOP = 1;
    public static final int DEFAULT_ACTION_ON_FAILURE = 1;
    public static final int EXEC = 0;
    public static final int CONFIG = 1;
    public static final int DEFAULT_MODE = 0;
    public static final int QUIET = 0;
    public static final int PLAIN_TEXT = 1;
    public static final int DEFAULT_OUTPUT = 1;
    public static final int SUCCESS = 0;
    public static final int UNRECOGNIZED_OPTION = 1;
    public static final int UNRECOGNIZED_VERSION = 2;
    public static final int INVALID_TERMINATION = 3;
    public static final int NULL = 4;
    public static final int INVALID = 5;
    public static final int PARSE_ERROR_NO_ERROR = 0;
    public static final int PARSE_ERROR_AMBIG = 1;
    public static final int PARSE_ERROR_NOMATCH = 2;
    public static final int PARSE_ERROR_UNKNOWN = 4;
    public static final int PARSE_ERROR_ALIAS = 8;
    public static final int PARSE_ERROR_LOCKED = 16;
    private static final int CMD_OPEN = 1;
    private static final int CMD_CLOSE = 2;
    private static final int CMD_READ = 3;
    private static final int CMD_HALT = 4;
    private static final int BUF_SIZE = 65536;
    private static final String COMMAND_OUTPUT_BEGIN = "! COMMAND_OUTPUT BEGIN";
    private static final String COMMAND_OUTPUT_END = "! COMMAND_OUTPUT END";
    private static final String COMMAND_BEGIN = "! COMMAND BEGIN";
    private static final String COMMAND_END = "! COMMAND END";
    private static final String OUTPUT_BEGIN = "! OUTPUT BEGIN";
    private static final String OUTPUT_END = "! OUTPUT END";
    private static final String STATUS_BEGIN = "! STATUS BEGIN";
    private static final String STATUS_END = "! STATUS END";
    private static final String COMMANDSET_END = "! COMMANDSET END";
    private static final String COMMANDSET_BEGIN = "! COMMANDSET";
    private static final String VERSION_OPTION = "VERSION=";
    private static final String STATUS_OPTION = "STATUS=";
    private static final String PARSE_ERROR_OPTION = "PARSE_ERROR=";
    ServiceControl control = null;
    private String[] _sendCmds;
    private CredentialRepository _credRep;
    private int _action;
    private int _output;
    private PAIVersion _paiVersion;
    private int _timeout = 120000;

    public void close() {
        Log.getLog().info("PAIIOSCmdService close()");
        this.serviceExit();
    }

    public synchronized IOSCmdResponse[] config(String[] cmds) throws IOSCmdServiceException {
        IOSCmdResponse[] replies = this.sendCmds(false, cmds);
        if (replies == null) {
            throw this.processIOSCmdServiceException("PAI communication protocol error");
        }
        return replies;
    }

    public synchronized IOSCmdResponse[] config(String[] cmds, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        throw this.processIOSCmdServiceException("interactive commands not supported");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void connect(String protocol, String ipAddress, int port, CredentialRepository credRep) throws IOSCmdServiceException {
        this._protocol = protocol;
        this._ipAddress = ipAddress;
        this._credRep = credRep;
        if (port == -1) {
            if (protocol.equals("http")) {
                this._port = 80;
            } else {
                if (!protocol.equals("https")) throw this.processIOSCmdServiceException("PAIIOSCmdService bad protocol");
                this._port = 443;
            }
        } else {
            this._port = port;
        }
        this.initSettings();
        this.makeNewServiceThread();
        String[] cmds = new String[]{"ping " + ipAddress};
        IOSCmdResponse[] tests = this.exec(cmds);
        if (tests[0].getStatus() == 1) return;
        throw this.processIOSCmdServiceException("PAIIOSCmdService test failed");
    }

    private String createCmdTextOptions(int iMode) {
        String optStr = "!";
        optStr = optStr.concat(" MODE=" + this.quoteArg(iMode));
        if (this._action != 1) {
            optStr = optStr.concat(" ACTION_ON_FAILURE=" + this.quoteArg(this._action));
        }
        if (this._output != 1) {
            optStr = optStr.concat(" OUTPUT=" + this.quoteArg(this._output));
        }
        optStr = optStr.concat("\r\n");
        return optStr;
    }

    private void doTimer(int timeout) throws IOSCmdServiceException {
        ServiceControl serviceControl = this.control;
        synchronized (serviceControl) {
            this.control.notify();
        }
        int timer = 0;
        while (!this.control.getDone()) {
            if ((timer += 100) > timeout) {
                throw this.processIOSCmdServiceException("timeout");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.control.errorEx != null) {
            throw this.processIOSCmdServiceException(this.control.errorEx);
        }
    }

    public synchronized IOSCmdResponse[] exec(String[] cmds) throws IOSCmdServiceException {
        IOSCmdResponse[] replies = this.sendCmds(true, cmds);
        if (replies == null) {
            throw this.processIOSCmdServiceException("PAI communication protocol error");
        }
        return replies;
    }

    public synchronized IOSCmdResponse[] exec(String[] cmds, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        throw this.processIOSCmdServiceException("interactive commands not supported");
    }

    private String extractValueStr(String field, String str) {
        String returnStr = null;
        int index = str.indexOf(field);
        if (index == -1) {
            return "";
        }
        String remaining = str.substring(index + field.length()).trim();
        returnStr = (index = remaining.indexOf(" ")) == -1 ? remaining : remaining.substring(0, index);
        return this.unquoteArg(returnStr);
    }

    public synchronized int getTimeout() {
        return this._timeout;
    }

    private void initSettings() {
        this._action = 1;
        this._output = 1;
    }

    public boolean isSecure() {
        return this.getProtocol().equals("https");
    }

    private void makeNewServiceThread() {
        this.control = new ServiceControl(new Thread(this));
        this.control.serviceThread.start();
    }

    private PAIVersion parsePAIVersion(String cmdSetLine) {
        String versionStr = this.extractValueStr(VERSION_OPTION, cmdSetLine);
        if (versionStr.length() == 0) {
            return null;
        }
        return new PAIVersion(versionStr);
    }

    private String quoteArg(int iArg) {
        return "\"" + iArg + "\"";
    }

    public void run() {
        Log.getLog().debug("PAI service thread: starting");
        char[] tmpBuf = new char[65536];
        while (true) {
            Object var4_6;
            ServiceControl serviceControl;
            try {
                serviceControl = this.control;
                synchronized (serviceControl) {
                    if (this.control.serviceThread != Thread.currentThread()) {
                        Log.getLog().debug("PAI service thread: aborting <1>");
                        var4_6 = null;
                        return;
                    }
                    if (this.control.currentCommand == -1) {
                        this.control.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                Log.getLog().warn("PAIIOSCmdService service thread interrupted");
            }
            switch (this.control.currentCommand) {
                case 1: {
                    try {
                        this.control.inStream = SgzApplet.getInputStreamFromURLConnection(this.control.urlConn);
                    }
                    catch (IOException e) {
                        this.control.inStream = null;
                        this.control.errorEx = e;
                    }
                    break;
                }
                case 2: {
                    try {
                        this.control.outStream.close();
                    }
                    catch (IOException e) {
                        this.control.outStream = null;
                        this.control.errorEx = e;
                    }
                    break;
                }
                case 3: {
                    int nBytes = 0;
                    StringBuffer strBuf = new StringBuffer();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.control.inStream));
                    while (nBytes != -1) {
                        try {
                            nBytes = reader.read(tmpBuf, 0, 65536);
                        }
                        catch (IOException ex) {
                            this.control.errorEx = ex;
                            nBytes = -1;
                        }
                        if (nBytes <= 0) continue;
                        strBuf = strBuf.append(tmpBuf, 0, nBytes);
                    }
                    this.control.rawOutput = strBuf;
                    break;
                }
                case 4: {
                    this.control.serviceThread = null;
                    break;
                }
            }
            serviceControl = this.control;
            synchronized (serviceControl) {
                if (this.control.serviceThread != Thread.currentThread()) {
                    Log.getLog().debug("PAI service thread: aborting <2>");
                    var4_6 = null;
                    return;
                }
                this.control.setDone(true, -1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IOSCmdResponse[] sendCmds(boolean bExec, String[] cmds) throws IOSCmdServiceException {
        String strPort = ":" + this.getPort();
        if (this.getProtocol().equals("http") && this.getPort() == 80 || this.getProtocol().equals("https") && this.getPort() == 443) {
            strPort = "";
        }
        String strURL = String.valueOf(this.getProtocol()) + "://" + this.getIPAddress() + strPort + CMDSET_URL;
        try {
            InputStream dataIn;
            Vector<IOSCmdResponse> replies;
            Log log = Log.getLog();
            this.initSettings();
            this._sendCmds = cmds;
            URL url = new URL(strURL);
            URLConnection conn = url.openConnection();
            String username = this._credRep.getCredential(1);
            String password = this._credRep.getCredential(2);
            if (username != null && password != null) {
                String enc = Base64.encode(String.valueOf(username) + ":" + password);
                conn.setRequestProperty("Authorization", "Basic " + enc);
            }
            conn.setDoOutput(true);
            OutputStream dataOut = null;
            try {
                dataOut = SgzApplet.getOutputStreamFromURLConnection(conn);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("Exception on output stream: " + e + ", '" + e.getMessage() + "'");
                throw e;
            }
            dataOut.write(CMDSET_TEXT_HEADER.getBytes());
            if (cmds.length > 0 && cmds[cmds.length - 1].endsWith("?")) {
                this._action = 0;
            }
            int iType = bExec ? 0 : 1;
            String optStr = this.createCmdTextOptions(iType);
            dataOut.write(CMD_TEXT_OPTIONS_HEADER.getBytes());
            dataOut.write(optStr.getBytes());
            dataOut.write(CMD_TEXT_OPTIONS_TRAILER.getBytes());
            int i = 0;
            while (true) {
                if (i >= this._sendCmds.length) {
                    dataOut.write(CMD_TEXT_TRAILER.getBytes());
                    dataOut.write(CMDSET_TEXT_TRAILER.getBytes());
                    this.timedCloseStream(this.getTimeout(), dataOut);
                    replies = new Vector<IOSCmdResponse>();
                    dataIn = null;
                    try {
                        dataIn = this.timedGetInputStream(this.getTimeout(), conn);
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error("Exception on input stream: " + e + ", '" + e.getMessage() + "'");
                        throw e;
                    }
                }
                String cmd = String.valueOf(this._sendCmds[i]) + "\r\n";
                dataOut.write(cmd.getBytes());
                log.debug("PAI: command sent '" + this._sendCmds[i] + "'");
                ++i;
            }
            StringBuffer strBuf = this.timedRead(this.getTimeout(), dataIn);
            String strOut = new String(strBuf);
            BufferedReader reader = new BufferedReader(new StringReader(strOut));
            String cmd = "";
            StringBuffer cmdReply = new StringBuffer();
            int parseError = -1;
            int cmdSetStatus = -1;
            String strLine = "";
            while ((strLine = reader.readLine()) != null && strLine.equals("")) {
            }
            if (strLine == null || !strLine.startsWith(COMMANDSET_BEGIN)) {
                log.error("PAI: garbled output format");
                return null;
            }
            this._paiVersion = this.parsePAIVersion(strLine);
            String statusStr = this.extractValueStr(STATUS_OPTION, strLine);
            if (statusStr.length() != 0) {
                cmdSetStatus = Integer.parseInt(statusStr);
            }
            if (cmdSetStatus != 0) {
                log.debug("PAI: commandset status is " + cmdSetStatus);
                return null;
            }
            while ((strLine = reader.readLine()) != null) {
                if (strLine.startsWith(COMMANDSET_END)) {
                    strLine = reader.readLine();
                    break;
                }
                if (strLine.startsWith(COMMAND_OUTPUT_END)) {
                    String strReply = new String(cmdReply);
                    IOSCmdResponse reply = new IOSCmdResponse(cmd, strReply, parseError == 0 ? 1 : (parseError == 4 || parseError == 1 || parseError == 2 ? 2 : 0));
                    replies.addElement(reply);
                    if (!IOSCmdServiceFactory._Trace) continue;
                    int index = replies.size() - 1;
                    System.out.println("##### PAIOISCmdService: command[" + index + "] is <" + cmd + ">, reply is <" + strReply + ">");
                    continue;
                }
                if (strLine.startsWith(COMMAND_OUTPUT_BEGIN)) {
                    parseError = -1;
                    cmd = "";
                    cmdReply = new StringBuffer();
                    continue;
                }
                if (strLine.startsWith(COMMAND_BEGIN)) {
                    cmd = reader.readLine();
                    continue;
                }
                if (strLine.startsWith(COMMAND_END) || strLine.startsWith(OUTPUT_BEGIN) || strLine.startsWith(OUTPUT_END)) continue;
                if (strLine.startsWith(STATUS_BEGIN)) {
                    strLine = reader.readLine();
                    String parseErrStr = this.extractValueStr(PARSE_ERROR_OPTION, strLine);
                    if (parseErrStr.length() != 0) {
                        parseError = Integer.parseInt(parseErrStr);
                        if (parseError == 0) continue;
                        log.debug("PAI: command {" + cmd + "} status <" + strLine + ">");
                        continue;
                    }
                    log.debug("PAI: invalid STATUS " + strLine);
                    continue;
                }
                if (strLine.startsWith(STATUS_END)) continue;
                cmdReply.append(strLine);
                cmdReply.append("\r\n");
            }
            reader.close();
            Object[] replyArray = new IOSCmdResponse[replies.size()];
            replies.copyInto(replyArray);
            return replyArray;
        }
        catch (IOSCmdServiceException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw this.processIOSCmdServiceException(e);
        }
    }

    private void serviceExit() {
        Log.getLog().debug("PAI request: HALT");
        this.control.setHalt();
    }

    public synchronized void setTimeout(int msecs) {
        this._timeout = msecs;
    }

    private void timedCloseStream(int timeout, OutputStream dataOut) throws IOSCmdServiceException {
        this.control.setClose(dataOut);
        this.doTimer(timeout);
    }

    private InputStream timedGetInputStream(int timeout, URLConnection conn) throws IOSCmdServiceException, Exception {
        this.control.setOpen(conn);
        this.doTimer(timeout);
        return this.control.inStream;
    }

    private StringBuffer timedRead(int timeout, InputStream dataIn) throws IOSCmdServiceException {
        this.control.setRead(dataIn);
        this.doTimer(timeout);
        return this.control.rawOutput;
    }

    private String unquoteArg(String strArg) {
        int startIndex = strArg.startsWith("\"") ? 1 : 0;
        int endIndex = strArg.endsWith("\"") ? strArg.length() - 1 : strArg.length();
        return strArg.substring(startIndex, endIndex);
    }

    public class PAIVersion {
        public int _majorVer;
        public int _minorVer;

        private PAIVersion() {
        }

        PAIVersion(String versionStr) {
            int separator = versionStr.indexOf(".");
            String majorVerStr = versionStr.substring(0, separator);
            String minorVerStr = versionStr.substring(separator + 1);
            this._majorVer = Integer.parseInt(majorVerStr);
            this._minorVer = Integer.parseInt(minorVerStr);
        }
    }

    private class ServiceControl {
        boolean bDone = false;
        int currentCommand = -1;
        OutputStream outStream = null;
        URLConnection urlConn = null;
        InputStream inStream = null;
        StringBuffer rawOutput = null;
        Thread serviceThread = null;
        Exception errorEx = null;

        ServiceControl(Thread svc) {
            this.serviceThread = svc;
        }

        boolean getDone() {
            return this.bDone;
        }

        void setClose(OutputStream dataOut) {
            this.setDone(false, 2);
            this.outStream = dataOut;
            this.errorEx = null;
        }

        void setDone(boolean b, int cmd) {
            this.bDone = b;
            this.currentCommand = !this.bDone ? cmd : -1;
        }

        void setHalt() {
            this.setDone(false, 4);
            this.errorEx = null;
        }

        void setOpen(URLConnection conn) {
            this.setDone(false, 1);
            this.urlConn = conn;
            this.errorEx = null;
        }

        void setRead(InputStream dataIn) {
            this.setDone(false, 3);
            this.inStream = dataIn;
            this.errorEx = null;
        }
    }
}

