/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.net.cmdsvc;

import com.cisco.nm.util.sgz.SgzApplet;
import com.cisco.xdm.commonutils.StringUtils;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceFactory;
import com.cisco.xdm.net.cmdsvc.PromptHandlerIf;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class RcpDelivery {
    private static final String TMPFN = "SDMupload";
    private IOSCmdService _cs;
    private String _laddr;
    private String _luser;
    private String _ruser;
    private String[] _disableCmds;

    public RcpDelivery(IOSCmdService cs, String localAddr) throws Exception {
        this._cs = cs;
        Random r = new Random(System.currentTimeMillis());
        this._laddr = localAddr;
        this._luser = "L" + Integer.toHexString(r.nextInt());
        this._ruser = this._cs.getCredentialRepository().getCredential(1);
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("laddr = " + this._laddr + " luser = " + this._luser + " ruser = " + this._ruser);
        }
    }

    private static void checkResponse(BufferedReader inp) throws Exception {
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("RcpDelivery.checkResponse");
        }
        int code = inp.read();
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("code = " + code);
        }
        if (code == 0) {
            return;
        }
        String msg = inp.readLine();
        throw new Exception(String.valueOf(msg) + " (" + code + ")");
    }

    public void cleanup() throws Exception {
        this._cs.exec(new String[]{"delete /force flash:SDMupload"}, new PromptHandlerIf(){

            public String handle(String[] devOutput) {
                if (devOutput[devOutput.length - 1].toLowerCase().indexOf("delete filename") > -1) {
                    return "\r\n";
                }
                return null;
            }
        });
    }

    private void copyRunningConfig() throws Exception {
        this._cs.exec(new String[]{"copy flash:SDMupload running-config"}, new PromptHandlerIf(){

            public String handle(String[] devOutput) {
                if (devOutput[devOutput.length - 1].toLowerCase().indexOf("destination filename") > -1) {
                    return "\r\n";
                }
                return null;
            }
        });
    }

    private void disableRcp() throws Exception {
        this._cs.config(this._disableCmds);
    }

    private void enableRcp() throws Exception {
        boolean rcpAlreadyEnabled = false;
        boolean rcpDomainLookupDisabled = false;
        IOSCmdResponse[] rsps = this._cs.exec(new String[]{"sh run | include ip rcmd"});
        Vector<String> orgCmdVec = new Vector<String>();
        if (rsps != null && rsps[0] != null) {
            StringTokenizer st = new StringTokenizer(rsps[0].getOutput(), "\n");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.startsWith("ip rcmd")) {
                    if (s.indexOf("rcp-enable") > -1) {
                        rcpAlreadyEnabled = true;
                    }
                    orgCmdVec.addElement(s);
                    continue;
                }
                if (!s.equals("no ip rcmd domain-lookup")) continue;
                rcpDomainLookupDisabled = true;
                orgCmdVec.addElement(s);
            }
        }
        Vector<String> enableCmdVec = new Vector<String>();
        if (!rcpAlreadyEnabled) {
            enableCmdVec.addElement("ip rcmd rcp-enable");
        }
        enableCmdVec.addElement("ip rcmd remote-host " + this._ruser + " " + this._laddr + " " + this._luser + " enable");
        enableCmdVec.addElement("ip rcmd remote-username " + this._ruser);
        if (!rcpDomainLookupDisabled) {
            enableCmdVec.addElement("no ip rcmd domain-lookup");
        }
        Vector<String> disableCmdVec = new Vector<String>();
        Enumeration e = enableCmdVec.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (s.startsWith("no ")) {
                disableCmdVec.addElement(s.substring(3));
                continue;
            }
            disableCmdVec.addElement("no " + s);
        }
        Enumeration e2 = orgCmdVec.elements();
        while (e2.hasMoreElements()) {
            disableCmdVec.addElement((String)e2.nextElement());
        }
        this._disableCmds = this.getStrs(disableCmdVec);
        this._cs.config(this.getStrs(enableCmdVec));
    }

    public int getMaxDeliverySize() throws Exception {
        IOSCmdResponse[] rsps = this._cs.exec(new String[]{"dir flash:"});
        StringTokenizer st = new StringTokenizer(rsps[0].getOutput(), "\n");
        while (st.hasMoreTokens()) {
            int end;
            String s = st.nextToken();
            if (IOSCmdServiceFactory._Trace) {
                System.out.println(s);
            }
            if ((end = s.toLowerCase().indexOf("bytes free")) <= 0) continue;
            while (end > 0 && !Character.isDigit(s.charAt(end - 1))) {
                --end;
            }
            int beg = end - 1;
            while (beg > 0 && Character.isDigit(s.charAt(beg - 1))) {
                --beg;
            }
            if (beg <= 0) continue;
            return Integer.parseInt(s.substring(beg, end));
        }
        throw new Exception("unable to determine max delivery size");
    }

    private String[] getStrs(Vector vec) {
        Object[] res = new String[vec.size()];
        vec.copyInto(res);
        return res;
    }

    private static void send(PrintWriter out, String data) {
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("RcpDelivery.send " + StringUtils.quoted(data));
        }
        out.print(data);
        out.flush();
    }

    /*
     * WARNING - void declaration
     */
    public void send(byte[] data) throws Exception {
        this.enableRcp();
        try {
            Socket sock = SgzApplet.createSocket(this._cs.getIPAddress(), 514);
            PrintWriter out = new PrintWriter(sock.getOutputStream());
            BufferedReader inp = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            RcpDelivery.send(out, "\u0000");
            RcpDelivery.send(out, String.valueOf(this._luser) + "\u0000");
            RcpDelivery.send(out, String.valueOf(this._ruser) + "\u0000");
            RcpDelivery.send(out, "rcp -t SDMupload\u0000");
            RcpDelivery.checkResponse(inp);
            RcpDelivery.send(out, "C0666 " + data.length + " " + TMPFN + "\n");
            RcpDelivery.checkResponse(inp);
            RcpDelivery.send(out, new String(data));
            RcpDelivery.send(out, "\u0000");
            RcpDelivery.checkResponse(inp);
            sock.close();
        }
        catch (Exception ex) {
            void sock;
            this.disableRcp();
            this.cleanup();
            throw sock;
        }
        this.disableRcp();
        this.copyRunningConfig();
        this.cleanup();
    }
}

