/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.net.cmdsvc;

import com.cisco.nm.lib.expect.TelnetProtocol;
import com.cisco.xdm.commonutils.StringUtils;
import java.io.IOException;

class TelnetBuffer {
    private TelnetProtocol _tp;
    private int _crsX;
    private int _lineCount;
    private StringBuffer _bufferedLines;
    private StringBuffer _currLine;

    TelnetBuffer(TelnetProtocol tp) {
        this._tp = tp;
        this._bufferedLines = new StringBuffer();
        this._currLine = new StringBuffer();
    }

    void clear() {
        this._crsX = 0;
        this._currLine.setLength(0);
        this._bufferedLines.setLength(0);
    }

    String[] getAllLines() {
        return new String[]{this._bufferedLines.toString(), this._currLine.toString()};
    }

    String getBufferedLines() {
        String s = this._bufferedLines.toString();
        this._bufferedLines.setLength(0);
        return s;
    }

    String getCurrLine() {
        return this._currLine.toString();
    }

    void newLine() {
        this._bufferedLines.append(this._currLine.toString());
        this._bufferedLines.append("\n");
        this._crsX = 0;
        this._currLine.setLength(0);
    }

    void print() {
        System.out.println(this.toString());
        System.out.println();
    }

    private void putCharIntoBuffer(char ch) {
        switch (ch) {
            case '\r': {
                this._crsX = 0;
                break;
            }
            case '\n': {
                this._bufferedLines.append(this._currLine.toString());
                this._bufferedLines.append("\n");
                this._currLine.setLength(0);
                ++this._lineCount;
                break;
            }
            default: {
                if (this._crsX >= this._currLine.length()) {
                    this._currLine.setLength(this._crsX + 1);
                }
                this._currLine.setCharAt(this._crsX, ch);
                ++this._crsX;
            }
        }
    }

    void read() throws IOException {
        String s = this._tp.readText();
        int i = 0;
        int n = s.length();
        while (i < n) {
            char ch = s.charAt(i);
            this.putCharIntoBuffer(ch);
            ++i;
        }
    }

    char readChar() throws IOException {
        char ch = (char)this._tp.readByte();
        this.putCharIntoBuffer(ch);
        return ch;
    }

    void readln() throws IOException {
        int lc = this._lineCount;
        do {
            this.read();
        } while (lc == this._lineCount);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("--------------------------------------------------\n");
        sb.append("|" + this._lineCount + ": " + StringUtils.quoted(this._bufferedLines.toString()) + "\n");
        sb.append("|" + this._crsX + "> " + StringUtils.quoted(this._currLine.toString()) + "\n");
        sb.append("--------------------------------------------------\n");
        return sb.toString();
    }
}

