/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.net.cmdsvc;

import com.cisco.nm.lib.expect.TelnetProtocol;
import com.cisco.nm.lib.expect.TelnetSocket;
import com.cisco.nm.util.sgz.SgzApplet;
import com.cisco.xdm.commonutils.StringUtils;
import com.cisco.xdm.net.cmdsvc.CredentialRepository;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceBase;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceFactory;
import com.cisco.xdm.net.cmdsvc.PromptHandlerIf;
import com.cisco.xdm.net.cmdsvc.TelnetBuffer;
import java.io.IOException;
import java.net.Socket;

public class TelnetIOSCmdService
extends IOSCmdServiceBase {
    private static final boolean DEBUG = false;
    public static final int DEFAULT_TELNET_PORT = 23;
    public static final String CRLF = "\r\n";
    public static final int MAX_LOGIN_CYCLE = 10;
    private Socket _sock;
    private TelnetSocket _ts;
    private TelnetProtocol _tp;
    private TelnetBuffer _tb;
    static final String[] PROMPTS = new String[]{">", "#", "assw", ":", "(enable)", "%", "?", "]"};
    private String _execPrompt;
    private String _configPrompt;

    private void checkConnect() throws IOSCmdServiceException {
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("TelnetIOSCmdService: checkConnect");
        }
        try {
            this.sendControlled(CRLF);
            this.expect(this._execPrompt);
        }
        catch (Exception ex) {
            if (IOSCmdServiceFactory._Trace) {
                System.out.println("TelnetIOSCmdService: reconnecting");
            }
            this.connect();
        }
    }

    public synchronized void close() throws IOSCmdServiceException {
        try {
            this._tp.close();
        }
        catch (IOException ex) {
            throw this.processIOSCmdServiceException(ex);
        }
    }

    public synchronized IOSCmdResponse[] config(String[] cmds) throws IOSCmdServiceException {
        return this.config(cmds, null);
    }

    public synchronized IOSCmdResponse[] config(String[] cmds, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        this.checkConnect();
        try {
            if (cmds.length < 1) {
                return new IOSCmdResponse[0];
            }
            this.sendControlled("configure terminal\r\n");
            this.expect(this._configPrompt);
            IOSCmdResponse[] responses = this.execute(cmds, this._configPrompt, promptHandler);
            this.sendControlled("end\r\n");
            this.expect(this._execPrompt);
            return responses;
        }
        catch (IOException ex) {
            throw this.processIOSCmdServiceException(ex);
        }
    }

    private void connect() throws IOSCmdServiceException {
        try {
            this._sock = SgzApplet.createSocket(this._ipAddress, this._port);
            this._ts = new TelnetSocket(this._sock);
            this._tp = new TelnetProtocol(this._ts);
        }
        catch (Exception ex) {
            throw this.processIOSCmdServiceException(ex);
        }
        if (!this._ts.isReady()) {
            throw this.processIOSCmdServiceException("Telnet socket not ready");
        }
        String username = this._credRep.getCredential(1);
        String password = this._credRep.getCredential(2);
        if (username.equals("") && password.equals("")) {
            throw this.processIOSCmdServiceException("canceled");
        }
        try {
            this._tb = new TelnetBuffer(this._tp);
            int nCycles = 0;
            while (nCycles++ < 10) {
                this.receiveUntilQuiet(100);
                String r = this._tb.getCurrLine().toLowerCase();
                if (r.indexOf("username") > -1) {
                    this.sendControlled(String.valueOf(username) + CRLF);
                    this._tb.newLine();
                } else {
                    if (r.indexOf("assw") > -1) {
                        this.sendUncontrolled(String.valueOf(password) + CRLF);
                        this._tb.newLine();
                        break;
                    }
                    this.sendControlled(CRLF);
                }
                Thread.sleep(100L);
            }
            if (nCycles >= 10) {
                throw this.processIOSCmdServiceException("login sequence");
            }
            this._tb.clear();
            this.learnPrompts();
            this.sendControlled("term length 0\r\n");
            this.expect(this._execPrompt);
        }
        catch (IOException iOException) {
            throw this.processIOSCmdServiceException("login sequence");
        }
        catch (Exception ex) {
            if (IOSCmdServiceFactory._Trace) {
                ex.printStackTrace();
            }
            throw this.processIOSCmdServiceException(ex);
        }
    }

    public synchronized void connect(String protocol, String ipAddress, int port, CredentialRepository credRep) throws IOSCmdServiceException {
        this._protocol = protocol;
        this._ipAddress = ipAddress;
        this._port = port < 0 ? 23 : port;
        this._credRep = credRep;
        this.connect();
    }

    public synchronized IOSCmdResponse[] exec(String[] cmds) throws IOSCmdServiceException {
        return this.exec(cmds, null);
    }

    public synchronized IOSCmdResponse[] exec(String[] cmds, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        this.checkConnect();
        return this.execute(cmds, this._execPrompt, promptHandler);
    }

    private IOSCmdResponse[] execute(String[] cmds, String prompt, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        IOSCmdResponse[] responses = new IOSCmdResponse[cmds.length];
        int i = 0;
        while (i < cmds.length) {
            String cmd = cmds[i];
            if (cmd != null) {
                try {
                    boolean endsWithQM = cmd.endsWith("?");
                    if (endsWithQM) {
                        this.sendControlled(cmd);
                    } else {
                        this.sendControlled(String.valueOf(cmd) + CRLF);
                    }
                    this._tb.clear();
                    if (IOSCmdServiceFactory._Trace) {
                        System.out.println("TelnetIOSCmdService: expecting " + StringUtils.quoted(prompt));
                    }
                    if (promptHandler == null) {
                        do {
                            this._tb.read();
                        } while (this._tb.getCurrLine().indexOf(prompt) <= -1);
                    } else {
                        boolean bPreviousNewline = false;
                        while (true) {
                            if (bPreviousNewline) {
                                if (IOSCmdServiceFactory._Trace) {
                                    System.out.println("TelnetIOSCmdService: seeking line of response");
                                }
                                this._tb.readln();
                                this._tb.read();
                            } else {
                                if (IOSCmdServiceFactory._Trace) {
                                    System.out.println("TelnetIOSCmdService: seeking any response");
                                }
                                this._tb.read();
                            }
                            String x = promptHandler.handle(this._tb.getAllLines());
                            if (IOSCmdServiceFactory._Trace) {
                                System.out.println("TelnetIOSCmdService: received prompt handler <" + x + ">");
                            }
                            if (x != null) {
                                if (IOSCmdServiceFactory._Trace) {
                                    System.out.println("TelnetIOSCmdService: got interactive prompt " + StringUtils.quoted(this._tb.getCurrLine()));
                                }
                                this.sendUncontrolled(x);
                                bPreviousNewline = x.endsWith("\n");
                                continue;
                            }
                            if (IOSCmdServiceFactory._Trace) {
                                System.out.println("TelnetIOSCmdService: current line <" + this._tb.getCurrLine());
                            }
                            if (this._tb.getCurrLine().indexOf(prompt) > -1) break;
                            bPreviousNewline = false;
                        }
                    }
                    responses[i] = new IOSCmdResponse(cmd, this._tb.getBufferedLines(), 0);
                    if (endsWithQM) {
                        this.sendUncontrolled("\u0015");
                    }
                }
                catch (IOException ex) {
                    throw this.processIOSCmdServiceException(String.valueOf(ex.getMessage()) + "\n" + this._tb.toString());
                }
            }
            ++i;
        }
        return responses;
    }

    private String expect(String s) throws IOException {
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("TelnetIOSCmdService: expecting " + StringUtils.quoted(s));
        }
        do {
            this._tb.read();
        } while (this._tb.getCurrLine().indexOf(s) <= -1);
        return this._tb.getBufferedLines();
    }

    public int getTimeout() throws IOSCmdServiceException {
        try {
            return this._sock.getSoTimeout();
        }
        catch (Exception ex) {
            throw this.processIOSCmdServiceException(ex);
        }
    }

    public boolean isSecure() {
        return false;
    }

    private String learnPrompt() throws IOException, IOSCmdServiceException {
        int[] pcount = new int[PROMPTS.length];
        int i = 0;
        while (i < 5) {
            this.sendControlled(CRLF);
            String r = this.receive(1).trim();
            int j = 0;
            while (j < PROMPTS.length) {
                if (r.indexOf(PROMPTS[j]) > -1) {
                    int n = j;
                    pcount[n] = pcount[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        int maxcount = -1;
        int maxidx = -1;
        int j = 0;
        while (j < PROMPTS.length) {
            if (pcount[j] > maxcount) {
                maxcount = pcount[j];
                maxidx = j;
            }
            ++j;
        }
        if (maxidx < 0) {
            throw this.processIOSCmdServiceException("unable to learn prompt");
        }
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("TelnetIOSCmdService: learned prompt is " + StringUtils.quoted(PROMPTS[maxidx]));
        }
        return PROMPTS[maxidx];
    }

    private void learnPrompts() throws IOException {
        this._execPrompt = this.learnPrompt();
        this.sendControlled("configure terminal\r\n");
        this._configPrompt = this.learnPrompt();
        this.sendControlled("exit\r\n");
        this.expect(this._execPrompt);
    }

    private String receive(int minLen) throws IOException {
        String s;
        while ((s = this._tp.readText()).length() < minLen) {
        }
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("TelnetIOSCmdService: rcvd " + StringUtils.quoted(s));
        }
        return s;
    }

    private void receiveUntilQuiet(int msecs) throws IOException {
        int oTimeout = this.getTimeout();
        this.setTimeout(msecs);
        try {
            while (true) {
                this._tb.read();
            }
        }
        catch (IOException ex) {
            this.setTimeout(oTimeout);
            return;
        }
    }

    private void sendControlled(String s) throws IOException {
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("TelnetIOSCmdService: sending " + StringUtils.quoted(s));
        }
        int i = 0;
        int n = s.length();
        while (i < n) {
            char rch;
            String chs = s.substring(i, i + 1);
            this._tp.writeString(chs);
            char ch = chs.charAt(0);
            while ((rch = this._tb.readChar()) != ch) {
            }
            ++i;
        }
    }

    private void sendUncontrolled(String s) throws IOException {
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("TelnetIOSCmdService: sending " + StringUtils.quoted(s));
        }
        this._tp.writeString(s);
    }

    public void setTimeout(int msecs) throws IOSCmdServiceException {
        try {
            if (IOSCmdServiceFactory._Trace) {
                System.out.println("TelnetIOSCmdService: setting timeout to " + msecs);
            }
            this._sock.setSoTimeout(msecs);
        }
        catch (Exception ex) {
            throw this.processIOSCmdServiceException(ex);
        }
    }
}

