/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.parser;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Hashtable;

public class InterfaceParser {
    private InterfaceParser() {
    }

    private static String getIfType(String myInterface) {
        int i = myInterface.length() - 1;
        while (i > 0) {
            if (Character.isLetter(myInterface.charAt(i))) break;
            --i;
        }
        return myInterface.substring(0, i + 1);
    }

    public static void main(String[] args) {
        InterfaceParser.parseInterface(args[0]);
    }

    public static Hashtable parseInterface(String myInterface) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        try {
            String ifType = InterfaceParser.getIfType(myInterface);
            StringReader rd = new StringReader(myInterface.substring(ifType.length()));
            StreamTokenizer st = new StreamTokenizer(rd);
            StringBuffer value = null;
            int index = 0;
            String type = null;
            st.ordinaryChars(48, 57);
            st.ordinaryChar(46);
            st.ordinaryChar(47);
            int token = st.nextToken();
            ht.put("type", ifType);
            type = "part" + index++;
            while (token != -1) {
                switch (token) {
                    case 47: {
                        if (value == null) break;
                        ht.put(type, value.toString());
                        value = null;
                        type = "part" + index++;
                        break;
                    }
                    case 46: {
                        if (value == null) break;
                        ht.put(type, value.toString());
                        value = null;
                        type = "subinterface";
                        break;
                    }
                    case 58: {
                        if (value == null) break;
                        ht.put(type, value.toString());
                        value = null;
                        type = "timeslot";
                        break;
                    }
                    default: {
                        char ch = (char)st.ttype;
                        if (value == null) {
                            value = new StringBuffer();
                            value.append(ch);
                            break;
                        }
                        value.append(ch);
                    }
                }
                token = st.nextToken();
            }
            ht.put(type, value.toString());
            rd.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ht;
    }
}

