/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.parser;

import com.cisco.xdm.parser.DiagInfo;
import com.cisco.xdm.parser.VersionInfo;
import com.cisco.xdm.parser.WicInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class ShowCmdParser {
    private static void getConfigRegisterValue(String line, VersionInfo vi) {
        String configRegisterValue;
        int startIndex = "Configuration register is".length();
        vi._configReg = configRegisterValue = line.substring(startIndex + 1);
    }

    private static String getFlash(String line) {
        int end = line.indexOf(" ", 0);
        return line.substring(0, end);
    }

    private static void getHardwareAndMemory(String line, VersionInfo vi) {
        int start = line.indexOf(" ");
        int end = line.indexOf(" ", start + 1);
        vi._hardware = line.substring(start + 1, end);
        int cStart = end;
        int cEnd = line.toUpperCase().indexOf("PROCESSOR");
        String subline = cEnd != -1 ? line.substring(cStart + 1, cEnd) : "";
        start = subline.indexOf("(");
        end = subline.indexOf(")");
        vi._cpu = "";
        if (start >= 0) {
            vi._cpu = subline.substring(start + 1, end);
        }
        start = line.indexOf("with");
        start = line.indexOf(" ", start + 1);
        end = line.indexOf("bytes", start + 1);
        vi._totalMem = line.substring(start + 1, end - 1);
    }

    private static void getImageAndBootLocation(String line, VersionInfo vi) {
        int start = line.indexOf("\"");
        int end = line.indexOf("\"", start + 1);
        String mystring = line.substring(start + 1, end);
        int split = mystring.indexOf(":");
        vi._bootLocation = mystring.substring(0, split);
        int startImage = mystring.lastIndexOf("/");
        if (startImage == -1) {
            startImage = split;
        }
        vi._imageName = mystring.substring(startImage + 1);
    }

    private static long getLong(String x) {
        int length = x.length();
        return Long.parseLong(x.substring(0, length - 1));
    }

    private static String getPartNumberFromLine(String line) {
        int start = line.toUpperCase().indexOf("PART NUMBER");
        int startspace = line.indexOf(" ", start + 5);
        String pno = line.substring(startspace + 1);
        return pno.replace(':', ' ').trim();
    }

    private static String getSlotNumberFromLine(String line) {
        if (line.toUpperCase().indexOf("AIM") == -1) {
            int start = line.toUpperCase().indexOf("SLOT");
            int startspace = line.indexOf(" ", start);
            int end = line.indexOf(":", start);
            return line.substring(startspace + 1, end);
        }
        if (line.startsWith("AIM Module in slot")) {
            int start = line.indexOf(":");
            return "AIM " + line.substring(start + 1);
        }
        if (line.startsWith("AIM slot")) {
            return "AIM " + line.substring(9, 10);
        }
        if (line.startsWith("AIM on Carrier Card")) {
            return "AIM " + line.substring(20, 21);
        }
        int start = line.toUpperCase().indexOf("AIM");
        String pno = line.substring(start);
        return pno.replace(':', ' ').trim();
    }

    private static String getVersion(String line) {
        int start = line.indexOf("Version");
        int startspace = line.indexOf(" ", start);
        int end = line.indexOf(",", start);
        if (end == -1) {
            end = line.indexOf(" ", startspace + 1);
        }
        return line.substring(startspace + 1, end);
    }

    public static DiagInfo[] parseShowDiag(InputStream diagShow) throws IOException {
        InputStreamReader isr = new InputStreamReader(diagShow);
        BufferedReader bfr = new BufferedReader(isr);
        String line = null;
        Vector<DiagInfo> v = new Vector<DiagInfo>();
        Object[] diarray = null;
        DiagInfo di = null;
        WicInfo wic = null;
        Object[] wicarray = null;
        Vector<WicInfo> wicvector = new Vector<WicInfo>();
        StringBuffer sb = new StringBuffer();
        StringBuffer wicsb = new StringBuffer();
        try {
            while ((line = bfr.readLine()) != null) {
                if (line.toUpperCase().startsWith("SLOT") || line.toUpperCase().startsWith("ENCRYPTION AIM") || line.toUpperCase().startsWith("AIM ") || line.startsWith("\tAIM ")) {
                    if (!wicvector.isEmpty()) {
                        wicarray = new WicInfo[wicvector.size()];
                        wicvector.copyInto(wicarray);
                        di = (DiagInfo)v.lastElement();
                        di.wics = wicarray;
                        di.slotText = sb;
                        wicvector = new Vector();
                    }
                    sb = new StringBuffer();
                    sb.append(String.valueOf(line) + "\n");
                    di = new DiagInfo();
                    di.slotNo = ShowCmdParser.getSlotNumberFromLine(line);
                    continue;
                }
                wicsb.append(String.valueOf(line) + "\n");
                sb.append(String.valueOf(line) + "\n");
                if (line.toUpperCase().indexOf("WIC SLOT") != -1 || line.toUpperCase().indexOf("VIC SLOT") != -1) {
                    wic = new WicInfo();
                    wicsb = new StringBuffer();
                    wic.slotNo = ShowCmdParser.getSlotNumberFromLine(line);
                    continue;
                }
                if (line.toUpperCase().indexOf("PART NUMBER") == -1 || wic == null && di == null) continue;
                if (wic == null) {
                    di.partNumber = ShowCmdParser.getPartNumberFromLine(line);
                    di.slotText = sb;
                    v.addElement(di);
                    di = null;
                    continue;
                }
                wic.partNumber = ShowCmdParser.getPartNumberFromLine(line);
                wic.slotText = wicsb;
                wicvector.addElement(wic);
                wic = null;
            }
            if (!wicvector.isEmpty()) {
                wicarray = new WicInfo[wicvector.size()];
                wicvector.copyInto(wicarray);
                di = (DiagInfo)v.lastElement();
                di.wics = wicarray;
                di.slotText = sb;
            }
            diarray = new DiagInfo[v.size()];
            v.copyInto(diarray);
            return diarray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static VersionInfo parseShowVersion(InputStream versionShow) throws IOException {
        InputStreamReader isr = new InputStreamReader(versionShow);
        BufferedReader bfr = new BufferedReader(isr);
        String line = null;
        VersionInfo vi = new VersionInfo();
        try {
            while ((line = bfr.readLine()) != null) {
                if (line.toUpperCase().startsWith("IOS (") || line.toUpperCase().startsWith("CISCO IOS SOFTWARE,")) {
                    vi._iosVersion = ShowCmdParser.getVersion(line);
                    continue;
                }
                if (line.toUpperCase().startsWith("CISCO") && line.toUpperCase().indexOf("BYTES OF MEMORY") != -1) {
                    ShowCmdParser.getHardwareAndMemory(line, vi);
                    continue;
                }
                if (line.toUpperCase().startsWith("SYSTEM IMAGE FILE")) {
                    ShowCmdParser.getImageAndBootLocation(line, vi);
                    continue;
                }
                if (line.toUpperCase().indexOf("BYTES") != -1 && (line.toUpperCase().indexOf("FLASH") != -1 || line.toUpperCase().indexOf("AT SLOT") != -1)) {
                    if (vi._flash == null) {
                        vi._flash = ShowCmdParser.getFlash(line);
                        continue;
                    }
                    vi._flash = String.valueOf(ShowCmdParser.getLong(vi._flash) + ShowCmdParser.getLong(ShowCmdParser.getFlash(line))) + "K";
                    continue;
                }
                if (!line.startsWith("Configuration register is")) continue;
                ShowCmdParser.getConfigRegisterValue(line, vi);
            }
            return vi;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

