/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.crypto.engines;

import com.maverick.ssh.cipher.SshCipher;
import com.maverick.ssh.crypto.engines.CipherEngine;
import java.io.IOException;

public class CbcBlockCipher
extends SshCipher {
    private CipherEngine L;
    private int O;
    private byte[] J = null;
    private byte[] N = null;
    private byte[] M = null;
    private byte[] K = null;

    public CbcBlockCipher(int n, CipherEngine cipherEngine) {
        this.K = new byte[n / 8];
        this.L = cipherEngine;
    }

    public void init(int n, byte[] byArray, byte[] byArray2) {
        this.O = n;
        System.arraycopy(byArray2, 0, this.K, 0, this.K.length);
        this.L.init(n == 0, this.K);
        this.J = new byte[this.getBlockSize()];
        System.arraycopy(byArray, 0, this.J, 0, this.J.length);
        this.N = new byte[this.getBlockSize()];
        System.arraycopy(this.J, 0, this.N, 0, this.N.length);
        this.M = new byte[this.getBlockSize()];
    }

    public int getBlockSize() {
        return this.L.getBlockSize();
    }

    public void transform(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws IOException {
        if (this.N == null) {
            throw new IOException("Cipher not initialized!");
        }
        if (n3 % this.getBlockSize() != 0) {
            throw new IOException("Input data length MUST be a multiple of the cipher block size!");
        }
        block4: for (int i = 0; i < n3; i += this.getBlockSize()) {
            switch (this.O) {
                case 0: {
                    for (int j = 0; j < this.getBlockSize(); ++j) {
                        this.M[j] = (byte)(byArray[n + i + j] ^ this.N[j]);
                    }
                    this.L.processBlock(this.M, 0, this.N, 0);
                    System.arraycopy(this.N, 0, byArray2, n2 + i, this.getBlockSize());
                    continue block4;
                }
                case 1: {
                    byte[] byArray3 = new byte[this.getBlockSize()];
                    System.arraycopy(byArray, n + i, byArray3, 0, this.getBlockSize());
                    this.L.processBlock(byArray, n2 + i, this.M, 0);
                    for (int j = 0; j < this.getBlockSize(); ++j) {
                        byArray2[n2 + j + i] = (byte)(this.M[j] ^ this.N[j]);
                    }
                    System.arraycopy(byArray3, 0, this.N, 0, this.getBlockSize());
                    byArray3 = null;
                    continue block4;
                }
                default: {
                    throw new IOException("Invalid cipher mode!");
                }
            }
        }
    }
}

